/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.scope;

import com.android.build.gradle.AndroidConfig;
import com.android.build.gradle.AndroidGradleOptions;
import com.android.build.gradle.internal.SdkHandler;
import com.android.build.gradle.internal.ndk.NdkHandler;
import com.android.build.gradle.internal.scope.TransformGlobalScope;
import com.android.builder.core.AndroidBuilder;
import com.android.builder.model.OptionalCompilationStep;
import com.android.utils.FileUtils;
import com.google.common.base.CharMatcher;
import com.google.common.base.MoreObjects;
import java.io.File;
import java.util.EnumSet;
import org.gradle.api.Project;
import org.gradle.tooling.provider.model.ToolingModelBuilderRegistry;

public class GlobalScope
implements TransformGlobalScope {
    private Project project;
    private AndroidBuilder androidBuilder;
    private AndroidConfig extension;
    private SdkHandler sdkHandler;
    private NdkHandler ndkHandler;
    private ToolingModelBuilderRegistry toolingRegistry;
    private final File intermediatesDir;
    private final File generatedDir;
    private final File reportsDir;
    private final File outputsDir;
    private File mockableAndroidJarFile;
    private final EnumSet<OptionalCompilationStep> optionalCompilationSteps;

    public GlobalScope(Project project, AndroidBuilder androidBuilder, AndroidConfig extension, SdkHandler sdkHandler, NdkHandler ndkHandler, ToolingModelBuilderRegistry toolingRegistry) {
        this.project = project;
        this.androidBuilder = androidBuilder;
        this.extension = extension;
        this.sdkHandler = sdkHandler;
        this.ndkHandler = ndkHandler;
        this.toolingRegistry = toolingRegistry;
        this.intermediatesDir = new File(this.getBuildDir(), "intermediates");
        this.generatedDir = new File(this.getBuildDir(), "generated");
        this.reportsDir = new File(this.getBuildDir(), "reports");
        this.outputsDir = new File(this.getBuildDir(), "outputs");
        this.optionalCompilationSteps = AndroidGradleOptions.getOptionalCompilationSteps(project);
    }

    @Override
    public Project getProject() {
        return this.project;
    }

    public AndroidConfig getExtension() {
        return this.extension;
    }

    public AndroidBuilder getAndroidBuilder() {
        return this.androidBuilder;
    }

    public String getProjectBaseName() {
        return (String)this.project.property("archivesBaseName");
    }

    public SdkHandler getSdkHandler() {
        return this.sdkHandler;
    }

    public NdkHandler getNdkHandler() {
        return this.ndkHandler;
    }

    public ToolingModelBuilderRegistry getToolingRegistry() {
        return this.toolingRegistry;
    }

    @Override
    public File getBuildDir() {
        return this.project.getBuildDir();
    }

    public File getIntermediatesDir() {
        return this.intermediatesDir;
    }

    public File getGeneratedDir() {
        return this.generatedDir;
    }

    public File getReportsDir() {
        return this.reportsDir;
    }

    public File getTestResultsFolder() {
        return new File(this.getBuildDir(), "test-results");
    }

    public File getTestReportFolder() {
        return new File(this.getBuildDir(), "reports/tests");
    }

    public File getMockableAndroidJarFile() {
        if (this.mockableAndroidJarFile == null) {
            String fileExt = this.getExtension().getTestOptions().getUnitTests().isReturnDefaultValues() ? ".default-values.jar" : ".jar";
            File outDir = new File(this.getProject().getRootProject().getBuildDir(), "generated");
            CharMatcher safeCharacters = CharMatcher.JAVA_LETTER_OR_DIGIT.or(CharMatcher.anyOf((CharSequence)"-."));
            String sdkName = safeCharacters.negate().replaceFrom((CharSequence)this.getExtension().getCompileSdkVersion(), '-');
            this.mockableAndroidJarFile = new File(outDir, "mockable-" + sdkName + fileExt);
        }
        return this.mockableAndroidJarFile;
    }

    public File getOutputsDir() {
        return this.outputsDir;
    }

    private File getDefaultApkLocation() {
        return FileUtils.join((File)this.getBuildDir(), (String[])new String[]{"outputs", "apk"});
    }

    public File getApkLocation() {
        return (File)MoreObjects.firstNonNull((Object)AndroidGradleOptions.getApkLocation(this.project), (Object)this.getDefaultApkLocation());
    }

    @Override
    public boolean isActive(OptionalCompilationStep step) {
        return this.optionalCompilationSteps.contains(step);
    }

    public String getArchivesBaseName() {
        return (String)this.getProject().getProperties().get("archivesBaseName");
    }

    public File getJacocoAgentOutputDirectory() {
        return new File(this.getIntermediatesDir(), "jacoco");
    }

    public File getJacocoAgent() {
        return new File(this.getJacocoAgentOutputDirectory(), "jacocoagent.jar");
    }
}

