/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.build.gradle.internal.scope.ConventionMappingHelper;
import com.android.build.gradle.internal.scope.TaskConfigAction;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.tasks.DefaultAndroidTask;
import java.io.File;
import org.gradle.api.Task;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.ParallelizableTask;
import org.gradle.api.tasks.TaskAction;

@ParallelizableTask
public class CheckManifest
extends DefaultAndroidTask {
    private File manifest;
    private Boolean isOptional;

    @Optional
    @InputFile
    public File getManifest() {
        return this.manifest;
    }

    public void setManifest(File manifest) {
        this.manifest = manifest;
    }

    public Boolean getOptional() {
        return this.isOptional;
    }

    public void setOptional(Boolean optional) {
        this.isOptional = optional;
    }

    @TaskAction
    void check() {
        File f = this.getManifest();
        if (!this.isOptional.booleanValue() && f != null && !f.isFile()) {
            throw new IllegalArgumentException(String.format("Main Manifest missing for variant %1$s. Expected path: %2$s", this.getVariantName(), this.getManifest().getAbsolutePath()));
        }
    }

    public static class ConfigAction
    implements TaskConfigAction<CheckManifest> {
        private final VariantScope scope;
        private final boolean isManifestOptional;

        public ConfigAction(VariantScope scope, boolean isManifestOptional) {
            this.scope = scope;
            this.isManifestOptional = isManifestOptional;
        }

        @Override
        public String getName() {
            return this.scope.getTaskName("check", "Manifest");
        }

        @Override
        public Class<CheckManifest> getType() {
            return CheckManifest.class;
        }

        @Override
        public void execute(CheckManifest checkManifestTask) {
            this.scope.getVariantData().checkManifestTask = checkManifestTask;
            checkManifestTask.setVariantName(this.scope.getVariantData().getVariantConfiguration().getFullName());
            checkManifestTask.setOptional(this.isManifestOptional);
            ConventionMappingHelper.map((Task)checkManifestTask, "manifest", () -> this.scope.getVariantData().getVariantConfiguration().getMainManifest());
        }
    }
}

