/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.build.api.transform.JarInput;
import com.android.build.api.transform.QualifiedContent;
import com.android.build.api.transform.SecondaryFile;
import com.android.build.api.transform.Transform;
import com.android.build.api.transform.TransformException;
import com.android.build.api.transform.TransformInput;
import com.android.build.api.transform.TransformInvocation;
import com.android.build.gradle.internal.pipeline.TransformManager;
import com.android.build.gradle.internal.transforms.JarMerger;
import com.android.build.gradle.tasks.annotations.TypedefRemover;
import com.android.builder.packaging.ZipAbortException;
import com.android.builder.packaging.ZipEntryFilter;
import com.android.utils.FileUtils;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.io.Closer;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public class LibraryJarTransform
extends Transform {
    private final File mainClassLocation;
    private final File localJarsLocation;
    private final String packagePath;
    private final boolean packageBuildConfig;
    private final File typedefRecipe;
    private List<ExcludeListProvider> excludeListProviders;

    public LibraryJarTransform(File mainClassLocation, File localJarsLocation, File typedefRecipe, String packageName, boolean packageBuildConfig) {
        this.mainClassLocation = mainClassLocation;
        this.localJarsLocation = localJarsLocation;
        this.typedefRecipe = typedefRecipe;
        this.packagePath = packageName.replace(".", "/");
        this.packageBuildConfig = packageBuildConfig;
    }

    public Collection<SecondaryFile> getSecondaryFiles() {
        if (this.typedefRecipe.isFile()) {
            return ImmutableList.of((Object)SecondaryFile.nonIncremental((File)this.typedefRecipe));
        }
        return ImmutableList.of();
    }

    public void addExcludeListProvider(ExcludeListProvider provider) {
        if (this.excludeListProviders == null) {
            this.excludeListProviders = Lists.newArrayList();
        }
        this.excludeListProviders.add(provider);
    }

    public String getName() {
        return "syncLibJars";
    }

    public Set<QualifiedContent.ContentType> getInputTypes() {
        return TransformManager.CONTENT_JARS;
    }

    public Set<QualifiedContent.Scope> getScopes() {
        return TransformManager.EMPTY_SCOPES;
    }

    public Set<QualifiedContent.Scope> getReferencedScopes() {
        return TransformManager.SCOPE_FULL_LIBRARY;
    }

    public boolean isIncremental() {
        return false;
    }

    public Collection<File> getSecondaryFileOutputs() {
        return ImmutableList.of((Object)this.mainClassLocation);
    }

    public Collection<File> getSecondaryDirectoryOutputs() {
        return ImmutableList.of((Object)this.localJarsLocation);
    }

    public void transform(TransformInvocation invocation) throws IOException, TransformException, InterruptedException {
        FileUtils.deleteDirectoryContents((File)this.localJarsLocation);
        ArrayList excludes = Lists.newArrayListWithExpectedSize((int)5);
        excludes.add(".*/R.class$");
        excludes.add(".*/R\\$(.*).class$");
        excludes.add(this.packagePath + "/Manifest.class$");
        excludes.add(this.packagePath + "/Manifest\\$(.*).class$");
        if (!this.packageBuildConfig) {
            excludes.add(this.packagePath + "/BuildConfig.class$");
        }
        if (this.excludeListProviders != null) {
            for (ExcludeListProvider provider : this.excludeListProviders) {
                List<String> list = provider.getExcludeList();
                if (list == null) continue;
                excludes.addAll(list);
            }
        }
        List<Pattern> patterns = excludes.stream().map(Pattern::compile).collect(Collectors.toList());
        ArrayList mainScope = Lists.newArrayList();
        ArrayList locaJlJarScope = Lists.newArrayList();
        for (TransformInput input : invocation.getReferencedInputs()) {
            for (QualifiedContent qualifiedContent : Iterables.concat((Iterable)input.getJarInputs(), (Iterable)input.getDirectoryInputs())) {
                if (qualifiedContent.getScopes().contains(QualifiedContent.Scope.PROJECT)) {
                    mainScope.add(qualifiedContent);
                    continue;
                }
                locaJlJarScope.add(qualifiedContent);
            }
        }
        if (mainScope.isEmpty()) {
            throw new RuntimeException("Empty Main scope for " + this.getName());
        }
        if (mainScope.size() == 1) {
            QualifiedContent content = (QualifiedContent)mainScope.get(0);
            if (content instanceof JarInput) {
                LibraryJarTransform.copyJarWithContentFilter(content.getFile(), this.mainClassLocation, patterns);
            } else {
                this.jarFolderToRootLocation(content.getFile(), patterns);
            }
        } else {
            this.mergeToRootLocation(mainScope, patterns);
        }
        this.processLocalJars(locaJlJarScope);
    }

    private void mergeToRootLocation(List<QualifiedContent> qualifiedContentList, List<Pattern> excludes) throws IOException {
        JarMerger jarMerger = new JarMerger(this.mainClassLocation);
        jarMerger.setFilter(archivePath -> LibraryJarTransform.checkEntry(excludes, archivePath));
        for (QualifiedContent content : qualifiedContentList) {
            if (content instanceof JarInput) {
                jarMerger.addJar(content.getFile());
                continue;
            }
            jarMerger.addFolder(content.getFile());
        }
        jarMerger.close();
    }

    private void processLocalJars(List<QualifiedContent> qualifiedContentList) throws IOException {
        ZipEntryFilter classOnlyFilter = path -> path.endsWith(".class");
        Iterator<QualifiedContent> iterator = qualifiedContentList.iterator();
        while (iterator.hasNext()) {
            QualifiedContent content = iterator.next();
            if (!(content instanceof JarInput)) continue;
            LibraryJarTransform.copyJarWithContentFilter(content.getFile(), new File(this.localJarsLocation, content.getFile().getName()), classOnlyFilter);
            iterator.remove();
        }
        if (!qualifiedContentList.isEmpty()) {
            JarMerger jarMerger = new JarMerger(new File(this.localJarsLocation, "otherclasses.jar"));
            jarMerger.setFilter(classOnlyFilter);
            for (QualifiedContent content : qualifiedContentList) {
                jarMerger.addFolder(content.getFile());
            }
            jarMerger.close();
        }
    }

    private void jarFolderToRootLocation(File file, List<Pattern> excludes) throws IOException {
        JarMerger jarMerger = new JarMerger(this.mainClassLocation);
        jarMerger.setFilter(archivePath -> LibraryJarTransform.checkEntry(excludes, archivePath));
        if (this.typedefRecipe.isFile()) {
            jarMerger.setTypedefRemover(new TypedefRemover().setTypedefFile(this.typedefRecipe));
        }
        jarMerger.addFolder(file);
        jarMerger.close();
    }

    private static void copyJarWithContentFilter(File from, File to, List<Pattern> excludes) throws IOException {
        LibraryJarTransform.copyJarWithContentFilter(from, to, archivePath -> LibraryJarTransform.checkEntry(excludes, archivePath));
    }

    private static void copyJarWithContentFilter(File from, File to, ZipEntryFilter filter) throws IOException {
        byte[] buffer = new byte[4096];
        try (Closer closer = Closer.create();){
            ZipEntry entry;
            FileOutputStream fos = (FileOutputStream)closer.register((Closeable)new FileOutputStream(to));
            BufferedOutputStream bos = (BufferedOutputStream)closer.register((Closeable)new BufferedOutputStream(fos));
            ZipOutputStream zos = (ZipOutputStream)closer.register((Closeable)new ZipOutputStream(bos));
            FileInputStream fis = (FileInputStream)closer.register((Closeable)new FileInputStream(from));
            BufferedInputStream bis = (BufferedInputStream)closer.register((Closeable)new BufferedInputStream(fis));
            ZipInputStream zis = (ZipInputStream)closer.register((Closeable)new ZipInputStream(bis));
            while ((entry = zis.getNextEntry()) != null) {
                int count;
                String name = entry.getName();
                if (filter != null && !filter.checkEntry(name)) continue;
                JarEntry newEntry = entry.getMethod() == 0 ? new JarEntry(entry) : new JarEntry(name);
                newEntry.setLastModifiedTime(JarMerger.ZERO_TIME);
                newEntry.setLastAccessTime(JarMerger.ZERO_TIME);
                newEntry.setCreationTime(JarMerger.ZERO_TIME);
                zos.putNextEntry(newEntry);
                while ((count = zis.read(buffer)) != -1) {
                    zos.write(buffer, 0, count);
                }
                zos.closeEntry();
                zis.closeEntry();
            }
        }
        catch (ZipAbortException e) {
            throw new IOException(e);
        }
    }

    private static boolean checkEntry(List<Pattern> patterns, String name) {
        for (Pattern pattern : patterns) {
            if (!pattern.matcher(name).matches()) continue;
            return false;
        }
        return true;
    }

    public static interface ExcludeListProvider {
        public List<String> getExcludeList();
    }
}

