/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.build.gradle.internal.LibraryCache;
import com.android.build.gradle.internal.tasks.DefaultAndroidTask;
import com.android.builder.model.MavenCoordinates;
import com.android.builder.utils.FileCache;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.io.Files;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.function.Consumer;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import org.gradle.api.Project;
import org.gradle.api.logging.Logger;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.ParallelizableTask;
import org.gradle.api.tasks.TaskAction;

@ParallelizableTask
public class PrepareLibraryTask
extends DefaultAndroidTask {
    private File bundle;
    private File explodedDir;
    private boolean shouldUseBuildCache;
    private FileCache buildCache;
    private MavenCoordinates mavenCoordinates;

    public void init(File bundle, File explodedDir, Optional<FileCache> buildCache, MavenCoordinates mavenCoordinates) {
        this.bundle = bundle;
        this.explodedDir = explodedDir;
        this.shouldUseBuildCache = PrepareLibraryTask.shouldUseBuildCache(buildCache.isPresent(), mavenCoordinates);
        if (this.shouldUseBuildCache) {
            this.buildCache = buildCache.get();
            this.mavenCoordinates = mavenCoordinates;
        } else {
            this.getOutputs().dir((Object)explodedDir);
        }
    }

    @InputFile
    public File getBundle() {
        return this.bundle;
    }

    @TaskAction
    public void prepare() throws IOException {
        Preconditions.checkNotNull((Object)this.explodedDir, (Object)"explodedDir must not be null");
        if (this.shouldUseBuildCache) {
            Preconditions.checkNotNull((Object)this.buildCache, (Object)"buildCache must not be null");
            Preconditions.checkNotNull((Object)this.mavenCoordinates, (Object)"mavenCoordinates must not be null");
        }
        Consumer<File> unzipAarAction = explodedDir -> PrepareLibraryTask.extract(this.bundle, explodedDir, this.getProject());
        PrepareLibraryTask.prepareLibrary(this.bundle, this.explodedDir, this.buildCache, unzipAarAction, this.getLogger(), this.shouldUseBuildCache);
    }

    public static void extract(File bundle, File outputDir, Project project) {
        LibraryCache.unzipAar(bundle, outputDir, project);
        File classesJar = new File(new File(outputDir, "jars"), "classes.jar");
        if (classesJar.exists()) {
            return;
        }
        try {
            Files.createParentDirs((File)classesJar);
            JarOutputStream jarOutputStream = new JarOutputStream((OutputStream)new BufferedOutputStream(new FileOutputStream(classesJar)), new Manifest());
            jarOutputStream.close();
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot create missing classes.jar", e);
        }
    }

    public static void prepareLibrary(File inputAar, File outputDir, FileCache buildCache, Consumer<File> action, Logger logger, boolean useBuildCache) throws IOException {
        if (useBuildCache) {
            FileCache.QueryResult result;
            Preconditions.checkNotNull((Object)buildCache);
            FileCache.Inputs buildCacheInputs = PrepareLibraryTask.getBuildCacheInputs(inputAar);
            try {
                result = buildCache.createFileInCacheIfAbsent(buildCacheInputs, action::accept);
            }
            catch (ExecutionException exception) {
                throw new RuntimeException(String.format("Unable to unzip '%1$s' to '%2$s'", inputAar.getAbsolutePath(), outputDir.getAbsolutePath()), exception);
            }
            catch (Exception exception) {
                throw new RuntimeException(String.format("Unable to unzip '%1$s' to '%2$s' or find the cached output '%2$s' using the build cache at '%3$s'.\n%4$s", inputAar.getAbsolutePath(), outputDir.getAbsolutePath(), buildCache.getCacheDirectory().getAbsolutePath(), "To troubleshoot the issue or learn how to disable the build cache, go to https://d.android.com/r/tools/build-cache.html.\nIf you are unable to fix the issue, please file a bug at https://d.android.com/studio/report-bugs.html."), exception);
            }
            if (result.getQueryEvent().equals((Object)FileCache.QueryEvent.CORRUPTED)) {
                logger.info(String.format("The build cache at '%1$s' contained an invalid cache entry.\nCause: %2$s\nWe have recreated the cache entry.\n%3$s", buildCache.getCacheDirectory().getAbsolutePath(), Throwables.getStackTraceAsString((Throwable)((Throwable)result.getCauseOfCorruption().get())), "To troubleshoot the issue or learn how to disable the build cache, go to https://d.android.com/r/tools/build-cache.html.\nIf you are unable to fix the issue, please file a bug at https://d.android.com/studio/report-bugs.html."));
            }
        } else {
            action.accept(outputDir);
        }
    }

    public static boolean shouldUseBuildCache(boolean buildCacheEnabled, MavenCoordinates mavenCoordinates) {
        return buildCacheEnabled && !mavenCoordinates.getVersion().endsWith("-SNAPSHOT");
    }

    public static FileCache.Inputs getBuildCacheInputs(File artifactFile) throws IOException {
        return new FileCache.Inputs.Builder(FileCache.Command.PREPARE_LIBRARY).putFilePath(FileCacheInputParams.FILE_PATH.name(), artifactFile).putLong(FileCacheInputParams.FILE_SIZE.name(), artifactFile.length()).putLong(FileCacheInputParams.FILE_TIMESTAMP.name(), artifactFile.lastModified()).build();
    }

    private static enum FileCacheInputParams {
        FILE_PATH,
        FILE_SIZE,
        FILE_TIMESTAMP;

    }
}

