/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks.databinding;

import android.databinding.tool.LayoutXmlProcessor;
import android.databinding.tool.processing.Scope;
import com.android.build.gradle.internal.scope.ConventionMappingHelper;
import com.android.build.gradle.internal.scope.TaskConfigAction;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.variant.BaseVariantData;
import com.android.build.gradle.internal.variant.BaseVariantOutputData;
import java.io.File;
import java.util.stream.Collectors;
import org.gradle.api.DefaultTask;
import org.gradle.api.Task;
import org.gradle.api.file.ConfigurableFileTree;
import org.gradle.api.file.FileCollection;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputDirectory;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.incremental.IncrementalTaskInputs;

public class DataBindingExportBuildInfoTask
extends DefaultTask {
    private LayoutXmlProcessor xmlProcessor;
    private File sdkDir;
    private File xmlOutFolder;
    private File exportClassListTo;
    private File dataBindingClassOutput;

    @TaskAction
    public void exportInfo(IncrementalTaskInputs inputs) {
        this.xmlProcessor.writeEmptyInfoClass();
        Scope.assertNoError();
    }

    public LayoutXmlProcessor getXmlProcessor() {
        return this.xmlProcessor;
    }

    public void setXmlProcessor(LayoutXmlProcessor xmlProcessor) {
        this.xmlProcessor = xmlProcessor;
    }

    @InputFiles
    public FileCollection getCompilerClasspath() {
        return null;
    }

    @InputFiles
    public Iterable<ConfigurableFileTree> getCompilerSources() {
        return null;
    }

    @Input
    public File getSdkDir() {
        return this.sdkDir;
    }

    public void setSdkDir(File sdkDir) {
        this.sdkDir = sdkDir;
    }

    @InputDirectory
    public File getXmlOutFolder() {
        return this.xmlOutFolder;
    }

    public void setXmlOutFolder(File xmlOutFolder) {
        this.xmlOutFolder = xmlOutFolder;
    }

    @Input
    @Optional
    public File getExportClassListTo() {
        return this.exportClassListTo;
    }

    public void setExportClassListTo(File exportClassListTo) {
        this.exportClassListTo = exportClassListTo;
    }

    @OutputDirectory
    public File getOutput() {
        return this.dataBindingClassOutput;
    }

    public void setDataBindingClassOutput(File dataBindingClassOutput) {
        this.dataBindingClassOutput = dataBindingClassOutput;
    }

    public static class ConfigAction
    implements TaskConfigAction<DataBindingExportBuildInfoTask> {
        private final VariantScope variantScope;

        public ConfigAction(VariantScope variantScope) {
            this.variantScope = variantScope;
        }

        @Override
        public String getName() {
            return this.variantScope.getTaskName("dataBindingExportBuildInfo");
        }

        @Override
        public Class<DataBindingExportBuildInfoTask> getType() {
            return DataBindingExportBuildInfoTask.class;
        }

        @Override
        public void execute(DataBindingExportBuildInfoTask task) {
            BaseVariantData<? extends BaseVariantOutputData> variantData = this.variantScope.getVariantData();
            task.setXmlProcessor(variantData.getLayoutXmlProcessor());
            task.setSdkDir(this.variantScope.getGlobalScope().getSdkHandler().getSdkFolder());
            task.setXmlOutFolder(this.variantScope.getLayoutInfoOutputForDataBinding());
            ConventionMappingHelper.map((Task)task, "compilerClasspath", this.variantScope::getJavaClasspath);
            ConventionMappingHelper.map((Task)task, "compilerSources", () -> variantData.getJavaSources().stream().filter(input -> !this.variantScope.getClassOutputForDataBinding().equals(input.getDir())).collect(Collectors.toList()));
            task.setExportClassListTo(variantData.getType().isExportDataBindingClassList() ? this.variantScope.getGeneratedClassListOutputFileForDataBinding() : null);
            task.setDataBindingClassOutput(this.variantScope.getClassOutputForDataBinding());
        }
    }
}

