/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks.databinding;

import android.databinding.tool.DataBindingBuilder;
import com.android.build.api.transform.DirectoryInput;
import com.android.build.api.transform.JarInput;
import com.android.build.api.transform.QualifiedContent;
import com.android.build.api.transform.Transform;
import com.android.build.api.transform.TransformException;
import com.android.build.api.transform.TransformInput;
import com.android.build.api.transform.TransformInvocation;
import com.android.build.gradle.internal.LoggerWrapper;
import com.android.build.gradle.internal.pipeline.TransformManager;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.utils.ILogger;
import com.google.common.base.Charsets;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.common.hash.HashCode;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import com.google.common.io.ByteStreams;
import com.google.common.io.Closer;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.io.FileUtils;
import org.gradle.api.logging.Logger;

public class DataBindingMergeArtifactsTransform
extends Transform {
    private final ILogger logger;
    private final File outFolder;

    public DataBindingMergeArtifactsTransform(Logger logger, VariantScope variantScope) {
        this.logger = new LoggerWrapper(logger);
        this.outFolder = new File(variantScope.getBuildFolderForDataBindingCompiler(), "dependent-lib-artifacts");
    }

    public String getName() {
        return "dataBindingMergeArtifacts";
    }

    public Collection<File> getSecondaryDirectoryOutputs() {
        return Collections.singleton(this.outFolder);
    }

    public void transform(TransformInvocation transformInvocation) throws TransformException, InterruptedException, IOException {
        Collection inputs = transformInvocation.getReferencedInputs();
        this.outFolder.mkdirs();
        if (transformInvocation.isIncremental()) {
            this.incrementalUpdate(inputs);
        } else {
            this.fullCopy(inputs);
        }
    }

    private void incrementalUpdate(Collection<TransformInput> inputs) {
        inputs.forEach(input -> input.getDirectoryInputs().forEach(directoryInput -> directoryInput.getChangedFiles().forEach((file, status) -> {
            if (DataBindingMergeArtifactsTransform.isResource(file.getName())) {
                switch (status) {
                    case ADDED: 
                    case CHANGED: {
                        try {
                            FileUtils.copyFile((File)file, (File)new File(this.outFolder, file.getName()));
                        }
                        catch (IOException e) {
                            this.logger.error((Throwable)e, "Cannot copy data binding artifacts from dependency.", new Object[0]);
                        }
                        break;
                    }
                    case REMOVED: {
                        FileUtils.deleteQuietly((File)new File(this.outFolder, file.getName()));
                    }
                }
            }
        })));
        inputs.forEach(input -> input.getJarInputs().forEach(jarInput -> {
            switch (jarInput.getStatus()) {
                case ADDED: 
                case CHANGED: {
                    try {
                        this.extractBinFilesFromJar(jarInput.getFile());
                    }
                    catch (IOException e) {
                        this.logger.error((Throwable)e, "Cannot extract data binding from input jar ", new Object[0]);
                    }
                    break;
                }
                case REMOVED: {
                    File jarOutFolder = this.getOutFolderForJarFile(jarInput.getFile());
                    FileUtils.deleteQuietly((File)jarOutFolder);
                }
            }
        }));
    }

    private void fullCopy(Collection<TransformInput> inputs) throws IOException {
        FileUtils.deleteQuietly((File)this.outFolder);
        FileUtils.forceMkdir((File)this.outFolder);
        for (TransformInput input : inputs) {
            for (DirectoryInput dirInput : input.getDirectoryInputs()) {
                File artifactFolder;
                File dataBindingDir = dirInput.getFile();
                if (!dataBindingDir.exists() || !(artifactFolder = new File(dataBindingDir, "bin-files")).exists()) continue;
                for (String artifactName : artifactFolder.list()) {
                    if (!DataBindingMergeArtifactsTransform.isResource(artifactName)) continue;
                    FileUtils.copyFile((File)new File(artifactFolder, artifactName), (File)new File(this.outFolder, artifactName));
                }
            }
            for (JarInput jarInput : input.getJarInputs()) {
                File jarFile = jarInput.getFile();
                this.extractBinFilesFromJar(jarFile);
            }
        }
    }

    private static boolean isResource(String fileName) {
        for (String ext : DataBindingBuilder.RESOURCE_FILE_EXTENSIONS) {
            if (!fileName.endsWith(ext)) continue;
            return true;
        }
        return false;
    }

    public Set<QualifiedContent.ContentType> getInputTypes() {
        return TransformManager.DATA_BINDING_ARTIFACT;
    }

    public Set<QualifiedContent.Scope> getReferencedScopes() {
        return Sets.immutableEnumSet((Enum)QualifiedContent.Scope.SUB_PROJECTS, (Enum[])new QualifiedContent.Scope[]{QualifiedContent.Scope.EXTERNAL_LIBRARIES});
    }

    public Set<QualifiedContent.Scope> getScopes() {
        return TransformManager.EMPTY_SCOPES;
    }

    public Set<QualifiedContent.ContentType> getOutputTypes() {
        return ImmutableSet.of();
    }

    public boolean isIncremental() {
        return true;
    }

    private void extractBinFilesFromJar(File jarFile) throws IOException {
        File jarOutFolder = this.getOutFolderForJarFile(jarFile);
        FileUtils.deleteQuietly((File)jarOutFolder);
        FileUtils.forceMkdir((File)jarOutFolder);
        try (Closer localCloser = Closer.create();){
            ZipEntry entry;
            FileInputStream fis = (FileInputStream)localCloser.register((Closeable)new FileInputStream(jarFile));
            ZipInputStream zis = (ZipInputStream)localCloser.register((Closeable)new ZipInputStream(fis));
            while ((entry = zis.getNextEntry()) != null) {
                String name;
                if (entry.isDirectory() || !DataBindingMergeArtifactsTransform.isResource(name = entry.getName())) continue;
                name = new File(name).getName();
                File out = new File(jarOutFolder, name);
                FileOutputStream fos = (FileOutputStream)localCloser.register((Closeable)new FileOutputStream(out));
                ByteStreams.copy((InputStream)zis, (OutputStream)fos);
                zis.closeEntry();
            }
        }
    }

    private File getOutFolderForJarFile(File jarFile) {
        return new File(this.outFolder, DataBindingMergeArtifactsTransform.getJarFilePrefix(jarFile));
    }

    private static String getJarFilePrefix(File inputFile) {
        String name = inputFile.getName();
        int pos = name.lastIndexOf(46);
        if (pos != -1) {
            name = name.substring(0, pos);
        }
        String input = inputFile.getAbsolutePath();
        HashFunction hashFunction = Hashing.sha1();
        HashCode hashCode = hashFunction.hashString((CharSequence)input, Charsets.UTF_16LE);
        return name + "-" + hashCode.toString();
    }
}

