/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.test;

import com.android.build.gradle.api.ApkOutputFile;
import com.android.build.gradle.internal.core.GradleVariantConfiguration;
import com.android.build.gradle.internal.publishing.FilterDataPersistence;
import com.android.build.gradle.internal.test.AbstractTestDataImpl;
import com.android.build.gradle.internal.variant.BaseVariantData;
import com.android.build.gradle.internal.variant.BaseVariantOutputData;
import com.android.builder.core.AndroidBuilder;
import com.android.builder.core.ApkInfoParser;
import com.android.builder.model.SourceProvider;
import com.android.builder.testing.api.DeviceConfigProvider;
import com.android.ide.common.build.SplitOutputMatcher;
import com.android.ide.common.process.ProcessException;
import com.android.ide.common.process.ProcessExecutor;
import com.android.sdklib.BuildToolInfo;
import com.android.utils.ILogger;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.gradle.api.artifacts.Configuration;

public class TestApplicationTestData
extends AbstractTestDataImpl {
    private final Configuration testedConfiguration;
    private final Configuration testedMetadata;
    private final AndroidBuilder androidBuilder;
    private final BaseVariantData testVariant;

    public TestApplicationTestData(BaseVariantData<? extends BaseVariantOutputData> testVariantData, Configuration testedConfiguration, Configuration testedMetadata, AndroidBuilder androidBuilder) {
        super(testVariantData.getVariantConfiguration());
        this.testVariant = testVariantData;
        this.testedConfiguration = testedConfiguration;
        this.testedMetadata = testedMetadata;
        this.androidBuilder = androidBuilder;
    }

    public String getApplicationId() {
        return this.testVariant.getApplicationId();
    }

    public String getTestedApplicationId() {
        ApkInfoParser.ApkInfo apkInfo = this.loadTestedApkInfo();
        return apkInfo.getPackageName();
    }

    public boolean isLibrary() {
        return false;
    }

    public ImmutableList<File> getTestedApks(ProcessExecutor processExecutor, File splitSelectExe, DeviceConfigProvider deviceConfigProvider, ILogger logger) throws ProcessException {
        ImmutableList.Builder testedApks = ImmutableList.builder();
        Set testedApkFiles = this.testedConfiguration.getFiles();
        if (testedApkFiles.size() > 1 && splitSelectExe != null) {
            List<File> testedSplitApkFiles = this.getSplitApks();
            List testedSplitApksPath = Lists.transform(testedSplitApkFiles, file -> file != null ? file.getAbsolutePath() : null);
            testedApks.addAll((Iterable)SplitOutputMatcher.computeBestOutput((ProcessExecutor)processExecutor, (File)splitSelectExe, (DeviceConfigProvider)deviceConfigProvider, (File)this.getMainApk(), (Collection)testedSplitApksPath));
        } else {
            if (testedApkFiles.size() > 1) {
                logger.warning("split-select tool unavailable, all split APKs will be installed", new Object[0]);
            }
            testedApks.addAll((Iterable)testedApkFiles);
        }
        return testedApks.build();
    }

    public File getTestApk() {
        ImmutableList<ApkOutputFile> outputs = ((BaseVariantOutputData)this.testVariant.getMainOutput()).getOutputs();
        Preconditions.checkState((outputs.size() == 1 ? 1 : 0) != 0, (Object)"There must be exactly one output");
        return ((ApkOutputFile)outputs.get(0)).getOutputFile();
    }

    public List<File> getTestDirectories() {
        GradleVariantConfiguration variantConfiguration = this.testVariant.getVariantConfiguration();
        ImmutableList.Builder javaDirectories = ImmutableList.builder();
        for (SourceProvider sourceProvider : variantConfiguration.getSortedSourceProviders()) {
            javaDirectories.addAll((Iterable)sourceProvider.getJavaDirectories());
        }
        return javaDirectories.build();
    }

    private ApkInfoParser.ApkInfo loadTestedApkInfo() {
        File aaptFile = new File(this.androidBuilder.getTargetInfo().getBuildTools().getPath(BuildToolInfo.PathId.AAPT));
        ApkInfoParser apkInfoParser = new ApkInfoParser(aaptFile, this.androidBuilder.getProcessExecutor());
        try {
            return apkInfoParser.parseApk(this.getMainApk());
        }
        catch (ProcessException e) {
            throw new RuntimeException(e);
        }
    }

    public List<File> getSplitApks() {
        ArrayList<File> testedApkFiles = new ArrayList<File>(this.testedConfiguration.getFiles());
        if (testedApkFiles.size() > 1) {
            testedApkFiles.remove(this.getMainApk());
            return testedApkFiles;
        }
        return Collections.emptyList();
    }

    public File getMainApk() {
        HashSet<File> testedApkFiles = new HashSet<File>(this.testedConfiguration.getFiles());
        if (testedApkFiles.size() > 1) {
            List<FilterDataPersistence.Record> filterDatas = this.loadMetadata();
            for (FilterDataPersistence.Record filterData : filterDatas) {
                File splitFile = TestApplicationTestData.findSplitFile(testedApkFiles, filterData.splitFileName);
                if (splitFile != null) {
                    testedApkFiles.remove(splitFile);
                    continue;
                }
                throw new RuntimeException(String.format("Internal Error : %1$s is not in the list of published files", filterData.splitFileName));
            }
            if (testedApkFiles.size() != 1) {
                throw new RuntimeException(String.format("Internal Error : %1$s files are not in the variant metadata", Joiner.on((String)",").join(testedApkFiles)));
            }
        }
        if (testedApkFiles.isEmpty()) {
            throw new RuntimeException("Cannot retrieve tested APKs");
        }
        return (File)Iterables.getOnlyElement(testedApkFiles);
    }

    private List<FilterDataPersistence.Record> loadMetadata() {
        File metadataFile = this.testedMetadata.getSingleFile();
        FilterDataPersistence persistence = new FilterDataPersistence();
        try {
            return persistence.load(new FileReader(metadataFile));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static File findSplitFile(Collection<File> splitFiles, String splitFileName) {
        for (File splitFile : splitFiles) {
            if (!splitFile.getName().equals(splitFileName)) continue;
            return splitFile;
        }
        return null;
    }
}

