/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.variant;

import android.databinding.tool.LayoutXmlProcessor;
import com.android.build.FilterData;
import com.android.build.OutputFile;
import com.android.build.gradle.AndroidConfig;
import com.android.build.gradle.api.AndroidSourceSet;
import com.android.build.gradle.internal.TaskManager;
import com.android.build.gradle.internal.api.DefaultAndroidSourceSet;
import com.android.build.gradle.internal.core.GradleVariantConfiguration;
import com.android.build.gradle.internal.dependency.VariantDependencies;
import com.android.build.gradle.internal.dsl.CoreBuildType;
import com.android.build.gradle.internal.dsl.Splits;
import com.android.build.gradle.internal.pipeline.TransformManager;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.scope.VariantScopeImpl;
import com.android.build.gradle.internal.tasks.CheckManifest;
import com.android.build.gradle.internal.tasks.FileSupplier;
import com.android.build.gradle.internal.tasks.GenerateApkDataTask;
import com.android.build.gradle.internal.tasks.PrepareDependenciesTask;
import com.android.build.gradle.internal.transforms.JackTransform;
import com.android.build.gradle.internal.variant.BaseVariantOutputData;
import com.android.build.gradle.internal.variant.SplitHandlingPolicy;
import com.android.build.gradle.tasks.AidlCompile;
import com.android.build.gradle.tasks.BinaryFileProviderTask;
import com.android.build.gradle.tasks.ExternalNativeBuildTask;
import com.android.build.gradle.tasks.GenerateBuildConfig;
import com.android.build.gradle.tasks.GenerateResValues;
import com.android.build.gradle.tasks.MergeResources;
import com.android.build.gradle.tasks.MergeSourceSetFolders;
import com.android.build.gradle.tasks.NdkCompile;
import com.android.build.gradle.tasks.ProcessAndroidResources;
import com.android.build.gradle.tasks.RenderscriptCompile;
import com.android.build.gradle.tasks.ShaderCompile;
import com.android.builder.core.ErrorReporter;
import com.android.builder.core.VariantType;
import com.android.builder.model.SourceProvider;
import com.android.builder.profile.Recorder;
import com.android.ide.common.blame.MergingLog;
import com.android.ide.common.blame.SourceFile;
import com.android.ide.common.res2.ResourceSet;
import com.android.utils.StringHelper;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.file.ConfigurableFileTree;
import org.gradle.api.logging.Logging;
import org.gradle.api.tasks.Copy;
import org.gradle.api.tasks.Sync;
import org.gradle.api.tasks.bundling.Jar;
import org.gradle.api.tasks.compile.JavaCompile;

public abstract class BaseVariantData<T extends BaseVariantOutputData> {
    protected final TaskManager taskManager;
    private final GradleVariantConfiguration variantConfiguration;
    private VariantDependencies variantDependency;
    private final VariantScope scope;
    public Task preBuildTask;
    public PrepareDependenciesTask prepareDependenciesTask;
    public ProcessAndroidResources generateRClassTask;
    public Task sourceGenTask;
    public Task resourceGenTask;
    public Task assetGenTask;
    public CheckManifest checkManifestTask;
    public RenderscriptCompile renderscriptCompileTask;
    public AidlCompile aidlCompileTask;
    public MergeResources mergeResourcesTask;
    public MergeSourceSetFolders mergeAssetsTask;
    public GenerateBuildConfig generateBuildConfigTask;
    public GenerateResValues generateResValuesTask;
    public Copy copyApkTask;
    public GenerateApkDataTask generateApkDataTask;
    public ShaderCompile shaderCompileTask;
    public Sync processJavaResourcesTask;
    public NdkCompile ndkCompileTask;
    public Task javaCompilerTask;
    public JavaCompile javacTask;
    public Collection<ExternalNativeBuildTask> externalNativeBuildTasks = Lists.newArrayList();
    public JackTransform jackTransform = null;
    public Jar classesJarTask;
    public Task compileTask;
    public FileSupplier mappingFileProviderTask;
    public BinaryFileProviderTask binaryFileProviderTask;
    public Task obfuscationTask;
    public Task assembleVariantTask;
    private List<ConfigurableFileTree> javaSources;
    private List<File> extraGeneratedSourceFolders;
    private List<File> extraGeneratedResFolders;
    private final List<T> outputs = Lists.newArrayListWithExpectedSize((int)4);
    private T mainOutput;
    private Set<String> densityFilters;
    private Set<String> languageFilters;
    private Set<String> abiFilters;
    private LayoutXmlProcessor layoutXmlProcessor;
    public boolean outputsAreSigned = false;
    private SplitHandlingPolicy mSplitHandlingPolicy;

    public BaseVariantData(AndroidConfig androidConfig, TaskManager taskManager, GradleVariantConfiguration variantConfiguration, ErrorReporter errorReporter, Recorder recorder) {
        this.variantConfiguration = variantConfiguration;
        this.taskManager = taskManager;
        SplitHandlingPolicy splitHandlingPolicy = this.mSplitHandlingPolicy = androidConfig.getGeneratePureSplits() && variantConfiguration.getMinSdkVersion().getApiLevel() >= 21 ? SplitHandlingPolicy.RELEASE_21_AND_AFTER_POLICY : SplitHandlingPolicy.PRE_21_POLICY;
        if (androidConfig.getGeneratePureSplits() && this.mSplitHandlingPolicy != SplitHandlingPolicy.RELEASE_21_AND_AFTER_POLICY) {
            Logging.getLogger(BaseVariantData.class).warn(String.format("Variant %s, MinSdkVersion %s is too low (<21) to support pure splits, reverting to full APKs", variantConfiguration.getFullName(), variantConfiguration.getMinSdkVersion().getApiLevel()));
        }
        this.scope = new VariantScopeImpl(taskManager.getGlobalScope(), new TransformManager(taskManager.getAndroidTasks(), errorReporter, recorder), this);
        taskManager.configureScopeForNdk(this.scope);
    }

    public LayoutXmlProcessor getLayoutXmlProcessor() {
        if (this.layoutXmlProcessor == null) {
            File resourceBlameLogDir = this.getScope().getResourceBlameLogDir();
            MergingLog mergingLog = new MergingLog(resourceBlameLogDir);
            this.layoutXmlProcessor = new LayoutXmlProcessor(this.getVariantConfiguration().getOriginalApplicationId(), this.taskManager.getDataBindingBuilder().createJavaFileWriter(this.scope.getClassOutputForDataBinding()), file -> {
                SourceFile input = new SourceFile(file);
                SourceFile original = mergingLog.find(input);
                return original == input ? null : original.getSourceFile();
            });
        }
        return this.layoutXmlProcessor;
    }

    public SplitHandlingPolicy getSplitHandlingPolicy() {
        return this.mSplitHandlingPolicy;
    }

    protected abstract T doCreateOutput(OutputFile.OutputType var1, Collection<FilterData> var2);

    public T createOutput(OutputFile.OutputType outputType, Collection<FilterData> filters) {
        T data = this.doCreateOutput(outputType, filters);
        if (this.outputs.size() == 1) {
            ((BaseVariantOutputData)this.outputs.get(0)).setMultiOutput(true);
            ((BaseVariantOutputData)data).setMultiOutput(true);
        } else if (this.outputs.size() > 1) {
            ((BaseVariantOutputData)data).setMultiOutput(true);
        }
        this.outputs.add(data);
        return data;
    }

    public List<T> getOutputs() {
        return this.outputs;
    }

    public void setMainOutput(T mainOutput) {
        Preconditions.checkState((boolean)this.outputs.contains(mainOutput));
        this.mainOutput = mainOutput;
    }

    public T getMainOutput() {
        if (this.mainOutput != null) {
            return this.mainOutput;
        }
        Preconditions.checkState((!this.outputs.isEmpty() ? 1 : 0) != 0);
        return (T)((BaseVariantOutputData)this.outputs.get(0));
    }

    public GradleVariantConfiguration getVariantConfiguration() {
        return this.variantConfiguration;
    }

    public void setVariantDependency(VariantDependencies variantDependency) {
        this.variantDependency = variantDependency;
    }

    public VariantDependencies getVariantDependency() {
        return this.variantDependency;
    }

    public abstract String getDescription();

    public String getApplicationId() {
        return this.variantConfiguration.getApplicationId();
    }

    protected String getCapitalizedBuildTypeName() {
        return StringHelper.capitalize((String)((CoreBuildType)this.variantConfiguration.getBuildType()).getName());
    }

    protected String getCapitalizedFlavorName() {
        return StringHelper.capitalize((String)this.variantConfiguration.getFlavorName());
    }

    public VariantType getType() {
        return this.variantConfiguration.getType();
    }

    public String getName() {
        return this.variantConfiguration.getFullName();
    }

    public List<File> getExtraGeneratedSourceFolders() {
        return this.extraGeneratedSourceFolders;
    }

    public List<File> getExtraGeneratedResFolders() {
        return this.extraGeneratedResFolders;
    }

    public void addJavaSourceFoldersToModel(File ... generatedSourceFolders) {
        if (this.extraGeneratedSourceFolders == null) {
            this.extraGeneratedSourceFolders = Lists.newArrayList();
        }
        Collections.addAll(this.extraGeneratedSourceFolders, generatedSourceFolders);
    }

    public void addJavaSourceFoldersToModel(Collection<File> generatedSourceFolders) {
        if (this.extraGeneratedSourceFolders == null) {
            this.extraGeneratedSourceFolders = Lists.newArrayList();
        }
        this.extraGeneratedSourceFolders.addAll(generatedSourceFolders);
    }

    public void registerJavaGeneratingTask(Task task, File ... generatedSourceFolders) {
        Preconditions.checkState((this.javacTask != null || this.jackTransform != null ? 1 : 0) != 0);
        this.sourceGenTask.dependsOn(new Object[]{task});
        for (File f : generatedSourceFolders) {
            if (this.javacTask != null) {
                this.javacTask.source(new Object[]{f});
            }
            if (this.jackTransform == null) continue;
            this.jackTransform.addSource(f);
        }
        this.addJavaSourceFoldersToModel(generatedSourceFolders);
    }

    public void registerJavaGeneratingTask(Task task, Collection<File> generatedSourceFolders) {
        Preconditions.checkState((this.javacTask != null || this.jackTransform != null ? 1 : 0) != 0);
        this.sourceGenTask.dependsOn(new Object[]{task});
        for (File f : generatedSourceFolders) {
            if (this.javacTask != null) {
                this.javacTask.source(new Object[]{f});
            }
            if (this.jackTransform == null) continue;
            this.jackTransform.addSource(f);
        }
        this.addJavaSourceFoldersToModel(generatedSourceFolders);
    }

    public void registerResGeneratingTask(Task task, File ... generatedResFolders) {
        this.resourceGenTask.dependsOn(new Object[]{task});
        if (this.extraGeneratedResFolders == null) {
            this.extraGeneratedResFolders = Lists.newArrayList();
        }
        Collections.addAll(this.extraGeneratedResFolders, generatedResFolders);
    }

    public void registerResGeneratingTask(Task task, Collection<File> generatedResFolders) {
        this.resourceGenTask.dependsOn(new Object[]{task});
        if (this.extraGeneratedResFolders == null) {
            this.extraGeneratedResFolders = Lists.newArrayList();
        }
        this.extraGeneratedResFolders.addAll(generatedResFolders);
    }

    public void calculateFilters(Splits splits) {
        List resourceSets = this.variantConfiguration.getResourceSets(this.getGeneratedResFolders(), false, false);
        this.densityFilters = BaseVariantData.getFilters(resourceSets, DiscoverableFilterType.DENSITY, splits);
        this.languageFilters = BaseVariantData.getFilters(resourceSets, DiscoverableFilterType.LANGUAGE, splits);
        this.abiFilters = BaseVariantData.getFilters(resourceSets, DiscoverableFilterType.ABI, splits);
    }

    public Set<String> getFilters(OutputFile.FilterType filterType) {
        if (this.densityFilters == null || this.languageFilters == null || this.abiFilters == null) {
            throw new IllegalStateException("calculateFilters method not called");
        }
        switch (filterType) {
            case DENSITY: {
                return this.densityFilters;
            }
            case LANGUAGE: {
                return this.languageFilters;
            }
            case ABI: {
                return this.abiFilters;
            }
        }
        throw new RuntimeException("Unhandled filter type");
    }

    private List<File> getGeneratedResFolders() {
        ArrayList generatedResFolders = Lists.newArrayList((Object[])new File[]{this.scope.getRenderscriptResOutputDir(), this.scope.getGeneratedResOutputDir()});
        if (this.extraGeneratedResFolders != null) {
            generatedResFolders.addAll(this.extraGeneratedResFolders);
        }
        if (this.getScope().getMicroApkTask() != null && ((CoreBuildType)this.getVariantConfiguration().getBuildType()).isEmbedMicroApp()) {
            generatedResFolders.add(this.getScope().getMicroApkResDirectory());
        }
        return generatedResFolders;
    }

    public List<String> discoverListOfResourceConfigs() {
        ArrayList<String> resFoldersOnDisk = new ArrayList<String>();
        List resourceSets = this.variantConfiguration.getResourceSets(this.getGeneratedResFolders(), false, false);
        resFoldersOnDisk.addAll(BaseVariantData.getAllFilters(resourceSets, DiscoverableFilterType.LANGUAGE.folderPrefix, DiscoverableFilterType.DENSITY.folderPrefix));
        return resFoldersOnDisk;
    }

    public List<String> discoverListOfResourceConfigsNotDensities() {
        ArrayList<String> resFoldersOnDisk = new ArrayList<String>();
        List resourceSets = this.variantConfiguration.getResourceSets(this.getGeneratedResFolders(), false, false);
        resFoldersOnDisk.addAll(BaseVariantData.getAllFilters(resourceSets, DiscoverableFilterType.LANGUAGE.folderPrefix));
        return resFoldersOnDisk;
    }

    private static Set<String> getFilters(List<ResourceSet> resourceSets, DiscoverableFilterType filterType, Splits splits) {
        HashSet<String> filtersList = new HashSet<String>();
        if (filterType.isAuto(splits)) {
            filtersList.addAll(BaseVariantData.getAllFilters(resourceSets, filterType.folderPrefix));
        } else {
            filtersList.addAll(filterType.getConfiguredFilters(splits));
        }
        return filtersList;
    }

    private static List<String> getAllFilters(List<ResourceSet> resourceSets, String ... prefixes) {
        ArrayList<String> providedResFolders = new ArrayList<String>();
        for (ResourceSet resourceSet : resourceSets) {
            for (File resFolder : resourceSet.getSourceFiles()) {
                File[] subResFolders = resFolder.listFiles();
                if (subResFolders == null) continue;
                for (File subResFolder : subResFolders) {
                    for (String prefix : prefixes) {
                        if (!subResFolder.getName().startsWith(prefix)) continue;
                        providedResFolders.add(subResFolder.getName().substring(prefix.length()));
                    }
                }
            }
        }
        return providedResFolders;
    }

    public List<ConfigurableFileTree> getUserJavaSources() {
        ImmutableList.Builder sourceSets = ImmutableList.builder();
        List providers = this.variantConfiguration.getSortedSourceProviders();
        for (SourceProvider provider : providers) {
            sourceSets.addAll(((AndroidSourceSet)provider).getJava().getSourceDirectoryTrees());
        }
        return sourceSets.build();
    }

    public List<ConfigurableFileTree> getJavaSources() {
        if (this.javaSources == null) {
            ImmutableList.Builder sourceSets = ImmutableList.builder();
            sourceSets.addAll(this.getUserJavaSources());
            sourceSets.addAll(this.getGeneratedJavaSources());
            this.javaSources = sourceSets.build();
        }
        return this.javaSources;
    }

    public List<ConfigurableFileTree> getGeneratedJavaSources() {
        Project project = this.scope.getGlobalScope().getProject();
        ImmutableList.Builder sourceSets = ImmutableList.builder();
        if (this.scope.getGenerateRClassTask() != null) {
            sourceSets.add((Object)project.fileTree((Object)this.scope.getRClassSourceOutputDir()));
        }
        if (this.scope.getGenerateBuildConfigTask() != null) {
            sourceSets.add((Object)project.fileTree((Object)this.scope.getBuildConfigSourceOutputDir()));
        }
        if (this.scope.getAidlCompileTask() != null) {
            sourceSets.add((Object)project.fileTree((Object)this.scope.getAidlSourceOutputDir()));
        }
        if (this.scope.getGlobalScope().getExtension().getDataBinding().isEnabled()) {
            sourceSets.add((Object)project.fileTree((Object)this.scope.getClassOutputForDataBinding()));
        }
        if (!this.variantConfiguration.getRenderscriptNdkModeEnabled() && this.scope.getRenderscriptCompileTask() != null) {
            sourceSets.add((Object)project.fileTree((Object)this.scope.getRenderscriptSourceOutputDir()));
        }
        return sourceSets.build();
    }

    public List<File> getJavaSourceFoldersForCoverage() {
        ArrayList sourceFolders = Lists.newArrayList();
        List providers = this.variantConfiguration.getSortedSourceProviders();
        for (SourceProvider provider : providers) {
            for (File sourceFolder : provider.getJavaDirectories()) {
                if (!sourceFolder.isDirectory()) continue;
                sourceFolders.add(sourceFolder);
            }
        }
        File sourceFolder = this.aidlCompileTask.getSourceOutputDir();
        if (sourceFolder.isDirectory()) {
            sourceFolders.add(sourceFolder);
        }
        if (!this.variantConfiguration.getRenderscriptNdkModeEnabled() && (sourceFolder = this.renderscriptCompileTask.getSourceOutputDir()).isDirectory()) {
            sourceFolders.add(sourceFolder);
        }
        return sourceFolders;
    }

    public List<String> getWearConfigNames() {
        List providers = this.variantConfiguration.getSortedSourceProviders();
        int count = providers.size();
        ArrayList names = Lists.newArrayListWithCapacity((int)count);
        for (int i = count - 1; i >= 0; --i) {
            DefaultAndroidSourceSet sourceSet = (DefaultAndroidSourceSet)providers.get(i);
            names.add(sourceSet.getWearAppConfigurationName());
        }
        return names;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).addValue((Object)this.variantConfiguration.getFullName()).toString();
    }

    public FileSupplier getMappingFileProvider() {
        return this.mappingFileProviderTask;
    }

    public File getMappingFile() {
        return this.mappingFileProviderTask != null ? (File)this.mappingFileProviderTask.get() : null;
    }

    public VariantScope getScope() {
        return this.scope;
    }

    public File getJavaResourcesForUnitTesting() {
        if (this.processJavaResourcesTask != null) {
            return this.processJavaResourcesTask.getOutputs().getFiles().getSingleFile();
        }
        return this.getScope().getSourceFoldersJavaResDestinationDir();
    }

    private static enum DiscoverableFilterType {
        DENSITY("drawable-"){

            @Override
            Collection<String> getConfiguredFilters(Splits splits) {
                return splits.getDensityFilters();
            }

            @Override
            boolean isAuto(Splits splits) {
                return splits.getDensity().isAuto();
            }
        }
        ,
        LANGUAGE("values-"){

            @Override
            Collection<String> getConfiguredFilters(Splits splits) {
                return splits.getLanguageFilters();
            }

            @Override
            boolean isAuto(Splits splits) {
                return splits.getLanguage().isAuto();
            }
        }
        ,
        ABI(""){

            @Override
            Collection<String> getConfiguredFilters(Splits splits) {
                return splits.getAbiFilters();
            }

            @Override
            boolean isAuto(Splits splits) {
                return false;
            }
        };

        private String folderPrefix;

        private DiscoverableFilterType(String folderPrefix) {
            this.folderPrefix = folderPrefix;
        }

        abstract Collection<String> getConfiguredFilters(Splits var1);

        abstract boolean isAuto(Splits var1);
    }
}

