/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.shrinker;

import com.android.build.gradle.shrinker.ClassLookupException;
import com.android.build.gradle.shrinker.DependencyFinderVisitor;
import com.android.build.gradle.shrinker.DependencyType;
import com.android.build.gradle.shrinker.IncrementalShrinker;
import com.android.build.gradle.shrinker.PostProcessingData;
import com.android.build.gradle.shrinker.ShrinkerGraph;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

class IncrementalRunVisitor<T>
extends DependencyFinderVisitor<T> {
    private final ShrinkerGraph<T> mGraph;
    private final Collection<T> mClassesToWrite;
    private final Collection<PostProcessingData.UnresolvedReference<T>> mUnresolvedReferences;
    private String mClassName;
    private Set<T> mMethods;
    private Set<T> mFields;
    private Set<String> mAnnotations;

    public IncrementalRunVisitor(ShrinkerGraph<T> graph, Collection<T> classesToWrite, Collection<PostProcessingData.UnresolvedReference<T>> unresolvedReferences) {
        super(graph, null);
        this.mGraph = graph;
        this.mClassesToWrite = classesToWrite;
        this.mUnresolvedReferences = unresolvedReferences;
    }

    @Override
    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        T klass = this.mGraph.getClassReference(name);
        this.mClassName = name;
        this.checkSuperclass(klass, superName);
        this.checkInterfaces(klass, interfaces);
        this.checkModifiers(klass, access);
        this.mMethods = this.mGraph.getMethods(klass);
        this.mFields = this.mGraph.getFields(klass);
        this.mAnnotations = Sets.newHashSet(this.mGraph.getAnnotations(klass));
        this.mClassesToWrite.add(klass);
        super.visit(version, access, name, signature, superName, interfaces);
    }

    private void checkModifiers(T klass, int modifiers) {
        int oldModifiers = this.mGraph.getModifiers(klass);
        if (oldModifiers != modifiers) {
            throw new IncrementalShrinker.IncrementalRunImpossibleException(String.format("%s modifiers changed.", this.mClassName));
        }
    }

    private void checkInterfaces(T klass, String[] interfaceNames) {
        try {
            ImmutableSet oldNames = ImmutableSet.copyOf((Object[])interfaceNames);
            T[] interfaces = this.mGraph.getInterfaces(klass);
            HashSet newNames = Sets.newHashSet();
            for (T iface : interfaces) {
                newNames.add(this.mGraph.getClassName(iface));
            }
            if (!oldNames.equals(newNames)) {
                throw new IncrementalShrinker.IncrementalRunImpossibleException(String.format("%s interfaces changed.", this.mClassName));
            }
        }
        catch (ClassLookupException e) {
            throw new IncrementalShrinker.IncrementalRunImpossibleException(String.format("Can't find info for class %s.", this.mClassName));
        }
    }

    private void checkSuperclass(T klass, String superName) {
        try {
            T superclass = this.mGraph.getSuperclass(klass);
            Verify.verifyNotNull(superclass);
            if (!this.mGraph.getClassName(superclass).equals(superName)) {
                throw new IncrementalShrinker.IncrementalRunImpossibleException(String.format("%s superclass changed.", this.mClassName));
            }
        }
        catch (ClassLookupException e) {
            throw new IncrementalShrinker.IncrementalRunImpossibleException(String.format("Can't find info for class %s.", this.mClassName));
        }
    }

    @Override
    public FieldVisitor visitField(int access, final String name, String desc, String signature, Object value) {
        T field = this.mGraph.getMemberReference(this.mClassName, name, desc);
        if (!this.mFields.remove(field)) {
            throw new IncrementalShrinker.IncrementalRunImpossibleException(String.format("Field %s.%s:%s added.", this.mClassName, name, desc));
        }
        if (this.mGraph.getModifiers(field) != access) {
            throw new IncrementalShrinker.IncrementalRunImpossibleException(String.format("Field %s.%s:%s modifiers changed.", this.mClassName, name, desc));
        }
        final HashSet memberAnnotations = Sets.newHashSet(this.mGraph.getAnnotations(field));
        FieldVisitor superVisitor = super.visitField(access, name, desc, signature, value);
        return new FieldVisitor(327680, superVisitor){

            public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
                IncrementalRunVisitor.checkForAddedAnnotation(desc, memberAnnotations, IncrementalRunVisitor.this.mClassName + "." + name);
                return super.visitAnnotation(desc, visible);
            }

            public void visitEnd() {
                IncrementalRunVisitor.checkForRemovedAnnotation(memberAnnotations, IncrementalRunVisitor.this.mClassName + "." + name);
                super.visitEnd();
            }
        };
    }

    @Override
    public MethodVisitor visitMethod(int access, final String name, String desc, String signature, String[] exceptions) {
        T method = this.mGraph.getMemberReference(this.mClassName, name, desc);
        if (!this.mMethods.remove(method)) {
            throw new IncrementalShrinker.IncrementalRunImpossibleException(String.format("Method %s.%s:%s added.", this.mClassName, name, desc));
        }
        if (this.mGraph.getModifiers(method) != access) {
            throw new IncrementalShrinker.IncrementalRunImpossibleException(String.format("Method %s.%s:%s modifiers changed.", this.mClassName, name, desc));
        }
        final HashSet memberAnnotations = Sets.newHashSet(this.mGraph.getAnnotations(method));
        MethodVisitor superVisitor = super.visitMethod(access, name, desc, signature, exceptions);
        return new MethodVisitor(327680, superVisitor){

            public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
                IncrementalRunVisitor.checkForAddedAnnotation(desc, memberAnnotations, IncrementalRunVisitor.this.mClassName + "." + name);
                return super.visitAnnotation(desc, visible);
            }

            public void visitEnd() {
                IncrementalRunVisitor.checkForRemovedAnnotation(memberAnnotations, IncrementalRunVisitor.this.mClassName + "." + name);
                super.visitEnd();
            }
        };
    }

    @Override
    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        IncrementalRunVisitor.checkForAddedAnnotation(desc, this.mAnnotations, this.mClassName);
        return super.visitAnnotation(desc, visible);
    }

    @Override
    protected void handleDependency(T source, T target, DependencyType type) {
        if (type == DependencyType.REQUIRED_CODE_REFERENCE || type == DependencyType.REQUIRED_CODE_REFERENCE_REFLECTION) {
            this.mGraph.addDependency(source, target, type);
        }
    }

    @Override
    protected void handleMultipleInheritance(T klass) {
    }

    @Override
    protected void handleVirtualMethod(T method) {
    }

    @Override
    protected void handleInterfaceInheritance(T klass) {
    }

    @Override
    protected void handleUnresolvedReference(PostProcessingData.UnresolvedReference<T> reference) {
        this.mUnresolvedReferences.add(reference);
    }

    public void visitEnd() {
        Object field = Iterables.getFirst(this.mFields, null);
        if (field != null) {
            throw new IncrementalShrinker.IncrementalRunImpossibleException(String.format("Field %s.%s:%s removed.", this.mClassName, this.mGraph.getMemberName(field), this.mGraph.getMemberDescriptor(field)));
        }
        for (T method : this.mMethods) {
            if (this.mGraph.getMemberName(method).endsWith("$shrinker_fake")) continue;
            throw new IncrementalShrinker.IncrementalRunImpossibleException(String.format("Method %s.%s:%s removed.", this.mClassName, this.mGraph.getMemberName(method), this.mGraph.getMemberDescriptor(method)));
        }
        IncrementalRunVisitor.checkForRemovedAnnotation(this.mAnnotations, this.mClassName);
    }

    private static void checkForAddedAnnotation(String desc, Set<String> annotations, String target) {
        String name = Type.getType((String)desc).getInternalName();
        if (!annotations.remove(name)) {
            throw new IncrementalShrinker.IncrementalRunImpossibleException(String.format("Annotation %s on %s added.", name, target));
        }
    }

    private static void checkForRemovedAnnotation(Set<String> annotations, String target) {
        String annotation = (String)Iterables.getFirst(annotations, null);
        if (annotation != null) {
            throw new IncrementalShrinker.IncrementalRunImpossibleException(String.format("Annotation %s on %s removed.", annotation, target));
        }
    }
}

