/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.tasks;

import com.android.build.gradle.internal.pipeline.StreamFilter;
import com.android.build.gradle.internal.scope.ConventionMappingHelper;
import com.android.build.gradle.internal.scope.TaskConfigAction;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.tasks.DefaultAndroidTask;
import com.android.build.gradle.internal.tasks.FileSupplier;
import com.android.utils.FileUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.apache.commons.compress.utils.IOUtils;
import org.gradle.api.Task;
import org.gradle.api.tasks.InputDirectory;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;

public class BundleAtom
extends DefaultAndroidTask
implements FileSupplier {
    private File bundleFolder;
    private File bundleFile;
    private Set<File> jniFolders;
    private Set<File> dexFolders;
    private Set<File> javaResources;

    private static void deleteDirectoryContents(File directory) throws IOException {
        if (!directory.exists()) {
            FileUtils.mkdirs((File)directory);
        } else if (!directory.isDirectory()) {
            FileUtils.delete((File)directory);
            FileUtils.mkdirs((File)directory);
        } else {
            FileUtils.deleteDirectoryContents((File)directory);
        }
    }

    @TaskAction
    public void taskAction() throws IOException {
        File bundleFolder = this.getBundleFolder();
        File libBundleFolder = new File(bundleFolder, "libs");
        BundleAtom.deleteDirectoryContents(libBundleFolder);
        for (File file : this.getJniFolders()) {
            for (Object lib : FileUtils.find((File)file, (Pattern)Pattern.compile("\\.so$"))) {
                File destLibFile = new File(libBundleFolder, FileUtils.relativePath((File)lib, (File)file));
                if (!destLibFile.getParentFile().exists()) {
                    FileUtils.mkdirs((File)destLibFile.getParentFile());
                }
                FileUtils.copyFile((File)lib, (File)destLibFile);
            }
        }
        File dexBundleFolder = new File(bundleFolder, "dex");
        BundleAtom.deleteDirectoryContents(dexBundleFolder);
        for (File file : this.getDexFolders()) {
            for (Object dexFile : FileUtils.find((File)file, (Pattern)Pattern.compile("\\.dex$"))) {
                File destDexFile = new File(dexBundleFolder, ((File)dexFile).getName());
                FileUtils.copyFile((File)dexFile, (File)destDexFile);
            }
        }
        File file = new File(bundleFolder, "resources");
        BundleAtom.deleteDirectoryContents(file);
        for (File javaResource : this.getJavaResources()) {
            Serializable javaResFile22;
            if (javaResource.isDirectory()) {
                for (Serializable javaResFile22 : FileUtils.getAllFiles((File)javaResource)) {
                    File destJavaResFile = new File(file, FileUtils.relativePath((File)javaResFile22, (File)javaResource));
                    if (!destJavaResFile.getParentFile().exists()) {
                        FileUtils.mkdirs((File)destJavaResFile.getParentFile());
                    }
                    FileUtils.copyFile((File)javaResFile22, (File)destJavaResFile);
                }
                continue;
            }
            if (javaResource.getName().endsWith(".class")) continue;
            ZipFile zipFile = new ZipFile(javaResource);
            javaResFile22 = null;
            try {
                Enumeration<? extends ZipEntry> entries = zipFile.entries();
                while (entries.hasMoreElements()) {
                    ZipEntry zipEntry = entries.nextElement();
                    File destJavaResource = FileUtils.join((File)file, (String[])new String[]{zipEntry.getName()});
                    if (zipEntry.isDirectory()) {
                        FileUtils.mkdirs((File)destJavaResource);
                        continue;
                    }
                    if (!destJavaResource.getParentFile().exists()) {
                        FileUtils.mkdirs((File)destJavaResource.getParentFile());
                    }
                    InputStream zipInputStream = zipFile.getInputStream(zipEntry);
                    byte[] zipInputBuffer = IOUtils.toByteArray((InputStream)zipInputStream);
                    try (FileOutputStream destOutputStream = new FileOutputStream(destJavaResource);){
                        destOutputStream.write(zipInputBuffer, 0, zipInputBuffer.length);
                        destOutputStream.close();
                    }
                    zipInputStream.close();
                }
                zipFile.close();
            }
            catch (Throwable entries) {
                javaResFile22 = entries;
                throw entries;
            }
            finally {
                if (zipFile == null) continue;
                if (javaResFile22 != null) {
                    try {
                        zipFile.close();
                    }
                    catch (Throwable entries) {
                        ((Throwable)javaResFile22).addSuppressed(entries);
                    }
                    continue;
                }
                zipFile.close();
            }
        }
        try (ZipOutputStream zipOutputStream = new ZipOutputStream(new FileOutputStream(this.getBundleFile()));){
            for (File file2 : FileUtils.getAllFiles((File)bundleFolder)) {
                FileInputStream fileInputStream = new FileInputStream(file2);
                Throwable throwable = null;
                try {
                    byte[] inputBuffer = IOUtils.toByteArray((InputStream)fileInputStream);
                    zipOutputStream.putNextEntry(new ZipEntry(FileUtils.toSystemIndependentPath((String)FileUtils.relativePath((File)file2, (File)bundleFolder))));
                    zipOutputStream.write(inputBuffer, 0, inputBuffer.length);
                    zipOutputStream.closeEntry();
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (fileInputStream == null) continue;
                    if (throwable != null) {
                        try {
                            fileInputStream.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    fileInputStream.close();
                }
            }
        }
    }

    @InputDirectory
    public File getBundleFolder() {
        return this.bundleFolder;
    }

    public void setBundleFolder(File bundleFolder) {
        this.bundleFolder = bundleFolder;
    }

    @OutputFile
    public File getBundleFile() {
        return this.bundleFile;
    }

    public void setBundleFile(File bundleFile) {
        this.bundleFile = bundleFile;
    }

    @InputFiles
    public Set<File> getJniFolders() {
        return this.jniFolders;
    }

    public void setJniFolders(Set<File> jniFolders) {
        this.jniFolders = jniFolders;
    }

    @InputFiles
    public Set<File> getDexFolders() {
        return this.dexFolders;
    }

    public void setDexFolders(Set<File> dexFolders) {
        this.dexFolders = dexFolders;
    }

    @InputFiles
    public Set<File> getJavaResources() {
        return this.javaResources;
    }

    public void setJavaResources(Set<File> javaResources) {
        this.javaResources = javaResources;
    }

    @Override
    public Task getTask() {
        return this;
    }

    public File get() {
        return this.getBundleFile();
    }

    public static class ConfigAction
    implements TaskConfigAction<BundleAtom> {
        private VariantScope scope;

        public ConfigAction(VariantScope scope) {
            this.scope = scope;
        }

        @Override
        public String getName() {
            return this.scope.getTaskName("bundle");
        }

        @Override
        public Class<BundleAtom> getType() {
            return BundleAtom.class;
        }

        @Override
        public void execute(BundleAtom bundleAtom) {
            bundleAtom.setVariantName(this.scope.getFullVariantName());
            bundleAtom.setBundleFolder(this.scope.getBaseBundleDir());
            bundleAtom.setBundleFile(this.scope.getOutputBundleFile());
            ConventionMappingHelper.map((Task)bundleAtom, "jniFolders", () -> this.scope.getTransformManager().getPipelineOutput(StreamFilter.NATIVE_LIBS).keySet());
            ConventionMappingHelper.map((Task)bundleAtom, "dexFolders", () -> this.scope.getTransformManager().getPipelineOutput(StreamFilter.DEX).keySet());
            ConventionMappingHelper.map((Task)bundleAtom, "javaResources", () -> this.scope.getTransformManager().getPipelineOutput(StreamFilter.RESOURCES).keySet());
        }
    }
}

