/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.tasks;

import com.android.build.gradle.AndroidGradleOptions;
import com.android.build.gradle.internal.scope.GlobalScope;
import com.android.build.gradle.internal.scope.TaskConfigAction;
import com.android.build.gradle.internal.tasks.BaseTask;
import com.android.builder.utils.FileCache;
import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import org.gradle.api.tasks.ParallelizableTask;
import org.gradle.api.tasks.TaskAction;

@ParallelizableTask
public class CleanBuildCache
extends BaseTask {
    private File buildCacheDirectory;

    public void setBuildCacheDirectory(File buildCacheDirectory) {
        this.buildCacheDirectory = buildCacheDirectory;
    }

    @TaskAction
    public void clean() throws IOException {
        Preconditions.checkNotNull((Object)this.buildCacheDirectory, (Object)"buildCacheDirectory must not be null");
        FileCache.getInstanceWithInterProcessLocking((File)this.buildCacheDirectory).delete();
    }

    public static final class ConfigAction
    implements TaskConfigAction<CleanBuildCache> {
        private final GlobalScope globalScope;

        public ConfigAction(GlobalScope globalScope) {
            this.globalScope = globalScope;
        }

        @Override
        public String getName() {
            return "cleanBuildCache";
        }

        @Override
        public Class<CleanBuildCache> getType() {
            return CleanBuildCache.class;
        }

        @Override
        public void execute(CleanBuildCache task) {
            task.setDescription("Deletes the build cache directory.");
            task.setGroup("build");
            task.setVariantName("");
            task.setBuildCacheDirectory(AndroidGradleOptions.getBuildCacheDir(this.globalScope.getProject()));
        }
    }
}

