/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.tasks;

import com.android.build.OutputFile;
import com.android.build.gradle.internal.scope.TaskConfigAction;
import com.android.build.gradle.internal.scope.VariantOutputScope;
import com.android.build.gradle.internal.tasks.DefaultAndroidTask;
import com.android.resources.Density;
import com.google.common.base.Charsets;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Set;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.ParallelizableTask;
import org.gradle.api.tasks.TaskAction;

@ParallelizableTask
public class CompatibleScreensManifest
extends DefaultAndroidTask {
    private String screenDensity;
    private Set<String> screenSizes;
    private File manifestFile;

    @Input
    public String getScreenDensity() {
        return this.screenDensity;
    }

    public void setScreenDensity(String screenDensity) {
        this.screenDensity = screenDensity;
    }

    @Input
    public Set<String> getScreenSizes() {
        return this.screenSizes;
    }

    public void setScreenSizes(Set<String> screenSizes) {
        this.screenSizes = screenSizes;
    }

    @org.gradle.api.tasks.OutputFile
    public File getManifestFile() {
        return this.manifestFile;
    }

    public void setManifestFile(File manifestFile) {
        this.manifestFile = manifestFile;
    }

    @TaskAction
    public void generate() throws IOException {
        StringBuilder content = new StringBuilder("<?xml version=\"1.0\" encoding=\"utf-8\"?>\n<manifest xmlns:android=\"http://schemas.android.com/apk/res/android\"\n    package=\"\">\n\n    <compatible-screens>\n");
        String density = this.getScreenDensity();
        density = CompatibleScreensManifest.convert(density, Density.XXHIGH, Density.XXXHIGH);
        for (String size : this.getScreenSizes()) {
            content.append("        <screen android:screenSize=\"").append(size).append("\" android:screenDensity=\"").append(density).append("\" />\n");
        }
        content.append("    </compatible-screens>\n</manifest>");
        Files.write((CharSequence)content.toString(), (File)this.getManifestFile(), (Charset)Charsets.UTF_8);
    }

    private static String convert(String density, Density ... densitiesToConvert) {
        for (Density densityToConvert : densitiesToConvert) {
            if (!densityToConvert.getResourceValue().equals(density)) continue;
            return Integer.toString(densityToConvert.getDpiValue());
        }
        return density;
    }

    public static class ConfigAction
    implements TaskConfigAction<CompatibleScreensManifest> {
        private final VariantOutputScope scope;
        private final Set<String> screenSizes;

        public ConfigAction(VariantOutputScope scope, Set<String> screenSizes) {
            this.scope = scope;
            this.screenSizes = screenSizes;
        }

        @Override
        public String getName() {
            return this.scope.getTaskName("create", "CompatibleScreenManifest");
        }

        @Override
        public Class<CompatibleScreensManifest> getType() {
            return CompatibleScreensManifest.class;
        }

        @Override
        public void execute(CompatibleScreensManifest csmTask) {
            csmTask.setVariantName(this.scope.getVariantScope().getVariantConfiguration().getFullName());
            csmTask.setScreenDensity(this.scope.getVariantOutputData().getMainOutputFile().getFilter(OutputFile.DENSITY));
            csmTask.setScreenSizes(this.screenSizes);
            csmTask.setManifestFile(this.scope.getCompatibleScreensManifestFile());
        }
    }
}

