/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.tasks;

import com.android.build.gradle.AndroidConfig;
import com.android.build.gradle.internal.core.GradleVariantConfiguration;
import com.android.build.gradle.internal.scope.ConventionMappingHelper;
import com.android.build.gradle.internal.scope.TaskConfigAction;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.tasks.AbstractAndroidCompile;
import com.android.build.gradle.internal.variant.BaseVariantData;
import com.android.build.gradle.internal.variant.LibraryVariantData;
import com.android.build.gradle.tasks.annotations.ApiDatabase;
import com.android.build.gradle.tasks.annotations.Extractor;
import com.android.builder.core.AndroidBuilder;
import com.android.builder.core.VariantConfiguration;
import com.android.tools.lint.EcjParser;
import com.android.tools.lint.EcjSourceFile;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import org.eclipse.jdt.core.compiler.CategorizedProblem;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.util.Util;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.EmptyFileVisitor;
import org.gradle.api.file.FileVisitDetails;
import org.gradle.api.file.FileVisitor;
import org.gradle.api.logging.LogLevel;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputDirectory;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.ParallelizableTask;
import org.gradle.api.tasks.TaskAction;
import org.gradle.tooling.BuildException;

@ParallelizableTask
public class ExtractAnnotations
extends AbstractAndroidCompile {
    private BaseVariantData variant;
    private List<String> bootClasspath;
    private File typedefFile;
    private File output;
    private File proguard;
    private File apiFilter;
    private List<File> mergeJars;
    private String encoding;
    private File classDir;
    private boolean allowErrors = true;

    public BaseVariantData getVariant() {
        return this.variant;
    }

    public void setVariant(BaseVariantData variant) {
        this.variant = variant;
    }

    @Input
    @Optional
    public List<String> getBootClasspath() {
        return this.bootClasspath;
    }

    public void setBootClasspath(List<String> bootClasspath) {
        this.bootClasspath = bootClasspath;
    }

    @Optional
    @OutputFile
    public File getOutput() {
        return this.output;
    }

    public void setOutput(File output) {
        this.output = output;
    }

    @Optional
    @OutputFile
    public File getProguard() {
        return this.proguard;
    }

    public void setProguard(File proguard) {
        this.proguard = proguard;
    }

    @Optional
    @OutputFile
    public File getTypedefFile() {
        return this.typedefFile;
    }

    public void setTypedefFile(File typedefFile) {
        this.typedefFile = typedefFile;
    }

    @Optional
    @InputFile
    public File getApiFilter() {
        return this.apiFilter;
    }

    public void setApiFilter(File apiFilter) {
        this.apiFilter = apiFilter;
    }

    @Optional
    @InputFile
    public List<File> getMergeJars() {
        return this.mergeJars;
    }

    public void setMergeJars(List<File> mergeJars) {
        this.mergeJars = mergeJars;
    }

    @Optional
    @Input
    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    @Optional
    @InputDirectory
    public File getClassDir() {
        return this.classDir;
    }

    public void setClassDir(File classDir) {
        this.classDir = classDir;
    }

    @Input
    public boolean isAllowErrors() {
        return this.allowErrors;
    }

    public void setAllowErrors(boolean allowErrors) {
        this.allowErrors = allowErrors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TaskAction
    protected void compile() {
        if (!this.hasAndroidAnnotations()) {
            return;
        }
        if (this.encoding == null) {
            this.encoding = "UTF-8";
        }
        EcjParser.EcjResult result = this.parseSources();
        Collection parsedUnits = result.getCompilationUnits();
        try {
            if (!this.allowErrors) {
                for (CompilationUnitDeclaration unit : parsedUnits) {
                    CategorizedProblem[] problems = unit.compilationResult().getAllProblems();
                    if (problems == null) continue;
                    for (CategorizedProblem problem : problems) {
                        if (problem == null || !problem.isError()) continue;
                        this.getLogger().warn("Not extracting annotations (compilation problems encountered)\nError: " + new String(problem.getOriginatingFileName()) + ":" + problem.getSourceLineNumber() + ": " + problem.getMessage());
                        return;
                    }
                }
            }
            ApiDatabase database = null;
            if (this.apiFilter != null && this.apiFilter.exists()) {
                try {
                    database = new ApiDatabase(this.apiFilter);
                }
                catch (IOException e) {
                    throw new BuildException("Could not open API database " + this.apiFilter, (Throwable)e);
                }
            }
            boolean displayInfo = this.getProject().getLogger().isEnabled(LogLevel.INFO);
            Extractor extractor = new Extractor(database, this.classDir, displayInfo, false, false);
            extractor.extractFromProjectSource(parsedUnits);
            if (this.mergeJars != null) {
                for (File jar : this.mergeJars) {
                    extractor.mergeExisting(jar);
                }
            }
            extractor.export(this.output, this.proguard);
            if (this.typedefFile != null) {
                extractor.writeTypedefFile(this.typedefFile);
            } else {
                extractor.removeTypedefClasses();
            }
        }
        finally {
            result.dispose();
        }
    }

    @Input
    public boolean hasAndroidAnnotations() {
        return this.variant.getVariantDependency().isAnnotationsPresent();
    }

    private EcjParser.EcjResult parseSources() {
        final ArrayList sourceUnits = Lists.newArrayListWithExpectedSize((int)100);
        this.getSource().visit((FileVisitor)new EmptyFileVisitor(){

            public void visitFile(FileVisitDetails fileVisitDetails) {
                File file = fileVisitDetails.getFile();
                String path = file.getPath();
                if (path.endsWith(".java") && file.isFile()) {
                    char[] contents;
                    try {
                        contents = Util.getFileCharContent((File)file, (String)ExtractAnnotations.this.encoding);
                    }
                    catch (IOException e) {
                        ExtractAnnotations.this.getLogger().warn("Could not read file", (Throwable)e);
                        return;
                    }
                    EcjSourceFile unit = EcjSourceFile.create((char[])contents, (File)file, (String)ExtractAnnotations.this.encoding);
                    sourceUnits.add(unit);
                }
            }
        });
        ArrayList jars = Lists.newArrayList();
        if (this.bootClasspath != null) {
            jars.addAll(this.bootClasspath);
        }
        if (this.getClasspath() != null) {
            for (File jar : this.getClasspath()) {
                jars.add(jar.getPath());
            }
        }
        CompilerOptions options = EcjParser.createCompilerOptions();
        options.docCommentSupport = false;
        options.complianceLevel = options.sourceLevel = ExtractAnnotations.getLanguageLevel(this.getSourceCompatibility());
        options.targetJDK = options.sourceLevel;
        options.originalComplianceLevel = options.sourceLevel;
        options.originalSourceLevel = options.sourceLevel;
        options.inlineJsrBytecode = true;
        return EcjParser.parse((CompilerOptions)options, (List)sourceUnits, (List)jars, null);
    }

    private static long getLanguageLevel(String version) {
        if ("1.6".equals(version)) {
            return EcjParser.getLanguageLevel((int)1, (int)6);
        }
        if ("1.7".equals(version)) {
            return EcjParser.getLanguageLevel((int)1, (int)7);
        }
        if ("1.5".equals(version)) {
            return EcjParser.getLanguageLevel((int)1, (int)5);
        }
        if ("1.8".equals(version)) {
            return EcjParser.getLanguageLevel((int)1, (int)8);
        }
        return EcjParser.getLanguageLevel((int)1, (int)7);
    }

    public static class ConfigAction
    implements TaskConfigAction<ExtractAnnotations> {
        private Project project;
        private AndroidConfig extension;
        private VariantScope variantScope;

        public ConfigAction(Project project, AndroidConfig extension, VariantScope variantScope) {
            this.project = project;
            this.extension = extension;
            this.variantScope = variantScope;
        }

        @Override
        public String getName() {
            return this.variantScope.getTaskName("extract", "Annotations");
        }

        @Override
        public Class<ExtractAnnotations> getType() {
            return ExtractAnnotations.class;
        }

        @Override
        public void execute(ExtractAnnotations task) {
            final GradleVariantConfiguration variantConfig = this.variantScope.getVariantConfiguration();
            final AndroidBuilder androidBuilder = this.variantScope.getGlobalScope().getAndroidBuilder();
            task.setDescription("Extracts Android annotations for the " + variantConfig.getFullName() + " variant into the archive file");
            task.setGroup("build");
            task.setVariant(this.variantScope.getVariantData());
            task.setDestinationDir(new File(this.variantScope.getGlobalScope().getIntermediatesDir(), "annotations/" + variantConfig.getDirName()));
            task.setOutput(new File(task.getDestinationDir(), "annotations.zip"));
            task.setTypedefFile(this.variantScope.getTypedefFile());
            task.setClassDir(this.variantScope.getJavaOutputDir());
            task.setSource(this.variantScope.getVariantData().getJavaSources());
            task.setEncoding(this.extension.getCompileOptions().getEncoding());
            task.setSourceCompatibility(this.extension.getCompileOptions().getSourceCompatibility().toString());
            ConventionMappingHelper.map((Task)task, "classpath", new Callable<ConfigurableFileCollection>(){

                @Override
                public ConfigurableFileCollection call() throws Exception {
                    return project.files(new Object[]{androidBuilder.getCompileClasspath((VariantConfiguration)variantConfig)});
                }
            });
            task.doFirst(aTask -> {
                if (aTask instanceof ExtractAnnotations) {
                    ExtractAnnotations extractAnnotations = (ExtractAnnotations)((Object)aTask);
                    extractAnnotations.setBootClasspath(androidBuilder.getBootClasspathAsStrings(false));
                }
            });
            ((LibraryVariantData)this.variantScope.getVariantData()).generateAnnotationsTask = task;
        }
    }
}

