/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.tasks;

import com.android.build.gradle.internal.scope.TaskConfigAction;
import com.android.build.gradle.internal.scope.VariantOutputScope;
import com.android.build.gradle.internal.tasks.DefaultAndroidTask;
import com.android.build.gradle.internal.variant.InstantAppVariantOutputData;
import com.android.utils.FileUtils;
import com.google.wireless.android.instantapps.iapk.InstantAppMetadataProto;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.ParallelizableTask;
import org.gradle.api.tasks.TaskAction;

@ParallelizableTask
public class GenerateInstantAppMetadata
extends DefaultAndroidTask {
    private File instantAppMetadataFolder;
    private int substrateApiVersion;

    @TaskAction
    public void taskAction() throws IOException {
        InstantAppMetadataProto.InstantAppMetadata.Builder instantAppMetadataBuilder = InstantAppMetadataProto.InstantAppMetadata.newBuilder();
        instantAppMetadataBuilder.setSubstrateApiVersion(this.getSubstrateApiVersion());
        File instantAppMetadataFile = new File(this.getInstantAppMetadataFolder(), "instantapp-metadata");
        instantAppMetadataFile.delete();
        try (FileOutputStream outputStream = new FileOutputStream(instantAppMetadataFile);){
            instantAppMetadataBuilder.build().writeTo(outputStream);
            outputStream.close();
        }
    }

    @OutputDirectory
    public File getInstantAppMetadataFolder() {
        return this.instantAppMetadataFolder;
    }

    public void setInstantAppMetadataFolder(File instantAppMetadataFolder) {
        this.instantAppMetadataFolder = instantAppMetadataFolder;
    }

    @Input
    public int getSubstrateApiVersion() {
        return this.substrateApiVersion;
    }

    public void setSubstrateApiVersion(int substrateApiVersion) {
        this.substrateApiVersion = substrateApiVersion;
    }

    public static class ConfigAction
    implements TaskConfigAction<GenerateInstantAppMetadata> {
        private VariantOutputScope scope;

        public ConfigAction(VariantOutputScope scope) {
            this.scope = scope;
        }

        @Override
        public String getName() {
            return this.scope.getTaskName("generate", "InstantAppMetadata");
        }

        @Override
        public Class<GenerateInstantAppMetadata> getType() {
            return GenerateInstantAppMetadata.class;
        }

        @Override
        public void execute(GenerateInstantAppMetadata generateInstantAppMetadata) {
            InstantAppVariantOutputData variantOutputData = (InstantAppVariantOutputData)this.scope.getVariantOutputData();
            generateInstantAppMetadata.setInstantAppMetadataFolder(FileUtils.join((File)this.scope.getGlobalScope().getIntermediatesDir(), (String[])new String[]{"metadata", this.scope.getVariantScope().getDirName()}));
            generateInstantAppMetadata.setVariantName(variantOutputData.getFullName());
            generateInstantAppMetadata.setSubstrateApiVersion(5);
            variantOutputData.generateInstantAppMetadataTask = generateInstantAppMetadata;
        }

        public VariantOutputScope getScope() {
            return this.scope;
        }

        public void setScope(VariantOutputScope scope) {
            this.scope = scope;
        }
    }
}

