/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.tasks;

import com.android.build.api.transform.TransformException;
import com.android.build.gradle.internal.scope.TaskConfigAction;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.tasks.BaseTask;
import com.android.builder.core.DefaultDexOptions;
import com.android.builder.core.DexOptions;
import com.android.builder.dependency.level2.AtomDependency;
import com.android.dex.Dex;
import com.android.dx.command.dexer.DxContext;
import com.android.dx.merge.CollisionPolicy;
import com.android.dx.merge.DexMerger;
import com.android.ide.common.blame.Message;
import com.android.ide.common.blame.MessageReceiver;
import com.android.ide.common.blame.ParsingProcessOutputHandler;
import com.android.ide.common.blame.parser.DexParser;
import com.android.ide.common.blame.parser.PatternAwareOutputParser;
import com.android.ide.common.blame.parser.ToolOutputParser;
import com.android.ide.common.process.ProcessOutput;
import com.android.ide.common.process.ProcessOutputHandler;
import com.android.utils.StringHelper;
import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import org.gradle.api.tasks.InputDirectory;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskAction;

public class MergeDexAtomResClass
extends BaseTask {
    private VariantScope scope;
    private File atomDexDir;
    private File resClassDir;
    private File tempDir;
    private File outputDir;

    @TaskAction
    public void TaskAction() throws TransformException, IOException {
        ParsingProcessOutputHandler outputHandler = new ParsingProcessOutputHandler(new ToolOutputParser((PatternAwareOutputParser)new DexParser(), Message.Kind.ERROR, this.getILogger()), new ToolOutputParser((PatternAwareOutputParser)new DexParser(), this.getILogger()), new MessageReceiver[]{this.getBuilder().getErrorReporter()});
        DefaultDexOptions dexOptions = DefaultDexOptions.copyOf((DexOptions)this.scope.getGlobalScope().getExtension().getDexOptions());
        try {
            this.getBuilder().convertByteCode((Collection)ImmutableSet.of((Object)this.getResClassDir()), this.getTempDir(), false, null, (DexOptions)dexOptions, (ProcessOutputHandler)outputHandler);
        }
        catch (Exception e) {
            throw new TransformException((Throwable)e);
        }
        Dex[] input = new Dex[]{new Dex(new File(this.getTempDir(), "classes.dex")), new Dex(new File(this.getAtomDexDir(), "classes.dex"))};
        try (ProcessOutput output = outputHandler.createOutput();){
            DxContext dxContext = new DxContext(output.getStandardOutput(), output.getErrorOutput());
            Dex merged = new DexMerger(input, CollisionPolicy.KEEP_FIRST, dxContext).merge();
            merged.writeTo(new File(this.getOutputDir(), "classes.dex"));
        }
    }

    @InputDirectory
    public File getResClassDir() {
        return this.resClassDir;
    }

    public void setResClassDir(File resClassDir) {
        this.resClassDir = resClassDir;
    }

    @InputDirectory
    public File getAtomDexDir() {
        return this.atomDexDir;
    }

    public void setAtomDexDir(File atomDexDir) {
        this.atomDexDir = atomDexDir;
    }

    @OutputDirectory
    public File getTempDir() {
        return this.tempDir;
    }

    public void setTempDir(File tempDir) {
        this.tempDir = tempDir;
    }

    @OutputDirectory
    public File getOutputDir() {
        return this.outputDir;
    }

    public void setOutputDir(File outputDir) {
        this.outputDir = outputDir;
    }

    public static class ConfigAction
    implements TaskConfigAction<MergeDexAtomResClass> {
        private VariantScope scope;
        private AtomDependency atomDependency;

        public ConfigAction(VariantScope scope, AtomDependency atomDependency) {
            this.scope = scope;
            this.atomDependency = atomDependency;
        }

        @Override
        public String getName() {
            return this.scope.getTaskName("dex", StringHelper.capitalize((String)this.atomDependency.getAtomName()) + "Atom");
        }

        @Override
        public Class<MergeDexAtomResClass> getType() {
            return MergeDexAtomResClass.class;
        }

        @Override
        public void execute(MergeDexAtomResClass task) {
            task.setVariantName(this.scope.getFullVariantName());
            task.setAndroidBuilder(this.scope.getGlobalScope().getAndroidBuilder());
            task.setAtomDexDir(this.atomDependency.getDexFolder());
            task.setResClassDir(this.scope.getJavaOutputDir(this.atomDependency));
            task.setTempDir(this.scope.getIncrementalDir(this.atomDependency.getAtomName() + "-" + this.scope.getFullVariantName()));
            task.setOutputDir(this.scope.getDexOutputFolder(this.atomDependency));
            task.scope = this.scope;
        }
    }
}

