/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.tasks;

import com.android.build.gradle.internal.core.GradleVariantConfiguration;
import com.android.build.gradle.internal.dsl.AaptOptions;
import com.android.build.gradle.internal.scope.ConventionMappingHelper;
import com.android.build.gradle.internal.scope.TaskConfigAction;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.tasks.IncrementalTask;
import com.android.build.gradle.internal.variant.BaseVariantData;
import com.android.build.gradle.internal.variant.BaseVariantOutputData;
import com.android.build.gradle.tasks.ResourceException;
import com.android.builder.core.VariantType;
import com.android.ide.common.res2.AssetMerger;
import com.android.ide.common.res2.AssetSet;
import com.android.ide.common.res2.DataSet;
import com.android.ide.common.res2.FileStatus;
import com.android.ide.common.res2.FileValidity;
import com.android.ide.common.res2.MergeConsumer;
import com.android.ide.common.res2.MergedAssetWriter;
import com.android.ide.common.res2.MergingException;
import com.android.utils.FileUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.gradle.api.Task;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.ParallelizableTask;

@ParallelizableTask
public class MergeSourceSetFolders
extends IncrementalTask {
    private File outputDir;
    private List<AssetSet> inputDirectorySets;
    private final FileValidity<AssetSet> fileValidity = new FileValidity();

    @OutputDirectory
    public File getOutputDir() {
        return this.outputDir;
    }

    public void setOutputDir(File outputDir) {
        this.outputDir = outputDir;
    }

    @InputFiles
    public Iterable<File> getRawInputFolders() {
        return IncrementalTask.flattenSourceSets(this.getInputDirectorySets());
    }

    public List<AssetSet> getInputDirectorySets() {
        return this.inputDirectorySets;
    }

    public void setInputDirectorySets(List<AssetSet> inputDirectorySets) {
        this.inputDirectorySets = inputDirectorySets;
    }

    @Override
    protected boolean isIncremental() {
        return true;
    }

    @Override
    protected void doFullTaskAction() throws IOException {
        File destinationDir = this.getOutputDir();
        FileUtils.cleanOutputDir((File)destinationDir);
        List<AssetSet> assetSets = this.getInputDirectorySets();
        AssetMerger merger = new AssetMerger();
        try {
            for (AssetSet assetSet : assetSets) {
                assetSet.loadFromFiles(this.getILogger());
                merger.addDataSet((DataSet)assetSet);
            }
            MergedAssetWriter writer = new MergedAssetWriter(destinationDir);
            merger.mergeData((MergeConsumer)writer, false);
            merger.writeBlobTo(this.getIncrementalFolder(), (MergeConsumer)writer, false);
        }
        catch (MergingException e) {
            this.getLogger().error("Could not merge source set folders: ", (Throwable)e);
            merger.cleanBlob(this.getIncrementalFolder());
            throw new ResourceException(e.getMessage(), e);
        }
    }

    @Override
    protected void doIncrementalTaskAction(Map<File, FileStatus> changedInputs) throws IOException {
        AssetMerger merger = new AssetMerger();
        try {
            if (!merger.loadFromBlob(this.getIncrementalFolder(), true)) {
                this.doFullTaskAction();
                return;
            }
            List<AssetSet> assetSets = this.getInputDirectorySets();
            if (!merger.checkValidUpdate(assetSets)) {
                this.getLogger().info("Changed Asset sets: full task run!");
                this.doFullTaskAction();
                return;
            }
            for (Map.Entry<File, FileStatus> entry : changedInputs.entrySet()) {
                File changedFile = entry.getKey();
                if (changedFile.isDirectory()) continue;
                merger.findDataSetContaining(changedFile, this.fileValidity);
                if (this.fileValidity.getStatus() == FileValidity.FileStatus.UNKNOWN_FILE) {
                    this.doFullTaskAction();
                    return;
                }
                if (this.fileValidity.getStatus() != FileValidity.FileStatus.VALID_FILE || ((AssetSet)this.fileValidity.getDataSet()).updateWith(this.fileValidity.getSourceFile(), changedFile, entry.getValue(), this.getILogger())) continue;
                this.getLogger().info("Failed to process {} event! Full task run", (Object)entry.getValue());
                this.doFullTaskAction();
                return;
            }
            MergedAssetWriter writer = new MergedAssetWriter(this.getOutputDir());
            merger.mergeData((MergeConsumer)writer, false);
            merger.writeBlobTo(this.getIncrementalFolder(), (MergeConsumer)writer, false);
        }
        catch (MergingException e) {
            this.getLogger().error("Could not merge source set folders: ", (Throwable)e);
            merger.cleanBlob(this.getIncrementalFolder());
            throw new ResourceException(e.getMessage(), e);
        }
        finally {
            this.fileValidity.clear();
        }
    }

    public static class MergeShaderSourceFoldersConfigAction
    extends ConfigAction {
        public MergeShaderSourceFoldersConfigAction(VariantScope scope) {
            super(scope);
        }

        @Override
        public String getName() {
            return this.scope.getTaskName("merge", "Shaders");
        }

        @Override
        public void execute(MergeSourceSetFolders mergeAssetsTask) {
            super.execute(mergeAssetsTask);
            BaseVariantData<? extends BaseVariantOutputData> variantData = this.scope.getVariantData();
            GradleVariantConfiguration variantConfig = variantData.getVariantConfiguration();
            ConventionMappingHelper.map((Task)mergeAssetsTask, "inputDirectorySets", () -> ((GradleVariantConfiguration)variantConfig).getShaderSets());
            mergeAssetsTask.setOutputDir(this.scope.getMergeShadersOutputDir());
        }
    }

    public static class MergeJniLibFoldersConfigAction
    extends ConfigAction {
        public MergeJniLibFoldersConfigAction(VariantScope scope) {
            super(scope);
        }

        @Override
        public String getName() {
            return this.scope.getTaskName("merge", "JniLibFolders");
        }

        @Override
        public void execute(MergeSourceSetFolders mergeAssetsTask) {
            super.execute(mergeAssetsTask);
            BaseVariantData<? extends BaseVariantOutputData> variantData = this.scope.getVariantData();
            GradleVariantConfiguration variantConfig = variantData.getVariantConfiguration();
            ConventionMappingHelper.map((Task)mergeAssetsTask, "inputDirectorySets", () -> ((GradleVariantConfiguration)variantConfig).getJniLibsSets());
            mergeAssetsTask.setOutputDir(this.scope.getMergeNativeLibsOutputDir());
        }
    }

    public static class MergeAssetConfigAction
    extends ConfigAction {
        public MergeAssetConfigAction(VariantScope scope) {
            super(scope);
        }

        @Override
        public String getName() {
            return this.scope.getTaskName("merge", "Assets");
        }

        @Override
        public void execute(MergeSourceSetFolders mergeAssetsTask) {
            super.execute(mergeAssetsTask);
            BaseVariantData<? extends BaseVariantOutputData> variantData = this.scope.getVariantData();
            GradleVariantConfiguration variantConfig = variantData.getVariantConfiguration();
            variantData.mergeAssetsTask = mergeAssetsTask;
            boolean includeDependencies = !variantConfig.getType().equals((Object)VariantType.LIBRARY);
            ConventionMappingHelper.map((Task)mergeAssetsTask, "inputDirectorySets", () -> {
                ArrayList<File> generatedAssets = new ArrayList<File>();
                generatedAssets.add(this.scope.getShadersOutputDir());
                if (variantData.copyApkTask != null) {
                    generatedAssets.add(variantData.copyApkTask.getDestinationDir());
                }
                List assetSets = variantConfig.getAssetSets(generatedAssets, includeDependencies);
                AaptOptions options = this.scope.getGlobalScope().getExtension().getAaptOptions();
                if (options != null && options.getIgnoreAssets() != null) {
                    assetSets.forEach(as -> as.setIgnoredPatterns(options.getIgnoreAssets()));
                }
                return assetSets;
            });
            mergeAssetsTask.setOutputDir(this.scope.getMergeAssetsOutputDir());
        }
    }

    protected static abstract class ConfigAction
    implements TaskConfigAction<MergeSourceSetFolders> {
        protected final VariantScope scope;

        protected ConfigAction(VariantScope scope) {
            this.scope = scope;
        }

        @Override
        public Class<MergeSourceSetFolders> getType() {
            return MergeSourceSetFolders.class;
        }

        @Override
        public void execute(MergeSourceSetFolders mergeAssetsTask) {
            BaseVariantData<? extends BaseVariantOutputData> variantData = this.scope.getVariantData();
            GradleVariantConfiguration variantConfig = variantData.getVariantConfiguration();
            mergeAssetsTask.setAndroidBuilder(this.scope.getGlobalScope().getAndroidBuilder());
            mergeAssetsTask.setVariantName(variantConfig.getFullName());
            mergeAssetsTask.setIncrementalFolder(this.scope.getIncrementalDir(this.getName()));
        }
    }
}

