/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.tasks;

import com.android.build.gradle.internal.incremental.DexPackagingPolicy;
import com.android.build.gradle.internal.incremental.FileType;
import com.android.build.gradle.internal.incremental.InstantRunPatchingPolicy;
import com.android.build.gradle.internal.scope.ConventionMappingHelper;
import com.android.build.gradle.internal.scope.PackagingScope;
import com.android.build.gradle.tasks.PackageAndroidArtifact;
import com.android.builder.profile.ProcessProfileWriter;
import com.android.ide.common.res2.FileStatus;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.wireless.android.sdk.stats.GradleBuildProjectMetrics;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.util.Collections;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.gradle.api.Task;
import org.gradle.api.tasks.ParallelizableTask;

@ParallelizableTask
public class PackageApplication
extends PackageAndroidArtifact {
    @Override
    protected boolean isIncremental() {
        return true;
    }

    @Override
    protected void doFullTaskAction() throws IOException {
        super.doFullTaskAction();
        this.recordMetrics();
    }

    @Override
    protected void doIncrementalTaskAction(Map<File, FileStatus> changedInputs) throws IOException {
        super.doIncrementalTaskAction(changedInputs);
        this.recordMetrics();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File zipDexesForInstantRun(Iterable<File> dexFolders, ImmutableSet.Builder<File> dexFoldersForApk) throws IOException {
        File tmpZipFile = new File(this.instantRunSupportDir, "classes.zip");
        com.google.common.io.Files.createParentDirs((File)tmpZipFile);
        zipFile.setLevel(0);
        try (ZipOutputStream zipFile = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(tmpZipFile)));){
            for (File dexFolder : dexFolders) {
                if (dexFolder.getName().contains("instant-run")) {
                    dexFoldersForApk.add((Object)dexFolder);
                    continue;
                }
                for (File file : com.google.common.io.Files.fileTreeTraverser().breadthFirstTraversal((Object)dexFolder)) {
                    if (!file.isFile() || !file.getName().endsWith(".dex")) continue;
                    String entryName = file.getParentFile().getName() + "-" + file.getName();
                    zipFile.putNextEntry(new ZipEntry(entryName));
                    try {
                        com.google.common.io.Files.copy((File)file, (OutputStream)zipFile);
                    }
                    finally {
                        zipFile.closeEntry();
                    }
                }
            }
        }
        File finalResourceFile = new File(this.instantRunSupportDir, "resources.zip");
        zipFile = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(finalResourceFile)));
        try {
            zipFile.putNextEntry(new ZipEntry("instant-run.zip"));
            try {
                com.google.common.io.Files.copy((File)tmpZipFile, (OutputStream)zipFile);
            }
            finally {
                zipFile.closeEntry();
            }
        }
        finally {
            zipFile.close();
        }
        return finalResourceFile;
    }

    private void recordMetrics() {
        Long resourcesApSize;
        long metricsStartTime = System.nanoTime();
        GradleBuildProjectMetrics.Builder metrics = GradleBuildProjectMetrics.newBuilder();
        Long apkSize = PackageApplication.getSize(this.getOutputFile());
        if (apkSize != null) {
            metrics.setApkSize(apkSize.longValue());
        }
        if ((resourcesApSize = PackageApplication.getSize(this.getResourceFile())) != null) {
            metrics.setResourcesApSize(resourcesApSize.longValue());
        }
        metrics.setMetricsTimeNs(System.nanoTime() - metricsStartTime);
        ProcessProfileWriter.getProject((String)this.getProject().getPath()).setMetrics(metrics);
    }

    private static Long getSize(File file) {
        if (file == null) {
            return null;
        }
        try {
            return Files.size(file.toPath());
        }
        catch (IOException e) {
            return null;
        }
    }

    public static class InstantRunResourcesConfigAction
    extends PackageAndroidArtifact.ConfigAction<PackageApplication> {
        private final File mOutputFile;

        public InstantRunResourcesConfigAction(File outputFile, PackagingScope scope, InstantRunPatchingPolicy patchingPolicy) {
            super(scope, patchingPolicy);
            this.mOutputFile = outputFile;
        }

        @Override
        public String getName() {
            return this.packagingScope.getTaskName("packageInstantRunResources");
        }

        @Override
        public Class<PackageApplication> getType() {
            return PackageApplication.class;
        }

        @Override
        public void execute(PackageApplication packageApplication) {
            packageApplication.setOutputFile(this.mOutputFile);
            super.execute(packageApplication);
            packageApplication.instantRunFileType = FileType.RESOURCES;
            packageApplication.dexPackagingPolicy = DexPackagingPolicy.STANDARD;
            for (String prop : ImmutableList.of((Object)"dexFolders", (Object)"jniFolders", (Object)"javaResourceFiles")) {
                ConventionMappingHelper.map((Task)packageApplication, prop, Collections::emptySet);
            }
            packageApplication.setSigningConfig(null);
        }
    }

    public static class StandardConfigAction
    extends PackageAndroidArtifact.ConfigAction<PackageApplication> {
        public StandardConfigAction(PackagingScope scope, InstantRunPatchingPolicy patchingPolicy) {
            super(scope, patchingPolicy);
        }

        @Override
        public String getName() {
            return this.packagingScope.getTaskName("package");
        }

        @Override
        public Class<PackageApplication> getType() {
            return PackageApplication.class;
        }

        @Override
        public void execute(PackageApplication packageApplication) {
            ConventionMappingHelper.map((Task)packageApplication, "outputFile", this.packagingScope::getOutputPackage);
            super.execute(packageApplication);
        }
    }
}

