/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.tasks;

import com.android.apkzlib.zfile.ApkCreatorFactory;
import com.android.build.FilterData;
import com.android.build.OutputFile;
import com.android.build.gradle.api.ApkOutputFile;
import com.android.build.gradle.internal.core.GradleVariantConfiguration;
import com.android.build.gradle.internal.dsl.AbiSplitOptions;
import com.android.build.gradle.internal.ide.FilterDataImpl;
import com.android.build.gradle.internal.packaging.ApkCreatorFactories;
import com.android.build.gradle.internal.pipeline.StreamFilter;
import com.android.build.gradle.internal.scope.ConventionMappingHelper;
import com.android.build.gradle.internal.scope.TaskConfigAction;
import com.android.build.gradle.internal.scope.VariantOutputScope;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.variant.BaseVariantData;
import com.android.build.gradle.internal.variant.BaseVariantOutputData;
import com.android.build.gradle.tasks.SplitRelatedTask;
import com.android.builder.files.IncrementalRelativeFileSets;
import com.android.builder.internal.packaging.IncrementalPackager;
import com.android.builder.model.AaptOptions;
import com.android.builder.model.ApiVersion;
import com.android.builder.model.SigningConfig;
import com.android.builder.packaging.PackagerException;
import com.android.builder.packaging.PackagingUtils;
import com.android.builder.packaging.SigningException;
import com.android.ide.common.signing.CertificateInfo;
import com.android.ide.common.signing.KeystoreHelper;
import com.android.ide.common.signing.KeytoolException;
import com.android.utils.FileUtils;
import com.google.common.base.Joiner;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.Callables;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.gradle.api.Task;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputFiles;
import org.gradle.api.tasks.ParallelizableTask;
import org.gradle.api.tasks.TaskAction;

@ParallelizableTask
public class PackageSplitAbi
extends SplitRelatedTask {
    private ImmutableList<ApkOutputFile> outputFiles;
    private Collection<File> inputFiles;
    private File outputDirectory;
    private Set<String> splits;
    private String outputBaseName;
    private boolean jniDebuggable;
    private SigningConfig signingConfig;
    private Collection<File> jniFolders;
    private ApiVersion minSdkVersion;
    private File incrementalDir;
    private File manifest;
    private AaptOptions aaptOptions;

    @OutputFiles
    public List<File> getOutputFiles() {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (String split : this.splits) {
            String apkName = this.getApkName(split);
            builder.add((Object)new File(this.outputDirectory, apkName));
        }
        return builder.build();
    }

    @Override
    public File getApkMetadataFile() {
        return null;
    }

    public synchronized ImmutableList<ApkOutputFile> getOutputSplitFiles() {
        if (this.outputFiles == null) {
            ImmutableList.Builder builder = ImmutableList.builder();
            for (String split : this.splits) {
                String apkName = this.getApkName(split);
                ApkOutputFile apkOutput = new ApkOutputFile(OutputFile.OutputType.SPLIT, (Collection<FilterData>)ImmutableList.of((Object)FilterDataImpl.build(OutputFile.ABI, apkName)), Callables.returning((Object)new File(this.outputDirectory, apkName)));
                builder.add((Object)apkOutput);
            }
            this.outputFiles = builder.build();
        }
        return this.outputFiles;
    }

    private boolean isAbiSplit(String fileName) {
        for (String abi : this.getSplits()) {
            if (!fileName.contains(abi)) continue;
            return true;
        }
        return false;
    }

    private ApkCreatorFactory.CreationData makeCreationData(File outputApk) {
        boolean v2SigningEnabled;
        boolean v1SigningEnabled;
        X509Certificate certificate;
        PrivateKey key;
        try {
            if (this.signingConfig != null && this.signingConfig.isSigningReady()) {
                CertificateInfo certificateInfo = KeystoreHelper.getCertificateInfo((String)this.signingConfig.getStoreType(), (File)((File)Preconditions.checkNotNull((Object)this.signingConfig.getStoreFile())), (String)((String)Preconditions.checkNotNull((Object)this.signingConfig.getStorePassword())), (String)((String)Preconditions.checkNotNull((Object)this.signingConfig.getKeyPassword())), (String)((String)Preconditions.checkNotNull((Object)this.signingConfig.getKeyAlias())));
                key = certificateInfo.getKey();
                certificate = certificateInfo.getCertificate();
                v1SigningEnabled = this.signingConfig.isV1SigningEnabled();
                v2SigningEnabled = this.signingConfig.isV2SigningEnabled();
            } else {
                key = null;
                certificate = null;
                v1SigningEnabled = false;
                v2SigningEnabled = false;
            }
        }
        catch (KeytoolException | IOException e) {
            throw new RuntimeException("Failed to get signing information", e);
        }
        return new ApkCreatorFactory.CreationData(outputApk, key, certificate, v1SigningEnabled, v2SigningEnabled, null, this.getBuilder().getCreatedBy(), this.getMinSdkVersion(), PackagingUtils.getNativeLibrariesLibrariesPackagingMode((File)this.manifest), PackagingUtils.getNoCompressPredicate((AaptOptions)this.aaptOptions, (File)this.manifest));
    }

    @TaskAction
    protected void doFullTaskAction() throws FileNotFoundException, SigningException, KeytoolException, PackagerException, IOException {
        FileUtils.cleanOutputDir((File)this.incrementalDir);
        Pattern pattern = Pattern.compile("resources-" + this.getOutputBaseName() + "-(.*).ap_");
        ArrayList unprocessedSplits = Lists.newArrayList(this.splits);
        for (File file : this.inputFiles) {
            Matcher matcher = pattern.matcher(file.getName());
            if (!matcher.matches() || !this.isAbiSplit(file.getName())) continue;
            String apkName = this.getApkName(matcher.group(1));
            File outFile = new File(this.getOutputDirectory(), apkName);
            ApkCreatorFactory.CreationData creationData = this.makeCreationData(outFile);
            try (IncrementalPackager pkg = new IncrementalPackager(creationData, this.incrementalDir, ApkCreatorFactories.fromProjectProperties(this.getProject(), this.isJniDebuggable()), (Set)ImmutableSet.of((Object)matcher.group(1)), this.isJniDebuggable());){
                ImmutableMap nativeLibs = IncrementalRelativeFileSets.fromZipsAndDirectories(this.getJniFolders());
                pkg.updateNativeLibraries(nativeLibs);
                ImmutableMap androidResources = IncrementalRelativeFileSets.fromZip((File)file);
                pkg.updateAndroidResources(androidResources);
            }
            unprocessedSplits.remove(matcher.group(1));
        }
        if (!unprocessedSplits.isEmpty()) {
            String message = "Could not find resource package for " + Joiner.on((char)',').join((Iterable)unprocessedSplits);
            this.getLogger().error(message);
            throw new IllegalStateException(message);
        }
    }

    @Override
    public List<FilterData> getSplitsData() {
        ImmutableList.Builder filterDataBuilder = ImmutableList.builder();
        SplitRelatedTask.addAllFilterData((ImmutableList.Builder<FilterData>)filterDataBuilder, this.splits, OutputFile.FilterType.ABI);
        return filterDataBuilder.build();
    }

    private String getApkName(String split) {
        String archivesBaseName = (String)this.getProject().getProperties().get("archivesBaseName");
        String apkName = archivesBaseName + "-" + this.getOutputBaseName() + "_" + split;
        return apkName + (this.getSigningConfig() == null ? "-unsigned.apk" : "-unaligned.apk");
    }

    public void setOutputFiles(ImmutableList<ApkOutputFile> outputFiles) {
        this.outputFiles = outputFiles;
    }

    @InputFiles
    public Collection<File> getInputFiles() {
        return this.inputFiles;
    }

    public void setInputFiles(Collection<File> inputFiles) {
        this.inputFiles = inputFiles;
    }

    public File getOutputDirectory() {
        return this.outputDirectory;
    }

    public void setOutputDirectory(File outputDirectory) {
        this.outputDirectory = outputDirectory;
    }

    @Input
    public Set<String> getSplits() {
        return this.splits;
    }

    public void setSplits(Set<String> splits) {
        this.splits = splits;
    }

    @Input
    public String getOutputBaseName() {
        return this.outputBaseName;
    }

    public void setOutputBaseName(String outputBaseName) {
        this.outputBaseName = outputBaseName;
    }

    @Input
    public boolean isJniDebuggable() {
        return this.jniDebuggable;
    }

    public void setJniDebuggable(boolean jniDebuggable) {
        this.jniDebuggable = jniDebuggable;
    }

    @Nested
    @Optional
    public SigningConfig getSigningConfig() {
        return this.signingConfig;
    }

    public void setSigningConfig(SigningConfig signingConfig) {
        this.signingConfig = signingConfig;
    }

    @Input
    public Collection<File> getJniFolders() {
        return this.jniFolders;
    }

    public void setJniFolders(Collection<File> jniFolders) {
        this.jniFolders = jniFolders;
    }

    public void setMinSdkVersion(ApiVersion version) {
        this.minSdkVersion = version;
    }

    @Input
    public int getMinSdkVersion() {
        return this.minSdkVersion.getApiLevel();
    }

    @Input
    public Collection<String> getNoCompressExtensions() {
        return (Collection)MoreObjects.firstNonNull((Object)this.aaptOptions.getNoCompress(), Collections.emptyList());
    }

    public static class ConfigAction
    implements TaskConfigAction<PackageSplitAbi> {
        private VariantScope scope;

        public ConfigAction(VariantScope scope) {
            this.scope = scope;
        }

        @Override
        public String getName() {
            return this.scope.getTaskName("package", "SplitAbi");
        }

        @Override
        public Class<PackageSplitAbi> getType() {
            return PackageSplitAbi.class;
        }

        @Override
        public void execute(PackageSplitAbi packageSplitAbiTask) {
            BaseVariantData<? extends BaseVariantOutputData> variantData = this.scope.getVariantData();
            BaseVariantOutputData variantOutputData = variantData.getMainOutput();
            VariantOutputScope variantOutputScope = variantOutputData.getScope();
            GradleVariantConfiguration config = this.scope.getVariantConfiguration();
            variantOutputData.packageSplitAbiTask = packageSplitAbiTask;
            ImmutableSet<String> filters = AbiSplitOptions.getAbiFilters(this.scope.getGlobalScope().getExtension().getSplits().getAbiFilters());
            packageSplitAbiTask.setInputFiles(this.scope.getSplitAbiResOutputFiles());
            packageSplitAbiTask.setSplits((Set<String>)filters);
            packageSplitAbiTask.setOutputBaseName(config.getBaseName());
            packageSplitAbiTask.setSigningConfig(config.getSigningConfig());
            packageSplitAbiTask.setOutputDirectory(this.scope.getSplitOutputDirectory());
            packageSplitAbiTask.setAndroidBuilder(this.scope.getGlobalScope().getAndroidBuilder());
            packageSplitAbiTask.setVariantName(config.getFullName());
            packageSplitAbiTask.setMinSdkVersion(config.getMinSdkVersion());
            packageSplitAbiTask.incrementalDir = this.scope.getIncrementalDir(packageSplitAbiTask.getName());
            packageSplitAbiTask.aaptOptions = this.scope.getGlobalScope().getExtension().getAaptOptions();
            packageSplitAbiTask.manifest = variantOutputScope.getManifestOutputFile();
            ConventionMappingHelper.map((Task)packageSplitAbiTask, "jniFolders", () -> this.scope.getTransformManager().getPipelineOutput(StreamFilter.NATIVE_LIBS).keySet());
            ConventionMappingHelper.map((Task)packageSplitAbiTask, "jniDebuggable", () -> config.getBuildType().isJniDebuggable());
        }
    }
}

