/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.tasks;

import com.android.apkzlib.zfile.NativeLibrariesPackagingMode;
import com.android.build.gradle.internal.annotations.PackageFile;
import com.android.build.gradle.internal.incremental.FileType;
import com.android.build.gradle.internal.incremental.InstantRunBuildContext;
import com.android.build.gradle.internal.scope.ConventionMappingHelper;
import com.android.build.gradle.internal.scope.TaskConfigAction;
import com.android.build.gradle.internal.scope.VariantOutputScope;
import com.android.build.gradle.internal.tasks.FileSupplier;
import com.android.build.gradle.internal.variant.ApkVariantOutputData;
import com.android.build.gradle.tasks.PackageAndroidArtifact;
import com.android.builder.packaging.PackagingUtils;
import com.android.sdklib.BuildToolInfo;
import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import org.gradle.api.DefaultTask;
import org.gradle.api.Task;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.ParallelizableTask;
import org.gradle.api.tasks.TaskAction;

@ParallelizableTask
public class ZipAlign
extends DefaultTask
implements FileSupplier {
    private File outputFile;
    @PackageFile
    private File inputFile;
    private File manifest;
    private File zipAlignExe;
    private InstantRunBuildContext instantRunBuildContext;

    @OutputFile
    public File getOutputFile() {
        return this.outputFile;
    }

    public void setOutputFile(File outputFile) {
        this.outputFile = outputFile;
    }

    @InputFile
    public File getInputFile() {
        return this.inputFile;
    }

    public void setInputFile(File inputFile) {
        this.inputFile = inputFile;
    }

    public void setInstantRunBuildContext(InstantRunBuildContext instantRunBuildContext) {
        this.instantRunBuildContext = instantRunBuildContext;
    }

    @InputFile
    public File getZipAlignExe() {
        return this.zipAlignExe;
    }

    public void setZipAlignExe(File zipAlignExe) {
        this.zipAlignExe = zipAlignExe;
    }

    @InputFile
    public File getManifest() {
        return this.manifest;
    }

    @TaskAction
    public void zipAlign() throws IOException {
        File inputFile = this.getInputFile();
        File outputFile = this.getOutputFile();
        Preconditions.checkNotNull((Object)inputFile, (Object)"inputFile == null");
        Preconditions.checkNotNull((Object)outputFile, (Object)"outputFile == null");
        if (!inputFile.isFile()) {
            throw new IOException("Path '" + inputFile.getAbsolutePath() + "' does not represent a file.");
        }
        if (outputFile.exists() && !outputFile.isFile()) {
            throw new IOException("Path '" + inputFile.getAbsolutePath() + "' exists but is not a file.");
        }
        this.getProject().exec(execSpec -> {
            execSpec.executable((Object)this.getZipAlignExe());
            execSpec.args(new Object[]{"-f"});
            NativeLibrariesPackagingMode nativeLibrariesPackagingMode = PackagingUtils.getNativeLibrariesLibrariesPackagingMode((File)this.manifest);
            if (nativeLibrariesPackagingMode == NativeLibrariesPackagingMode.UNCOMPRESSED_AND_ALIGNED) {
                execSpec.args(new Object[]{"-p"});
            }
            execSpec.args(new Object[]{"4"});
            execSpec.args(new Object[]{this.getInputFile()});
            execSpec.args(new Object[]{this.getOutputFile()});
        });
        try {
            this.instantRunBuildContext.addChangedFile(FileType.MAIN, this.getOutputFile());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public File get() {
        return this.getOutputFile();
    }

    @Override
    public Task getTask() {
        return this;
    }

    public static class ConfigAction
    implements TaskConfigAction<ZipAlign> {
        private final VariantOutputScope scope;

        @Override
        public String getName() {
            return this.scope.getTaskName("zipalign");
        }

        @Override
        public Class<ZipAlign> getType() {
            return ZipAlign.class;
        }

        public ConfigAction(VariantOutputScope scope) {
            this.scope = scope;
        }

        @Override
        public void execute(ZipAlign zipAlign) {
            ApkVariantOutputData variantData = (ApkVariantOutputData)this.scope.getVariantOutputData();
            variantData.zipAlignTask = zipAlign;
            zipAlign.manifest = this.scope.getManifestOutputFile();
            ConventionMappingHelper.map((Task)zipAlign, "inputFile", () -> {
                PackageAndroidArtifact packageAndroidArtifactTask = this.scope.getVariantOutputData().packageAndroidArtifactTask;
                return packageAndroidArtifactTask == null ? this.scope.getIntermediateApk() : packageAndroidArtifactTask.getOutputFile();
            });
            ConventionMappingHelper.map((Task)zipAlign, "outputFile", () -> this.scope.getGlobalScope().getProject().file((Object)(this.scope.getGlobalScope().getApkLocation() + "/" + this.scope.getGlobalScope().getProjectBaseName() + "-" + this.scope.getVariantOutputData().getBaseName() + ".apk")));
            ConventionMappingHelper.map((Task)zipAlign, "zipAlignExe", () -> {
                String zipAlignPath = this.scope.getGlobalScope().getAndroidBuilder().getTargetInfo().getBuildTools().getPath(BuildToolInfo.PathId.ZIP_ALIGN);
                if (zipAlignPath != null) {
                    return new File(zipAlignPath);
                }
                return null;
            });
            zipAlign.instantRunBuildContext = this.scope.getVariantScope().getInstantRunBuildContext();
        }
    }
}

