/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.tasks.factory;

import com.android.build.gradle.AndroidGradleOptions;
import com.android.build.gradle.internal.CompileOptions;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.sdklib.AndroidTargetHash;
import com.android.sdklib.AndroidVersion;
import com.android.utils.ILogger;
import com.google.common.base.Joiner;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import org.gradle.api.JavaVersion;
import org.gradle.api.Project;
import org.gradle.api.file.ConfigurableFileTree;
import org.gradle.api.logging.Logging;
import org.gradle.api.tasks.compile.AbstractCompile;

public class AbstractCompilesUtil {
    public static void configureLanguageLevel(AbstractCompile compileTask, CompileOptions compileOptions, String compileSdkVersion, boolean jackEnabled) {
        AbstractCompilesUtil.setDefaultJavaVersion(compileOptions, compileSdkVersion, jackEnabled);
        compileTask.setSourceCompatibility(compileOptions.getSourceCompatibility().toString());
        compileTask.setTargetCompatibility(compileOptions.getTargetCompatibility().toString());
    }

    public static void setDefaultJavaVersion(CompileOptions compileOptions, String compileSdkVersion, boolean jackEnabled) {
        compileOptions.setDefaultJavaVersion(AbstractCompilesUtil.chooseDefaultJavaVersion(compileSdkVersion, System.getProperty("java.specification.version"), jackEnabled));
    }

    static JavaVersion chooseDefaultJavaVersion(String compileSdkVersion, String currentJdkVersion, boolean jackEnabled) {
        Integer compileSdkLevel;
        AndroidVersion hash = AndroidTargetHash.getVersionFromHash((String)compileSdkVersion);
        Integer n = compileSdkLevel = hash == null ? null : Integer.valueOf(hash.getFeatureLevel());
        JavaVersion javaVersionToUse = compileSdkLevel == null ? JavaVersion.VERSION_1_6 : (0 < compileSdkLevel && compileSdkLevel <= 20 ? JavaVersion.VERSION_1_6 : (21 <= compileSdkLevel && compileSdkLevel < 24 ? JavaVersion.VERSION_1_7 : (jackEnabled ? JavaVersion.VERSION_1_8 : JavaVersion.VERSION_1_7)));
        JavaVersion jdkVersion = JavaVersion.toVersion((Object)currentJdkVersion);
        if (jdkVersion.compareTo((Enum)javaVersionToUse) < 0) {
            Logging.getLogger(AbstractCompilesUtil.class).warn("Default language level for compileSdkVersion '{}' is {}, but the JDK used is {}, so the JDK language level will be used.", new Object[]{compileSdkVersion, javaVersionToUse, jdkVersion});
            javaVersionToUse = jdkVersion;
        }
        return javaVersionToUse;
    }

    public static boolean isIncremental(Project project, VariantScope variantScope, CompileOptions compileOptions, Collection<File> processorPath, ILogger log) {
        boolean incremental;
        if (compileOptions.getIncremental() != null) {
            incremental = compileOptions.getIncremental();
            log.verbose("Incremental flag set to %1$b in DSL", new Object[]{incremental});
        } else if (variantScope.getGlobalScope().getExtension().getDataBinding().isEnabled() || !processorPath.isEmpty() || project.getPlugins().hasPlugin("com.neenbedankt.android-apt") || project.getPlugins().hasPlugin("me.tatarka.retrolambda")) {
            incremental = false;
            log.verbose("Incremental Java compilation disabled in variant %1$s as you are using an incompatible plugin", new Object[]{variantScope.getVariantConfiguration().getFullName()});
        } else if (variantScope.getTestedVariantData() != null) {
            incremental = false;
        } else {
            ArrayList<File> sourceFolders = new ArrayList<File>();
            for (ConfigurableFileTree sourceFolder : variantScope.getVariantData().getUserJavaSources()) {
                if (!sourceFolder.getDir().exists()) continue;
                sourceFolders.add(sourceFolder.getDir());
            }
            boolean bl = incremental = sourceFolders.size() == 1;
            if (sourceFolders.size() > 1) {
                log.verbose("Incremental Java compilation disabled in variant %1$s as you are using %2$d source folders : %3$s", new Object[]{variantScope.getVariantConfiguration().getFullName(), sourceFolders.size(), Joiner.on((char)',').join(sourceFolders)});
            }
        }
        if (AndroidGradleOptions.isJavaCompileIncrementalPropertySet(project)) {
            variantScope.getGlobalScope().getAndroidBuilder().getErrorReporter().handleSyncError(null, 0, String.format("The %s property has been replaced by a DSL property. Please add the following to your build.gradle instead:\nandroid {\n  compileOptions.incremental = false\n}", "android.incrementalJavaCompile"));
        }
        return incremental;
    }
}

