/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.tasks.factory;

import com.android.build.gradle.internal.scope.ConventionMappingHelper;
import com.android.build.gradle.internal.scope.TaskConfigAction;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.variant.BaseVariantData;
import com.android.build.gradle.internal.variant.TestVariantData;
import com.android.builder.core.VariantType;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.io.File;
import java.util.ArrayList;
import java.util.function.Predicate;
import org.gradle.api.Task;
import org.gradle.api.file.FileTree;
import org.gradle.api.reporting.DirectoryReport;
import org.gradle.api.tasks.TaskInputs;
import org.gradle.api.tasks.compile.JavaCompile;
import org.gradle.api.tasks.testing.JUnitXmlReport;
import org.gradle.api.tasks.testing.Test;
import org.gradle.api.tasks.testing.TestTaskReports;

public class AndroidUnitTest
extends Test {
    public FileTree getCandidateClassFiles() {
        if (this.getTestClassesDir() == null) {
            return this.getProject().files(new Object[0]).getAsFileTree();
        }
        return super.getCandidateClassFiles();
    }

    public static class ConfigAction
    implements TaskConfigAction<AndroidUnitTest> {
        private static final Predicate<File> PLATFORM_JAR = file -> "android.jar".equals(file.getName());
        private final VariantScope scope;

        public ConfigAction(VariantScope scope) {
            this.scope = (VariantScope)Preconditions.checkNotNull((Object)scope);
        }

        @Override
        public String getName() {
            return this.scope.getTaskName(VariantType.UNIT_TEST.getPrefix());
        }

        @Override
        public Class<AndroidUnitTest> getType() {
            return AndroidUnitTest.class;
        }

        @Override
        public void execute(AndroidUnitTest runTestsTask) {
            TestVariantData variantData = (TestVariantData)this.scope.getVariantData();
            BaseVariantData testedVariantData = (BaseVariantData)((Object)variantData.getTestedVariantData());
            runTestsTask.systemProperty("java.awt.headless", "true");
            runTestsTask.setGroup("verification");
            runTestsTask.setDescription("Run unit tests for the " + testedVariantData.getVariantConfiguration().getFullName() + " build.");
            runTestsTask.setTestClassesDir(this.scope.getJavaOutputDir());
            ConfigAction.configureSources(runTestsTask);
            ConventionMappingHelper.map((Task)runTestsTask, "classpath", () -> {
                ArrayList classpaths = Lists.newArrayList();
                JavaCompile testCompileTask = variantData.javacTask;
                if (testCompileTask != null) {
                    testCompileTask.getClasspath().getFiles().stream().filter(PLATFORM_JAR.negate()).forEach(classpaths::add);
                    classpaths.add(testCompileTask.getOutputs().getFiles());
                } else {
                    classpaths.add(testedVariantData.getScope().getJavaOutputs());
                    classpaths.add(this.scope.getJavaOutputs());
                }
                classpaths.add(variantData.getJavaResourcesForUnitTesting());
                classpaths.add(testedVariantData.getJavaResourcesForUnitTesting());
                this.scope.getGlobalScope().getAndroidBuilder().getBootClasspath(false).stream().filter(PLATFORM_JAR.negate()).forEach(classpaths::add);
                classpaths.add(this.scope.getGlobalScope().getMockableAndroidJarFile());
                return this.scope.getGlobalScope().getProject().files(new Object[]{classpaths});
            });
            TestTaskReports testTaskReports = runTestsTask.getReports();
            JUnitXmlReport xmlReport = testTaskReports.getJunitXml();
            xmlReport.setDestination((Object)new File(this.scope.getGlobalScope().getTestResultsFolder(), runTestsTask.getName()));
            DirectoryReport htmlReport = testTaskReports.getHtml();
            htmlReport.setDestination((Object)new File(this.scope.getGlobalScope().getTestReportFolder(), runTestsTask.getName()));
            this.scope.getGlobalScope().getExtension().getTestOptions().getUnitTests().applyConfiguration(runTestsTask);
        }

        private static TaskInputs configureSources(AndroidUnitTest runTestsTask) {
            return runTestsTask.getInputs().files(new Object[]{runTestsTask.getCandidateClassFiles()}).skipWhenEmpty();
        }
    }
}

