/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.tasks.factory;

import com.android.build.gradle.internal.CompileOptions;
import com.android.build.gradle.internal.LoggerWrapper;
import com.android.build.gradle.internal.dsl.CoreAnnotationProcessorOptions;
import com.android.build.gradle.internal.scope.ConventionMappingHelper;
import com.android.build.gradle.internal.scope.GlobalScope;
import com.android.build.gradle.internal.scope.TaskConfigAction;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.variant.BaseVariantData;
import com.android.build.gradle.tasks.factory.AbstractCompilesUtil;
import com.android.build.gradle.tasks.factory.AndroidJavaCompile;
import com.android.builder.core.ErrorReporter;
import com.android.builder.core.VariantType;
import com.android.builder.dependency.level2.AndroidDependency;
import com.android.utils.FileUtils;
import com.android.utils.ILogger;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.io.File;
import java.util.ArrayList;
import java.util.Map;
import org.gradle.api.JavaVersion;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.file.ConfigurableFileTree;
import org.gradle.api.file.FileCollection;
import org.gradle.api.tasks.compile.AbstractCompile;

public class JavaCompileConfigAction
implements TaskConfigAction<AndroidJavaCompile> {
    private static final ILogger LOG = LoggerWrapper.getLogger(JavaCompileConfigAction.class);
    private VariantScope scope;
    private ErrorReporter errorReporter;

    public JavaCompileConfigAction(VariantScope scope, ErrorReporter errorReporter) {
        this.scope = scope;
        this.errorReporter = errorReporter;
    }

    @Override
    public String getName() {
        return this.scope.getTaskName("compile", "JavaWithJavac");
    }

    @Override
    public Class<AndroidJavaCompile> getType() {
        return AndroidJavaCompile.class;
    }

    @Override
    public void execute(AndroidJavaCompile javacTask) {
        boolean keepDefaultBootstrap;
        BaseVariantData testedVariantData = this.scope.getTestedVariantData();
        this.scope.getVariantData().javacTask = javacTask;
        javacTask.compileSdkVersion = this.scope.getGlobalScope().getExtension().getCompileSdkVersion();
        javacTask.mBuildContext = this.scope.getInstantRunBuildContext();
        for (ConfigurableFileTree fileTree : this.scope.getVariantData().getJavaSources()) {
            javacTask.source(new Object[]{fileTree});
        }
        boolean bl = keepDefaultBootstrap = this.scope.getVariantConfiguration().getJackOptions().isEnabled() != false && JavaVersion.current().isJava8Compatible();
        if (!keepDefaultBootstrap) {
            javacTask.getOptions().setBootClasspath(Joiner.on((String)File.pathSeparator).join((Iterable)this.scope.getGlobalScope().getAndroidBuilder().getBootClasspathAsStrings(false)));
        }
        ConventionMappingHelper.map((Task)javacTask, "classpath", () -> {
            FileCollection classpath = this.scope.getJavaClasspath();
            Project project = this.scope.getGlobalScope().getProject();
            if (keepDefaultBootstrap) {
                classpath = classpath.plus((FileCollection)project.files(new Object[]{this.scope.getGlobalScope().getAndroidBuilder().getBootClasspath(false)}));
            }
            if (testedVariantData != null) {
                AndroidDependency testedLibrary;
                if (!testedVariantData.getType().equals((Object)VariantType.LIBRARY) || this.scope.getVariantData().getType().equals((Object)VariantType.UNIT_TEST)) {
                    classpath = classpath.plus((FileCollection)project.files(new Object[]{testedVariantData.getScope().getJavaClasspath(), testedVariantData.getScope().getJavaOutputDir()}));
                }
                if (this.scope.getVariantData().getType().equals((Object)VariantType.UNIT_TEST) && testedVariantData.getType().equals((Object)VariantType.LIBRARY) && (testedLibrary = testedVariantData.getVariantConfiguration().getOutput()) != null) {
                    File jarFile = testedLibrary.getJarFile();
                    classpath = classpath.minus((FileCollection)project.files(new Object[]{jarFile}));
                }
            }
            return classpath;
        });
        javacTask.setDestinationDir(this.scope.getJavaOutputDir());
        CompileOptions compileOptions = this.scope.getGlobalScope().getExtension().getCompileOptions();
        AbstractCompilesUtil.configureLanguageLevel((AbstractCompile)javacTask, compileOptions, this.scope.getGlobalScope().getExtension().getCompileSdkVersion(), this.scope.getVariantConfiguration().getJackOptions().isEnabled());
        javacTask.getOptions().setEncoding(compileOptions.getEncoding());
        GlobalScope globalScope = this.scope.getGlobalScope();
        Project project = this.scope.getGlobalScope().getProject();
        CoreAnnotationProcessorOptions annotationProcessorOptions = this.scope.getVariantConfiguration().getJavaCompileOptions().getAnnotationProcessorOptions();
        Preconditions.checkNotNull((Object)annotationProcessorOptions.getIncludeCompileClasspath());
        ArrayList processorPath = Lists.newArrayList(this.scope.getVariantData().getVariantDependency().resolveAndGetAnnotationProcessorClassPath(annotationProcessorOptions.getIncludeCompileClasspath(), this.scope.getGlobalScope().getAndroidBuilder().getErrorReporter()));
        boolean incremental = AbstractCompilesUtil.isIncremental(project, this.scope, compileOptions, processorPath, LOG);
        if (incremental) {
            LOG.verbose("Using incremental javac compilation for %1$s %2$s.", new Object[]{project.getPath(), this.scope.getFullVariantName()});
            javacTask.getOptions().setIncremental(true);
        } else {
            LOG.verbose("Not using incremental javac compilation for %1$s %2$s.", new Object[]{project.getPath(), this.scope.getFullVariantName()});
        }
        if (!processorPath.isEmpty()) {
            if (Boolean.TRUE.equals(annotationProcessorOptions.getIncludeCompileClasspath())) {
                processorPath.addAll(javacTask.getClasspath().getFiles());
            }
            javacTask.getOptions().getCompilerArgs().add("-processorpath");
            javacTask.getOptions().getCompilerArgs().add(FileUtils.joinFilePaths((Iterable)processorPath));
        }
        if (!annotationProcessorOptions.getClassNames().isEmpty()) {
            javacTask.getOptions().getCompilerArgs().add("-processor");
            javacTask.getOptions().getCompilerArgs().add(Joiner.on((char)',').join(annotationProcessorOptions.getClassNames()));
        }
        if (!(processorPath.isEmpty() && annotationProcessorOptions.getClassNames().isEmpty() || !project.getPlugins().hasPlugin("com.neenbedankt.android-apt"))) {
            this.errorReporter.handleSyncWarning(null, 0, "Using incompatible plugins for the annotation processing: android-apt. This may result in an unexpected behavior.");
        }
        if (!annotationProcessorOptions.getArguments().isEmpty()) {
            for (Map.Entry<String, String> arg : annotationProcessorOptions.getArguments().entrySet()) {
                javacTask.getOptions().getCompilerArgs().add("-A" + arg.getKey() + "=" + arg.getValue());
            }
        }
        javacTask.getOptions().getCompilerArgs().add("-s");
        javacTask.getOptions().getCompilerArgs().add(this.scope.getAnnotationProcessorOutputDir().getAbsolutePath());
    }
}

