/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.tasks.fd;

import com.android.build.gradle.internal.incremental.InstantRunBuildContext;
import com.android.build.gradle.internal.incremental.InstantRunPatchingPolicy;
import com.android.build.gradle.internal.scope.ConventionMappingHelper;
import com.android.build.gradle.internal.scope.InstantRunVariantScope;
import com.android.build.gradle.internal.scope.TaskConfigAction;
import com.android.build.gradle.internal.scope.TransformVariantScope;
import com.android.build.gradle.internal.tasks.BaseTask;
import com.android.utils.XmlUtils;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.function.Supplier;
import java.util.jar.JarOutputStream;
import java.util.zip.ZipEntry;
import javax.xml.parsers.ParserConfigurationException;
import org.gradle.api.Task;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;
import org.gradle.tooling.BuildException;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class GenerateInstantRunAppInfoTask
extends BaseTask {
    private File outputFile;
    private File mergedManifest;
    boolean usingMultiApks;
    InstantRunBuildContext instantRunBuildcontext;

    @OutputFile
    public File getOutputFile() {
        return this.outputFile;
    }

    @InputFile
    public File getMergedManifest() {
        return this.mergedManifest;
    }

    @Input
    boolean isUsingMultiApks() {
        return this.usingMultiApks;
    }

    @Input
    public long getSecretToken() {
        return this.instantRunBuildcontext.getSecretToken();
    }

    @TaskAction
    public void generateInfoTask() throws IOException {
        if (this.getMergedManifest().exists()) {
            try {
                Document document = XmlUtils.parseUtfXmlFile((File)this.getMergedManifest(), (boolean)true);
                Element root = document.getDocumentElement();
                if (root != null) {
                    String applicationId = root.getAttribute("package");
                    String applicationClass = null;
                    NodeList children = root.getChildNodes();
                    for (int i = 0; i < children.getLength(); ++i) {
                        Node node = children.item(i);
                        if (node.getNodeType() != 1 || !node.getNodeName().equals("application")) continue;
                        String applicationClass1 = null;
                        Element element = (Element)node;
                        if (element.hasAttribute("name")) {
                            String name = element.getAttribute("name");
                            assert (!name.startsWith(".")) : name;
                            if (!name.isEmpty()) {
                                applicationClass1 = name;
                            }
                        }
                        applicationClass = applicationClass1;
                        break;
                    }
                    if (!applicationId.isEmpty()) {
                        this.writeAppInfoClass(applicationId, applicationClass, this.getSecretToken());
                    }
                }
            }
            catch (IOException | ParserConfigurationException | SAXException e) {
                throw new BuildException("Failed to inject bootstrapping application", (Throwable)e);
            }
        }
    }

    void writeAppInfoClass(String applicationId, String applicationClass, long token) throws IOException {
        ClassWriter cw = new ClassWriter(0);
        String appInfoOwner = "com/android/tools/fd/runtime/AppInfo";
        cw.visit(50, 33, appInfoOwner, null, "java/lang/Object", null);
        FieldVisitor fv = cw.visitField(9, "applicationId", "Ljava/lang/String;", null, null);
        fv.visitEnd();
        fv = cw.visitField(9, "applicationClass", "Ljava/lang/String;", null, null);
        fv.visitEnd();
        fv = cw.visitField(9, "token", "J", null, null);
        fv.visitEnd();
        fv = cw.visitField(9, "usingApkSplits", "Z", null, null);
        fv.visitEnd();
        MethodVisitor mv = cw.visitMethod(1, "<init>", "()V", null, null);
        mv.visitCode();
        Label l0 = new Label();
        mv.visitLabel(l0);
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, "java/lang/Object", "<init>", "()V", false);
        mv.visitInsn(177);
        Label l1 = new Label();
        mv.visitLabel(l1);
        mv.visitLocalVariable("this", "L" + appInfoOwner + ";", null, l0, l1, 0);
        mv.visitMaxs(1, 1);
        mv.visitEnd();
        mv = cw.visitMethod(8, "<clinit>", "()V", null, null);
        mv.visitCode();
        mv.visitLdcInsn((Object)applicationId);
        mv.visitFieldInsn(179, appInfoOwner, "applicationId", "Ljava/lang/String;");
        if (applicationClass != null) {
            mv.visitLdcInsn((Object)applicationClass);
        } else {
            mv.visitInsn(1);
        }
        mv.visitFieldInsn(179, appInfoOwner, "applicationClass", "Ljava/lang/String;");
        if (token != 0L) {
            mv.visitLdcInsn((Object)token);
        } else {
            mv.visitInsn(9);
        }
        mv.visitFieldInsn(179, appInfoOwner, "token", "J");
        if (this.isUsingMultiApks()) {
            mv.visitInsn(4);
        } else {
            mv.visitInsn(3);
        }
        mv.visitFieldInsn(179, appInfoOwner, "usingApkSplits", "Z");
        mv.visitInsn(177);
        mv.visitMaxs(2, 0);
        mv.visitEnd();
        cw.visitEnd();
        byte[] bytes = cw.toByteArray();
        try (JarOutputStream outputStream = new JarOutputStream(new BufferedOutputStream(new FileOutputStream(this.getOutputFile())));){
            outputStream.putNextEntry(new ZipEntry("com/android/tools/fd/runtime/AppInfo.class"));
            outputStream.write(bytes);
            outputStream.closeEntry();
        }
    }

    public static class ConfigAction
    implements TaskConfigAction<GenerateInstantRunAppInfoTask> {
        private final InstantRunVariantScope variantScope;
        private final TransformVariantScope transformVariantScope;
        private final Supplier<File> instantRunManifestOutputFile;

        public ConfigAction(TransformVariantScope transformVariantScope, InstantRunVariantScope variantScope, Supplier<File> instantRunManifestOutputFile) {
            this.transformVariantScope = transformVariantScope;
            this.variantScope = variantScope;
            this.instantRunManifestOutputFile = instantRunManifestOutputFile;
        }

        @Override
        public String getName() {
            return this.transformVariantScope.getTaskName("generate", "InstantRunAppInfo");
        }

        @Override
        public Class<GenerateInstantRunAppInfoTask> getType() {
            return GenerateInstantRunAppInfoTask.class;
        }

        @Override
        public void execute(GenerateInstantRunAppInfoTask task) {
            task.setVariantName(this.variantScope.getFullVariantName());
            task.instantRunBuildcontext = this.variantScope.getInstantRunBuildContext();
            task.outputFile = new File(this.variantScope.getIncrementalApplicationSupportDir(), "instant-run-bootstrap.jar");
            task.mergedManifest = this.instantRunManifestOutputFile.get();
            ConventionMappingHelper.map((Task)task, "usingMultiApks", () -> this.variantScope.getInstantRunBuildContext().getPatchingPolicy() == InstantRunPatchingPolicy.MULTI_APK);
        }
    }
}

