/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.services.fetchasgoogle_pa;

import com.google.api.client.googleapis.GoogleUtils;
import com.google.api.client.googleapis.services.AbstractGoogleClientRequest;
import com.google.api.client.googleapis.services.GoogleClientRequestInitializer;
import com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient;
import com.google.api.client.http.AbstractInputStreamContent;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.util.Key;
import com.google.api.client.util.Preconditions;
import com.google.api.services.fetchasgoogle_pa.FetchasgooglePaRequest;
import com.google.api.services.fetchasgoogle_pa.FetchasgooglePaRequestInitializer;
import com.google.api.services.fetchasgoogle_pa.model.ApkDataRef;
import com.google.api.services.fetchasgoogle_pa.model.ApkHolder;
import com.google.api.services.fetchasgoogle_pa.model.CancelOperationRequest;
import com.google.api.services.fetchasgoogle_pa.model.Empty;
import com.google.api.services.fetchasgoogle_pa.model.FetchRequest;
import com.google.api.services.fetchasgoogle_pa.model.FetchResponse;
import com.google.api.services.fetchasgoogle_pa.model.ListOperationsResponse;
import com.google.api.services.fetchasgoogle_pa.model.Operation;
import com.google.api.services.fetchasgoogle_pa.model.SuggestLinkRequest;
import com.google.api.services.fetchasgoogle_pa.model.SuggestLinkResponse;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.regex.Pattern;

public class FetchasgooglePa
extends AbstractGoogleJsonClient {
    public static final String DEFAULT_ROOT_URL = "https://test-fetchasgoogle-pa.sandbox.googleapis.com/";
    public static final String DEFAULT_SERVICE_PATH = "";
    public static final String DEFAULT_BASE_URL = "https://test-fetchasgoogle-pa.sandbox.googleapis.com/";

    public FetchasgooglePa(HttpTransport transport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
        this(new Builder(transport, jsonFactory, httpRequestInitializer));
    }

    FetchasgooglePa(Builder builder) {
        super((AbstractGoogleJsonClient.Builder)builder);
    }

    protected void initialize(AbstractGoogleClientRequest<?> httpClientRequest) throws IOException {
        super.initialize(httpClientRequest);
    }

    public Apks apks() {
        return new Apks();
    }

    public Media media() {
        return new Media();
    }

    public Operations operations() {
        return new Operations();
    }

    static {
        Preconditions.checkState((GoogleUtils.MAJOR_VERSION == 1 && GoogleUtils.MINOR_VERSION >= 15 ? 1 : 0) != 0, (String)"You are currently running with version %s of google-api-client. You need at least version 1.15 of google-api-client to run version 1.22.0-SNAPSHOT of the Fetch As Google API(Test) library.", (Object[])new Object[]{GoogleUtils.VERSION});
    }

    public static final class Builder
    extends AbstractGoogleJsonClient.Builder {
        public Builder(HttpTransport transport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
            super(transport, jsonFactory, "https://test-fetchasgoogle-pa.sandbox.googleapis.com/", FetchasgooglePa.DEFAULT_SERVICE_PATH, httpRequestInitializer, false);
        }

        public FetchasgooglePa build() {
            return new FetchasgooglePa(this);
        }

        public Builder setRootUrl(String rootUrl) {
            return (Builder)super.setRootUrl(rootUrl);
        }

        public Builder setServicePath(String servicePath) {
            return (Builder)super.setServicePath(servicePath);
        }

        public Builder setHttpRequestInitializer(HttpRequestInitializer httpRequestInitializer) {
            return (Builder)super.setHttpRequestInitializer(httpRequestInitializer);
        }

        public Builder setApplicationName(String applicationName) {
            return (Builder)super.setApplicationName(applicationName);
        }

        public Builder setSuppressPatternChecks(boolean suppressPatternChecks) {
            return (Builder)super.setSuppressPatternChecks(suppressPatternChecks);
        }

        public Builder setSuppressRequiredParameterChecks(boolean suppressRequiredParameterChecks) {
            return (Builder)super.setSuppressRequiredParameterChecks(suppressRequiredParameterChecks);
        }

        public Builder setSuppressAllChecks(boolean suppressAllChecks) {
            return (Builder)super.setSuppressAllChecks(suppressAllChecks);
        }

        public Builder setFetchasgooglePaRequestInitializer(FetchasgooglePaRequestInitializer fetchasgooglepaRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer((GoogleClientRequestInitializer)fetchasgooglepaRequestInitializer);
        }

        public Builder setGoogleClientRequestInitializer(GoogleClientRequestInitializer googleClientRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer(googleClientRequestInitializer);
        }
    }

    public class Operations {
        public Cancel cancel(String name, CancelOperationRequest content) throws IOException {
            Cancel result = new Cancel(name, content);
            FetchasgooglePa.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Delete delete(String name) throws IOException {
            Delete result = new Delete(name);
            FetchasgooglePa.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Get get(String name) throws IOException {
            Get result = new Get(name);
            FetchasgooglePa.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public List list(String name) throws IOException {
            List result = new List(name);
            FetchasgooglePa.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class List
        extends FetchasgooglePaRequest<ListOperationsResponse> {
            private static final String REST_PATH = "v1/{+name}";
            private final Pattern NAME_PATTERN;
            @Key
            private String name;
            @Key
            private String filter;
            @Key
            private Integer pageSize;
            @Key
            private String pageToken;

            protected List(String name) {
                super(FetchasgooglePa.this, "GET", REST_PATH, null, ListOperationsResponse.class);
                this.NAME_PATTERN = Pattern.compile("^operations$");
                this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                if (!FetchasgooglePa.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^operations$");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List set$Xgafv(String $Xgafv) {
                return (List)super.set$Xgafv($Xgafv);
            }

            public List setAccessToken(String accessToken) {
                return (List)super.setAccessToken(accessToken);
            }

            public List setAlt(String alt) {
                return (List)super.setAlt(alt);
            }

            public List setBearerToken(String bearerToken) {
                return (List)super.setBearerToken(bearerToken);
            }

            public List setCallback(String callback) {
                return (List)super.setCallback(callback);
            }

            public List setFields(String fields) {
                return (List)super.setFields(fields);
            }

            public List setKey(String key) {
                return (List)super.setKey(key);
            }

            public List setOauthToken(String oauthToken) {
                return (List)super.setOauthToken(oauthToken);
            }

            public List setPp(Boolean pp) {
                return (List)super.setPp(pp);
            }

            public List setPrettyPrint(Boolean prettyPrint) {
                return (List)super.setPrettyPrint(prettyPrint);
            }

            public List setQuotaUser(String quotaUser) {
                return (List)super.setQuotaUser(quotaUser);
            }

            public List setUploadType(String uploadType) {
                return (List)super.setUploadType(uploadType);
            }

            public List setUploadProtocol(String uploadProtocol) {
                return (List)super.setUploadProtocol(uploadProtocol);
            }

            public String getName() {
                return this.name;
            }

            public List setName(String name) {
                if (!FetchasgooglePa.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^operations$");
                }
                this.name = name;
                return this;
            }

            public String getFilter() {
                return this.filter;
            }

            public List setFilter(String filter) {
                this.filter = filter;
                return this;
            }

            public Integer getPageSize() {
                return this.pageSize;
            }

            public List setPageSize(Integer pageSize) {
                this.pageSize = pageSize;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            @Override
            public List set(String parameterName, Object value) {
                return (List)super.set(parameterName, value);
            }
        }

        public class Get
        extends FetchasgooglePaRequest<Operation> {
            private static final String REST_PATH = "v1/{+name}";
            private final Pattern NAME_PATTERN;
            @Key
            private String name;

            protected Get(String name) {
                super(FetchasgooglePa.this, "GET", REST_PATH, null, Operation.class);
                this.NAME_PATTERN = Pattern.compile("^operations/.+$");
                this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                if (!FetchasgooglePa.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^operations/.+$");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get set$Xgafv(String $Xgafv) {
                return (Get)super.set$Xgafv($Xgafv);
            }

            public Get setAccessToken(String accessToken) {
                return (Get)super.setAccessToken(accessToken);
            }

            public Get setAlt(String alt) {
                return (Get)super.setAlt(alt);
            }

            public Get setBearerToken(String bearerToken) {
                return (Get)super.setBearerToken(bearerToken);
            }

            public Get setCallback(String callback) {
                return (Get)super.setCallback(callback);
            }

            public Get setFields(String fields) {
                return (Get)super.setFields(fields);
            }

            public Get setKey(String key) {
                return (Get)super.setKey(key);
            }

            public Get setOauthToken(String oauthToken) {
                return (Get)super.setOauthToken(oauthToken);
            }

            public Get setPp(Boolean pp) {
                return (Get)super.setPp(pp);
            }

            public Get setPrettyPrint(Boolean prettyPrint) {
                return (Get)super.setPrettyPrint(prettyPrint);
            }

            public Get setQuotaUser(String quotaUser) {
                return (Get)super.setQuotaUser(quotaUser);
            }

            public Get setUploadType(String uploadType) {
                return (Get)super.setUploadType(uploadType);
            }

            public Get setUploadProtocol(String uploadProtocol) {
                return (Get)super.setUploadProtocol(uploadProtocol);
            }

            public String getName() {
                return this.name;
            }

            public Get setName(String name) {
                if (!FetchasgooglePa.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^operations/.+$");
                }
                this.name = name;
                return this;
            }

            @Override
            public Get set(String parameterName, Object value) {
                return (Get)super.set(parameterName, value);
            }
        }

        public class Delete
        extends FetchasgooglePaRequest<Empty> {
            private static final String REST_PATH = "v1/{+name}";
            private final Pattern NAME_PATTERN;
            @Key
            private String name;

            protected Delete(String name) {
                super(FetchasgooglePa.this, "DELETE", REST_PATH, null, Empty.class);
                this.NAME_PATTERN = Pattern.compile("^operations/.+$");
                this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                if (!FetchasgooglePa.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^operations/.+$");
                }
            }

            public Delete set$Xgafv(String $Xgafv) {
                return (Delete)super.set$Xgafv($Xgafv);
            }

            public Delete setAccessToken(String accessToken) {
                return (Delete)super.setAccessToken(accessToken);
            }

            public Delete setAlt(String alt) {
                return (Delete)super.setAlt(alt);
            }

            public Delete setBearerToken(String bearerToken) {
                return (Delete)super.setBearerToken(bearerToken);
            }

            public Delete setCallback(String callback) {
                return (Delete)super.setCallback(callback);
            }

            public Delete setFields(String fields) {
                return (Delete)super.setFields(fields);
            }

            public Delete setKey(String key) {
                return (Delete)super.setKey(key);
            }

            public Delete setOauthToken(String oauthToken) {
                return (Delete)super.setOauthToken(oauthToken);
            }

            public Delete setPp(Boolean pp) {
                return (Delete)super.setPp(pp);
            }

            public Delete setPrettyPrint(Boolean prettyPrint) {
                return (Delete)super.setPrettyPrint(prettyPrint);
            }

            public Delete setQuotaUser(String quotaUser) {
                return (Delete)super.setQuotaUser(quotaUser);
            }

            public Delete setUploadType(String uploadType) {
                return (Delete)super.setUploadType(uploadType);
            }

            public Delete setUploadProtocol(String uploadProtocol) {
                return (Delete)super.setUploadProtocol(uploadProtocol);
            }

            public String getName() {
                return this.name;
            }

            public Delete setName(String name) {
                if (!FetchasgooglePa.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^operations/.+$");
                }
                this.name = name;
                return this;
            }

            @Override
            public Delete set(String parameterName, Object value) {
                return (Delete)super.set(parameterName, value);
            }
        }

        public class Cancel
        extends FetchasgooglePaRequest<Empty> {
            private static final String REST_PATH = "v1/{+name}:cancel";
            private final Pattern NAME_PATTERN;
            @Key
            private String name;

            protected Cancel(String name, CancelOperationRequest content) {
                super(FetchasgooglePa.this, "POST", REST_PATH, (Object)content, Empty.class);
                this.NAME_PATTERN = Pattern.compile("^operations/.+$");
                this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                if (!FetchasgooglePa.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^operations/.+$");
                }
            }

            public Cancel set$Xgafv(String $Xgafv) {
                return (Cancel)super.set$Xgafv($Xgafv);
            }

            public Cancel setAccessToken(String accessToken) {
                return (Cancel)super.setAccessToken(accessToken);
            }

            public Cancel setAlt(String alt) {
                return (Cancel)super.setAlt(alt);
            }

            public Cancel setBearerToken(String bearerToken) {
                return (Cancel)super.setBearerToken(bearerToken);
            }

            public Cancel setCallback(String callback) {
                return (Cancel)super.setCallback(callback);
            }

            public Cancel setFields(String fields) {
                return (Cancel)super.setFields(fields);
            }

            public Cancel setKey(String key) {
                return (Cancel)super.setKey(key);
            }

            public Cancel setOauthToken(String oauthToken) {
                return (Cancel)super.setOauthToken(oauthToken);
            }

            public Cancel setPp(Boolean pp) {
                return (Cancel)super.setPp(pp);
            }

            public Cancel setPrettyPrint(Boolean prettyPrint) {
                return (Cancel)super.setPrettyPrint(prettyPrint);
            }

            public Cancel setQuotaUser(String quotaUser) {
                return (Cancel)super.setQuotaUser(quotaUser);
            }

            public Cancel setUploadType(String uploadType) {
                return (Cancel)super.setUploadType(uploadType);
            }

            public Cancel setUploadProtocol(String uploadProtocol) {
                return (Cancel)super.setUploadProtocol(uploadProtocol);
            }

            public String getName() {
                return this.name;
            }

            public Cancel setName(String name) {
                if (!FetchasgooglePa.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^operations/.+$");
                }
                this.name = name;
                return this;
            }

            @Override
            public Cancel set(String parameterName, Object value) {
                return (Cancel)super.set(parameterName, value);
            }
        }
    }

    public class Media {
        public Download download(String resourceName) throws IOException {
            Download result = new Download(resourceName);
            FetchasgooglePa.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Upload upload(String resourceName, com.google.api.services.fetchasgoogle_pa.model.Media content) throws IOException {
            Upload result = new Upload(resourceName, content);
            FetchasgooglePa.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Upload upload(String resourceName, com.google.api.services.fetchasgoogle_pa.model.Media content, AbstractInputStreamContent mediaContent) throws IOException {
            Upload result = new Upload(resourceName, content, mediaContent);
            FetchasgooglePa.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class Upload
        extends FetchasgooglePaRequest<com.google.api.services.fetchasgoogle_pa.model.Media> {
            private static final String REST_PATH = "v1/media/{+resourceName}";
            private final Pattern RESOURCE_NAME_PATTERN;
            @Key
            private String resourceName;

            protected Upload(String resourceName, com.google.api.services.fetchasgoogle_pa.model.Media content) {
                super(FetchasgooglePa.this, "POST", REST_PATH, (Object)content, com.google.api.services.fetchasgoogle_pa.model.Media.class);
                this.RESOURCE_NAME_PATTERN = Pattern.compile("^.+$");
                this.resourceName = (String)Preconditions.checkNotNull((Object)resourceName, (Object)"Required parameter resourceName must be specified.");
                if (!FetchasgooglePa.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.RESOURCE_NAME_PATTERN.matcher(resourceName).matches(), (Object)"Parameter resourceName must conform to the pattern ^.+$");
                }
            }

            protected Upload(String resourceName, com.google.api.services.fetchasgoogle_pa.model.Media content, AbstractInputStreamContent mediaContent) {
                String string = FetchasgooglePa.this.getServicePath();
                String string2 = REST_PATH;
                super(FetchasgooglePa.this, "POST", new StringBuilder(8 + String.valueOf(string).length() + String.valueOf(string2).length()).append("/upload/").append(string).append(string2).toString(), (Object)content, com.google.api.services.fetchasgoogle_pa.model.Media.class);
                this.RESOURCE_NAME_PATTERN = Pattern.compile("^.+$");
                this.resourceName = (String)Preconditions.checkNotNull((Object)resourceName, (Object)"Required parameter resourceName must be specified.");
                this.initializeMediaUpload(mediaContent);
            }

            public Upload set$Xgafv(String $Xgafv) {
                return (Upload)super.set$Xgafv($Xgafv);
            }

            public Upload setAccessToken(String accessToken) {
                return (Upload)super.setAccessToken(accessToken);
            }

            public Upload setAlt(String alt) {
                return (Upload)super.setAlt(alt);
            }

            public Upload setBearerToken(String bearerToken) {
                return (Upload)super.setBearerToken(bearerToken);
            }

            public Upload setCallback(String callback) {
                return (Upload)super.setCallback(callback);
            }

            public Upload setFields(String fields) {
                return (Upload)super.setFields(fields);
            }

            public Upload setKey(String key) {
                return (Upload)super.setKey(key);
            }

            public Upload setOauthToken(String oauthToken) {
                return (Upload)super.setOauthToken(oauthToken);
            }

            public Upload setPp(Boolean pp) {
                return (Upload)super.setPp(pp);
            }

            public Upload setPrettyPrint(Boolean prettyPrint) {
                return (Upload)super.setPrettyPrint(prettyPrint);
            }

            public Upload setQuotaUser(String quotaUser) {
                return (Upload)super.setQuotaUser(quotaUser);
            }

            public Upload setUploadType(String uploadType) {
                return (Upload)super.setUploadType(uploadType);
            }

            public Upload setUploadProtocol(String uploadProtocol) {
                return (Upload)super.setUploadProtocol(uploadProtocol);
            }

            public String getResourceName() {
                return this.resourceName;
            }

            public Upload setResourceName(String resourceName) {
                if (!FetchasgooglePa.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.RESOURCE_NAME_PATTERN.matcher(resourceName).matches(), (Object)"Parameter resourceName must conform to the pattern ^.+$");
                }
                this.resourceName = resourceName;
                return this;
            }

            @Override
            public Upload set(String parameterName, Object value) {
                return (Upload)super.set(parameterName, value);
            }
        }

        public class Download
        extends FetchasgooglePaRequest<com.google.api.services.fetchasgoogle_pa.model.Media> {
            private static final String REST_PATH = "v1/media/{+resourceName}";
            private final Pattern RESOURCE_NAME_PATTERN;
            @Key
            private String resourceName;

            protected Download(String resourceName) {
                super(FetchasgooglePa.this, "GET", REST_PATH, null, com.google.api.services.fetchasgoogle_pa.model.Media.class);
                this.RESOURCE_NAME_PATTERN = Pattern.compile("^.+$");
                this.resourceName = (String)Preconditions.checkNotNull((Object)resourceName, (Object)"Required parameter resourceName must be specified.");
                if (!FetchasgooglePa.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.RESOURCE_NAME_PATTERN.matcher(resourceName).matches(), (Object)"Parameter resourceName must conform to the pattern ^.+$");
                }
                this.initializeMediaDownload();
            }

            public void executeMediaAndDownloadTo(OutputStream outputStream) throws IOException {
                super.executeMediaAndDownloadTo(outputStream);
            }

            public InputStream executeMediaAsInputStream() throws IOException {
                return super.executeMediaAsInputStream();
            }

            public HttpResponse executeMedia() throws IOException {
                return super.executeMedia();
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Download set$Xgafv(String $Xgafv) {
                return (Download)super.set$Xgafv($Xgafv);
            }

            public Download setAccessToken(String accessToken) {
                return (Download)super.setAccessToken(accessToken);
            }

            public Download setAlt(String alt) {
                return (Download)super.setAlt(alt);
            }

            public Download setBearerToken(String bearerToken) {
                return (Download)super.setBearerToken(bearerToken);
            }

            public Download setCallback(String callback) {
                return (Download)super.setCallback(callback);
            }

            public Download setFields(String fields) {
                return (Download)super.setFields(fields);
            }

            public Download setKey(String key) {
                return (Download)super.setKey(key);
            }

            public Download setOauthToken(String oauthToken) {
                return (Download)super.setOauthToken(oauthToken);
            }

            public Download setPp(Boolean pp) {
                return (Download)super.setPp(pp);
            }

            public Download setPrettyPrint(Boolean prettyPrint) {
                return (Download)super.setPrettyPrint(prettyPrint);
            }

            public Download setQuotaUser(String quotaUser) {
                return (Download)super.setQuotaUser(quotaUser);
            }

            public Download setUploadType(String uploadType) {
                return (Download)super.setUploadType(uploadType);
            }

            public Download setUploadProtocol(String uploadProtocol) {
                return (Download)super.setUploadProtocol(uploadProtocol);
            }

            public String getResourceName() {
                return this.resourceName;
            }

            public Download setResourceName(String resourceName) {
                if (!FetchasgooglePa.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.RESOURCE_NAME_PATTERN.matcher(resourceName).matches(), (Object)"Parameter resourceName must conform to the pattern ^.+$");
                }
                this.resourceName = resourceName;
                return this;
            }

            @Override
            public Download set(String parameterName, Object value) {
                return (Download)super.set(parameterName, value);
            }
        }
    }

    public class Apks {
        public Create create(ApkHolder content) throws IOException {
            Create result = new Create(this, content);
            FetchasgooglePa.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Fetch fetch(FetchRequest content) throws IOException {
            Fetch result = new Fetch(this, content);
            FetchasgooglePa.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public GetFetch getFetch() throws IOException {
            GetFetch result = new GetFetch(this);
            FetchasgooglePa.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public StartUpload startUpload() throws IOException {
            StartUpload result = new StartUpload(this);
            FetchasgooglePa.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public SuggestLink suggestLink(SuggestLinkRequest content) throws IOException {
            SuggestLink result = new SuggestLink(this, content);
            FetchasgooglePa.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class SuggestLink
        extends FetchasgooglePaRequest<SuggestLinkResponse> {
            private static final String REST_PATH = "v1/apks:suggestLink";

            protected SuggestLink(Apks this$1, SuggestLinkRequest content) {
                super(this$1.FetchasgooglePa.this, "POST", REST_PATH, (Object)content, SuggestLinkResponse.class);
            }

            public SuggestLink set$Xgafv(String $Xgafv) {
                return (SuggestLink)super.set$Xgafv($Xgafv);
            }

            public SuggestLink setAccessToken(String accessToken) {
                return (SuggestLink)super.setAccessToken(accessToken);
            }

            public SuggestLink setAlt(String alt) {
                return (SuggestLink)super.setAlt(alt);
            }

            public SuggestLink setBearerToken(String bearerToken) {
                return (SuggestLink)super.setBearerToken(bearerToken);
            }

            public SuggestLink setCallback(String callback) {
                return (SuggestLink)super.setCallback(callback);
            }

            public SuggestLink setFields(String fields) {
                return (SuggestLink)super.setFields(fields);
            }

            public SuggestLink setKey(String key) {
                return (SuggestLink)super.setKey(key);
            }

            public SuggestLink setOauthToken(String oauthToken) {
                return (SuggestLink)super.setOauthToken(oauthToken);
            }

            public SuggestLink setPp(Boolean pp) {
                return (SuggestLink)super.setPp(pp);
            }

            public SuggestLink setPrettyPrint(Boolean prettyPrint) {
                return (SuggestLink)super.setPrettyPrint(prettyPrint);
            }

            public SuggestLink setQuotaUser(String quotaUser) {
                return (SuggestLink)super.setQuotaUser(quotaUser);
            }

            public SuggestLink setUploadType(String uploadType) {
                return (SuggestLink)super.setUploadType(uploadType);
            }

            public SuggestLink setUploadProtocol(String uploadProtocol) {
                return (SuggestLink)super.setUploadProtocol(uploadProtocol);
            }

            @Override
            public SuggestLink set(String parameterName, Object value) {
                return (SuggestLink)super.set(parameterName, value);
            }
        }

        public class StartUpload
        extends FetchasgooglePaRequest<ApkDataRef> {
            private static final String REST_PATH = "v1/apks:startUpload";

            protected StartUpload(Apks this$1) {
                super(this$1.FetchasgooglePa.this, "POST", REST_PATH, null, ApkDataRef.class);
            }

            public StartUpload set$Xgafv(String $Xgafv) {
                return (StartUpload)super.set$Xgafv($Xgafv);
            }

            public StartUpload setAccessToken(String accessToken) {
                return (StartUpload)super.setAccessToken(accessToken);
            }

            public StartUpload setAlt(String alt) {
                return (StartUpload)super.setAlt(alt);
            }

            public StartUpload setBearerToken(String bearerToken) {
                return (StartUpload)super.setBearerToken(bearerToken);
            }

            public StartUpload setCallback(String callback) {
                return (StartUpload)super.setCallback(callback);
            }

            public StartUpload setFields(String fields) {
                return (StartUpload)super.setFields(fields);
            }

            public StartUpload setKey(String key) {
                return (StartUpload)super.setKey(key);
            }

            public StartUpload setOauthToken(String oauthToken) {
                return (StartUpload)super.setOauthToken(oauthToken);
            }

            public StartUpload setPp(Boolean pp) {
                return (StartUpload)super.setPp(pp);
            }

            public StartUpload setPrettyPrint(Boolean prettyPrint) {
                return (StartUpload)super.setPrettyPrint(prettyPrint);
            }

            public StartUpload setQuotaUser(String quotaUser) {
                return (StartUpload)super.setQuotaUser(quotaUser);
            }

            public StartUpload setUploadType(String uploadType) {
                return (StartUpload)super.setUploadType(uploadType);
            }

            public StartUpload setUploadProtocol(String uploadProtocol) {
                return (StartUpload)super.setUploadProtocol(uploadProtocol);
            }

            @Override
            public StartUpload set(String parameterName, Object value) {
                return (StartUpload)super.set(parameterName, value);
            }
        }

        public class GetFetch
        extends FetchasgooglePaRequest<FetchResponse> {
            private static final String REST_PATH = "v1/apks:fetch";
            @Key
            private String packageId;
            @Key
            private String apkId;
            @Key
            private String source;
            @Key
            private String language;
            @Key(value="intent.uri")
            private String intentUri;
            @Key
            private String previewFeature;

            protected GetFetch(Apks this$1) {
                super(this$1.FetchasgooglePa.this, "GET", REST_PATH, null, FetchResponse.class);
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public GetFetch set$Xgafv(String $Xgafv) {
                return (GetFetch)super.set$Xgafv($Xgafv);
            }

            public GetFetch setAccessToken(String accessToken) {
                return (GetFetch)super.setAccessToken(accessToken);
            }

            public GetFetch setAlt(String alt) {
                return (GetFetch)super.setAlt(alt);
            }

            public GetFetch setBearerToken(String bearerToken) {
                return (GetFetch)super.setBearerToken(bearerToken);
            }

            public GetFetch setCallback(String callback) {
                return (GetFetch)super.setCallback(callback);
            }

            public GetFetch setFields(String fields) {
                return (GetFetch)super.setFields(fields);
            }

            public GetFetch setKey(String key) {
                return (GetFetch)super.setKey(key);
            }

            public GetFetch setOauthToken(String oauthToken) {
                return (GetFetch)super.setOauthToken(oauthToken);
            }

            public GetFetch setPp(Boolean pp) {
                return (GetFetch)super.setPp(pp);
            }

            public GetFetch setPrettyPrint(Boolean prettyPrint) {
                return (GetFetch)super.setPrettyPrint(prettyPrint);
            }

            public GetFetch setQuotaUser(String quotaUser) {
                return (GetFetch)super.setQuotaUser(quotaUser);
            }

            public GetFetch setUploadType(String uploadType) {
                return (GetFetch)super.setUploadType(uploadType);
            }

            public GetFetch setUploadProtocol(String uploadProtocol) {
                return (GetFetch)super.setUploadProtocol(uploadProtocol);
            }

            public String getPackageId() {
                return this.packageId;
            }

            public GetFetch setPackageId(String packageId) {
                this.packageId = packageId;
                return this;
            }

            public String getApkId() {
                return this.apkId;
            }

            public GetFetch setApkId(String apkId) {
                this.apkId = apkId;
                return this;
            }

            public String getSource() {
                return this.source;
            }

            public GetFetch setSource(String source) {
                this.source = source;
                return this;
            }

            public String getLanguage() {
                return this.language;
            }

            public GetFetch setLanguage(String language) {
                this.language = language;
                return this;
            }

            public String getIntentUri() {
                return this.intentUri;
            }

            public GetFetch setIntentUri(String intentUri) {
                this.intentUri = intentUri;
                return this;
            }

            public String getPreviewFeature() {
                return this.previewFeature;
            }

            public GetFetch setPreviewFeature(String previewFeature) {
                this.previewFeature = previewFeature;
                return this;
            }

            @Override
            public GetFetch set(String parameterName, Object value) {
                return (GetFetch)super.set(parameterName, value);
            }
        }

        public class Fetch
        extends FetchasgooglePaRequest<Operation> {
            private static final String REST_PATH = "v1/apks:fetch";

            protected Fetch(Apks this$1, FetchRequest content) {
                super(this$1.FetchasgooglePa.this, "POST", REST_PATH, (Object)content, Operation.class);
            }

            public Fetch set$Xgafv(String $Xgafv) {
                return (Fetch)super.set$Xgafv($Xgafv);
            }

            public Fetch setAccessToken(String accessToken) {
                return (Fetch)super.setAccessToken(accessToken);
            }

            public Fetch setAlt(String alt) {
                return (Fetch)super.setAlt(alt);
            }

            public Fetch setBearerToken(String bearerToken) {
                return (Fetch)super.setBearerToken(bearerToken);
            }

            public Fetch setCallback(String callback) {
                return (Fetch)super.setCallback(callback);
            }

            public Fetch setFields(String fields) {
                return (Fetch)super.setFields(fields);
            }

            public Fetch setKey(String key) {
                return (Fetch)super.setKey(key);
            }

            public Fetch setOauthToken(String oauthToken) {
                return (Fetch)super.setOauthToken(oauthToken);
            }

            public Fetch setPp(Boolean pp) {
                return (Fetch)super.setPp(pp);
            }

            public Fetch setPrettyPrint(Boolean prettyPrint) {
                return (Fetch)super.setPrettyPrint(prettyPrint);
            }

            public Fetch setQuotaUser(String quotaUser) {
                return (Fetch)super.setQuotaUser(quotaUser);
            }

            public Fetch setUploadType(String uploadType) {
                return (Fetch)super.setUploadType(uploadType);
            }

            public Fetch setUploadProtocol(String uploadProtocol) {
                return (Fetch)super.setUploadProtocol(uploadProtocol);
            }

            @Override
            public Fetch set(String parameterName, Object value) {
                return (Fetch)super.set(parameterName, value);
            }
        }

        public class Create
        extends FetchasgooglePaRequest<ApkHolder> {
            private static final String REST_PATH = "v1/apks";

            protected Create(Apks this$1, ApkHolder content) {
                super(this$1.FetchasgooglePa.this, "POST", REST_PATH, (Object)content, ApkHolder.class);
            }

            public Create set$Xgafv(String $Xgafv) {
                return (Create)super.set$Xgafv($Xgafv);
            }

            public Create setAccessToken(String accessToken) {
                return (Create)super.setAccessToken(accessToken);
            }

            public Create setAlt(String alt) {
                return (Create)super.setAlt(alt);
            }

            public Create setBearerToken(String bearerToken) {
                return (Create)super.setBearerToken(bearerToken);
            }

            public Create setCallback(String callback) {
                return (Create)super.setCallback(callback);
            }

            public Create setFields(String fields) {
                return (Create)super.setFields(fields);
            }

            public Create setKey(String key) {
                return (Create)super.setKey(key);
            }

            public Create setOauthToken(String oauthToken) {
                return (Create)super.setOauthToken(oauthToken);
            }

            public Create setPp(Boolean pp) {
                return (Create)super.setPp(pp);
            }

            public Create setPrettyPrint(Boolean prettyPrint) {
                return (Create)super.setPrettyPrint(prettyPrint);
            }

            public Create setQuotaUser(String quotaUser) {
                return (Create)super.setQuotaUser(quotaUser);
            }

            public Create setUploadType(String uploadType) {
                return (Create)super.setUploadType(uploadType);
            }

            public Create setUploadProtocol(String uploadProtocol) {
                return (Create)super.setUploadProtocol(uploadProtocol);
            }

            @Override
            public Create set(String parameterName, Object value) {
                return (Create)super.set(parameterName, value);
            }
        }
    }
}

