/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint;

import com.android.tools.lint.LintCliClient;
import com.android.tools.lint.Reporter;
import com.android.tools.lint.Warning;
import com.android.tools.lint.checks.BuiltinIssueRegistry;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Position;
import com.android.tools.lint.detector.api.TextFormat;
import com.android.utils.SdkUtils;
import com.android.utils.XmlUtils;
import com.google.common.annotations.Beta;
import com.google.common.base.Charsets;
import com.google.common.base.Joiner;
import com.google.common.io.Files;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.List;

@Beta
public class XmlReporter
extends Reporter {
    private final Writer writer;
    private boolean intendedForBaseline;

    public XmlReporter(LintCliClient client, File output) throws IOException {
        super(client, output);
        this.writer = new BufferedWriter(Files.newWriter((File)output, (Charset)Charsets.UTF_8));
    }

    public boolean isIntendedForBaseline() {
        return this.intendedForBaseline;
    }

    public void setIntendedForBaseline(boolean intendedForBaseline) {
        this.intendedForBaseline = intendedForBaseline;
    }

    @Override
    public void write(Reporter.Stats stats, List<Warning> issues) throws IOException {
        this.writer.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        this.writer.write("<issues format=\"4\"");
        String revision = this.client.getClientRevision();
        if (revision != null) {
            this.writer.write(String.format(" by=\"lint %1$s\"", revision));
        }
        this.writer.write(">\n");
        if (!issues.isEmpty()) {
            for (Warning warning : issues) {
                int index2;
                String line;
                int index1;
                this.writer.write(10);
                XmlReporter.indent(this.writer, 1);
                this.writer.write("<issue");
                Issue issue = warning.issue;
                XmlReporter.writeAttribute(this.writer, 2, "id", issue.getId());
                if (!this.intendedForBaseline) {
                    XmlReporter.writeAttribute(this.writer, 2, "severity", warning.severity.getDescription());
                }
                XmlReporter.writeAttribute(this.writer, 2, "message", warning.message);
                if (!this.isIntendedForBaseline()) {
                    XmlReporter.writeAttribute(this.writer, 2, "category", issue.getCategory().getFullName());
                    XmlReporter.writeAttribute(this.writer, 2, "priority", Integer.toString(issue.getPriority()));
                    XmlReporter.writeAttribute(this.writer, 2, "summary", issue.getBriefDescription(TextFormat.RAW));
                    XmlReporter.writeAttribute(this.writer, 2, "explanation", issue.getExplanation(TextFormat.RAW));
                    List moreInfo = issue.getMoreInfo();
                    if (!moreInfo.isEmpty()) {
                        XmlReporter.writeAttribute(this.writer, 2, "url", (String)moreInfo.get(0));
                        XmlReporter.writeAttribute(this.writer, 2, "urls", Joiner.on((char)',').join((Iterable)issue.getMoreInfo()));
                    }
                }
                if (warning.errorLine != null && !warning.errorLine.isEmpty() && (index1 = (line = warning.errorLine).indexOf(10)) != -1 && (index2 = line.indexOf(10, index1 + 1)) != -1) {
                    String line1 = line.substring(0, index1);
                    String line2 = line.substring(index1 + 1, index2);
                    XmlReporter.writeAttribute(this.writer, 2, "errorLine1", line1);
                    XmlReporter.writeAttribute(this.writer, 2, "errorLine2", line2);
                }
                if (warning.isVariantSpecific()) {
                    XmlReporter.writeAttribute(this.writer, 2, "includedVariants", Joiner.on((char)',').join(warning.getIncludedVariantNames()));
                    XmlReporter.writeAttribute(this.writer, 2, "excludedVariants", Joiner.on((char)',').join(warning.getExcludedVariantNames()));
                }
                if (!this.isIntendedForBaseline() && this.client.getRegistry() instanceof BuiltinIssueRegistry && XmlReporter.hasAutoFix(issue)) {
                    XmlReporter.writeAttribute(this.writer, 2, "quickfix", "studio");
                }
                assert (warning.file != null == (warning.location != null));
                if (warning.file != null) assert (warning.location.getFile() == warning.file);
                Location location = warning.location;
                if (location != null) {
                    this.writer.write(">\n");
                    while (location != null) {
                        XmlReporter.indent(this.writer, 2);
                        this.writer.write("<location");
                        String path = LintCliClient.getDisplayPath(warning.project, location.getFile(), this.client.flags.isFullPath() && !this.intendedForBaseline);
                        XmlReporter.writeAttribute(this.writer, 3, "file", path);
                        Position start = location.getStart();
                        if (start != null) {
                            int line2 = start.getLine();
                            int column = start.getColumn();
                            if (line2 >= 0) {
                                XmlReporter.writeAttribute(this.writer, 3, "line", Integer.toString(line2 + 1));
                                if (column >= 0) {
                                    XmlReporter.writeAttribute(this.writer, 3, "column", Integer.toString(column + 1));
                                }
                            }
                        }
                        this.writer.write("/>\n");
                        location = location.getSecondary();
                    }
                    XmlReporter.indent(this.writer, 1);
                    this.writer.write("</issue>\n");
                    continue;
                }
                this.writer.write(10);
                XmlReporter.indent(this.writer, 1);
                this.writer.write("/>\n");
            }
        }
        this.writer.write("\n</issues>\n");
        this.writer.close();
        if (!(this.client.getFlags().isQuiet() || stats.errorCount <= 0 && stats.warningCount <= 0)) {
            String url = SdkUtils.fileToUrlString((File)this.output.getAbsoluteFile());
            System.out.println(String.format("Wrote XML report to %1$s", url));
        }
    }

    private static void writeAttribute(Writer writer, int indent, String name, String value) throws IOException {
        writer.write(10);
        XmlReporter.indent(writer, indent);
        writer.write(name);
        writer.write(61);
        writer.write(34);
        writer.write(XmlUtils.toXmlAttributeValue((String)value));
        writer.write(34);
    }

    private static void indent(Writer writer, int indent) throws IOException {
        for (int level = 0; level < indent; ++level) {
            writer.write("    ");
        }
    }
}

