/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.psi;

import com.android.tools.lint.psi.EcjPsiManager;
import com.android.tools.lint.psi.EcjPsiSourceElement;
import com.android.tools.lint.psi.UnimplementedLintPsiApiException;
import com.google.common.collect.Lists;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiType;
import java.util.ArrayList;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.ImportReference;
import org.eclipse.jdt.internal.compiler.ast.QualifiedTypeReference;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;

class EcjPsiJavaCodeReferenceElement
extends EcjPsiSourceElement
implements PsiJavaCodeReferenceElement {
    private PsiElement mNameElement;
    private EcjPsiJavaCodeReferenceElement mQualifier;
    private PsiReferenceParameterList mParameterList;

    EcjPsiJavaCodeReferenceElement(EcjPsiManager manager, TypeReference typeReference) {
        super(manager, (ASTNode)typeReference);
    }

    EcjPsiJavaCodeReferenceElement(EcjPsiManager manager, ImportReference importReference) {
        super(manager, (ASTNode)importReference);
    }

    @Override
    public void accept(PsiElementVisitor visitor) {
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitReferenceElement((PsiJavaCodeReferenceElement)this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    void setNameElement(PsiElement nameElement) {
        this.mNameElement = nameElement;
    }

    void setQualifier(EcjPsiJavaCodeReferenceElement qualifier) {
        this.mQualifier = qualifier;
    }

    void setParameterList(PsiReferenceParameterList parameterList) {
        this.mParameterList = parameterList;
    }

    public PsiElement getReferenceNameElement() {
        return this.mNameElement;
    }

    public PsiReferenceParameterList getParameterList() {
        return this.mParameterList;
    }

    public PsiType[] getTypeParameters() {
        if (!(this.mNativeNode instanceof TypeReference)) {
            return PsiType.EMPTY_ARRAY;
        }
        TypeReference typeReference = (TypeReference)this.mNativeNode;
        TypeReference[][] typeArguments = typeReference.getTypeArguments();
        if (typeArguments == null || typeArguments.length == 0) {
            return PsiType.EMPTY_ARRAY;
        }
        for (int i = typeArguments.length - 1; i >= 0; --i) {
            TypeReference[] refs = typeArguments[i];
            if (refs == null || refs.length <= 0) continue;
            ArrayList types = Lists.newArrayListWithCapacity((int)refs.length);
            for (TypeReference ref : refs) {
                PsiType type = this.mManager.findType(ref);
                if (type == null) continue;
                types.add(type);
            }
            return types.toArray(PsiType.EMPTY_ARRAY);
        }
        return PsiType.EMPTY_ARRAY;
    }

    public boolean isQualified() {
        return this.mNativeNode instanceof ImportReference || this.mNativeNode instanceof QualifiedTypeReference;
    }

    public String getQualifiedName() {
        if (this.mNativeNode instanceof ImportReference) {
            return EcjPsiManager.getTypeName(((ImportReference)this.mNativeNode).getImportName());
        }
        TypeReference reference = (TypeReference)this.mNativeNode;
        if (reference.resolvedType instanceof ReferenceBinding) {
            return EcjPsiManager.getTypeName((ReferenceBinding)reference.resolvedType);
        }
        return EcjPsiManager.getTypeName(reference.getTypeName());
    }

    public String getReferenceName() {
        return this.mNameElement.getText();
    }

    public PsiElement getQualifier() {
        return this.mQualifier;
    }

    public PsiElement getElement() {
        return this;
    }

    public TextRange getRangeInElement() {
        throw new UnimplementedLintPsiApiException();
    }

    public PsiElement resolve() {
        return this.mManager.findElement(this.mNativeNode);
    }

    public String getCanonicalText() {
        return this.getQualifiedName();
    }

    public boolean isSoft() {
        return false;
    }
}

