/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.state;

import com.google.common.hash.Hasher;
import com.google.common.io.ByteStreams;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import org.gradle.api.internal.changedetection.state.ClasspathContentHasher;
import org.gradle.api.internal.tasks.compile.ApiClassExtractor;
import org.gradle.util.DeprecationLogger;
import org.gradle.util.internal.Java9ClassReader;

public class AbiExtractingClasspathContentHasher
implements ClasspathContentHasher {
    private final ClasspathContentHasher fallback;

    public AbiExtractingClasspathContentHasher(ClasspathContentHasher fallback) {
        this.fallback = fallback;
    }

    private void hashClassBytes(InputStream inputStream, Hasher hasher) throws IOException {
        byte[] signature;
        Java9ClassReader reader;
        byte[] classBytes = ByteStreams.toByteArray((InputStream)inputStream);
        ApiClassExtractor extractor = new ApiClassExtractor(Collections.<String>emptySet());
        if (extractor.shouldExtractApiClassFrom(reader = new Java9ClassReader(classBytes)) && (signature = extractor.extractApiClassFrom(reader)) != null) {
            hasher.putBytes(signature);
        }
    }

    public void appendContent(String name, InputStream inputStream, Hasher hasher) {
        if (name.endsWith(".class")) {
            try {
                this.hashClassBytes(inputStream, hasher);
            }
            catch (Exception e) {
                this.fallback.appendContent(name, inputStream, hasher);
                DeprecationLogger.nagUserWith((String)("Malformed class file [" + name + "] found on compile classpath, which means that this class will cause a compile error if referenced in a source file. Gradle 5.0 will no longer allow malformed classes on compile classpath."));
            }
        }
    }
}

