/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks;

import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Lists;
import groovy.lang.GString;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import org.gradle.api.Describable;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.TaskInputsInternal;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.file.CompositeFileCollection;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.api.internal.file.collections.FileCollectionResolveContext;
import org.gradle.api.internal.tasks.DefaultTaskInputPropertySpec;
import org.gradle.api.internal.tasks.TaskInputFilePropertyBuilderInternal;
import org.gradle.api.internal.tasks.TaskInputFilePropertySpec;
import org.gradle.api.internal.tasks.TaskInputPropertySpecAndBuilder;
import org.gradle.api.internal.tasks.TaskMutator;
import org.gradle.api.internal.tasks.TaskPropertyUtils;
import org.gradle.api.tasks.TaskInputs;
import org.gradle.util.DeprecationLogger;
import org.gradle.util.GUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultTaskInputs
implements TaskInputsInternal {
    private final FileCollection allInputFiles;
    private final FileCollection allSourceFiles;
    private final FileResolver resolver;
    private final TaskInternal task;
    private final TaskMutator taskMutator;
    private final Map<String, Object> properties = new HashMap<String, Object>();
    private final List<TaskInputPropertySpecAndBuilder> filePropertiesInternal = Lists.newArrayList();
    private ImmutableSortedSet<TaskInputFilePropertySpec> fileProperties;

    public DefaultTaskInputs(FileResolver resolver, TaskInternal task, TaskMutator taskMutator) {
        this.resolver = resolver;
        this.task = task;
        this.taskMutator = taskMutator;
        String taskName = task.getName();
        this.allInputFiles = new TaskInputUnionFileCollection(taskName, "input", false, this.filePropertiesInternal);
        this.allSourceFiles = new TaskInputUnionFileCollection(taskName, "source", true, this.filePropertiesInternal);
    }

    @Override
    public boolean getHasInputs() {
        return !this.filePropertiesInternal.isEmpty() || !this.properties.isEmpty();
    }

    @Override
    public FileCollection getFiles() {
        return this.allInputFiles;
    }

    @Override
    public ImmutableSortedSet<TaskInputFilePropertySpec> getFileProperties() {
        if (this.fileProperties == null) {
            TaskPropertyUtils.ensurePropertiesHaveNames(this.filePropertiesInternal);
            this.fileProperties = TaskPropertyUtils.collectFileProperties("input", this.filePropertiesInternal.iterator());
        }
        return this.fileProperties;
    }

    @Override
    public TaskInputFilePropertyBuilderInternal files(final Object ... paths) {
        return this.taskMutator.mutate("TaskInputs.files(Object...)", new Callable<TaskInputFilePropertyBuilderInternal>(){

            @Override
            public TaskInputFilePropertyBuilderInternal call() {
                return DefaultTaskInputs.this.addSpec(paths);
            }
        });
    }

    @Override
    public TaskInputFilePropertyBuilderInternal file(final Object path) {
        return this.taskMutator.mutate("TaskInputs.file(Object)", new Callable<TaskInputFilePropertyBuilderInternal>(){

            @Override
            public TaskInputFilePropertyBuilderInternal call() {
                return DefaultTaskInputs.this.addSpec(path);
            }
        });
    }

    @Override
    public TaskInputFilePropertyBuilderInternal dir(final Object dirPath) {
        return this.taskMutator.mutate("TaskInputs.dir(Object)", new Callable<TaskInputFilePropertyBuilderInternal>(){

            @Override
            public TaskInputFilePropertyBuilderInternal call() {
                return DefaultTaskInputs.this.addSpec(DefaultTaskInputs.this.resolver.resolveFilesAsTree(dirPath));
            }
        });
    }

    @Override
    public boolean getHasSourceFiles() {
        for (TaskInputPropertySpecAndBuilder propertySpec : this.filePropertiesInternal) {
            if (!propertySpec.isSkipWhenEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public FileCollection getSourceFiles() {
        return this.allSourceFiles;
    }

    @Override
    public TaskInputs source(final Object ... paths) {
        DeprecationLogger.nagUserOfDiscontinuedMethod((String)"TaskInputs.source(Object...)", (String)"Please use TaskInputs.files(Object...).skipWhenEmpty() instead.");
        this.taskMutator.mutate("TaskInputs.source(Object...)", new Runnable(){

            public void run() {
                DefaultTaskInputs.this.addSpec(paths, true);
            }
        });
        return this;
    }

    @Override
    public TaskInputs source(final Object path) {
        DeprecationLogger.nagUserOfDiscontinuedMethod((String)"TaskInputs.source(Object)", (String)"Please use TaskInputs.file(Object).skipWhenEmpty() instead.");
        this.taskMutator.mutate("TaskInputs.source(Object)", new Runnable(){

            public void run() {
                DefaultTaskInputs.this.addSpec(path, true);
            }
        });
        return this;
    }

    @Override
    public TaskInputs sourceDir(final Object path) {
        DeprecationLogger.nagUserOfDiscontinuedMethod((String)"TaskInputs.sourceDir(Object)", (String)"Please use TaskInputs.dir(Object).skipWhenEmpty() instead.");
        this.taskMutator.mutate("TaskInputs.sourceDir(Object)", new Runnable(){

            public void run() {
                DefaultTaskInputs.this.addSpec(DefaultTaskInputs.this.resolver.resolveFilesAsTree(path), true);
            }
        });
        return this;
    }

    private TaskInputFilePropertyBuilderInternal addSpec(Object paths) {
        return this.addSpec(paths, false);
    }

    private TaskInputFilePropertyBuilderInternal addSpec(Object paths, boolean skipWhenEmpty) {
        DefaultTaskInputPropertySpec spec = new DefaultTaskInputPropertySpec(this, this.task.getName(), skipWhenEmpty, this.resolver, paths);
        this.filePropertiesInternal.add(spec);
        return spec;
    }

    @Override
    public Map<String, Object> getProperties() {
        HashMap<String, Object> actualProperties = new HashMap<String, Object>();
        for (Map.Entry<String, Object> entry : this.properties.entrySet()) {
            String propertyName = entry.getKey();
            try {
                Object value = this.prepareValue(entry.getValue());
                actualProperties.put(propertyName, value);
            }
            catch (Exception ex) {
                throw new InvalidUserDataException(String.format("Error while evaluating property '%s' of %s", propertyName, this.task), ex);
            }
        }
        return actualProperties;
    }

    private Object prepareValue(Object value) {
        while (value instanceof Callable) {
            Callable callable = (Callable)value;
            value = GUtil.uncheckedCall((Callable)callable);
        }
        if (value instanceof FileCollection) {
            FileCollection fileCollection = (FileCollection)value;
            return fileCollection.getFiles();
        }
        return DefaultTaskInputs.avoidGString(value);
    }

    private static Object avoidGString(Object value) {
        return value instanceof GString ? value.toString() : value;
    }

    @Override
    public TaskInputs property(final String name, final Object value) {
        this.taskMutator.mutate("TaskInputs.property(String, Object)", new Runnable(){

            public void run() {
                DefaultTaskInputs.this.properties.put(name, value);
            }
        });
        return this;
    }

    @Override
    public TaskInputs properties(final Map<String, ?> newProps) {
        this.taskMutator.mutate("TaskInputs.properties(Map)", new Runnable(){

            public void run() {
                DefaultTaskInputs.this.properties.putAll(newProps);
            }
        });
        return this;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TaskInputUnionFileCollection
    extends CompositeFileCollection
    implements Describable {
        private final boolean skipWhenEmptyOnly;
        private final String taskName;
        private final String type;
        private final List<TaskInputPropertySpecAndBuilder> filePropertiesInternal;

        public TaskInputUnionFileCollection(String taskName, String type, boolean skipWhenEmptyOnly, List<TaskInputPropertySpecAndBuilder> filePropertiesInternal) {
            this.taskName = taskName;
            this.type = type;
            this.skipWhenEmptyOnly = skipWhenEmptyOnly;
            this.filePropertiesInternal = filePropertiesInternal;
        }

        @Override
        public String getDisplayName() {
            return "task '" + this.taskName + "' " + this.type + " files";
        }

        @Override
        public void visitContents(FileCollectionResolveContext context) {
            for (TaskInputPropertySpecAndBuilder fileProperty : this.filePropertiesInternal) {
                if (this.skipWhenEmptyOnly && !fileProperty.isSkipWhenEmpty()) continue;
                context.add(fileProperty.getPropertyFiles());
            }
        }
    }
}

