/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.execution;

import org.gradle.api.GradleException;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.changedetection.TaskArtifactStateRepository;
import org.gradle.api.internal.tasks.TaskExecuter;
import org.gradle.api.internal.tasks.TaskExecutionContext;
import org.gradle.api.internal.tasks.TaskStateInternal;
import org.gradle.api.tasks.TaskExecutionException;
import org.gradle.caching.internal.tasks.TaskOutputCachingBuildCacheKey;

public class VerifyNoInputChangesTaskExecuter
implements TaskExecuter {
    private TaskExecuter delegate;
    private TaskArtifactStateRepository repository;

    public VerifyNoInputChangesTaskExecuter(TaskArtifactStateRepository repository, TaskExecuter delegate) {
        this.delegate = delegate;
        this.repository = repository;
    }

    public void execute(TaskInternal task, TaskStateInternal state, TaskExecutionContext context) {
        TaskOutputCachingBuildCacheKey beforeExecution = context.getBuildCacheKey();
        this.delegate.execute(task, state, context);
        if (beforeExecution.isValid()) {
            TaskOutputCachingBuildCacheKey afterExecution = this.repository.getStateFor(task).calculateCacheKey();
            if (!afterExecution.isValid()) {
                throw new TaskExecutionException(task, new GradleException("The build cache key became invalid after the task has been executed!"));
            }
            if (!beforeExecution.getHashCode().equals(afterExecution.getHashCode())) {
                throw new TaskExecutionException(task, new GradleException("The inputs for the task changed during the execution! Check if you have a `doFirst` changing the inputs."));
            }
        }
    }
}

