/*
 * Decompiled with CFR 0.152.
 */
package android.bluetooth;

import android.os.Parcel;
import android.os.Parcelable;

public class BluetoothAudioConfig
implements Parcelable {
    private final int mSampleRate;
    private final int mChannelConfig;
    private final int mAudioFormat;
    public static final Parcelable.Creator<BluetoothAudioConfig> CREATOR = new Parcelable.Creator<BluetoothAudioConfig>(){

        @Override
        public BluetoothAudioConfig createFromParcel(Parcel in) {
            int sampleRate = in.readInt();
            int channelConfig = in.readInt();
            int audioFormat = in.readInt();
            return new BluetoothAudioConfig(sampleRate, channelConfig, audioFormat);
        }

        public BluetoothAudioConfig[] newArray(int size) {
            return new BluetoothAudioConfig[size];
        }
    };

    public BluetoothAudioConfig(int sampleRate, int channelConfig, int audioFormat) {
        this.mSampleRate = sampleRate;
        this.mChannelConfig = channelConfig;
        this.mAudioFormat = audioFormat;
    }

    public boolean equals(Object o) {
        if (o instanceof BluetoothAudioConfig) {
            BluetoothAudioConfig bac = (BluetoothAudioConfig)o;
            return bac.mSampleRate == this.mSampleRate && bac.mChannelConfig == this.mChannelConfig && bac.mAudioFormat == this.mAudioFormat;
        }
        return false;
    }

    public int hashCode() {
        return this.mSampleRate | this.mChannelConfig << 24 | this.mAudioFormat << 28;
    }

    public String toString() {
        return "{mSampleRate:" + this.mSampleRate + ",mChannelConfig:" + this.mChannelConfig + ",mAudioFormat:" + this.mAudioFormat + "}";
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel out, int flags) {
        out.writeInt(this.mSampleRate);
        out.writeInt(this.mChannelConfig);
        out.writeInt(this.mAudioFormat);
    }

    public int getSampleRate() {
        return this.mSampleRate;
    }

    public int getChannelConfig() {
        return this.mChannelConfig;
    }

    public int getAudioFormat() {
        return this.mAudioFormat;
    }
}

