/*
 * Decompiled with CFR 0.152.
 */
package android.bluetooth.le;

import android.os.Parcel;
import android.os.Parcelable;

public class PeriodicAdvertisingParameters
implements Parcelable {
    private static final int INTERVAL_MIN = 80;
    private static final int INTERVAL_MAX = 65519;
    private final boolean mIncludeTxPower;
    private final int mInterval;
    public static final Parcelable.Creator<PeriodicAdvertisingParameters> CREATOR = new Parcelable.Creator<PeriodicAdvertisingParameters>(){

        public PeriodicAdvertisingParameters[] newArray(int size) {
            return new PeriodicAdvertisingParameters[size];
        }

        @Override
        public PeriodicAdvertisingParameters createFromParcel(Parcel in) {
            return new PeriodicAdvertisingParameters(in);
        }
    };

    private PeriodicAdvertisingParameters(boolean includeTxPower, int interval) {
        this.mIncludeTxPower = includeTxPower;
        this.mInterval = interval;
    }

    private PeriodicAdvertisingParameters(Parcel in) {
        this.mIncludeTxPower = in.readInt() != 0;
        this.mInterval = in.readInt();
    }

    public boolean getIncludeTxPower() {
        return this.mIncludeTxPower;
    }

    public int getInterval() {
        return this.mInterval;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.mIncludeTxPower ? 1 : 0);
        dest.writeInt(this.mInterval);
    }

    public static class Builder {
        private boolean mIncludeTxPower = false;
        private int mInterval = 65519;

        public Builder setIncludeTxPower(boolean includeTxPower) {
            this.mIncludeTxPower = includeTxPower;
            return this;
        }

        public Builder setInterval(int interval) {
            if (interval < 80 || interval > 65519) {
                throw new IllegalArgumentException("Invalid interval (must be 80-65519)");
            }
            this.mInterval = interval;
            return this;
        }

        public PeriodicAdvertisingParameters build() {
            return new PeriodicAdvertisingParameters(this.mIncludeTxPower, this.mInterval);
        }
    }
}

