/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import java.awt.Composite;
import java.awt.CompositeContext;
import java.awt.RenderingHints;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;

public final class BlendComposite
implements Composite {
    private float alpha;
    private BlendingMode mode;

    private BlendComposite(BlendingMode mode) {
        this(mode, 1.0f);
    }

    private BlendComposite(BlendingMode mode, float alpha) {
        this.mode = mode;
        this.setAlpha(alpha);
    }

    public static BlendComposite getInstance(BlendingMode mode) {
        return mode.getBlendComposite();
    }

    public static BlendComposite getInstance(BlendingMode mode, float alpha) {
        if (alpha > 0.9999f) {
            return BlendComposite.getInstance(mode);
        }
        return new BlendComposite(mode, alpha);
    }

    public float getAlpha() {
        return this.alpha;
    }

    public BlendingMode getMode() {
        return this.mode;
    }

    private void setAlpha(float alpha) {
        if (alpha < 0.0f || alpha > 1.0f) {
            assert (false) : "alpha must be comprised between 0.0f and 1.0f";
            alpha = Math.min(alpha, 1.0f);
            alpha = Math.max(alpha, 0.0f);
        }
        this.alpha = alpha;
    }

    public int hashCode() {
        return Float.floatToIntBits(this.alpha) * 31 + this.mode.ordinal();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof BlendComposite)) {
            return false;
        }
        BlendComposite bc = (BlendComposite)obj;
        return this.mode == bc.mode && this.alpha == bc.alpha;
    }

    @Override
    public CompositeContext createContext(ColorModel srcColorModel, ColorModel dstColorModel, RenderingHints hints) {
        return new BlendingContext(this);
    }

    private static abstract class Blender {
        private Blender() {
        }

        public abstract int[] blend(int[] var1, int[] var2, int[] var3);

        public static Blender getBlenderFor(BlendComposite composite) {
            switch (composite.getMode()) {
                case ADD: {
                    return new Blender(){

                        @Override
                        public int[] blend(int[] src, int[] dst, int[] result) {
                            for (int i = 0; i < 4; ++i) {
                                result[i] = Math.min(255, src[i] + dst[i]);
                            }
                            return result;
                        }
                    };
                }
                case DARKEN: {
                    return new Blender(){

                        @Override
                        public int[] blend(int[] src, int[] dst, int[] result) {
                            for (int i = 0; i < 3; ++i) {
                                result[i] = Math.min(src[i], dst[i]);
                            }
                            result[3] = Math.min(255, src[3] + dst[3]);
                            return result;
                        }
                    };
                }
                case LIGHTEN: {
                    return new Blender(){

                        @Override
                        public int[] blend(int[] src, int[] dst, int[] result) {
                            for (int i = 0; i < 3; ++i) {
                                result[i] = Math.max(src[i], dst[i]);
                            }
                            result[3] = Math.min(255, src[3] + dst[3]);
                            return result;
                        }
                    };
                }
                case MULTIPLY: {
                    return new Blender(){

                        @Override
                        public int[] blend(int[] src, int[] dst, int[] result) {
                            for (int i = 0; i < 3; ++i) {
                                result[i] = src[i] * dst[i] >> 8;
                            }
                            result[3] = Math.min(255, src[3] + dst[3] - src[3] * dst[3] / 255);
                            return result;
                        }
                    };
                }
                case OVERLAY: {
                    return new Blender(){

                        @Override
                        public int[] blend(int[] src, int[] dst, int[] result) {
                            for (int i = 0; i < 3; ++i) {
                                result[i] = dst[i] < 128 ? dst[i] * src[i] >> 7 : 255 - ((255 - dst[i]) * (255 - src[i]) >> 7);
                            }
                            result[3] = Math.min(255, src[3] + dst[3]);
                            return result;
                        }
                    };
                }
                case SCREEN: {
                    return new Blender(){

                        @Override
                        public int[] blend(int[] src, int[] dst, int[] result) {
                            result[0] = 255 - ((255 - src[0]) * (255 - dst[0]) >> 8);
                            result[1] = 255 - ((255 - src[1]) * (255 - dst[1]) >> 8);
                            result[2] = 255 - ((255 - src[2]) * (255 - dst[2]) >> 8);
                            result[3] = Math.min(255, src[3] + dst[3]);
                            return result;
                        }
                    };
                }
            }
            assert (false) : "Blender not implement for " + composite.getMode().name();
            return new Blender(){

                @Override
                public int[] blend(int[] src, int[] dst, int[] result) {
                    result[0] = dst[0];
                    result[1] = dst[1];
                    result[2] = dst[2];
                    result[3] = dst[3];
                    return result;
                }
            };
        }
    }

    private static final class BlendingContext
    implements CompositeContext {
        private final Blender blender;
        private final BlendComposite composite;

        private BlendingContext(BlendComposite composite) {
            this.composite = composite;
            this.blender = Blender.getBlenderFor(composite);
        }

        @Override
        public void dispose() {
        }

        @Override
        public void compose(Raster src, Raster dstIn, WritableRaster dstOut) {
            if (src.getSampleModel().getDataType() != 3 || dstIn.getSampleModel().getDataType() != 3 || dstOut.getSampleModel().getDataType() != 3) {
                throw new IllegalStateException("Source and destination must store pixels as INT.");
            }
            int width = Math.min(src.getWidth(), dstIn.getWidth());
            int height = Math.min(src.getHeight(), dstIn.getHeight());
            float alpha = this.composite.getAlpha();
            int[] srcPixel = new int[4];
            int[] dstPixel = new int[4];
            int[] result = new int[4];
            int[] srcPixels = new int[width];
            int[] dstPixels = new int[width];
            for (int y = 0; y < height; ++y) {
                dstIn.getDataElements(0, y, width, 1, dstPixels);
                if (alpha != 0.0f) {
                    src.getDataElements(0, y, width, 1, srcPixels);
                    for (int x = 0; x < width; ++x) {
                        int pixel = srcPixels[x];
                        srcPixel[0] = pixel >> 16 & 0xFF;
                        srcPixel[1] = pixel >> 8 & 0xFF;
                        srcPixel[2] = pixel & 0xFF;
                        srcPixel[3] = pixel >> 24 & 0xFF;
                        pixel = dstPixels[x];
                        dstPixel[0] = pixel >> 16 & 0xFF;
                        dstPixel[1] = pixel >> 8 & 0xFF;
                        dstPixel[2] = pixel & 0xFF;
                        dstPixel[3] = pixel >> 24 & 0xFF;
                        srcPixel[3] = srcPixel[3] * (dstPixel[3] / 255);
                        result = this.blender.blend(srcPixel, dstPixel, result);
                        dstPixels[x] = alpha == 1.0f ? (result[3] & 0xFF) << 24 | (result[0] & 0xFF) << 16 | (result[1] & 0xFF) << 8 | result[2] & 0xFF : ((int)((float)dstPixel[3] + (float)(result[3] - dstPixel[3]) * alpha) & 0xFF) << 24 | ((int)((float)dstPixel[0] + (float)(result[0] - dstPixel[0]) * alpha) & 0xFF) << 16 | ((int)((float)dstPixel[1] + (float)(result[1] - dstPixel[1]) * alpha) & 0xFF) << 8 | (int)((float)dstPixel[2] + (float)(result[2] - dstPixel[2]) * alpha) & 0xFF;
                    }
                }
                dstOut.setDataElements(0, y, width, 1, dstPixels);
            }
        }
    }

    public static enum BlendingMode {
        MULTIPLY,
        SCREEN,
        DARKEN,
        LIGHTEN,
        OVERLAY,
        ADD;

        private final BlendComposite mComposite = new BlendComposite(this);

        BlendComposite getBlendComposite() {
            return this.mComposite;
        }
    }
}

