/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import android.graphics.Shader;
import android.graphics.SweepGradient_Delegate;
import com.android.tools.layoutlib.annotations.LayoutlibDelegate;

public class SweepGradient
extends Shader {
    private static final int TYPE_COLORS_AND_POSITIONS = 1;
    private static final int TYPE_COLOR_START_AND_COLOR_END = 2;
    private int mType;
    private float mCx;
    private float mCy;
    private int[] mColors;
    private float[] mPositions;
    private int mColor0;
    private int mColor1;

    public SweepGradient(float cx, float cy, int[] colors, float[] positions) {
        if (colors.length < 2) {
            throw new IllegalArgumentException("needs >= 2 number of colors");
        }
        if (positions != null && colors.length != positions.length) {
            throw new IllegalArgumentException("color and position arrays must be of equal length");
        }
        this.mType = 1;
        this.mCx = cx;
        this.mCy = cy;
        this.mColors = (int[])colors.clone();
        this.mPositions = positions != null ? (float[])positions.clone() : null;
    }

    public SweepGradient(float cx, float cy, int color0, int color1) {
        this.mType = 2;
        this.mCx = cx;
        this.mCy = cy;
        this.mColor0 = color0;
        this.mColor1 = color1;
        this.mColors = null;
        this.mPositions = null;
    }

    @Override
    long createNativeInstance(long nativeMatrix) {
        if (this.mType == 1) {
            return SweepGradient.nativeCreate1(nativeMatrix, this.mCx, this.mCy, this.mColors, this.mPositions);
        }
        return SweepGradient.nativeCreate2(nativeMatrix, this.mCx, this.mCy, this.mColor0, this.mColor1);
    }

    @Override
    protected Shader copy() {
        SweepGradient copy = this.mType == 1 ? new SweepGradient(this.mCx, this.mCy, (int[])this.mColors.clone(), this.mPositions != null ? (float[])this.mPositions.clone() : null) : new SweepGradient(this.mCx, this.mCy, this.mColor0, this.mColor1);
        this.copyLocalMatrix(copy);
        return copy;
    }

    @LayoutlibDelegate
    private static long nativeCreate1(long l, float f, float f2, int[] nArray, float[] fArray) {
        return SweepGradient_Delegate.nativeCreate1(l, f, f2, nArray, fArray);
    }

    @LayoutlibDelegate
    private static long nativeCreate2(long l, float f, float f2, int n, int n2) {
        return SweepGradient_Delegate.nativeCreate2(l, f, f2, n, n2);
    }
}

