/*
 * Decompiled with CFR 0.152.
 */
package android.media.midi;

import android.media.midi.IMidiDeviceServer;
import android.media.midi.IMidiManager;
import android.media.midi.MidiDeviceInfo;
import android.media.midi.MidiInputPort;
import android.media.midi.MidiOutputPort;
import android.os.Binder;
import android.os.IBinder;
import android.os.Process;
import android.os.RemoteException;
import android.util.Log;
import com.android.tools.layoutlib.create.OverrideMethod;
import dalvik.system.CloseGuard;
import java.io.Closeable;
import java.io.FileDescriptor;
import java.io.IOException;
import java.util.HashSet;
import libcore.io.IoUtils;

public class MidiDevice
implements Closeable {
    private static final String TAG = "MidiDevice";
    private final MidiDeviceInfo mDeviceInfo;
    private final IMidiDeviceServer mDeviceServer;
    private final IMidiManager mMidiManager;
    private final IBinder mClientToken;
    private final IBinder mDeviceToken;
    private boolean mIsDeviceClosed;
    private static HashSet<MidiDevice> mMirroredDevices;
    private long mNativeHandle;
    private final CloseGuard mGuard = CloseGuard.get();

    MidiDevice(MidiDeviceInfo deviceInfo, IMidiDeviceServer server, IMidiManager midiManager, IBinder clientToken, IBinder deviceToken) {
        this.mDeviceInfo = deviceInfo;
        this.mDeviceServer = server;
        this.mMidiManager = midiManager;
        this.mClientToken = clientToken;
        this.mDeviceToken = deviceToken;
        this.mGuard.open("close");
    }

    public MidiDeviceInfo getInfo() {
        return this.mDeviceInfo;
    }

    public MidiInputPort openInputPort(int portNumber) {
        if (this.mIsDeviceClosed) {
            return null;
        }
        try {
            Binder token = new Binder();
            FileDescriptor fd = this.mDeviceServer.openInputPort(token, portNumber);
            if (fd == null) {
                return null;
            }
            return new MidiInputPort(this.mDeviceServer, token, fd, portNumber);
        }
        catch (RemoteException e) {
            Log.e(TAG, "RemoteException in openInputPort");
            return null;
        }
    }

    public MidiOutputPort openOutputPort(int portNumber) {
        if (this.mIsDeviceClosed) {
            return null;
        }
        try {
            Binder token = new Binder();
            FileDescriptor fd = this.mDeviceServer.openOutputPort(token, portNumber);
            if (fd == null) {
                return null;
            }
            return new MidiOutputPort(this.mDeviceServer, token, fd, portNumber);
        }
        catch (RemoteException e) {
            Log.e(TAG, "RemoteException in openOutputPort");
            return null;
        }
    }

    public MidiConnection connectPorts(MidiInputPort inputPort, int outputPortNumber) {
        if (outputPortNumber < 0 || outputPortNumber >= this.mDeviceInfo.getOutputPortCount()) {
            throw new IllegalArgumentException("outputPortNumber out of range");
        }
        if (this.mIsDeviceClosed) {
            return null;
        }
        FileDescriptor fd = inputPort.claimFileDescriptor();
        if (fd == null) {
            return null;
        }
        try {
            Binder token = new Binder();
            int calleePid = this.mDeviceServer.connectPorts(token, fd, outputPortNumber);
            if (calleePid != Process.myPid()) {
                IoUtils.closeQuietly(fd);
            }
            return new MidiConnection(token, inputPort);
        }
        catch (RemoteException e) {
            Log.e(TAG, "RemoteException in connectPorts");
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long mirrorToNative() throws IOException {
        if (this.mIsDeviceClosed || this.mNativeHandle != 0L) {
            return 0L;
        }
        this.mNativeHandle = this.native_mirrorToNative(this.mDeviceServer.asBinder(), this.mDeviceInfo.getId());
        if (this.mNativeHandle == 0L) {
            throw new IOException("Failed mirroring to native");
        }
        HashSet<MidiDevice> hashSet = mMirroredDevices;
        synchronized (hashSet) {
            mMirroredDevices.add(this);
        }
        return this.mNativeHandle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFromNative() {
        if (this.mNativeHandle == 0L) {
            return;
        }
        Object object = this.mGuard;
        synchronized (object) {
            this.native_removeFromNative(this.mNativeHandle);
            this.mNativeHandle = 0L;
        }
        object = mMirroredDevices;
        synchronized (object) {
            mMirroredDevices.remove(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        CloseGuard closeGuard = this.mGuard;
        synchronized (closeGuard) {
            if (!this.mIsDeviceClosed) {
                this.removeFromNative();
                this.mGuard.close();
                this.mIsDeviceClosed = true;
                try {
                    this.mMidiManager.closeDevice(this.mClientToken, this.mDeviceToken);
                }
                catch (RemoteException e) {
                    Log.e(TAG, "RemoteException in closeDevice");
                }
            }
        }
    }

    protected void finalize() throws Throwable {
        try {
            if (this.mGuard != null) {
                this.mGuard.warnIfOpen();
            }
            this.close();
        }
        finally {
            super.finalize();
        }
    }

    public String toString() {
        return "MidiDevice: " + this.mDeviceInfo.toString();
    }

    private long native_mirrorToNative(IBinder iBinder, int n) {
        return OverrideMethod.invokeL("android.media.midi.MidiDevice#native_mirrorToNative(Landroid/os/IBinder;I)J", true, this);
    }

    private void native_removeFromNative(long l) {
        OverrideMethod.invokeV("android.media.midi.MidiDevice#native_removeFromNative(J)V", true, this);
    }

    static {
        System.loadLibrary("media_jni");
        mMirroredDevices = new HashSet();
    }

    public class MidiConnection
    implements Closeable {
        private final IMidiDeviceServer mInputPortDeviceServer;
        private final IBinder mInputPortToken;
        private final IBinder mOutputPortToken;
        private final CloseGuard mGuard = CloseGuard.get();
        private boolean mIsClosed;

        MidiConnection(IBinder outputPortToken, MidiInputPort inputPort) {
            this.mInputPortDeviceServer = inputPort.getDeviceServer();
            this.mInputPortToken = inputPort.getToken();
            this.mOutputPortToken = outputPortToken;
            this.mGuard.open("close");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws IOException {
            CloseGuard closeGuard = this.mGuard;
            synchronized (closeGuard) {
                if (this.mIsClosed) {
                    return;
                }
                this.mGuard.close();
                try {
                    this.mInputPortDeviceServer.closePort(this.mInputPortToken);
                    MidiDevice.this.mDeviceServer.closePort(this.mOutputPortToken);
                }
                catch (RemoteException e) {
                    Log.e(MidiDevice.TAG, "RemoteException in MidiConnection.close");
                }
                this.mIsClosed = true;
            }
        }

        protected void finalize() throws Throwable {
            try {
                if (this.mGuard != null) {
                    this.mGuard.warnIfOpen();
                }
                this.close();
            }
            finally {
                super.finalize();
            }
        }
    }
}

