/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.os.BinderProxy;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.ParcelFileDescriptor;
import android.os.RemoteException;
import android.os.ResultReceiver;
import android.os.ShellCallback;
import android.os.StrictMode;
import android.os.Trace;
import android.os.TransactionTracker;
import android.os.UserHandle;
import android.util.ExceptionUtils;
import android.util.Log;
import com.android.internal.util.FastPrintWriter;
import com.android.internal.util.FunctionalUtils;
import com.android.tools.layoutlib.create.OverrideMethod;
import java.io.FileDescriptor;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import libcore.io.IoUtils;

public class Binder
implements IBinder {
    private static final boolean FIND_POTENTIAL_LEAKS = false;
    public static final boolean CHECK_PARCEL_SIZE = false;
    static final String TAG = "Binder";
    public static boolean LOG_RUNTIME_EXCEPTION = false;
    private static volatile String sDumpDisabled = null;
    private static volatile TransactionTracker sTransactionTracker = null;
    private static volatile boolean sTracingEnabled = false;
    static volatile boolean sWarnOnBlocking = false;
    private long mObject;
    private IInterface mOwner;
    private String mDescriptor;

    public static void enableTracing() {
        sTracingEnabled = true;
    }

    public static void disableTracing() {
        sTracingEnabled = false;
    }

    public static boolean isTracingEnabled() {
        return sTracingEnabled;
    }

    public static synchronized TransactionTracker getTransactionTracker() {
        if (sTransactionTracker == null) {
            sTransactionTracker = new TransactionTracker();
        }
        return sTransactionTracker;
    }

    public static void setWarnOnBlocking(boolean warnOnBlocking) {
        sWarnOnBlocking = warnOnBlocking;
    }

    public static IBinder allowBlocking(IBinder binder) {
        try {
            if (binder instanceof BinderProxy) {
                ((BinderProxy)binder).mWarnOnBlocking = false;
            } else if (binder != null && binder.queryLocalInterface(binder.getInterfaceDescriptor()) == null) {
                Log.w(TAG, "Unable to allow blocking on interface " + binder);
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return binder;
    }

    public static void copyAllowBlocking(IBinder fromBinder, IBinder toBinder) {
        if (fromBinder instanceof BinderProxy && toBinder instanceof BinderProxy) {
            ((BinderProxy)toBinder).mWarnOnBlocking = ((BinderProxy)fromBinder).mWarnOnBlocking;
        }
    }

    public static int getCallingPid() {
        return OverrideMethod.invokeI("android.os.Binder#getCallingPid()I", true, null);
    }

    public static int getCallingUid() {
        return OverrideMethod.invokeI("android.os.Binder#getCallingUid()I", true, null);
    }

    public static UserHandle getCallingUserHandle() {
        return UserHandle.of(UserHandle.getUserId(Binder.getCallingUid()));
    }

    public static long clearCallingIdentity() {
        return OverrideMethod.invokeL("android.os.Binder#clearCallingIdentity()J", true, null);
    }

    public static void restoreCallingIdentity(long l) {
        OverrideMethod.invokeV("android.os.Binder#restoreCallingIdentity(J)V", true, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void withCleanCallingIdentity(FunctionalUtils.ThrowingRunnable action) {
        long callingIdentity = Binder.clearCallingIdentity();
        Throwable throwableToPropagate = null;
        try {
            action.run();
        }
        catch (Throwable throwable) {
            throwableToPropagate = throwable;
        }
        finally {
            Binder.restoreCallingIdentity(callingIdentity);
            if (throwableToPropagate != null) {
                throw ExceptionUtils.propagate(throwableToPropagate);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T withCleanCallingIdentity(FunctionalUtils.ThrowingSupplier<T> action) {
        long callingIdentity = Binder.clearCallingIdentity();
        Throwable throwableToPropagate = null;
        try {
            T t = action.get();
            return t;
        }
        catch (Throwable throwable) {
            throwableToPropagate = throwable;
            T t = null;
            return t;
        }
        finally {
            Binder.restoreCallingIdentity(callingIdentity);
            if (throwableToPropagate != null) {
                throw ExceptionUtils.propagate(throwableToPropagate);
            }
        }
    }

    public static void setThreadStrictModePolicy(int n) {
        OverrideMethod.invokeV("android.os.Binder#setThreadStrictModePolicy(I)V", true, null);
    }

    public static int getThreadStrictModePolicy() {
        return OverrideMethod.invokeI("android.os.Binder#getThreadStrictModePolicy()I", true, null);
    }

    public static void flushPendingCommands() {
        OverrideMethod.invokeV("android.os.Binder#flushPendingCommands()V", true, null);
    }

    public static void joinThreadPool() {
        OverrideMethod.invokeV("android.os.Binder#joinThreadPool()V", true, null);
    }

    public static boolean isProxy(IInterface iface) {
        return iface.asBinder() != iface;
    }

    public static void blockUntilThreadAvailable() {
        OverrideMethod.invokeV("android.os.Binder#blockUntilThreadAvailable()V", true, null);
    }

    public Binder() {
        this.init();
    }

    public void attachInterface(IInterface owner, String descriptor) {
        this.mOwner = owner;
        this.mDescriptor = descriptor;
    }

    @Override
    public String getInterfaceDescriptor() {
        return this.mDescriptor;
    }

    @Override
    public boolean pingBinder() {
        return true;
    }

    @Override
    public boolean isBinderAlive() {
        return true;
    }

    @Override
    public IInterface queryLocalInterface(String descriptor) {
        if (this.mDescriptor.equals(descriptor)) {
            return this.mOwner;
        }
        return null;
    }

    public static void setDumpDisabled(String msg) {
        sDumpDisabled = msg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
        if (code == 1598968902) {
            reply.writeString(this.getInterfaceDescriptor());
            return true;
        }
        if (code == 1598311760) {
            ParcelFileDescriptor fd = data.readFileDescriptor();
            String[] args = data.readStringArray();
            if (fd != null) {
                try {
                    this.dump(fd.getFileDescriptor(), args);
                }
                finally {
                    IoUtils.closeQuietly(fd);
                }
            }
            if (reply != null) {
                reply.writeNoException();
            } else {
                StrictMode.clearGatheredViolations();
            }
            return true;
        }
        if (code == 1598246212) {
            ParcelFileDescriptor in = data.readFileDescriptor();
            ParcelFileDescriptor out = data.readFileDescriptor();
            ParcelFileDescriptor err = data.readFileDescriptor();
            String[] args = data.readStringArray();
            ShellCallback shellCallback = ShellCallback.CREATOR.createFromParcel(data);
            ResultReceiver resultReceiver = ResultReceiver.CREATOR.createFromParcel(data);
            try {
                if (out != null) {
                    this.shellCommand(in != null ? in.getFileDescriptor() : null, out.getFileDescriptor(), err != null ? err.getFileDescriptor() : out.getFileDescriptor(), args, shellCallback, resultReceiver);
                }
            }
            finally {
                IoUtils.closeQuietly(in);
                IoUtils.closeQuietly(out);
                IoUtils.closeQuietly(err);
                if (reply != null) {
                    reply.writeNoException();
                } else {
                    StrictMode.clearGatheredViolations();
                }
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dump(FileDescriptor fd, String[] args) {
        FileOutputStream fout = new FileOutputStream(fd);
        FastPrintWriter pw = new FastPrintWriter(fout);
        try {
            this.doDump(fd, pw, args);
        }
        finally {
            ((PrintWriter)pw).flush();
        }
    }

    void doDump(FileDescriptor fd, PrintWriter pw, String[] args) {
        String disabled = sDumpDisabled;
        if (disabled == null) {
            try {
                this.dump(fd, pw, args);
            }
            catch (SecurityException e) {
                pw.println("Security exception: " + e.getMessage());
                throw e;
            }
            catch (Throwable e) {
                pw.println();
                pw.println("Exception occurred while dumping:");
                e.printStackTrace(pw);
            }
        } else {
            pw.println(sDumpDisabled);
        }
    }

    @Override
    public void dumpAsync(final FileDescriptor fd, final String[] args) {
        FileOutputStream fout = new FileOutputStream(fd);
        final FastPrintWriter pw = new FastPrintWriter(fout);
        Thread thr = new Thread("Binder.dumpAsync"){

            @Override
            public void run() {
                try {
                    Binder.this.dump(fd, pw, args);
                }
                finally {
                    pw.flush();
                }
            }
        };
        thr.start();
    }

    protected void dump(FileDescriptor fd, PrintWriter fout, String[] args) {
    }

    @Override
    public void shellCommand(FileDescriptor in, FileDescriptor out, FileDescriptor err, String[] args, ShellCallback callback, ResultReceiver resultReceiver) throws RemoteException {
        this.onShellCommand(in, out, err, args, callback, resultReceiver);
    }

    public void onShellCommand(FileDescriptor in, FileDescriptor out, FileDescriptor err, String[] args, ShellCallback callback, ResultReceiver resultReceiver) throws RemoteException {
        FileOutputStream fout = new FileOutputStream(err != null ? err : out);
        FastPrintWriter pw = new FastPrintWriter(fout);
        pw.println("No shell command implementation.");
        ((PrintWriter)pw).flush();
        resultReceiver.send(0, null);
    }

    @Override
    public boolean transact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
        if (data != null) {
            data.setDataPosition(0);
        }
        boolean r = this.onTransact(code, data, reply, flags);
        if (reply != null) {
            reply.setDataPosition(0);
        }
        return r;
    }

    @Override
    public void linkToDeath(IBinder.DeathRecipient recipient, int flags) {
    }

    @Override
    public boolean unlinkToDeath(IBinder.DeathRecipient recipient, int flags) {
        return true;
    }

    protected void finalize() throws Throwable {
        try {
            this.destroyBinder();
        }
        finally {
            super.finalize();
        }
    }

    static void checkParcel(IBinder obj, int code, Parcel parcel, String msg) {
    }

    private void init() {
        OverrideMethod.invokeV("android.os.Binder#init()V", true, this);
    }

    private void destroyBinder() {
        OverrideMethod.invokeV("android.os.Binder#destroyBinder()V", true, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean execTransact(int code, long dataObj, long replyObj, int flags) {
        boolean res;
        Parcel data = Parcel.obtain(dataObj);
        Parcel reply = Parcel.obtain(replyObj);
        boolean tracingEnabled = Binder.isTracingEnabled();
        try {
            if (tracingEnabled) {
                Trace.traceBegin(1L, this.getClass().getName() + ":" + code);
            }
            res = this.onTransact(code, data, reply, flags);
        }
        catch (RemoteException | RuntimeException e) {
            if (LOG_RUNTIME_EXCEPTION) {
                Log.w(TAG, "Caught a RuntimeException from the binder stub implementation.", e);
            }
            if ((flags & 1) != 0) {
                if (e instanceof RemoteException) {
                    Log.w(TAG, "Binder call failed.", e);
                } else {
                    Log.w(TAG, "Caught a RuntimeException from the binder stub implementation.", e);
                }
            } else {
                reply.setDataPosition(0);
                reply.writeException(e);
            }
            res = true;
        }
        finally {
            if (tracingEnabled) {
                Trace.traceEnd(1L);
            }
        }
        Binder.checkParcel(this, code, reply, "Unreasonably large binder reply buffer");
        reply.recycle();
        data.recycle();
        StrictMode.clearGatheredViolations();
        return res;
    }
}

