/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import android.os.ResultReceiver;
import android.os.ShellCallback;
import android.os.Trace;
import android.util.Log;
import com.android.tools.layoutlib.create.OverrideMethod;
import java.io.FileDescriptor;
import java.lang.ref.WeakReference;

class BinderProxy
implements IBinder {
    volatile boolean mWarnOnBlocking = Binder.sWarnOnBlocking;
    private final WeakReference mSelf = new WeakReference<BinderProxy>(this);
    private long mObject;
    private long mOrgue;

    @Override
    public boolean pingBinder() {
        return OverrideMethod.invokeI("android.os.BinderProxy#pingBinder()Z", true, this) != 0;
    }

    @Override
    public boolean isBinderAlive() {
        return OverrideMethod.invokeI("android.os.BinderProxy#isBinderAlive()Z", true, this) != 0;
    }

    @Override
    public IInterface queryLocalInterface(String descriptor) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean transact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
        boolean tracingEnabled;
        Binder.checkParcel(this, code, data, "Unreasonably large binder buffer");
        if (this.mWarnOnBlocking && (flags & 1) == 0) {
            this.mWarnOnBlocking = false;
            Log.w("Binder", "Outgoing transactions from this process must be FLAG_ONEWAY", new Throwable());
        }
        if (tracingEnabled = Binder.isTracingEnabled()) {
            Throwable tr = new Throwable();
            Binder.getTransactionTracker().addTrace(tr);
            StackTraceElement stackTraceElement = tr.getStackTrace()[1];
            Trace.traceBegin(1L, stackTraceElement.getClassName() + "." + stackTraceElement.getMethodName());
        }
        try {
            boolean bl = this.transactNative(code, data, reply, flags);
            return bl;
        }
        finally {
            if (tracingEnabled) {
                Trace.traceEnd(1L);
            }
        }
    }

    @Override
    public String getInterfaceDescriptor() throws RemoteException {
        return (String)OverrideMethod.invokeA("android.os.BinderProxy#getInterfaceDescriptor()Ljava/lang/String;", true, this);
    }

    public boolean transactNative(int n, Parcel parcel, Parcel parcel2, int n2) throws RemoteException {
        return OverrideMethod.invokeI("android.os.BinderProxy#transactNative(ILandroid/os/Parcel;Landroid/os/Parcel;I)Z", true, this) != 0;
    }

    @Override
    public void linkToDeath(IBinder.DeathRecipient deathRecipient, int n) throws RemoteException {
        OverrideMethod.invokeV("android.os.BinderProxy#linkToDeath(Landroid/os/IBinder$DeathRecipient;I)V", true, this);
    }

    @Override
    public boolean unlinkToDeath(IBinder.DeathRecipient deathRecipient, int n) {
        return OverrideMethod.invokeI("android.os.BinderProxy#unlinkToDeath(Landroid/os/IBinder$DeathRecipient;I)Z", true, this) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dump(FileDescriptor fd, String[] args) throws RemoteException {
        Parcel data = Parcel.obtain();
        Parcel reply = Parcel.obtain();
        data.writeFileDescriptor(fd);
        data.writeStringArray(args);
        try {
            this.transact(1598311760, data, reply, 0);
            reply.readException();
        }
        finally {
            data.recycle();
            reply.recycle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dumpAsync(FileDescriptor fd, String[] args) throws RemoteException {
        Parcel data = Parcel.obtain();
        Parcel reply = Parcel.obtain();
        data.writeFileDescriptor(fd);
        data.writeStringArray(args);
        try {
            this.transact(1598311760, data, reply, 1);
        }
        finally {
            data.recycle();
            reply.recycle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shellCommand(FileDescriptor in, FileDescriptor out, FileDescriptor err, String[] args, ShellCallback callback, ResultReceiver resultReceiver) throws RemoteException {
        Parcel data = Parcel.obtain();
        Parcel reply = Parcel.obtain();
        data.writeFileDescriptor(in);
        data.writeFileDescriptor(out);
        data.writeFileDescriptor(err);
        data.writeStringArray(args);
        ShellCallback.writeToParcel(callback, data);
        resultReceiver.writeToParcel(data, 0);
        try {
            this.transact(1598246212, data, reply, 0);
            reply.readException();
        }
        finally {
            data.recycle();
            reply.recycle();
        }
    }

    BinderProxy() {
    }

    protected void finalize() throws Throwable {
        try {
            this.destroy();
        }
        finally {
            super.finalize();
        }
    }

    private void destroy() {
        OverrideMethod.invokeV("android.os.BinderProxy#destroy()V", true, this);
    }

    private static void sendDeathNotice(IBinder.DeathRecipient recipient) {
        try {
            recipient.binderDied();
        }
        catch (RuntimeException exc) {
            Log.w("BinderNative", "Uncaught exception from death notification", exc);
        }
    }
}

