/*
 * Decompiled with CFR 0.152.
 */
package android.provider;

import android.content.ContentProviderClient;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentSender;
import android.content.pm.ResolveInfo;
import android.content.res.AssetFileDescriptor;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import android.graphics.Point;
import android.media.ExifInterface;
import android.net.Uri;
import android.os.Bundle;
import android.os.CancellationSignal;
import android.os.OperationCanceledException;
import android.os.Parcel;
import android.os.ParcelFileDescriptor;
import android.os.Parcelable;
import android.os.ParcelableException;
import android.os.RemoteException;
import android.system.ErrnoException;
import android.system.Os;
import android.system.OsConstants;
import android.util.Log;
import com.android.internal.util.Preconditions;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import libcore.io.IoUtils;

public class DocumentsContract {
    private static final String TAG = "DocumentsContract";
    public static final String PROVIDER_INTERFACE = "android.content.action.DOCUMENTS_PROVIDER";
    public static final String EXTRA_PACKAGE_NAME = "android.content.extra.PACKAGE_NAME";
    public static final String EXTRA_SHOW_ADVANCED = "android.content.extra.SHOW_ADVANCED";
    public static final String EXTRA_TARGET_URI = "android.content.extra.TARGET_URI";
    public static final String EXTRA_INITIAL_URI = "android.provider.extra.INITIAL_URI";
    public static final String EXTRA_EXCLUDE_SELF = "android.provider.extra.EXCLUDE_SELF";
    public static final String EXTRA_ORIENTATION = "android.provider.extra.ORIENTATION";
    public static final String EXTRA_PROMPT = "android.provider.extra.PROMPT";
    public static final String ACTION_DOCUMENT_SETTINGS = "android.provider.action.DOCUMENT_SETTINGS";
    public static final String ACTION_MANAGE_DOCUMENT = "android.provider.action.MANAGE_DOCUMENT";
    public static final String ACTION_DOCUMENT_ROOT_SETTINGS = "android.provider.action.DOCUMENT_ROOT_SETTINGS";
    private static final int THUMBNAIL_BUFFER_SIZE = 131072;
    public static final String EXTERNAL_STORAGE_PROVIDER_AUTHORITY = "com.android.externalstorage.documents";
    public static final String PACKAGE_DOCUMENTS_UI = "com.android.documentsui";
    public static final String METADATA_TYPES = "android:documentMetadataType";
    public static final String METADATA_EXIF = "android:documentExif";
    public static final String EXTRA_LOADING = "loading";
    public static final String EXTRA_INFO = "info";
    public static final String EXTRA_ERROR = "error";
    public static final String EXTRA_RESULT = "result";
    public static final String METHOD_CREATE_DOCUMENT = "android:createDocument";
    public static final String METHOD_RENAME_DOCUMENT = "android:renameDocument";
    public static final String METHOD_DELETE_DOCUMENT = "android:deleteDocument";
    public static final String METHOD_COPY_DOCUMENT = "android:copyDocument";
    public static final String METHOD_MOVE_DOCUMENT = "android:moveDocument";
    public static final String METHOD_IS_CHILD_DOCUMENT = "android:isChildDocument";
    public static final String METHOD_REMOVE_DOCUMENT = "android:removeDocument";
    public static final String METHOD_EJECT_ROOT = "android:ejectRoot";
    public static final String METHOD_FIND_DOCUMENT_PATH = "android:findDocumentPath";
    public static final String METHOD_CREATE_WEB_LINK_INTENT = "android:createWebLinkIntent";
    public static final String METHOD_GET_DOCUMENT_METADATA = "android:getDocumentMetadata";
    public static final String EXTRA_PARENT_URI = "parentUri";
    public static final String EXTRA_URI = "uri";
    public static final String EXTRA_OPTIONS = "options";
    private static final String PATH_ROOT = "root";
    private static final String PATH_RECENT = "recent";
    private static final String PATH_DOCUMENT = "document";
    private static final String PATH_CHILDREN = "children";
    private static final String PATH_SEARCH = "search";
    private static final String PATH_TREE = "tree";
    private static final String PARAM_QUERY = "query";
    private static final String PARAM_MANAGE = "manage";

    private DocumentsContract() {
    }

    public static Uri buildRootsUri(String authority) {
        return new Uri.Builder().scheme("content").authority(authority).appendPath(PATH_ROOT).build();
    }

    public static Uri buildRootUri(String authority, String rootId) {
        return new Uri.Builder().scheme("content").authority(authority).appendPath(PATH_ROOT).appendPath(rootId).build();
    }

    public static Uri buildHomeUri() {
        return DocumentsContract.buildRootUri(EXTERNAL_STORAGE_PROVIDER_AUTHORITY, "home");
    }

    public static Uri buildRecentDocumentsUri(String authority, String rootId) {
        return new Uri.Builder().scheme("content").authority(authority).appendPath(PATH_ROOT).appendPath(rootId).appendPath(PATH_RECENT).build();
    }

    public static Uri buildTreeDocumentUri(String authority, String documentId) {
        return new Uri.Builder().scheme("content").authority(authority).appendPath(PATH_TREE).appendPath(documentId).build();
    }

    public static Uri buildDocumentUri(String authority, String documentId) {
        return new Uri.Builder().scheme("content").authority(authority).appendPath(PATH_DOCUMENT).appendPath(documentId).build();
    }

    public static Uri buildDocumentUriUsingTree(Uri treeUri, String documentId) {
        return new Uri.Builder().scheme("content").authority(treeUri.getAuthority()).appendPath(PATH_TREE).appendPath(DocumentsContract.getTreeDocumentId(treeUri)).appendPath(PATH_DOCUMENT).appendPath(documentId).build();
    }

    public static Uri buildDocumentUriMaybeUsingTree(Uri baseUri, String documentId) {
        if (DocumentsContract.isTreeUri(baseUri)) {
            return DocumentsContract.buildDocumentUriUsingTree(baseUri, documentId);
        }
        return DocumentsContract.buildDocumentUri(baseUri.getAuthority(), documentId);
    }

    public static Uri buildChildDocumentsUri(String authority, String parentDocumentId) {
        return new Uri.Builder().scheme("content").authority(authority).appendPath(PATH_DOCUMENT).appendPath(parentDocumentId).appendPath(PATH_CHILDREN).build();
    }

    public static Uri buildChildDocumentsUriUsingTree(Uri treeUri, String parentDocumentId) {
        return new Uri.Builder().scheme("content").authority(treeUri.getAuthority()).appendPath(PATH_TREE).appendPath(DocumentsContract.getTreeDocumentId(treeUri)).appendPath(PATH_DOCUMENT).appendPath(parentDocumentId).appendPath(PATH_CHILDREN).build();
    }

    public static Uri buildSearchDocumentsUri(String authority, String rootId, String query) {
        return new Uri.Builder().scheme("content").authority(authority).appendPath(PATH_ROOT).appendPath(rootId).appendPath(PATH_SEARCH).appendQueryParameter(PARAM_QUERY, query).build();
    }

    public static boolean isDocumentUri(Context context, Uri uri) {
        if (DocumentsContract.isContentUri(uri) && DocumentsContract.isDocumentsProvider(context, uri.getAuthority())) {
            List<String> paths = uri.getPathSegments();
            if (paths.size() == 2) {
                return PATH_DOCUMENT.equals(paths.get(0));
            }
            if (paths.size() == 4) {
                return PATH_TREE.equals(paths.get(0)) && PATH_DOCUMENT.equals(paths.get(2));
            }
        }
        return false;
    }

    public static boolean isRootUri(Context context, Uri uri) {
        if (DocumentsContract.isContentUri(uri) && DocumentsContract.isDocumentsProvider(context, uri.getAuthority())) {
            List<String> paths = uri.getPathSegments();
            return paths.size() == 2 && PATH_ROOT.equals(paths.get(0));
        }
        return false;
    }

    public static boolean isContentUri(Uri uri) {
        return uri != null && "content".equals(uri.getScheme());
    }

    public static boolean isTreeUri(Uri uri) {
        List<String> paths = uri.getPathSegments();
        return paths.size() >= 2 && PATH_TREE.equals(paths.get(0));
    }

    private static boolean isDocumentsProvider(Context context, String authority) {
        Intent intent = new Intent(PROVIDER_INTERFACE);
        List<ResolveInfo> infos = context.getPackageManager().queryIntentContentProviders(intent, 0);
        for (ResolveInfo info : infos) {
            if (!authority.equals(info.providerInfo.authority)) continue;
            return true;
        }
        return false;
    }

    public static String getRootId(Uri rootUri) {
        List<String> paths = rootUri.getPathSegments();
        if (paths.size() >= 2 && PATH_ROOT.equals(paths.get(0))) {
            return paths.get(1);
        }
        throw new IllegalArgumentException("Invalid URI: " + rootUri);
    }

    public static String getDocumentId(Uri documentUri) {
        List<String> paths = documentUri.getPathSegments();
        if (paths.size() >= 2 && PATH_DOCUMENT.equals(paths.get(0))) {
            return paths.get(1);
        }
        if (paths.size() >= 4 && PATH_TREE.equals(paths.get(0)) && PATH_DOCUMENT.equals(paths.get(2))) {
            return paths.get(3);
        }
        throw new IllegalArgumentException("Invalid URI: " + documentUri);
    }

    public static String getTreeDocumentId(Uri documentUri) {
        List<String> paths = documentUri.getPathSegments();
        if (paths.size() >= 2 && PATH_TREE.equals(paths.get(0))) {
            return paths.get(1);
        }
        throw new IllegalArgumentException("Invalid URI: " + documentUri);
    }

    public static String getSearchDocumentsQuery(Uri searchDocumentsUri) {
        return searchDocumentsUri.getQueryParameter(PARAM_QUERY);
    }

    public static Uri setManageMode(Uri uri) {
        return uri.buildUpon().appendQueryParameter(PARAM_MANAGE, "true").build();
    }

    public static boolean isManageMode(Uri uri) {
        return uri.getBooleanQueryParameter(PARAM_MANAGE, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Bitmap getDocumentThumbnail(ContentResolver resolver, Uri documentUri, Point size, CancellationSignal signal) throws FileNotFoundException {
        ContentProviderClient client = resolver.acquireUnstableContentProviderClient(documentUri.getAuthority());
        try {
            Bitmap bitmap = DocumentsContract.getDocumentThumbnail(client, documentUri, size, signal);
            return bitmap;
        }
        catch (Exception e) {
            if (!(e instanceof OperationCanceledException)) {
                Log.w(TAG, "Failed to load thumbnail for " + documentUri + ": " + e);
            }
            DocumentsContract.rethrowIfNecessary(resolver, e);
            Bitmap bitmap = null;
            return bitmap;
        }
        finally {
            ContentProviderClient.releaseQuietly(client);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Bitmap getDocumentThumbnail(ContentProviderClient client, Uri documentUri, Point size, CancellationSignal signal) throws RemoteException, IOException {
        Bundle openOpts = new Bundle();
        openOpts.putParcelable("android.content.extra.SIZE", size);
        AssetFileDescriptor afd = null;
        Bitmap bitmap = null;
        try {
            int orientation;
            afd = client.openTypedAssetFileDescriptor(documentUri, "image/*", openOpts, signal);
            FileDescriptor fd = afd.getFileDescriptor();
            long offset = afd.getStartOffset();
            BufferedInputStream is = null;
            try {
                Os.lseek(fd, offset, OsConstants.SEEK_SET);
            }
            catch (ErrnoException e) {
                is = new BufferedInputStream(new FileInputStream(fd), 131072);
                is.mark(131072);
            }
            BitmapFactory.Options opts = new BitmapFactory.Options();
            opts.inJustDecodeBounds = true;
            if (is != null) {
                BitmapFactory.decodeStream(is, null, opts);
            } else {
                BitmapFactory.decodeFileDescriptor(fd, null, opts);
            }
            int widthSample = opts.outWidth / size.x;
            int heightSample = opts.outHeight / size.y;
            opts.inJustDecodeBounds = false;
            opts.inSampleSize = Math.min(widthSample, heightSample);
            if (is != null) {
                is.reset();
                bitmap = BitmapFactory.decodeStream(is, null, opts);
            } else {
                try {
                    Os.lseek(fd, offset, OsConstants.SEEK_SET);
                }
                catch (ErrnoException e) {
                    e.rethrowAsIOException();
                }
                bitmap = BitmapFactory.decodeFileDescriptor(fd, null, opts);
            }
            Bundle extras = afd.getExtras();
            int n = orientation = extras != null ? extras.getInt(EXTRA_ORIENTATION, 0) : 0;
            if (orientation != 0) {
                int width = bitmap.getWidth();
                int height = bitmap.getHeight();
                Matrix m = new Matrix();
                m.setRotate(orientation, width / 2, height / 2);
                bitmap = Bitmap.createBitmap(bitmap, 0, 0, width, height, m, false);
            }
        }
        catch (Throwable throwable) {
            IoUtils.closeQuietly(afd);
            throw throwable;
        }
        IoUtils.closeQuietly(afd);
        return bitmap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Uri createDocument(ContentResolver resolver, Uri parentDocumentUri, String mimeType, String displayName) throws FileNotFoundException {
        ContentProviderClient client = resolver.acquireUnstableContentProviderClient(parentDocumentUri.getAuthority());
        try {
            Uri uri = DocumentsContract.createDocument(client, parentDocumentUri, mimeType, displayName);
            return uri;
        }
        catch (Exception e) {
            Log.w(TAG, "Failed to create document", e);
            DocumentsContract.rethrowIfNecessary(resolver, e);
            Uri uri = null;
            return uri;
        }
        finally {
            ContentProviderClient.releaseQuietly(client);
        }
    }

    public static Uri createDocument(ContentProviderClient client, Uri parentDocumentUri, String mimeType, String displayName) throws RemoteException {
        Bundle in = new Bundle();
        in.putParcelable(EXTRA_URI, parentDocumentUri);
        in.putString("mime_type", mimeType);
        in.putString("_display_name", displayName);
        Bundle out = client.call(METHOD_CREATE_DOCUMENT, null, in);
        return (Uri)out.getParcelable(EXTRA_URI);
    }

    public static boolean isChildDocument(ContentProviderClient client, Uri parentDocumentUri, Uri childDocumentUri) throws RemoteException {
        Bundle in = new Bundle();
        in.putParcelable(EXTRA_URI, parentDocumentUri);
        in.putParcelable(EXTRA_TARGET_URI, childDocumentUri);
        Bundle out = client.call(METHOD_IS_CHILD_DOCUMENT, null, in);
        if (out == null) {
            throw new RemoteException("Failed to get a reponse from isChildDocument query.");
        }
        if (!out.containsKey(EXTRA_RESULT)) {
            throw new RemoteException("Response did not include result field..");
        }
        return out.getBoolean(EXTRA_RESULT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Uri renameDocument(ContentResolver resolver, Uri documentUri, String displayName) throws FileNotFoundException {
        ContentProviderClient client = resolver.acquireUnstableContentProviderClient(documentUri.getAuthority());
        try {
            Uri uri = DocumentsContract.renameDocument(client, documentUri, displayName);
            return uri;
        }
        catch (Exception e) {
            Log.w(TAG, "Failed to rename document", e);
            DocumentsContract.rethrowIfNecessary(resolver, e);
            Uri uri = null;
            return uri;
        }
        finally {
            ContentProviderClient.releaseQuietly(client);
        }
    }

    public static Uri renameDocument(ContentProviderClient client, Uri documentUri, String displayName) throws RemoteException {
        Bundle in = new Bundle();
        in.putParcelable(EXTRA_URI, documentUri);
        in.putString("_display_name", displayName);
        Bundle out = client.call(METHOD_RENAME_DOCUMENT, null, in);
        Uri outUri = (Uri)out.getParcelable(EXTRA_URI);
        return outUri != null ? outUri : documentUri;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean deleteDocument(ContentResolver resolver, Uri documentUri) throws FileNotFoundException {
        ContentProviderClient client = resolver.acquireUnstableContentProviderClient(documentUri.getAuthority());
        try {
            DocumentsContract.deleteDocument(client, documentUri);
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            Log.w(TAG, "Failed to delete document", e);
            DocumentsContract.rethrowIfNecessary(resolver, e);
            boolean bl = false;
            return bl;
        }
        finally {
            ContentProviderClient.releaseQuietly(client);
        }
    }

    public static void deleteDocument(ContentProviderClient client, Uri documentUri) throws RemoteException {
        Bundle in = new Bundle();
        in.putParcelable(EXTRA_URI, documentUri);
        client.call(METHOD_DELETE_DOCUMENT, null, in);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Uri copyDocument(ContentResolver resolver, Uri sourceDocumentUri, Uri targetParentDocumentUri) throws FileNotFoundException {
        ContentProviderClient client = resolver.acquireUnstableContentProviderClient(sourceDocumentUri.getAuthority());
        try {
            Uri uri = DocumentsContract.copyDocument(client, sourceDocumentUri, targetParentDocumentUri);
            return uri;
        }
        catch (Exception e) {
            Log.w(TAG, "Failed to copy document", e);
            DocumentsContract.rethrowIfNecessary(resolver, e);
            Uri uri = null;
            return uri;
        }
        finally {
            ContentProviderClient.releaseQuietly(client);
        }
    }

    public static Uri copyDocument(ContentProviderClient client, Uri sourceDocumentUri, Uri targetParentDocumentUri) throws RemoteException {
        Bundle in = new Bundle();
        in.putParcelable(EXTRA_URI, sourceDocumentUri);
        in.putParcelable(EXTRA_TARGET_URI, targetParentDocumentUri);
        Bundle out = client.call(METHOD_COPY_DOCUMENT, null, in);
        return (Uri)out.getParcelable(EXTRA_URI);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Uri moveDocument(ContentResolver resolver, Uri sourceDocumentUri, Uri sourceParentDocumentUri, Uri targetParentDocumentUri) throws FileNotFoundException {
        ContentProviderClient client = resolver.acquireUnstableContentProviderClient(sourceDocumentUri.getAuthority());
        try {
            Uri uri = DocumentsContract.moveDocument(client, sourceDocumentUri, sourceParentDocumentUri, targetParentDocumentUri);
            return uri;
        }
        catch (Exception e) {
            Log.w(TAG, "Failed to move document", e);
            DocumentsContract.rethrowIfNecessary(resolver, e);
            Uri uri = null;
            return uri;
        }
        finally {
            ContentProviderClient.releaseQuietly(client);
        }
    }

    public static Uri moveDocument(ContentProviderClient client, Uri sourceDocumentUri, Uri sourceParentDocumentUri, Uri targetParentDocumentUri) throws RemoteException {
        Bundle in = new Bundle();
        in.putParcelable(EXTRA_URI, sourceDocumentUri);
        in.putParcelable(EXTRA_PARENT_URI, sourceParentDocumentUri);
        in.putParcelable(EXTRA_TARGET_URI, targetParentDocumentUri);
        Bundle out = client.call(METHOD_MOVE_DOCUMENT, null, in);
        return (Uri)out.getParcelable(EXTRA_URI);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean removeDocument(ContentResolver resolver, Uri documentUri, Uri parentDocumentUri) throws FileNotFoundException {
        ContentProviderClient client = resolver.acquireUnstableContentProviderClient(documentUri.getAuthority());
        try {
            DocumentsContract.removeDocument(client, documentUri, parentDocumentUri);
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            Log.w(TAG, "Failed to remove document", e);
            DocumentsContract.rethrowIfNecessary(resolver, e);
            boolean bl = false;
            return bl;
        }
        finally {
            ContentProviderClient.releaseQuietly(client);
        }
    }

    public static void removeDocument(ContentProviderClient client, Uri documentUri, Uri parentDocumentUri) throws RemoteException {
        Bundle in = new Bundle();
        in.putParcelable(EXTRA_URI, documentUri);
        in.putParcelable(EXTRA_PARENT_URI, parentDocumentUri);
        client.call(METHOD_REMOVE_DOCUMENT, null, in);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void ejectRoot(ContentResolver resolver, Uri rootUri) {
        ContentProviderClient client = resolver.acquireUnstableContentProviderClient(rootUri.getAuthority());
        try {
            DocumentsContract.ejectRoot(client, rootUri);
        }
        catch (RemoteException e) {
            e.rethrowAsRuntimeException();
        }
        finally {
            ContentProviderClient.releaseQuietly(client);
        }
    }

    public static void ejectRoot(ContentProviderClient client, Uri rootUri) throws RemoteException {
        Bundle in = new Bundle();
        in.putParcelable(EXTRA_URI, rootUri);
        client.call(METHOD_EJECT_ROOT, null, in);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Bundle getDocumentMetadata(ContentResolver resolver, Uri documentUri) throws FileNotFoundException {
        ContentProviderClient client = resolver.acquireUnstableContentProviderClient(documentUri.getAuthority());
        try {
            Bundle bundle = DocumentsContract.getDocumentMetadata(client, documentUri);
            return bundle;
        }
        catch (Exception e) {
            Log.w(TAG, "Failed to get document metadata");
            DocumentsContract.rethrowIfNecessary(resolver, e);
            Bundle bundle = null;
            return bundle;
        }
        finally {
            ContentProviderClient.releaseQuietly(client);
        }
    }

    public static Bundle getDocumentMetadata(ContentProviderClient client, Uri documentUri) throws RemoteException {
        Bundle in = new Bundle();
        in.putParcelable(EXTRA_URI, documentUri);
        Bundle out = client.call(METHOD_GET_DOCUMENT_METADATA, null, in);
        if (out == null) {
            throw new RemoteException("Failed to get a response from getDocumentMetadata");
        }
        return out;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Path findDocumentPath(ContentResolver resolver, Uri treeUri) throws FileNotFoundException {
        Preconditions.checkArgument(DocumentsContract.isTreeUri(treeUri), treeUri + " is not a tree uri.");
        ContentProviderClient client = resolver.acquireUnstableContentProviderClient(treeUri.getAuthority());
        try {
            Path path = DocumentsContract.findDocumentPath(client, treeUri);
            return path;
        }
        catch (Exception e) {
            Log.w(TAG, "Failed to find path", e);
            DocumentsContract.rethrowIfNecessary(resolver, e);
            Path path = null;
            return path;
        }
        finally {
            ContentProviderClient.releaseQuietly(client);
        }
    }

    public static Path findDocumentPath(ContentProviderClient client, Uri uri) throws RemoteException {
        Bundle in = new Bundle();
        in.putParcelable(EXTRA_URI, uri);
        Bundle out = client.call(METHOD_FIND_DOCUMENT_PATH, null, in);
        return (Path)out.getParcelable(EXTRA_RESULT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IntentSender createWebLinkIntent(ContentResolver resolver, Uri uri, Bundle options) throws FileNotFoundException {
        ContentProviderClient client = resolver.acquireUnstableContentProviderClient(uri.getAuthority());
        try {
            IntentSender intentSender = DocumentsContract.createWebLinkIntent(client, uri, options);
            return intentSender;
        }
        catch (Exception e) {
            Log.w(TAG, "Failed to create a web link intent", e);
            DocumentsContract.rethrowIfNecessary(resolver, e);
            IntentSender intentSender = null;
            return intentSender;
        }
        finally {
            ContentProviderClient.releaseQuietly(client);
        }
    }

    public static IntentSender createWebLinkIntent(ContentProviderClient client, Uri uri, Bundle options) throws RemoteException {
        Bundle in = new Bundle();
        in.putParcelable(EXTRA_URI, uri);
        if (options != null) {
            in.putBundle(EXTRA_OPTIONS, options);
        }
        Bundle out = client.call(METHOD_CREATE_WEB_LINK_INTENT, null, in);
        return (IntentSender)out.getParcelable(EXTRA_RESULT);
    }

    public static AssetFileDescriptor openImageThumbnail(File file) throws FileNotFoundException {
        ParcelFileDescriptor pfd = ParcelFileDescriptor.open(file, 0x10000000);
        Bundle extras = null;
        try {
            ExifInterface exif = new ExifInterface(file.getAbsolutePath());
            switch (exif.getAttributeInt("Orientation", -1)) {
                case 6: {
                    extras = new Bundle(1);
                    extras.putInt(EXTRA_ORIENTATION, 90);
                    break;
                }
                case 3: {
                    extras = new Bundle(1);
                    extras.putInt(EXTRA_ORIENTATION, 180);
                    break;
                }
                case 8: {
                    extras = new Bundle(1);
                    extras.putInt(EXTRA_ORIENTATION, 270);
                }
            }
            long[] thumb = exif.getThumbnailRange();
            if (thumb != null) {
                return new AssetFileDescriptor(pfd, thumb[0], thumb[1], extras);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return new AssetFileDescriptor(pfd, 0L, -1L, extras);
    }

    private static void rethrowIfNecessary(ContentResolver resolver, Exception e) throws FileNotFoundException {
        if (resolver.getTargetSdkVersion() >= 26) {
            if (e instanceof ParcelableException) {
                ((ParcelableException)e).maybeRethrow(FileNotFoundException.class);
            } else if (e instanceof RemoteException) {
                ((RemoteException)e).rethrowAsRuntimeException();
            } else if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
        }
    }

    public static class Path
    implements Parcelable {
        private final String mRootId;
        private final List<String> mPath;
        public static final Parcelable.Creator<Path> CREATOR = new Parcelable.Creator<Path>(){

            @Override
            public Path createFromParcel(Parcel in) {
                String rootId = in.readString();
                ArrayList<String> path = in.createStringArrayList();
                return new Path(rootId, path);
            }

            public Path[] newArray(int size) {
                return new Path[size];
            }
        };

        public Path(String rootId, List<String> path) {
            Preconditions.checkCollectionNotEmpty(path, "path");
            Preconditions.checkCollectionElementsNotNull(path, "path");
            this.mRootId = rootId;
            this.mPath = path;
        }

        public String getRootId() {
            return this.mRootId;
        }

        public List<String> getPath() {
            return this.mPath;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof Path)) {
                return false;
            }
            Path path = (Path)o;
            return Objects.equals(this.mRootId, path.mRootId) && Objects.equals(this.mPath, path.mPath);
        }

        public int hashCode() {
            return Objects.hash(this.mRootId, this.mPath);
        }

        public String toString() {
            return "DocumentsContract.Path{" + "rootId=" + this.mRootId + ", path=" + this.mPath + "}";
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            dest.writeString(this.mRootId);
            dest.writeStringList(this.mPath);
        }

        @Override
        public int describeContents() {
            return 0;
        }
    }

    public static class Root {
        public static final String COLUMN_ROOT_ID = "root_id";
        public static final String COLUMN_FLAGS = "flags";
        public static final String COLUMN_ICON = "icon";
        public static final String COLUMN_TITLE = "title";
        public static final String COLUMN_SUMMARY = "summary";
        public static final String COLUMN_DOCUMENT_ID = "document_id";
        public static final String COLUMN_AVAILABLE_BYTES = "available_bytes";
        public static final String COLUMN_CAPACITY_BYTES = "capacity_bytes";
        public static final String COLUMN_MIME_TYPES = "mime_types";
        public static final String MIME_TYPE_ITEM = "vnd.android.document/root";
        public static final int FLAG_SUPPORTS_CREATE = 1;
        public static final int FLAG_LOCAL_ONLY = 2;
        public static final int FLAG_SUPPORTS_RECENTS = 4;
        public static final int FLAG_SUPPORTS_SEARCH = 8;
        public static final int FLAG_SUPPORTS_IS_CHILD = 16;
        public static final int FLAG_SUPPORTS_EJECT = 32;
        public static final int FLAG_EMPTY = 65536;
        public static final int FLAG_ADVANCED = 131072;
        public static final int FLAG_HAS_SETTINGS = 262144;
        public static final int FLAG_REMOVABLE_SD = 524288;
        public static final int FLAG_REMOVABLE_USB = 0x100000;

        private Root() {
        }
    }

    public static class Document {
        public static final String COLUMN_DOCUMENT_ID = "document_id";
        public static final String COLUMN_MIME_TYPE = "mime_type";
        public static final String COLUMN_DISPLAY_NAME = "_display_name";
        public static final String COLUMN_SUMMARY = "summary";
        public static final String COLUMN_LAST_MODIFIED = "last_modified";
        public static final String COLUMN_ICON = "icon";
        public static final String COLUMN_FLAGS = "flags";
        public static final String COLUMN_SIZE = "_size";
        public static final String MIME_TYPE_DIR = "vnd.android.document/directory";
        public static final int FLAG_SUPPORTS_THUMBNAIL = 1;
        public static final int FLAG_SUPPORTS_WRITE = 2;
        public static final int FLAG_SUPPORTS_DELETE = 4;
        public static final int FLAG_DIR_SUPPORTS_CREATE = 8;
        public static final int FLAG_DIR_PREFERS_GRID = 16;
        public static final int FLAG_DIR_PREFERS_LAST_MODIFIED = 32;
        public static final int FLAG_SUPPORTS_RENAME = 64;
        public static final int FLAG_SUPPORTS_COPY = 128;
        public static final int FLAG_SUPPORTS_MOVE = 256;
        public static final int FLAG_VIRTUAL_DOCUMENT = 512;
        public static final int FLAG_SUPPORTS_REMOVE = 1024;
        public static final int FLAG_SUPPORTS_SETTINGS = 2048;
        public static final int FLAG_WEB_LINKABLE = 4096;
        public static final int FLAG_PARTIAL = 65536;
        public static final int FLAG_SUPPORTS_METADATA = 131072;

        private Document() {
        }
    }
}

