/*
 * Decompiled with CFR 0.152.
 */
package android.telephony;

import android.annotation.SuppressLint;
import android.app.ActivityThread;
import android.app.PendingIntent;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.net.ConnectivityManager;
import android.net.NetworkStats;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.os.PersistableBundle;
import android.os.RemoteException;
import android.os.ResultReceiver;
import android.os.ServiceManager;
import android.os.SystemProperties;
import android.provider.Settings;
import android.service.carrier.CarrierIdentifier;
import android.telecom.PhoneAccount;
import android.telecom.PhoneAccountHandle;
import android.telephony.CarrierConfigManager;
import android.telephony.CellInfo;
import android.telephony.CellLocation;
import android.telephony.ClientRequestStats;
import android.telephony.IccOpenLogicalChannelResponse;
import android.telephony.ImsiEncryptionInfo;
import android.telephony.NeighboringCellInfo;
import android.telephony.NetworkScan;
import android.telephony.NetworkScanRequest;
import android.telephony.PhoneStateListener;
import android.telephony.Rlog;
import android.telephony.ServiceState;
import android.telephony.SignalStrength;
import android.telephony.SubscriptionManager;
import android.telephony.TelephonyHistogram;
import android.telephony.TelephonyScanManager;
import android.telephony.UssdResponse;
import android.telephony.VisualVoicemailSmsFilterSettings;
import android.util.Log;
import com.android.ims.internal.IImsServiceController;
import com.android.ims.internal.IImsServiceFeatureListener;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.telecom.ITelecomService;
import com.android.internal.telephony.CellNetworkScanResult;
import com.android.internal.telephony.IPhoneSubInfo;
import com.android.internal.telephony.ITelephony;
import com.android.internal.telephony.ITelephonyRegistry;
import com.android.internal.telephony.OperatorInfo;
import com.android.internal.telephony.PhoneConstants;
import com.android.internal.util.Preconditions;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TelephonyManager {
    private static final String TAG = "TelephonyManager";
    public static final String MODEM_ACTIVITY_RESULT_KEY = "controller_activity";
    private static ITelephonyRegistry sRegistry;
    public static final int OTASP_UNINITIALIZED = 0;
    public static final int OTASP_UNKNOWN = 1;
    public static final int OTASP_NEEDED = 2;
    public static final int OTASP_NOT_NEEDED = 3;
    public static final int OTASP_SIM_UNPROVISIONED = 5;
    public static final int KEY_TYPE_EPDG = 1;
    public static final int KEY_TYPE_WLAN = 2;
    private final Context mContext;
    private final int mSubId;
    private SubscriptionManager mSubscriptionManager;
    private TelephonyScanManager mTelephonyScanManager;
    private static String multiSimConfig;
    private static TelephonyManager sInstance;
    public static final String ACTION_PHONE_STATE_CHANGED = "android.intent.action.PHONE_STATE";
    public static final String ACTION_RESPOND_VIA_MESSAGE = "android.intent.action.RESPOND_VIA_MESSAGE";
    public static final String ACTION_EMERGENCY_ASSISTANCE = "android.telephony.action.EMERGENCY_ASSISTANCE";
    public static final String METADATA_HIDE_VOICEMAIL_SETTINGS_MENU = "android.telephony.HIDE_VOICEMAIL_SETTINGS_MENU";
    public static final String ACTION_CONFIGURE_VOICEMAIL = "android.telephony.action.CONFIGURE_VOICEMAIL";
    public static final String EXTRA_HIDE_PUBLIC_SETTINGS = "android.telephony.extra.HIDE_PUBLIC_SETTINGS";
    public static final boolean EMERGENCY_ASSISTANCE_ENABLED = true;
    public static final String EXTRA_STATE = "state";
    public static final String EXTRA_STATE_IDLE;
    public static final String EXTRA_STATE_RINGING;
    public static final String EXTRA_STATE_OFFHOOK;
    public static final String EXTRA_INCOMING_NUMBER = "incoming_number";
    public static final String ACTION_PRECISE_CALL_STATE_CHANGED = "android.intent.action.PRECISE_CALL_STATE";
    public static final String EXTRA_RINGING_CALL_STATE = "ringing_state";
    public static final String EXTRA_FOREGROUND_CALL_STATE = "foreground_state";
    public static final String EXTRA_BACKGROUND_CALL_STATE = "background_state";
    public static final String EXTRA_DISCONNECT_CAUSE = "disconnect_cause";
    public static final String EXTRA_PRECISE_DISCONNECT_CAUSE = "precise_disconnect_cause";
    @Deprecated
    public static final String ACTION_PRECISE_DATA_CONNECTION_STATE_CHANGED = "android.intent.action.PRECISE_DATA_CONNECTION_STATE_CHANGED";
    public static final String EXTRA_DATA_STATE = "state";
    public static final String EXTRA_DATA_NETWORK_TYPE = "networkType";
    public static final String EXTRA_DATA_APN_TYPE = "apnType";
    public static final String EXTRA_DATA_APN = "apn";
    public static final String EXTRA_DATA_CHANGE_REASON = "reason";
    public static final String EXTRA_DATA_LINK_PROPERTIES_KEY = "linkProperties";
    public static final String EXTRA_DATA_FAILURE_CAUSE = "failCause";
    public static final String ACTION_SHOW_VOICEMAIL_NOTIFICATION = "android.telephony.action.SHOW_VOICEMAIL_NOTIFICATION";
    public static final String EXTRA_PHONE_ACCOUNT_HANDLE = "android.telephony.extra.PHONE_ACCOUNT_HANDLE";
    public static final String EXTRA_NOTIFICATION_COUNT = "android.telephony.extra.NOTIFICATION_COUNT";
    public static final String EXTRA_VOICEMAIL_NUMBER = "android.telephony.extra.VOICEMAIL_NUMBER";
    public static final String EXTRA_CALL_VOICEMAIL_INTENT = "android.telephony.extra.CALL_VOICEMAIL_INTENT";
    public static final String EXTRA_LAUNCH_VOICEMAIL_SETTINGS_INTENT = "android.telephony.extra.LAUNCH_VOICEMAIL_SETTINGS_INTENT";
    public static final String EXTRA_IS_REFRESH = "android.telephony.extra.IS_REFRESH";
    public static final String EVENT_HANDOVER_VIDEO_FROM_WIFI_TO_LTE = "android.telephony.event.EVENT_HANDOVER_VIDEO_FROM_WIFI_TO_LTE";
    public static final String EVENT_HANDOVER_TO_WIFI_FAILED = "android.telephony.event.EVENT_HANDOVER_TO_WIFI_FAILED";
    public static final String EVENT_DOWNGRADE_DATA_LIMIT_REACHED = "android.telephony.event.EVENT_DOWNGRADE_DATA_LIMIT_REACHED";
    public static final String EVENT_DOWNGRADE_DATA_DISABLED = "android.telephony.event.EVENT_DOWNGRADE_DATA_DISABLED";
    public static final String EVENT_NOTIFY_INTERNATIONAL_CALL_ON_WFC = "android.telephony.event.EVENT_NOTIFY_INTERNATIONAL_CALL_ON_WFC";
    public static final String EVENT_CALL_FORWARDED = "android.telephony.event.EVENT_CALL_FORWARDED";
    public static final String VVM_TYPE_OMTP = "vvm_type_omtp";
    public static final String VVM_TYPE_CVVM = "vvm_type_cvvm";
    public static final String EXTRA_VISUAL_VOICEMAIL_ENABLED_BY_USER_BOOL = "android.telephony.extra.VISUAL_VOICEMAIL_ENABLED_BY_USER_BOOL";
    public static final String EXTRA_VOICEMAIL_SCRAMBLED_PIN_STRING = "android.telephony.extra.VOICEMAIL_SCRAMBLED_PIN_STRING";
    public static final String USSD_RESPONSE = "USSD_RESPONSE";
    public static final int USSD_RETURN_SUCCESS = 100;
    public static final int USSD_RETURN_FAILURE = -1;
    public static final int USSD_ERROR_SERVICE_UNAVAIL = -2;
    public static final int PHONE_TYPE_NONE = 0;
    public static final int PHONE_TYPE_GSM = 1;
    public static final int PHONE_TYPE_CDMA = 2;
    public static final int PHONE_TYPE_SIP = 3;
    private static final String sKernelCmdLine;
    private static final Pattern sProductTypePattern;
    private static final String sLteOnCdmaProductType;
    public static final int NETWORK_TYPE_UNKNOWN = 0;
    public static final int NETWORK_TYPE_GPRS = 1;
    public static final int NETWORK_TYPE_EDGE = 2;
    public static final int NETWORK_TYPE_UMTS = 3;
    public static final int NETWORK_TYPE_CDMA = 4;
    public static final int NETWORK_TYPE_EVDO_0 = 5;
    public static final int NETWORK_TYPE_EVDO_A = 6;
    public static final int NETWORK_TYPE_1xRTT = 7;
    public static final int NETWORK_TYPE_HSDPA = 8;
    public static final int NETWORK_TYPE_HSUPA = 9;
    public static final int NETWORK_TYPE_HSPA = 10;
    public static final int NETWORK_TYPE_IDEN = 11;
    public static final int NETWORK_TYPE_EVDO_B = 12;
    public static final int NETWORK_TYPE_LTE = 13;
    public static final int NETWORK_TYPE_EHRPD = 14;
    public static final int NETWORK_TYPE_HSPAP = 15;
    public static final int NETWORK_TYPE_GSM = 16;
    public static final int NETWORK_TYPE_TD_SCDMA = 17;
    public static final int NETWORK_TYPE_IWLAN = 18;
    public static final int NETWORK_TYPE_LTE_CA = 19;
    public static final int NETWORK_CLASS_UNKNOWN = 0;
    public static final int NETWORK_CLASS_2_G = 1;
    public static final int NETWORK_CLASS_3_G = 2;
    public static final int NETWORK_CLASS_4_G = 3;
    public static final int SIM_STATE_UNKNOWN = 0;
    public static final int SIM_STATE_ABSENT = 1;
    public static final int SIM_STATE_PIN_REQUIRED = 2;
    public static final int SIM_STATE_PUK_REQUIRED = 3;
    public static final int SIM_STATE_NETWORK_LOCKED = 4;
    public static final int SIM_STATE_READY = 5;
    public static final int SIM_STATE_NOT_READY = 6;
    public static final int SIM_STATE_PERM_DISABLED = 7;
    public static final int SIM_STATE_CARD_IO_ERROR = 8;
    public static final int SIM_STATE_CARD_RESTRICTED = 9;
    public static final int SIM_ACTIVATION_STATE_UNKNOWN = 0;
    public static final int SIM_ACTIVATION_STATE_ACTIVATING = 1;
    public static final int SIM_ACTIVATION_STATE_ACTIVATED = 2;
    public static final int SIM_ACTIVATION_STATE_DEACTIVATED = 3;
    public static final int SIM_ACTIVATION_STATE_RESTRICTED = 4;
    public static final int CALL_STATE_IDLE = 0;
    public static final int CALL_STATE_RINGING = 1;
    public static final int CALL_STATE_OFFHOOK = 2;
    public static final int DATA_ACTIVITY_NONE = 0;
    public static final int DATA_ACTIVITY_IN = 1;
    public static final int DATA_ACTIVITY_OUT = 2;
    public static final int DATA_ACTIVITY_INOUT = 3;
    public static final int DATA_ACTIVITY_DORMANT = 4;
    public static final int DATA_UNKNOWN = -1;
    public static final int DATA_DISCONNECTED = 0;
    public static final int DATA_CONNECTING = 1;
    public static final int DATA_CONNECTED = 2;
    public static final int DATA_SUSPENDED = 3;
    public static final int APPTYPE_SIM = 1;
    public static final int APPTYPE_USIM = 2;
    public static final int APPTYPE_RUIM = 3;
    public static final int APPTYPE_CSIM = 4;
    public static final int APPTYPE_ISIM = 5;
    public static final int AUTHTYPE_EAP_SIM = 128;
    public static final int AUTHTYPE_EAP_AKA = 129;
    public static final int CARRIER_PRIVILEGE_STATUS_HAS_ACCESS = 1;
    public static final int CARRIER_PRIVILEGE_STATUS_NO_ACCESS = 0;
    public static final int CARRIER_PRIVILEGE_STATUS_RULES_NOT_LOADED = -1;
    public static final int CARRIER_PRIVILEGE_STATUS_ERROR_LOADING_RULES = -2;
    public static final int CARD_POWER_DOWN = 0;
    public static final int CARD_POWER_UP = 1;
    public static final int CARD_POWER_UP_PASS_THROUGH = 2;

    public TelephonyManager(Context context) {
        this(context, Integer.MAX_VALUE);
    }

    public TelephonyManager(Context context, int subId) {
        this.mSubId = subId;
        Context appContext = context.getApplicationContext();
        this.mContext = appContext != null ? appContext : context;
        this.mSubscriptionManager = SubscriptionManager.from(this.mContext);
        if (sRegistry == null) {
            sRegistry = ITelephonyRegistry.Stub.asInterface(ServiceManager.getService("telephony.registry"));
        }
    }

    private TelephonyManager() {
        this.mContext = null;
        this.mSubId = -1;
    }

    public static TelephonyManager getDefault() {
        return sInstance;
    }

    private String getOpPackageName() {
        if (this.mContext != null) {
            return this.mContext.getOpPackageName();
        }
        return ActivityThread.currentOpPackageName();
    }

    public MultiSimVariants getMultiSimConfiguration() {
        String mSimConfig = SystemProperties.get("persist.radio.multisim.config");
        if (mSimConfig.equals("dsds")) {
            return MultiSimVariants.DSDS;
        }
        if (mSimConfig.equals("dsda")) {
            return MultiSimVariants.DSDA;
        }
        if (mSimConfig.equals("tsts")) {
            return MultiSimVariants.TSTS;
        }
        return MultiSimVariants.UNKNOWN;
    }

    public int getPhoneCount() {
        int phoneCount = 1;
        switch (this.getMultiSimConfiguration()) {
            case UNKNOWN: {
                if (this.isVoiceCapable() || this.isSmsCapable()) {
                    phoneCount = 1;
                    break;
                }
                if (this.mContext == null) {
                    phoneCount = 1;
                    break;
                }
                ConnectivityManager cm = (ConnectivityManager)this.mContext.getSystemService("connectivity");
                if (cm == null) {
                    phoneCount = 1;
                    break;
                }
                if (cm.isNetworkSupported(0)) {
                    phoneCount = 1;
                    break;
                }
                phoneCount = 0;
                break;
            }
            case DSDS: 
            case DSDA: {
                phoneCount = 2;
                break;
            }
            case TSTS: {
                phoneCount = 3;
            }
        }
        return phoneCount;
    }

    public static TelephonyManager from(Context context) {
        return (TelephonyManager)context.getSystemService("phone");
    }

    public TelephonyManager createForSubscriptionId(int subId) {
        return new TelephonyManager(this.mContext, subId);
    }

    public TelephonyManager createForPhoneAccountHandle(PhoneAccountHandle phoneAccountHandle) {
        int subId = this.getSubIdForPhoneAccountHandle(phoneAccountHandle);
        if (!SubscriptionManager.isValidSubscriptionId(subId)) {
            return null;
        }
        return new TelephonyManager(this.mContext, subId);
    }

    public boolean isMultiSimEnabled() {
        return multiSimConfig.equals("dsds") || multiSimConfig.equals("dsda") || multiSimConfig.equals("tsts");
    }

    public String getDeviceSoftwareVersion() {
        return this.getDeviceSoftwareVersion(this.getSlotIndex());
    }

    public String getDeviceSoftwareVersion(int slotIndex) {
        ITelephony telephony = this.getITelephony();
        if (telephony == null) {
            return null;
        }
        try {
            return telephony.getDeviceSoftwareVersionForSlot(slotIndex, this.getOpPackageName());
        }
        catch (RemoteException ex) {
            return null;
        }
        catch (NullPointerException ex) {
            return null;
        }
    }

    @Deprecated
    public String getDeviceId() {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony == null) {
                return null;
            }
            return telephony.getDeviceId(this.mContext.getOpPackageName());
        }
        catch (RemoteException ex) {
            return null;
        }
        catch (NullPointerException ex) {
            return null;
        }
    }

    @Deprecated
    public String getDeviceId(int slotIndex) {
        try {
            IPhoneSubInfo info = this.getSubscriberInfo();
            if (info == null) {
                return null;
            }
            return info.getDeviceIdForPhone(slotIndex, this.mContext.getOpPackageName());
        }
        catch (RemoteException ex) {
            return null;
        }
        catch (NullPointerException ex) {
            return null;
        }
    }

    public String getImei() {
        return this.getImei(this.getSlotIndex());
    }

    public String getImei(int slotIndex) {
        ITelephony telephony = this.getITelephony();
        if (telephony == null) {
            return null;
        }
        try {
            return telephony.getImeiForSlot(slotIndex, this.getOpPackageName());
        }
        catch (RemoteException ex) {
            return null;
        }
        catch (NullPointerException ex) {
            return null;
        }
    }

    public String getMeid() {
        return this.getMeid(this.getSlotIndex());
    }

    public String getMeid(int slotIndex) {
        ITelephony telephony = this.getITelephony();
        if (telephony == null) {
            return null;
        }
        try {
            return telephony.getMeidForSlot(slotIndex, this.getOpPackageName());
        }
        catch (RemoteException ex) {
            return null;
        }
        catch (NullPointerException ex) {
            return null;
        }
    }

    public String getNai() {
        return this.getNai(this.getSlotIndex());
    }

    public String getNai(int slotIndex) {
        int[] subId = SubscriptionManager.getSubId(slotIndex);
        try {
            IPhoneSubInfo info = this.getSubscriberInfo();
            if (info == null) {
                return null;
            }
            String nai = info.getNaiForSubscriber(subId[0], this.mContext.getOpPackageName());
            if (Log.isLoggable(TAG, 2)) {
                Rlog.v(TAG, "Nai = " + nai);
            }
            return nai;
        }
        catch (RemoteException ex) {
            return null;
        }
        catch (NullPointerException ex) {
            return null;
        }
    }

    @Deprecated
    public CellLocation getCellLocation() {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony == null) {
                Rlog.d(TAG, "getCellLocation returning null because telephony is null");
                return null;
            }
            Bundle bundle = telephony.getCellLocation(this.mContext.getOpPackageName());
            if (bundle.isEmpty()) {
                Rlog.d(TAG, "getCellLocation returning null because bundle is empty");
                return null;
            }
            CellLocation cl = CellLocation.newFromBundle(bundle);
            if (cl.isEmpty()) {
                Rlog.d(TAG, "getCellLocation returning null because CellLocation is empty");
                return null;
            }
            return cl;
        }
        catch (RemoteException ex) {
            Rlog.d(TAG, "getCellLocation returning null due to RemoteException " + ex);
            return null;
        }
        catch (NullPointerException ex) {
            Rlog.d(TAG, "getCellLocation returning null due to NullPointerException " + ex);
            return null;
        }
    }

    public void enableLocationUpdates() {
        this.enableLocationUpdates(this.getSubId());
    }

    public void enableLocationUpdates(int subId) {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                telephony.enableLocationUpdatesForSubscriber(subId);
            }
        }
        catch (RemoteException remoteException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void disableLocationUpdates() {
        this.disableLocationUpdates(this.getSubId());
    }

    public void disableLocationUpdates(int subId) {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                telephony.disableLocationUpdatesForSubscriber(subId);
            }
        }
        catch (RemoteException remoteException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Deprecated
    public List<NeighboringCellInfo> getNeighboringCellInfo() {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony == null) {
                return null;
            }
            return telephony.getNeighboringCellInfo(this.mContext.getOpPackageName());
        }
        catch (RemoteException ex) {
            return null;
        }
        catch (NullPointerException ex) {
            return null;
        }
    }

    public int getCurrentPhoneType() {
        return this.getCurrentPhoneType(this.getSubId());
    }

    public int getCurrentPhoneType(int subId) {
        int phoneId = subId == -1 ? 0 : SubscriptionManager.getPhoneId(subId);
        return this.getCurrentPhoneTypeForSlot(phoneId);
    }

    public int getCurrentPhoneTypeForSlot(int slotIndex) {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                return telephony.getActivePhoneTypeForSlot(slotIndex);
            }
            return this.getPhoneTypeFromProperty(slotIndex);
        }
        catch (RemoteException ex) {
            return this.getPhoneTypeFromProperty(slotIndex);
        }
        catch (NullPointerException ex) {
            return this.getPhoneTypeFromProperty(slotIndex);
        }
    }

    public int getPhoneType() {
        if (!this.isVoiceCapable()) {
            return 0;
        }
        return this.getCurrentPhoneType();
    }

    private int getPhoneTypeFromProperty() {
        return this.getPhoneTypeFromProperty(this.getPhoneId());
    }

    private int getPhoneTypeFromProperty(int phoneId) {
        String type = TelephonyManager.getTelephonyProperty(phoneId, "gsm.current.phone-type", null);
        if (type == null || type.isEmpty()) {
            return this.getPhoneTypeFromNetworkType(phoneId);
        }
        return Integer.parseInt(type);
    }

    private int getPhoneTypeFromNetworkType() {
        return this.getPhoneTypeFromNetworkType(this.getPhoneId());
    }

    private int getPhoneTypeFromNetworkType(int phoneId) {
        String mode = TelephonyManager.getTelephonyProperty(phoneId, "ro.telephony.default_network", null);
        if (mode != null && !mode.isEmpty()) {
            return TelephonyManager.getPhoneType(Integer.parseInt(mode));
        }
        return 0;
    }

    public static int getPhoneType(int networkMode) {
        switch (networkMode) {
            case 4: 
            case 5: 
            case 6: {
                return 2;
            }
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 22: {
                return 1;
            }
            case 7: 
            case 8: 
            case 21: {
                return 2;
            }
            case 11: {
                if (TelephonyManager.getLteOnCdmaModeStatic() == 1) {
                    return 2;
                }
                return 1;
            }
        }
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getProcCmdLine() {
        String cmdline = "";
        FileInputStream is = null;
        try {
            is = new FileInputStream("/proc/cmdline");
            byte[] buffer = new byte[2048];
            int count = is.read(buffer);
            if (count > 0) {
                cmdline = new String(buffer, 0, count);
            }
        }
        catch (IOException e) {
            Rlog.d(TAG, "No /proc/cmdline exception=" + e);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
        Rlog.d(TAG, "/proc/cmdline=" + cmdline);
        return cmdline;
    }

    public static int getLteOnCdmaModeStatic() {
        String productType = "";
        int curVal = SystemProperties.getInt("telephony.lteOnCdmaDevice", -1);
        int retVal = curVal;
        if (retVal == -1) {
            Matcher matcher = sProductTypePattern.matcher(sKernelCmdLine);
            retVal = matcher.find() ? (sLteOnCdmaProductType.equals(productType = matcher.group(1)) ? 1 : 0) : 0;
        }
        Rlog.d(TAG, "getLteOnCdmaMode=" + retVal + " curVal=" + curVal + " product_type='" + productType + "' lteOnCdmaProductType='" + sLteOnCdmaProductType + "'");
        return retVal;
    }

    public String getNetworkOperatorName() {
        return this.getNetworkOperatorName(this.getSubId());
    }

    public String getNetworkOperatorName(int subId) {
        int phoneId = SubscriptionManager.getPhoneId(subId);
        return TelephonyManager.getTelephonyProperty(phoneId, "gsm.operator.alpha", "");
    }

    public String getNetworkOperator() {
        return this.getNetworkOperatorForPhone(this.getPhoneId());
    }

    public String getNetworkOperator(int subId) {
        int phoneId = SubscriptionManager.getPhoneId(subId);
        return this.getNetworkOperatorForPhone(phoneId);
    }

    public String getNetworkOperatorForPhone(int phoneId) {
        return TelephonyManager.getTelephonyProperty(phoneId, "gsm.operator.numeric", "");
    }

    public String getNetworkSpecifier() {
        return String.valueOf(this.getSubId());
    }

    public PersistableBundle getCarrierConfig() {
        CarrierConfigManager carrierConfigManager = this.mContext.getSystemService(CarrierConfigManager.class);
        return carrierConfigManager.getConfigForSubId(this.getSubId());
    }

    public boolean isNetworkRoaming() {
        return this.isNetworkRoaming(this.getSubId());
    }

    public boolean isNetworkRoaming(int subId) {
        int phoneId = SubscriptionManager.getPhoneId(subId);
        return Boolean.parseBoolean(TelephonyManager.getTelephonyProperty(phoneId, "gsm.operator.isroaming", null));
    }

    public String getNetworkCountryIso() {
        return this.getNetworkCountryIsoForPhone(this.getPhoneId());
    }

    public String getNetworkCountryIso(int subId) {
        return this.getNetworkCountryIsoForPhone(this.getPhoneId(subId));
    }

    public String getNetworkCountryIsoForPhone(int phoneId) {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony == null) {
                return "";
            }
            return telephony.getNetworkCountryIsoForPhone(phoneId);
        }
        catch (RemoteException ex) {
            return "";
        }
    }

    public int getNetworkType() {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                return telephony.getNetworkType();
            }
            return 0;
        }
        catch (RemoteException ex) {
            return 0;
        }
        catch (NullPointerException ex) {
            return 0;
        }
    }

    public int getNetworkType(int subId) {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                return telephony.getNetworkTypeForSubscriber(subId, this.getOpPackageName());
            }
            return 0;
        }
        catch (RemoteException ex) {
            return 0;
        }
        catch (NullPointerException ex) {
            return 0;
        }
    }

    public int getDataNetworkType() {
        return this.getDataNetworkType(this.getSubId(SubscriptionManager.getDefaultDataSubscriptionId()));
    }

    public int getDataNetworkType(int subId) {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                return telephony.getDataNetworkTypeForSubscriber(subId, this.getOpPackageName());
            }
            return 0;
        }
        catch (RemoteException ex) {
            return 0;
        }
        catch (NullPointerException ex) {
            return 0;
        }
    }

    public int getVoiceNetworkType() {
        return this.getVoiceNetworkType(this.getSubId());
    }

    public int getVoiceNetworkType(int subId) {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                return telephony.getVoiceNetworkTypeForSubscriber(subId, this.getOpPackageName());
            }
            return 0;
        }
        catch (RemoteException ex) {
            return 0;
        }
        catch (NullPointerException ex) {
            return 0;
        }
    }

    public static int getNetworkClass(int networkType) {
        switch (networkType) {
            case 1: 
            case 2: 
            case 4: 
            case 7: 
            case 11: 
            case 16: {
                return 1;
            }
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 14: 
            case 15: 
            case 17: {
                return 2;
            }
            case 13: 
            case 18: 
            case 19: {
                return 3;
            }
        }
        return 0;
    }

    public String getNetworkTypeName() {
        return TelephonyManager.getNetworkTypeName(this.getNetworkType());
    }

    public static String getNetworkTypeName(int type) {
        switch (type) {
            case 1: {
                return "GPRS";
            }
            case 2: {
                return "EDGE";
            }
            case 3: {
                return "UMTS";
            }
            case 8: {
                return "HSDPA";
            }
            case 9: {
                return "HSUPA";
            }
            case 10: {
                return "HSPA";
            }
            case 4: {
                return "CDMA";
            }
            case 5: {
                return "CDMA - EvDo rev. 0";
            }
            case 6: {
                return "CDMA - EvDo rev. A";
            }
            case 12: {
                return "CDMA - EvDo rev. B";
            }
            case 7: {
                return "CDMA - 1xRTT";
            }
            case 13: {
                return "LTE";
            }
            case 14: {
                return "CDMA - eHRPD";
            }
            case 11: {
                return "iDEN";
            }
            case 15: {
                return "HSPA+";
            }
            case 16: {
                return "GSM";
            }
            case 17: {
                return "TD_SCDMA";
            }
            case 18: {
                return "IWLAN";
            }
            case 19: {
                return "LTE_CA";
            }
        }
        return "UNKNOWN";
    }

    public boolean hasIccCard() {
        return this.hasIccCard(this.getSlotIndex());
    }

    public boolean hasIccCard(int slotIndex) {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony == null) {
                return false;
            }
            return telephony.hasIccCardUsingSlotIndex(slotIndex);
        }
        catch (RemoteException ex) {
            return false;
        }
        catch (NullPointerException ex) {
            return false;
        }
    }

    public int getSimState() {
        int slotIndex = this.getSlotIndex();
        if (slotIndex < 0) {
            for (int i = 0; i < this.getPhoneCount(); ++i) {
                int simState = this.getSimState(i);
                if (simState == 1) continue;
                Rlog.d(TAG, "getSimState: default sim:" + slotIndex + ", sim state for slotIndex=" + i + " is " + simState + ", return state as unknown");
                return 0;
            }
            Rlog.d(TAG, "getSimState: default sim:" + slotIndex + ", all SIMs absent, return state as absent");
            return 1;
        }
        return this.getSimState(slotIndex);
    }

    public int getSimState(int slotIndex) {
        int simState = SubscriptionManager.getSimStateForSlotIndex(slotIndex);
        return simState;
    }

    public String getSimOperator() {
        return this.getSimOperatorNumeric();
    }

    public String getSimOperator(int subId) {
        return this.getSimOperatorNumeric(subId);
    }

    public String getSimOperatorNumeric() {
        int subId = SubscriptionManager.getDefaultDataSubscriptionId();
        if (!(SubscriptionManager.isUsableSubIdValue(subId) || SubscriptionManager.isUsableSubIdValue(subId = SubscriptionManager.getDefaultSmsSubscriptionId()) || SubscriptionManager.isUsableSubIdValue(subId = SubscriptionManager.getDefaultVoiceSubscriptionId()))) {
            subId = SubscriptionManager.getDefaultSubscriptionId();
        }
        return this.getSimOperatorNumeric(subId);
    }

    public String getSimOperatorNumeric(int subId) {
        int phoneId = SubscriptionManager.getPhoneId(subId);
        return this.getSimOperatorNumericForPhone(phoneId);
    }

    public String getSimOperatorNumericForPhone(int phoneId) {
        return TelephonyManager.getTelephonyProperty(phoneId, "gsm.sim.operator.numeric", "");
    }

    public String getSimOperatorName() {
        return this.getSimOperatorNameForPhone(this.getPhoneId());
    }

    public String getSimOperatorName(int subId) {
        int phoneId = SubscriptionManager.getPhoneId(subId);
        return this.getSimOperatorNameForPhone(phoneId);
    }

    public String getSimOperatorNameForPhone(int phoneId) {
        return TelephonyManager.getTelephonyProperty(phoneId, "gsm.sim.operator.alpha", "");
    }

    public String getSimCountryIso() {
        return this.getSimCountryIsoForPhone(this.getPhoneId());
    }

    public String getSimCountryIso(int subId) {
        int phoneId = SubscriptionManager.getPhoneId(subId);
        return this.getSimCountryIsoForPhone(phoneId);
    }

    public String getSimCountryIsoForPhone(int phoneId) {
        return TelephonyManager.getTelephonyProperty(phoneId, "gsm.sim.operator.iso-country", "");
    }

    public String getSimSerialNumber() {
        return this.getSimSerialNumber(this.getSubId());
    }

    public String getSimSerialNumber(int subId) {
        try {
            IPhoneSubInfo info = this.getSubscriberInfo();
            if (info == null) {
                return null;
            }
            return info.getIccSerialNumberForSubscriber(subId, this.mContext.getOpPackageName());
        }
        catch (RemoteException ex) {
            return null;
        }
        catch (NullPointerException ex) {
            return null;
        }
    }

    public int getLteOnCdmaMode() {
        return this.getLteOnCdmaMode(this.getSubId());
    }

    public int getLteOnCdmaMode(int subId) {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony == null) {
                return -1;
            }
            return telephony.getLteOnCdmaModeForSubscriber(subId, this.getOpPackageName());
        }
        catch (RemoteException ex) {
            return -1;
        }
        catch (NullPointerException ex) {
            return -1;
        }
    }

    public String getSubscriberId() {
        return this.getSubscriberId(this.getSubId());
    }

    public String getSubscriberId(int subId) {
        try {
            IPhoneSubInfo info = this.getSubscriberInfo();
            if (info == null) {
                return null;
            }
            return info.getSubscriberIdForSubscriber(subId, this.mContext.getOpPackageName());
        }
        catch (RemoteException ex) {
            return null;
        }
        catch (NullPointerException ex) {
            return null;
        }
    }

    public ImsiEncryptionInfo getCarrierInfoForImsiEncryption(int keyType) {
        try {
            IPhoneSubInfo info = this.getSubscriberInfo();
            if (info == null) {
                throw new RuntimeException("IMSI error: Subscriber Info is null");
            }
            int subId = this.getSubId(SubscriptionManager.getDefaultDataSubscriptionId());
            if (keyType != 1 && keyType != 2) {
                throw new IllegalArgumentException("IMSI error: Invalid key type");
            }
            ImsiEncryptionInfo imsiEncryptionInfo = info.getCarrierInfoForImsiEncryption(subId, keyType, this.mContext.getOpPackageName());
            if (imsiEncryptionInfo == null && this.isImsiEncryptionRequired(subId, keyType)) {
                Rlog.e(TAG, "IMSI error: key is required but not found");
                throw new RuntimeException("IMSI error: key is required but not found");
            }
            return imsiEncryptionInfo;
        }
        catch (RemoteException ex) {
            Rlog.e(TAG, "getCarrierInfoForImsiEncryption RemoteException" + ex);
            throw new RuntimeException("IMSI error: Remote Exception");
        }
        catch (NullPointerException ex) {
            Rlog.e(TAG, "getCarrierInfoForImsiEncryption NullPointerException" + ex);
            throw new RuntimeException("IMSI error: Null Pointer exception");
        }
    }

    private static boolean isKeyEnabled(int keyAvailability, int keyType) {
        int returnValue = keyAvailability >> keyType - 1 & 1;
        return returnValue == 1;
    }

    private boolean isImsiEncryptionRequired(int subId, int keyType) {
        CarrierConfigManager configManager = (CarrierConfigManager)this.mContext.getSystemService("carrier_config");
        if (configManager == null) {
            return false;
        }
        PersistableBundle pb = configManager.getConfigForSubId(subId);
        if (pb == null) {
            return false;
        }
        int keyAvailability = pb.getInt("imsi_key_availability_int");
        return TelephonyManager.isKeyEnabled(keyAvailability, keyType);
    }

    public void setCarrierInfoForImsiEncryption(ImsiEncryptionInfo imsiEncryptionInfo) {
        try {
            IPhoneSubInfo info = this.getSubscriberInfo();
            if (info == null) {
                return;
            }
            info.setCarrierInfoForImsiEncryption(this.mSubId, this.mContext.getOpPackageName(), imsiEncryptionInfo);
        }
        catch (NullPointerException ex) {
            return;
        }
        catch (RemoteException ex) {
            Rlog.e(TAG, "setCarrierInfoForImsiEncryption RemoteException", ex);
            return;
        }
    }

    public String getGroupIdLevel1() {
        try {
            IPhoneSubInfo info = this.getSubscriberInfo();
            if (info == null) {
                return null;
            }
            return info.getGroupIdLevel1(this.mContext.getOpPackageName());
        }
        catch (RemoteException ex) {
            return null;
        }
        catch (NullPointerException ex) {
            return null;
        }
    }

    public String getGroupIdLevel1(int subId) {
        try {
            IPhoneSubInfo info = this.getSubscriberInfo();
            if (info == null) {
                return null;
            }
            return info.getGroupIdLevel1ForSubscriber(subId, this.mContext.getOpPackageName());
        }
        catch (RemoteException ex) {
            return null;
        }
        catch (NullPointerException ex) {
            return null;
        }
    }

    public String getLine1Number() {
        return this.getLine1Number(this.getSubId());
    }

    public String getLine1Number(int subId) {
        String number = null;
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                number = telephony.getLine1NumberForDisplay(subId, this.mContext.getOpPackageName());
            }
        }
        catch (RemoteException telephony) {
        }
        catch (NullPointerException telephony) {
            // empty catch block
        }
        if (number != null) {
            return number;
        }
        try {
            IPhoneSubInfo info = this.getSubscriberInfo();
            if (info == null) {
                return null;
            }
            return info.getLine1NumberForSubscriber(subId, this.mContext.getOpPackageName());
        }
        catch (RemoteException ex) {
            return null;
        }
        catch (NullPointerException ex) {
            return null;
        }
    }

    public boolean setLine1NumberForDisplay(String alphaTag, String number) {
        return this.setLine1NumberForDisplay(this.getSubId(), alphaTag, number);
    }

    public boolean setLine1NumberForDisplay(int subId, String alphaTag, String number) {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                return telephony.setLine1NumberForDisplayForSubscriber(subId, alphaTag, number);
            }
        }
        catch (RemoteException remoteException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return false;
    }

    public String getLine1AlphaTag() {
        return this.getLine1AlphaTag(this.getSubId());
    }

    public String getLine1AlphaTag(int subId) {
        String alphaTag = null;
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                alphaTag = telephony.getLine1AlphaTagForDisplay(subId, this.getOpPackageName());
            }
        }
        catch (RemoteException telephony) {
        }
        catch (NullPointerException telephony) {
            // empty catch block
        }
        if (alphaTag != null) {
            return alphaTag;
        }
        try {
            IPhoneSubInfo info = this.getSubscriberInfo();
            if (info == null) {
                return null;
            }
            return info.getLine1AlphaTagForSubscriber(subId, this.getOpPackageName());
        }
        catch (RemoteException ex) {
            return null;
        }
        catch (NullPointerException ex) {
            return null;
        }
    }

    public String[] getMergedSubscriberIds() {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                return telephony.getMergedSubscriberIds(this.getOpPackageName());
            }
        }
        catch (RemoteException remoteException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return null;
    }

    public String getMsisdn() {
        return this.getMsisdn(this.getSubId());
    }

    public String getMsisdn(int subId) {
        try {
            IPhoneSubInfo info = this.getSubscriberInfo();
            if (info == null) {
                return null;
            }
            return info.getMsisdnForSubscriber(subId, this.getOpPackageName());
        }
        catch (RemoteException ex) {
            return null;
        }
        catch (NullPointerException ex) {
            return null;
        }
    }

    public String getVoiceMailNumber() {
        return this.getVoiceMailNumber(this.getSubId());
    }

    public String getVoiceMailNumber(int subId) {
        try {
            IPhoneSubInfo info = this.getSubscriberInfo();
            if (info == null) {
                return null;
            }
            return info.getVoiceMailNumberForSubscriber(subId, this.getOpPackageName());
        }
        catch (RemoteException ex) {
            return null;
        }
        catch (NullPointerException ex) {
            return null;
        }
    }

    public String getCompleteVoiceMailNumber() {
        return this.getCompleteVoiceMailNumber(this.getSubId());
    }

    public String getCompleteVoiceMailNumber(int subId) {
        try {
            IPhoneSubInfo info = this.getSubscriberInfo();
            if (info == null) {
                return null;
            }
            return info.getCompleteVoiceMailNumberForSubscriber(subId);
        }
        catch (RemoteException ex) {
            return null;
        }
        catch (NullPointerException ex) {
            return null;
        }
    }

    public boolean setVoiceMailNumber(String alphaTag, String number) {
        return this.setVoiceMailNumber(this.getSubId(), alphaTag, number);
    }

    public boolean setVoiceMailNumber(int subId, String alphaTag, String number) {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                return telephony.setVoiceMailNumber(subId, alphaTag, number);
            }
        }
        catch (RemoteException remoteException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return false;
    }

    @SuppressLint(value={"Doclava125"})
    public void setVisualVoicemailEnabled(PhoneAccountHandle phoneAccountHandle, boolean enabled) {
    }

    @SuppressLint(value={"Doclava125"})
    public boolean isVisualVoicemailEnabled(PhoneAccountHandle phoneAccountHandle) {
        return false;
    }

    @SuppressLint(value={"Doclava125"})
    public Bundle getVisualVoicemailSettings() {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                return telephony.getVisualVoicemailSettings(this.mContext.getOpPackageName(), this.mSubId);
            }
        }
        catch (RemoteException remoteException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return null;
    }

    public String getVisualVoicemailPackageName() {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                return telephony.getVisualVoicemailPackageName(this.mContext.getOpPackageName(), this.getSubId());
            }
        }
        catch (RemoteException remoteException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return null;
    }

    public void setVisualVoicemailSmsFilterSettings(VisualVoicemailSmsFilterSettings settings) {
        if (settings == null) {
            this.disableVisualVoicemailSmsFilter(this.mSubId);
        } else {
            this.enableVisualVoicemailSmsFilter(this.mSubId, settings);
        }
    }

    public void sendVisualVoicemailSms(String number, int port, String text, PendingIntent sentIntent) {
        this.sendVisualVoicemailSmsForSubscriber(this.mSubId, number, port, text, sentIntent);
    }

    public void enableVisualVoicemailSmsFilter(int subId, VisualVoicemailSmsFilterSettings settings) {
        if (settings == null) {
            throw new IllegalArgumentException("Settings cannot be null");
        }
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                telephony.enableVisualVoicemailSmsFilter(this.mContext.getOpPackageName(), subId, settings);
            }
        }
        catch (RemoteException remoteException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void disableVisualVoicemailSmsFilter(int subId) {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                telephony.disableVisualVoicemailSmsFilter(this.mContext.getOpPackageName(), subId);
            }
        }
        catch (RemoteException remoteException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public VisualVoicemailSmsFilterSettings getVisualVoicemailSmsFilterSettings(int subId) {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                return telephony.getVisualVoicemailSmsFilterSettings(this.mContext.getOpPackageName(), subId);
            }
        }
        catch (RemoteException remoteException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return null;
    }

    public VisualVoicemailSmsFilterSettings getActiveVisualVoicemailSmsFilterSettings(int subId) {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                return telephony.getActiveVisualVoicemailSmsFilterSettings(subId);
            }
        }
        catch (RemoteException remoteException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return null;
    }

    public void sendVisualVoicemailSmsForSubscriber(int subId, String number, int port, String text, PendingIntent sentIntent) {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                telephony.sendVisualVoicemailSmsForSubscriber(this.mContext.getOpPackageName(), subId, number, port, text, sentIntent);
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public void setVoiceActivationState(int subId, int activationState) {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                telephony.setVoiceActivationState(subId, activationState);
            }
        }
        catch (RemoteException remoteException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void setDataActivationState(int subId, int activationState) {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                telephony.setDataActivationState(subId, activationState);
            }
        }
        catch (RemoteException remoteException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public int getVoiceActivationState(int subId) {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                return telephony.getVoiceActivationState(subId, this.getOpPackageName());
            }
        }
        catch (RemoteException remoteException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return 0;
    }

    public int getDataActivationState(int subId) {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                return telephony.getDataActivationState(subId, this.getOpPackageName());
            }
        }
        catch (RemoteException remoteException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return 0;
    }

    public int getVoiceMessageCount() {
        return this.getVoiceMessageCount(this.getSubId());
    }

    public int getVoiceMessageCount(int subId) {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony == null) {
                return 0;
            }
            return telephony.getVoiceMessageCountForSubscriber(subId);
        }
        catch (RemoteException ex) {
            return 0;
        }
        catch (NullPointerException ex) {
            return 0;
        }
    }

    public String getVoiceMailAlphaTag() {
        return this.getVoiceMailAlphaTag(this.getSubId());
    }

    public String getVoiceMailAlphaTag(int subId) {
        try {
            IPhoneSubInfo info = this.getSubscriberInfo();
            if (info == null) {
                return null;
            }
            return info.getVoiceMailAlphaTagForSubscriber(subId, this.getOpPackageName());
        }
        catch (RemoteException ex) {
            return null;
        }
        catch (NullPointerException ex) {
            return null;
        }
    }

    public void sendDialerSpecialCode(String inputCode) {
        try {
            ITelephony telephony = this.getITelephony();
            telephony.sendDialerSpecialCode(this.mContext.getOpPackageName(), inputCode);
        }
        catch (RemoteException ex) {
            ex.rethrowFromSystemServer();
        }
        catch (NullPointerException ex) {
            throw new IllegalStateException("Telephony service unavailable");
        }
    }

    public String getIsimImpi() {
        try {
            IPhoneSubInfo info = this.getSubscriberInfo();
            if (info == null) {
                return null;
            }
            return info.getIsimImpi(this.getSubId());
        }
        catch (RemoteException ex) {
            return null;
        }
        catch (NullPointerException ex) {
            return null;
        }
    }

    public String getIsimDomain() {
        try {
            IPhoneSubInfo info = this.getSubscriberInfo();
            if (info == null) {
                return null;
            }
            return info.getIsimDomain(this.getSubId());
        }
        catch (RemoteException ex) {
            return null;
        }
        catch (NullPointerException ex) {
            return null;
        }
    }

    public String[] getIsimImpu() {
        try {
            IPhoneSubInfo info = this.getSubscriberInfo();
            if (info == null) {
                return null;
            }
            return info.getIsimImpu(this.getSubId());
        }
        catch (RemoteException ex) {
            return null;
        }
        catch (NullPointerException ex) {
            return null;
        }
    }

    private IPhoneSubInfo getSubscriberInfo() {
        return IPhoneSubInfo.Stub.asInterface(ServiceManager.getService("iphonesubinfo"));
    }

    public int getCallState() {
        try {
            ITelecomService telecom = this.getTelecomService();
            if (telecom != null) {
                return telecom.getCallState();
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error calling ITelecomService#getCallState", e);
        }
        return 0;
    }

    public int getCallState(int subId) {
        int phoneId = SubscriptionManager.getPhoneId(subId);
        return this.getCallStateForSlot(phoneId);
    }

    public int getCallStateForSlot(int slotIndex) {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony == null) {
                return 0;
            }
            return telephony.getCallStateForSlot(slotIndex);
        }
        catch (RemoteException ex) {
            return 0;
        }
        catch (NullPointerException ex) {
            return 0;
        }
    }

    public int getDataActivity() {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony == null) {
                return 0;
            }
            return telephony.getDataActivity();
        }
        catch (RemoteException ex) {
            return 0;
        }
        catch (NullPointerException ex) {
            return 0;
        }
    }

    public int getDataState() {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony == null) {
                return 0;
            }
            return telephony.getDataState();
        }
        catch (RemoteException ex) {
            return 0;
        }
        catch (NullPointerException ex) {
            return 0;
        }
    }

    private ITelephony getITelephony() {
        return ITelephony.Stub.asInterface(ServiceManager.getService("phone"));
    }

    private ITelecomService getTelecomService() {
        return ITelecomService.Stub.asInterface(ServiceManager.getService("telecom"));
    }

    public void listen(PhoneStateListener listener, int events) {
        if (this.mContext == null) {
            return;
        }
        try {
            boolean notifyNow;
            boolean bl = notifyNow = this.getITelephony() != null;
            if (listener.mSubId == null) {
                listener.mSubId = this.mSubId;
            }
            sRegistry.listenForSubscriber(listener.mSubId, this.getOpPackageName(), listener.callback, events, notifyNow);
        }
        catch (RemoteException remoteException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public int getCdmaEriIconIndex() {
        return this.getCdmaEriIconIndex(this.getSubId());
    }

    public int getCdmaEriIconIndex(int subId) {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony == null) {
                return -1;
            }
            return telephony.getCdmaEriIconIndexForSubscriber(subId, this.getOpPackageName());
        }
        catch (RemoteException ex) {
            return -1;
        }
        catch (NullPointerException ex) {
            return -1;
        }
    }

    public int getCdmaEriIconMode() {
        return this.getCdmaEriIconMode(this.getSubId());
    }

    public int getCdmaEriIconMode(int subId) {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony == null) {
                return -1;
            }
            return telephony.getCdmaEriIconModeForSubscriber(subId, this.getOpPackageName());
        }
        catch (RemoteException ex) {
            return -1;
        }
        catch (NullPointerException ex) {
            return -1;
        }
    }

    public String getCdmaEriText() {
        return this.getCdmaEriText(this.getSubId());
    }

    public String getCdmaEriText(int subId) {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony == null) {
                return null;
            }
            return telephony.getCdmaEriTextForSubscriber(subId, this.getOpPackageName());
        }
        catch (RemoteException ex) {
            return null;
        }
        catch (NullPointerException ex) {
            return null;
        }
    }

    public boolean isVoiceCapable() {
        if (this.mContext == null) {
            return true;
        }
        return this.mContext.getResources().getBoolean(17957053);
    }

    public boolean isSmsCapable() {
        if (this.mContext == null) {
            return true;
        }
        return this.mContext.getResources().getBoolean(17957013);
    }

    public List<CellInfo> getAllCellInfo() {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony == null) {
                return null;
            }
            return telephony.getAllCellInfo(this.getOpPackageName());
        }
        catch (RemoteException ex) {
            return null;
        }
        catch (NullPointerException ex) {
            return null;
        }
    }

    public void setCellInfoListRate(int rateInMillis) {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                telephony.setCellInfoListRate(rateInMillis);
            }
        }
        catch (RemoteException remoteException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public String getMmsUserAgent() {
        if (this.mContext == null) {
            return null;
        }
        return this.mContext.getResources().getString(17039676);
    }

    public String getMmsUAProfUrl() {
        if (this.mContext == null) {
            return null;
        }
        return this.mContext.getResources().getString(17039677);
    }

    @Deprecated
    public IccOpenLogicalChannelResponse iccOpenLogicalChannel(String AID) {
        return this.iccOpenLogicalChannel(this.getSubId(), AID, -1);
    }

    public IccOpenLogicalChannelResponse iccOpenLogicalChannel(String AID, int p2) {
        return this.iccOpenLogicalChannel(this.getSubId(), AID, p2);
    }

    public IccOpenLogicalChannelResponse iccOpenLogicalChannel(int subId, String AID, int p2) {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                return telephony.iccOpenLogicalChannel(subId, this.getOpPackageName(), AID, p2);
            }
        }
        catch (RemoteException remoteException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return null;
    }

    public boolean iccCloseLogicalChannel(int channel) {
        return this.iccCloseLogicalChannel(this.getSubId(), channel);
    }

    public boolean iccCloseLogicalChannel(int subId, int channel) {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                return telephony.iccCloseLogicalChannel(subId, channel);
            }
        }
        catch (RemoteException remoteException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return false;
    }

    public String iccTransmitApduLogicalChannel(int channel, int cla, int instruction, int p1, int p2, int p3, String data) {
        return this.iccTransmitApduLogicalChannel(this.getSubId(), channel, cla, instruction, p1, p2, p3, data);
    }

    public String iccTransmitApduLogicalChannel(int subId, int channel, int cla, int instruction, int p1, int p2, int p3, String data) {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                return telephony.iccTransmitApduLogicalChannel(subId, channel, cla, instruction, p1, p2, p3, data);
            }
        }
        catch (RemoteException remoteException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return "";
    }

    public String iccTransmitApduBasicChannel(int cla, int instruction, int p1, int p2, int p3, String data) {
        return this.iccTransmitApduBasicChannel(this.getSubId(), cla, instruction, p1, p2, p3, data);
    }

    public String iccTransmitApduBasicChannel(int subId, int cla, int instruction, int p1, int p2, int p3, String data) {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                return telephony.iccTransmitApduBasicChannel(subId, cla, instruction, p1, p2, p3, data);
            }
        }
        catch (RemoteException remoteException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return "";
    }

    public byte[] iccExchangeSimIO(int fileID, int command, int p1, int p2, int p3, String filePath) {
        return this.iccExchangeSimIO(this.getSubId(), fileID, command, p1, p2, p3, filePath);
    }

    public byte[] iccExchangeSimIO(int subId, int fileID, int command, int p1, int p2, int p3, String filePath) {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                return telephony.iccExchangeSimIO(subId, fileID, command, p1, p2, p3, filePath);
            }
        }
        catch (RemoteException remoteException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return null;
    }

    public String sendEnvelopeWithStatus(String content) {
        return this.sendEnvelopeWithStatus(this.getSubId(), content);
    }

    public String sendEnvelopeWithStatus(int subId, String content) {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                return telephony.sendEnvelopeWithStatus(subId, content);
            }
        }
        catch (RemoteException remoteException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return "";
    }

    public String nvReadItem(int itemID) {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                return telephony.nvReadItem(itemID);
            }
        }
        catch (RemoteException ex) {
            Rlog.e(TAG, "nvReadItem RemoteException", ex);
        }
        catch (NullPointerException ex) {
            Rlog.e(TAG, "nvReadItem NPE", ex);
        }
        return "";
    }

    public boolean nvWriteItem(int itemID, String itemValue) {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                return telephony.nvWriteItem(itemID, itemValue);
            }
        }
        catch (RemoteException ex) {
            Rlog.e(TAG, "nvWriteItem RemoteException", ex);
        }
        catch (NullPointerException ex) {
            Rlog.e(TAG, "nvWriteItem NPE", ex);
        }
        return false;
    }

    public boolean nvWriteCdmaPrl(byte[] preferredRoamingList) {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                return telephony.nvWriteCdmaPrl(preferredRoamingList);
            }
        }
        catch (RemoteException ex) {
            Rlog.e(TAG, "nvWriteCdmaPrl RemoteException", ex);
        }
        catch (NullPointerException ex) {
            Rlog.e(TAG, "nvWriteCdmaPrl NPE", ex);
        }
        return false;
    }

    public boolean nvResetConfig(int resetType) {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                return telephony.nvResetConfig(resetType);
            }
        }
        catch (RemoteException ex) {
            Rlog.e(TAG, "nvResetConfig RemoteException", ex);
        }
        catch (NullPointerException ex) {
            Rlog.e(TAG, "nvResetConfig NPE", ex);
        }
        return false;
    }

    private int getSubId() {
        if (SubscriptionManager.isUsableSubIdValue(this.mSubId)) {
            return this.mSubId;
        }
        return SubscriptionManager.getDefaultSubscriptionId();
    }

    private int getSubId(int preferredSubId) {
        if (SubscriptionManager.isUsableSubIdValue(this.mSubId)) {
            return this.mSubId;
        }
        return preferredSubId;
    }

    private int getPhoneId() {
        return SubscriptionManager.getPhoneId(this.getSubId());
    }

    private int getPhoneId(int preferredSubId) {
        return SubscriptionManager.getPhoneId(this.getSubId(preferredSubId));
    }

    @VisibleForTesting
    public int getSlotIndex() {
        int slotIndex = SubscriptionManager.getSlotIndex(this.getSubId());
        if (slotIndex == -1) {
            slotIndex = Integer.MAX_VALUE;
        }
        return slotIndex;
    }

    public static void setTelephonyProperty(int phoneId, String property, String value) {
        int i;
        String propVal = "";
        String[] p = null;
        String prop = SystemProperties.get(property);
        if (value == null) {
            value = "";
        }
        if (prop != null) {
            p = prop.split(",");
        }
        if (!SubscriptionManager.isValidPhoneId(phoneId)) {
            Rlog.d(TAG, "setTelephonyProperty: invalid phoneId=" + phoneId + " property=" + property + " value: " + value + " prop=" + prop);
            return;
        }
        for (i = 0; i < phoneId; ++i) {
            String str = "";
            if (p != null && i < p.length) {
                str = p[i];
            }
            propVal = propVal + str + ",";
        }
        propVal = propVal + value;
        if (p != null) {
            for (i = phoneId + 1; i < p.length; ++i) {
                propVal = propVal + "," + p[i];
            }
        }
        if (propVal.length() > 91) {
            Rlog.d(TAG, "setTelephonyProperty: property too long phoneId=" + phoneId + " property=" + property + " value: " + value + " propVal=" + propVal);
            return;
        }
        Rlog.d(TAG, "setTelephonyProperty: success phoneId=" + phoneId + " property=" + property + " value: " + value + " propVal=" + propVal);
        SystemProperties.set(property, propVal);
    }

    public static int getIntAtIndex(ContentResolver cr, String name, int index) throws Settings.SettingNotFoundException {
        String v = Settings.Global.getString(cr, name);
        if (v != null) {
            String[] valArray = v.split(",");
            if (index >= 0 && index < valArray.length && valArray[index] != null) {
                try {
                    return Integer.parseInt(valArray[index]);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        throw new Settings.SettingNotFoundException(name);
    }

    public static boolean putIntAtIndex(ContentResolver cr, String name, int index, int value) {
        int i;
        String data = "";
        String[] valArray = null;
        String v = Settings.Global.getString(cr, name);
        if (index == Integer.MAX_VALUE) {
            throw new RuntimeException("putIntAtIndex index == MAX_VALUE index=" + index);
        }
        if (index < 0) {
            throw new RuntimeException("putIntAtIndex index < 0 index=" + index);
        }
        if (v != null) {
            valArray = v.split(",");
        }
        for (i = 0; i < index; ++i) {
            String str = "";
            if (valArray != null && i < valArray.length) {
                str = valArray[i];
            }
            data = data + str + ",";
        }
        data = data + value;
        if (valArray != null) {
            for (i = index + 1; i < valArray.length; ++i) {
                data = data + "," + valArray[i];
            }
        }
        return Settings.Global.putString(cr, name, data);
    }

    public static String getTelephonyProperty(int phoneId, String property, String defaultVal) {
        String propVal = null;
        String prop = SystemProperties.get(property);
        if (prop != null && prop.length() > 0) {
            String[] values = prop.split(",");
            if (phoneId >= 0 && phoneId < values.length && values[phoneId] != null) {
                propVal = values[phoneId];
            }
        }
        return propVal == null ? defaultVal : propVal;
    }

    public int getSimCount() {
        if (this.isMultiSimEnabled()) {
            return 2;
        }
        return 1;
    }

    public String getIsimIst() {
        try {
            IPhoneSubInfo info = this.getSubscriberInfo();
            if (info == null) {
                return null;
            }
            return info.getIsimIst(this.getSubId());
        }
        catch (RemoteException ex) {
            return null;
        }
        catch (NullPointerException ex) {
            return null;
        }
    }

    public String[] getIsimPcscf() {
        try {
            IPhoneSubInfo info = this.getSubscriberInfo();
            if (info == null) {
                return null;
            }
            return info.getIsimPcscf(this.getSubId());
        }
        catch (RemoteException ex) {
            return null;
        }
        catch (NullPointerException ex) {
            return null;
        }
    }

    public String getIsimChallengeResponse(String nonce) {
        try {
            IPhoneSubInfo info = this.getSubscriberInfo();
            if (info == null) {
                return null;
            }
            return info.getIsimChallengeResponse(nonce);
        }
        catch (RemoteException ex) {
            return null;
        }
        catch (NullPointerException ex) {
            return null;
        }
    }

    public String getIccAuthentication(int appType, int authType, String data) {
        return this.getIccAuthentication(this.getSubId(), appType, authType, data);
    }

    public String getIccAuthentication(int subId, int appType, int authType, String data) {
        try {
            IPhoneSubInfo info = this.getSubscriberInfo();
            if (info == null) {
                return null;
            }
            return info.getIccSimChallengeResponse(subId, appType, authType, data);
        }
        catch (RemoteException ex) {
            return null;
        }
        catch (NullPointerException ex) {
            return null;
        }
    }

    public String[] getForbiddenPlmns() {
        return this.getForbiddenPlmns(this.getSubId(), 2);
    }

    public String[] getForbiddenPlmns(int subId, int appType) {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony == null) {
                return null;
            }
            return telephony.getForbiddenPlmns(subId, appType);
        }
        catch (RemoteException ex) {
            return null;
        }
        catch (NullPointerException ex) {
            return null;
        }
    }

    public String[] getPcscfAddress(String apnType) {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony == null) {
                return new String[0];
            }
            return telephony.getPcscfAddress(apnType, this.getOpPackageName());
        }
        catch (RemoteException e) {
            return new String[0];
        }
    }

    public IImsServiceController getImsServiceControllerAndListen(int slotIndex, int feature, IImsServiceFeatureListener callback) {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                return telephony.getImsServiceControllerAndListen(slotIndex, feature, callback);
            }
        }
        catch (RemoteException e) {
            Rlog.e(TAG, "getImsServiceControllerAndListen, RemoteException: " + e.getMessage());
        }
        return null;
    }

    public void setImsRegistrationState(boolean registered) {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                telephony.setImsRegistrationState(registered);
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public int getPreferredNetworkType(int subId) {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                return telephony.getPreferredNetworkType(subId);
            }
        }
        catch (RemoteException ex) {
            Rlog.e(TAG, "getPreferredNetworkType RemoteException", ex);
        }
        catch (NullPointerException ex) {
            Rlog.e(TAG, "getPreferredNetworkType NPE", ex);
        }
        return -1;
    }

    public void setNetworkSelectionModeAutomatic(int subId) {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                telephony.setNetworkSelectionModeAutomatic(subId);
            }
        }
        catch (RemoteException ex) {
            Rlog.e(TAG, "setNetworkSelectionModeAutomatic RemoteException", ex);
        }
        catch (NullPointerException ex) {
            Rlog.e(TAG, "setNetworkSelectionModeAutomatic NPE", ex);
        }
    }

    public CellNetworkScanResult getCellNetworkScanResults(int subId) {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                return telephony.getCellNetworkScanResults(subId);
            }
        }
        catch (RemoteException ex) {
            Rlog.e(TAG, "getCellNetworkScanResults RemoteException", ex);
        }
        catch (NullPointerException ex) {
            Rlog.e(TAG, "getCellNetworkScanResults NPE", ex);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NetworkScan requestNetworkScan(NetworkScanRequest request, TelephonyScanManager.NetworkScanCallback callback) {
        TelephonyManager telephonyManager = this;
        synchronized (telephonyManager) {
            if (this.mTelephonyScanManager == null) {
                this.mTelephonyScanManager = new TelephonyScanManager();
            }
        }
        return this.mTelephonyScanManager.requestNetworkScan(this.getSubId(), request, callback);
    }

    public boolean setNetworkSelectionModeManual(int subId, OperatorInfo operator, boolean persistSelection) {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                return telephony.setNetworkSelectionModeManual(subId, operator, persistSelection);
            }
        }
        catch (RemoteException ex) {
            Rlog.e(TAG, "setNetworkSelectionModeManual RemoteException", ex);
        }
        catch (NullPointerException ex) {
            Rlog.e(TAG, "setNetworkSelectionModeManual NPE", ex);
        }
        return false;
    }

    public boolean setPreferredNetworkType(int subId, int networkType) {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                return telephony.setPreferredNetworkType(subId, networkType);
            }
        }
        catch (RemoteException ex) {
            Rlog.e(TAG, "setPreferredNetworkType RemoteException", ex);
        }
        catch (NullPointerException ex) {
            Rlog.e(TAG, "setPreferredNetworkType NPE", ex);
        }
        return false;
    }

    public boolean setPreferredNetworkTypeToGlobal() {
        return this.setPreferredNetworkTypeToGlobal(this.getSubId());
    }

    public boolean setPreferredNetworkTypeToGlobal(int subId) {
        return this.setPreferredNetworkType(subId, 10);
    }

    public int getTetherApnRequired() {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                return telephony.getTetherApnRequired();
            }
        }
        catch (RemoteException ex) {
            Rlog.e(TAG, "hasMatchedTetherApnSetting RemoteException", ex);
        }
        catch (NullPointerException ex) {
            Rlog.e(TAG, "hasMatchedTetherApnSetting NPE", ex);
        }
        return 2;
    }

    public boolean hasCarrierPrivileges() {
        return this.hasCarrierPrivileges(this.getSubId());
    }

    public boolean hasCarrierPrivileges(int subId) {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                return telephony.getCarrierPrivilegeStatus(this.mSubId) == 1;
            }
        }
        catch (RemoteException ex) {
            Rlog.e(TAG, "hasCarrierPrivileges RemoteException", ex);
        }
        catch (NullPointerException ex) {
            Rlog.e(TAG, "hasCarrierPrivileges NPE", ex);
        }
        return false;
    }

    public boolean setOperatorBrandOverride(String brand) {
        return this.setOperatorBrandOverride(this.getSubId(), brand);
    }

    public boolean setOperatorBrandOverride(int subId, String brand) {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                return telephony.setOperatorBrandOverride(subId, brand);
            }
        }
        catch (RemoteException ex) {
            Rlog.e(TAG, "setOperatorBrandOverride RemoteException", ex);
        }
        catch (NullPointerException ex) {
            Rlog.e(TAG, "setOperatorBrandOverride NPE", ex);
        }
        return false;
    }

    public boolean setRoamingOverride(List<String> gsmRoamingList, List<String> gsmNonRoamingList, List<String> cdmaRoamingList, List<String> cdmaNonRoamingList) {
        return this.setRoamingOverride(this.getSubId(), gsmRoamingList, gsmNonRoamingList, cdmaRoamingList, cdmaNonRoamingList);
    }

    public boolean setRoamingOverride(int subId, List<String> gsmRoamingList, List<String> gsmNonRoamingList, List<String> cdmaRoamingList, List<String> cdmaNonRoamingList) {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                return telephony.setRoamingOverride(subId, gsmRoamingList, gsmNonRoamingList, cdmaRoamingList, cdmaNonRoamingList);
            }
        }
        catch (RemoteException ex) {
            Rlog.e(TAG, "setRoamingOverride RemoteException", ex);
        }
        catch (NullPointerException ex) {
            Rlog.e(TAG, "setRoamingOverride NPE", ex);
        }
        return false;
    }

    public String getCdmaMdn() {
        return this.getCdmaMdn(this.getSubId());
    }

    public String getCdmaMdn(int subId) {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony == null) {
                return null;
            }
            return telephony.getCdmaMdn(subId);
        }
        catch (RemoteException ex) {
            return null;
        }
        catch (NullPointerException ex) {
            return null;
        }
    }

    public String getCdmaMin() {
        return this.getCdmaMin(this.getSubId());
    }

    public String getCdmaMin(int subId) {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony == null) {
                return null;
            }
            return telephony.getCdmaMin(subId);
        }
        catch (RemoteException ex) {
            return null;
        }
        catch (NullPointerException ex) {
            return null;
        }
    }

    @SuppressLint(value={"Doclava125"})
    public int checkCarrierPrivilegesForPackage(String pkgName) {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                return telephony.checkCarrierPrivilegesForPackage(pkgName);
            }
        }
        catch (RemoteException ex) {
            Rlog.e(TAG, "checkCarrierPrivilegesForPackage RemoteException", ex);
        }
        catch (NullPointerException ex) {
            Rlog.e(TAG, "checkCarrierPrivilegesForPackage NPE", ex);
        }
        return 0;
    }

    @SuppressLint(value={"Doclava125"})
    public int checkCarrierPrivilegesForPackageAnyPhone(String pkgName) {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                return telephony.checkCarrierPrivilegesForPackageAnyPhone(pkgName);
            }
        }
        catch (RemoteException ex) {
            Rlog.e(TAG, "checkCarrierPrivilegesForPackageAnyPhone RemoteException", ex);
        }
        catch (NullPointerException ex) {
            Rlog.e(TAG, "checkCarrierPrivilegesForPackageAnyPhone NPE", ex);
        }
        return 0;
    }

    public List<String> getCarrierPackageNamesForIntent(Intent intent) {
        return this.getCarrierPackageNamesForIntentAndPhone(intent, this.getPhoneId());
    }

    public List<String> getCarrierPackageNamesForIntentAndPhone(Intent intent, int phoneId) {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                return telephony.getCarrierPackageNamesForIntentAndPhone(intent, phoneId);
            }
        }
        catch (RemoteException ex) {
            Rlog.e(TAG, "getCarrierPackageNamesForIntentAndPhone RemoteException", ex);
        }
        catch (NullPointerException ex) {
            Rlog.e(TAG, "getCarrierPackageNamesForIntentAndPhone NPE", ex);
        }
        return null;
    }

    public List<String> getPackagesWithCarrierPrivileges() {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                return telephony.getPackagesWithCarrierPrivileges();
            }
        }
        catch (RemoteException ex) {
            Rlog.e(TAG, "getPackagesWithCarrierPrivileges RemoteException", ex);
        }
        catch (NullPointerException ex) {
            Rlog.e(TAG, "getPackagesWithCarrierPrivileges NPE", ex);
        }
        return Collections.EMPTY_LIST;
    }

    @SuppressLint(value={"Doclava125"})
    public void dial(String number) {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                telephony.dial(number);
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error calling ITelephony#dial", e);
        }
    }

    @Deprecated
    public void call(String callingPackage, String number) {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                telephony.call(callingPackage, number);
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error calling ITelephony#call", e);
        }
    }

    @Deprecated
    public boolean endCall() {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                return telephony.endCall();
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error calling ITelephony#endCall", e);
        }
        return false;
    }

    @Deprecated
    public void answerRingingCall() {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                telephony.answerRingingCall();
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error calling ITelephony#answerRingingCall", e);
        }
    }

    @Deprecated
    @SuppressLint(value={"Doclava125"})
    public void silenceRinger() {
        try {
            this.getTelecomService().silenceRinger(this.getOpPackageName());
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error calling ITelecomService#silenceRinger", e);
        }
    }

    public boolean isOffhook() {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                return telephony.isOffhook(this.getOpPackageName());
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error calling ITelephony#isOffhook", e);
        }
        return false;
    }

    public boolean isRinging() {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                return telephony.isRinging(this.getOpPackageName());
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error calling ITelephony#isRinging", e);
        }
        return false;
    }

    public boolean isIdle() {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                return telephony.isIdle(this.getOpPackageName());
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error calling ITelephony#isIdle", e);
        }
        return true;
    }

    public boolean isRadioOn() {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                return telephony.isRadioOn(this.getOpPackageName());
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error calling ITelephony#isRadioOn", e);
        }
        return false;
    }

    public boolean supplyPin(String pin) {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                return telephony.supplyPin(pin);
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error calling ITelephony#supplyPin", e);
        }
        return false;
    }

    public boolean supplyPuk(String puk, String pin) {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                return telephony.supplyPuk(puk, pin);
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error calling ITelephony#supplyPuk", e);
        }
        return false;
    }

    public int[] supplyPinReportResult(String pin) {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                return telephony.supplyPinReportResult(pin);
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error calling ITelephony#supplyPinReportResult", e);
        }
        return new int[0];
    }

    public int[] supplyPukReportResult(String puk, String pin) {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                return telephony.supplyPukReportResult(puk, pin);
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error calling ITelephony#]", e);
        }
        return new int[0];
    }

    public void sendUssdRequest(String ussdRequest, final UssdResponseCallback callback, Handler handler) {
        Preconditions.checkNotNull(callback, "UssdResponseCallback cannot be null.");
        final TelephonyManager telephonyManager = this;
        ResultReceiver wrappedCallback = new ResultReceiver(handler){

            @Override
            protected void onReceiveResult(int resultCode, Bundle ussdResponse) {
                Rlog.d(TelephonyManager.TAG, "USSD:" + resultCode);
                Preconditions.checkNotNull(ussdResponse, "ussdResponse cannot be null.");
                UssdResponse response = (UssdResponse)ussdResponse.getParcelable(TelephonyManager.USSD_RESPONSE);
                if (resultCode == 100) {
                    callback.onReceiveUssdResponse(telephonyManager, response.getUssdRequest(), response.getReturnMessage());
                } else {
                    callback.onReceiveUssdResponseFailed(telephonyManager, response.getUssdRequest(), resultCode);
                }
            }
        };
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                telephony.handleUssdRequest(this.getSubId(), ussdRequest, wrappedCallback);
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error calling ITelephony#sendUSSDCode", e);
            UssdResponse response = new UssdResponse(ussdRequest, "");
            Bundle returnData = new Bundle();
            returnData.putParcelable(USSD_RESPONSE, response);
            wrappedCallback.send(-2, returnData);
        }
    }

    public boolean isConcurrentVoiceAndDataSupported() {
        try {
            ITelephony telephony = this.getITelephony();
            return telephony == null ? false : telephony.isConcurrentVoiceAndDataAllowed(this.getSubId());
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error calling ITelephony#isConcurrentVoiceAndDataAllowed", e);
            return false;
        }
    }

    public boolean handlePinMmi(String dialString) {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                return telephony.handlePinMmi(dialString);
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error calling ITelephony#handlePinMmi", e);
        }
        return false;
    }

    public boolean handlePinMmiForSubscriber(int subId, String dialString) {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                return telephony.handlePinMmiForSubscriber(subId, dialString);
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error calling ITelephony#handlePinMmi", e);
        }
        return false;
    }

    public void toggleRadioOnOff() {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                telephony.toggleRadioOnOff();
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error calling ITelephony#toggleRadioOnOff", e);
        }
    }

    public boolean setRadio(boolean turnOn) {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                return telephony.setRadio(turnOn);
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error calling ITelephony#setRadio", e);
        }
        return false;
    }

    public boolean setRadioPower(boolean turnOn) {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                return telephony.setRadioPower(turnOn);
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error calling ITelephony#setRadioPower", e);
        }
        return false;
    }

    @SuppressLint(value={"Doclava125"})
    public void updateServiceLocation() {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                telephony.updateServiceLocation();
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error calling ITelephony#updateServiceLocation", e);
        }
    }

    public boolean enableDataConnectivity() {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                return telephony.enableDataConnectivity();
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error calling ITelephony#enableDataConnectivity", e);
        }
        return false;
    }

    public boolean disableDataConnectivity() {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                return telephony.disableDataConnectivity();
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error calling ITelephony#disableDataConnectivity", e);
        }
        return false;
    }

    public boolean isDataConnectivityPossible() {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                return telephony.isDataConnectivityPossible(this.getSubId(SubscriptionManager.getDefaultDataSubscriptionId()));
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error calling ITelephony#isDataAllowed", e);
        }
        return false;
    }

    public boolean needsOtaServiceProvisioning() {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                return telephony.needsOtaServiceProvisioning();
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error calling ITelephony#needsOtaServiceProvisioning", e);
        }
        return false;
    }

    public void setDataEnabled(boolean enable) {
        this.setDataEnabled(this.getSubId(SubscriptionManager.getDefaultDataSubscriptionId()), enable);
    }

    public void setDataEnabled(int subId, boolean enable) {
        try {
            Log.d(TAG, "setDataEnabled: enabled=" + enable);
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                telephony.setDataEnabled(subId, enable);
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error calling ITelephony#setDataEnabled", e);
        }
    }

    @Deprecated
    public boolean getDataEnabled() {
        return this.isDataEnabled();
    }

    public boolean isDataEnabled() {
        return this.getDataEnabled(this.getSubId(SubscriptionManager.getDefaultDataSubscriptionId()));
    }

    public boolean getDataEnabled(int subId) {
        boolean retVal = false;
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                retVal = telephony.getDataEnabled(subId);
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error calling ITelephony#getDataEnabled", e);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return retVal;
    }

    @Deprecated
    public int invokeOemRilRequestRaw(byte[] oemReq, byte[] oemResp) {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                return telephony.invokeOemRilRequestRaw(oemReq, oemResp);
            }
        }
        catch (RemoteException remoteException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return -1;
    }

    public void enableVideoCalling(boolean enable) {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                telephony.enableVideoCalling(enable);
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error calling ITelephony#enableVideoCalling", e);
        }
    }

    public boolean isVideoCallingEnabled() {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                return telephony.isVideoCallingEnabled(this.getOpPackageName());
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error calling ITelephony#isVideoCallingEnabled", e);
        }
        return false;
    }

    public boolean canChangeDtmfToneLength() {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                return telephony.canChangeDtmfToneLength();
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error calling ITelephony#canChangeDtmfToneLength", e);
        }
        catch (SecurityException e) {
            Log.e(TAG, "Permission error calling ITelephony#canChangeDtmfToneLength", e);
        }
        return false;
    }

    public boolean isWorldPhone() {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                return telephony.isWorldPhone();
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error calling ITelephony#isWorldPhone", e);
        }
        catch (SecurityException e) {
            Log.e(TAG, "Permission error calling ITelephony#isWorldPhone", e);
        }
        return false;
    }

    @Deprecated
    public boolean isTtyModeSupported() {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                return telephony.isTtyModeSupported();
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error calling ITelephony#isTtyModeSupported", e);
        }
        catch (SecurityException e) {
            Log.e(TAG, "Permission error calling ITelephony#isTtyModeSupported", e);
        }
        return false;
    }

    public boolean isHearingAidCompatibilitySupported() {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                return telephony.isHearingAidCompatibilitySupported();
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error calling ITelephony#isHearingAidCompatibilitySupported", e);
        }
        catch (SecurityException e) {
            Log.e(TAG, "Permission error calling ITelephony#isHearingAidCompatibilitySupported", e);
        }
        return false;
    }

    public boolean isImsRegistered() {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony == null) {
                return false;
            }
            return telephony.isImsRegistered();
        }
        catch (RemoteException ex) {
            return false;
        }
        catch (NullPointerException ex) {
            return false;
        }
    }

    public boolean isImsRegistered(int subId) {
        try {
            return this.getITelephony().isImsRegisteredForSubscriber(subId);
        }
        catch (RemoteException ex) {
            return false;
        }
        catch (NullPointerException ex) {
            return false;
        }
    }

    public boolean isVolteAvailable() {
        try {
            return this.getITelephony().isVolteAvailable();
        }
        catch (RemoteException ex) {
            return false;
        }
        catch (NullPointerException ex) {
            return false;
        }
    }

    public boolean isVideoTelephonyAvailable() {
        try {
            return this.getITelephony().isVideoTelephonyAvailable();
        }
        catch (RemoteException ex) {
            return false;
        }
        catch (NullPointerException ex) {
            return false;
        }
    }

    public boolean isWifiCallingAvailable() {
        try {
            return this.getITelephony().isWifiCallingAvailable();
        }
        catch (RemoteException ex) {
            return false;
        }
        catch (NullPointerException ex) {
            return false;
        }
    }

    public void setSimOperatorNumeric(String numeric) {
        int phoneId = this.getPhoneId();
        this.setSimOperatorNumericForPhone(phoneId, numeric);
    }

    public void setSimOperatorNumericForPhone(int phoneId, String numeric) {
        TelephonyManager.setTelephonyProperty(phoneId, "gsm.sim.operator.numeric", numeric);
    }

    public void setSimOperatorName(String name) {
        int phoneId = this.getPhoneId();
        this.setSimOperatorNameForPhone(phoneId, name);
    }

    public void setSimOperatorNameForPhone(int phoneId, String name) {
        TelephonyManager.setTelephonyProperty(phoneId, "gsm.sim.operator.alpha", name);
    }

    public void setSimCountryIso(String iso) {
        int phoneId = this.getPhoneId();
        this.setSimCountryIsoForPhone(phoneId, iso);
    }

    public void setSimCountryIsoForPhone(int phoneId, String iso) {
        TelephonyManager.setTelephonyProperty(phoneId, "gsm.sim.operator.iso-country", iso);
    }

    public void setSimState(String state) {
        int phoneId = this.getPhoneId();
        this.setSimStateForPhone(phoneId, state);
    }

    public void setSimStateForPhone(int phoneId, String state) {
        TelephonyManager.setTelephonyProperty(phoneId, "gsm.sim.state", state);
    }

    public void setSimPowerState(int state) {
        this.setSimPowerStateForSlot(this.getSlotIndex(), state);
    }

    public void setSimPowerStateForSlot(int slotIndex, int state) {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                telephony.setSimPowerStateForSlot(slotIndex, state);
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error calling ITelephony#setSimPowerStateForSlot", e);
        }
        catch (SecurityException e) {
            Log.e(TAG, "Permission error calling ITelephony#setSimPowerStateForSlot", e);
        }
    }

    public void setBasebandVersion(String version) {
        int phoneId = this.getPhoneId();
        this.setBasebandVersionForPhone(phoneId, version);
    }

    public void setBasebandVersionForPhone(int phoneId, String version) {
        if (SubscriptionManager.isValidPhoneId(phoneId)) {
            String prop = "gsm.version.baseband" + (phoneId == 0 ? "" : Integer.toString(phoneId));
            SystemProperties.set(prop, version);
        }
    }

    public void setPhoneType(int type) {
        int phoneId = this.getPhoneId();
        this.setPhoneType(phoneId, type);
    }

    public void setPhoneType(int phoneId, int type) {
        if (SubscriptionManager.isValidPhoneId(phoneId)) {
            TelephonyManager.setTelephonyProperty(phoneId, "gsm.current.phone-type", String.valueOf(type));
        }
    }

    public String getOtaSpNumberSchema(String defaultValue) {
        int phoneId = this.getPhoneId();
        return this.getOtaSpNumberSchemaForPhone(phoneId, defaultValue);
    }

    public String getOtaSpNumberSchemaForPhone(int phoneId, String defaultValue) {
        if (SubscriptionManager.isValidPhoneId(phoneId)) {
            return TelephonyManager.getTelephonyProperty(phoneId, "ro.cdma.otaspnumschema", defaultValue);
        }
        return defaultValue;
    }

    public boolean getSmsReceiveCapable(boolean defaultValue) {
        int phoneId = this.getPhoneId();
        return this.getSmsReceiveCapableForPhone(phoneId, defaultValue);
    }

    public boolean getSmsReceiveCapableForPhone(int phoneId, boolean defaultValue) {
        if (SubscriptionManager.isValidPhoneId(phoneId)) {
            return Boolean.parseBoolean(TelephonyManager.getTelephonyProperty(phoneId, "telephony.sms.receive", String.valueOf(defaultValue)));
        }
        return defaultValue;
    }

    public boolean getSmsSendCapable(boolean defaultValue) {
        int phoneId = this.getPhoneId();
        return this.getSmsSendCapableForPhone(phoneId, defaultValue);
    }

    public boolean getSmsSendCapableForPhone(int phoneId, boolean defaultValue) {
        if (SubscriptionManager.isValidPhoneId(phoneId)) {
            return Boolean.parseBoolean(TelephonyManager.getTelephonyProperty(phoneId, "telephony.sms.send", String.valueOf(defaultValue)));
        }
        return defaultValue;
    }

    public void setNetworkOperatorName(String name) {
        int phoneId = this.getPhoneId();
        this.setNetworkOperatorNameForPhone(phoneId, name);
    }

    public void setNetworkOperatorNameForPhone(int phoneId, String name) {
        if (SubscriptionManager.isValidPhoneId(phoneId)) {
            TelephonyManager.setTelephonyProperty(phoneId, "gsm.operator.alpha", name);
        }
    }

    public void setNetworkOperatorNumeric(String numeric) {
        int phoneId = this.getPhoneId();
        this.setNetworkOperatorNumericForPhone(phoneId, numeric);
    }

    public void setNetworkOperatorNumericForPhone(int phoneId, String numeric) {
        TelephonyManager.setTelephonyProperty(phoneId, "gsm.operator.numeric", numeric);
    }

    public void setNetworkRoaming(boolean isRoaming) {
        int phoneId = this.getPhoneId();
        this.setNetworkRoamingForPhone(phoneId, isRoaming);
    }

    public void setNetworkRoamingForPhone(int phoneId, boolean isRoaming) {
        if (SubscriptionManager.isValidPhoneId(phoneId)) {
            TelephonyManager.setTelephonyProperty(phoneId, "gsm.operator.isroaming", isRoaming ? "true" : "false");
        }
    }

    public void setNetworkCountryIso(String iso) {
        int phoneId = this.getPhoneId();
        this.setNetworkCountryIsoForPhone(phoneId, iso);
    }

    public void setNetworkCountryIsoForPhone(int phoneId, String iso) {
        if (SubscriptionManager.isValidPhoneId(phoneId)) {
            TelephonyManager.setTelephonyProperty(phoneId, "gsm.operator.iso-country", iso);
        }
    }

    public void setDataNetworkType(int type) {
        int phoneId = this.getPhoneId(SubscriptionManager.getDefaultDataSubscriptionId());
        this.setDataNetworkTypeForPhone(phoneId, type);
    }

    public void setDataNetworkTypeForPhone(int phoneId, int type) {
        if (SubscriptionManager.isValidPhoneId(phoneId)) {
            TelephonyManager.setTelephonyProperty(phoneId, "gsm.network.type", ServiceState.rilRadioTechnologyToString(type));
        }
    }

    public int getSubIdForPhoneAccount(PhoneAccount phoneAccount) {
        int retval = -1;
        try {
            ITelephony service = this.getITelephony();
            if (service != null) {
                retval = service.getSubIdForPhoneAccount(phoneAccount);
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return retval;
    }

    private int getSubIdForPhoneAccountHandle(PhoneAccountHandle phoneAccountHandle) {
        int retval = -1;
        try {
            ITelecomService service = this.getTelecomService();
            if (service != null) {
                retval = this.getSubIdForPhoneAccount(service.getPhoneAccount(phoneAccountHandle));
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return retval;
    }

    public void factoryReset(int subId) {
        try {
            Log.d(TAG, "factoryReset: subId=" + subId);
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                telephony.factoryReset(subId);
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public String getLocaleFromDefaultSim() {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                return telephony.getLocaleFromDefaultSim();
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return null;
    }

    public void requestModemActivityInfo(ResultReceiver result) {
        try {
            ITelephony service = this.getITelephony();
            if (service != null) {
                service.requestModemActivityInfo(result);
                return;
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error calling ITelephony#getModemActivityInfo", e);
        }
        result.send(0, null);
    }

    public ServiceState getServiceState() {
        return this.getServiceStateForSubscriber(this.getSubId());
    }

    public ServiceState getServiceStateForSubscriber(int subId) {
        try {
            ITelephony service = this.getITelephony();
            if (service != null) {
                return service.getServiceStateForSubscriber(subId, this.getOpPackageName());
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error calling ITelephony#getServiceStateForSubscriber", e);
        }
        return null;
    }

    public Uri getVoicemailRingtoneUri(PhoneAccountHandle accountHandle) {
        try {
            ITelephony service = this.getITelephony();
            if (service != null) {
                return service.getVoicemailRingtoneUri(accountHandle);
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error calling ITelephony#getVoicemailRingtoneUri", e);
        }
        return null;
    }

    public void setVoicemailRingtoneUri(PhoneAccountHandle phoneAccountHandle, Uri uri) {
        try {
            ITelephony service = this.getITelephony();
            if (service != null) {
                service.setVoicemailRingtoneUri(this.getOpPackageName(), phoneAccountHandle, uri);
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error calling ITelephony#setVoicemailRingtoneUri", e);
        }
    }

    public boolean isVoicemailVibrationEnabled(PhoneAccountHandle accountHandle) {
        try {
            ITelephony service = this.getITelephony();
            if (service != null) {
                return service.isVoicemailVibrationEnabled(accountHandle);
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error calling ITelephony#isVoicemailVibrationEnabled", e);
        }
        return false;
    }

    public void setVoicemailVibrationEnabled(PhoneAccountHandle phoneAccountHandle, boolean enabled) {
        try {
            ITelephony service = this.getITelephony();
            if (service != null) {
                service.setVoicemailVibrationEnabled(this.getOpPackageName(), phoneAccountHandle, enabled);
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error calling ITelephony#isVoicemailVibrationEnabled", e);
        }
    }

    public String getAidForAppType(int appType) {
        return this.getAidForAppType(this.getSubId(), appType);
    }

    public String getAidForAppType(int subId, int appType) {
        try {
            ITelephony service = this.getITelephony();
            if (service != null) {
                return service.getAidForAppType(subId, appType);
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error calling ITelephony#getAidForAppType", e);
        }
        return null;
    }

    public String getEsn() {
        return this.getEsn(this.getSubId());
    }

    public String getEsn(int subId) {
        try {
            ITelephony service = this.getITelephony();
            if (service != null) {
                return service.getEsn(subId);
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error calling ITelephony#getEsn", e);
        }
        return null;
    }

    public String getCdmaPrlVersion() {
        return this.getCdmaPrlVersion(this.getSubId());
    }

    public String getCdmaPrlVersion(int subId) {
        try {
            ITelephony service = this.getITelephony();
            if (service != null) {
                return service.getCdmaPrlVersion(subId);
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error calling ITelephony#getCdmaPrlVersion", e);
        }
        return null;
    }

    public List<TelephonyHistogram> getTelephonyHistograms() {
        try {
            ITelephony service = this.getITelephony();
            if (service != null) {
                return service.getTelephonyHistograms();
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error calling ITelephony#getTelephonyHistograms", e);
        }
        return null;
    }

    public int setAllowedCarriers(int slotIndex, List<CarrierIdentifier> carriers) {
        try {
            ITelephony service = this.getITelephony();
            if (service != null) {
                return service.setAllowedCarriers(slotIndex, carriers);
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error calling ITelephony#setAllowedCarriers", e);
        }
        catch (NullPointerException e) {
            Log.e(TAG, "Error calling ITelephony#setAllowedCarriers", e);
        }
        return -1;
    }

    public List<CarrierIdentifier> getAllowedCarriers(int slotIndex) {
        try {
            ITelephony service = this.getITelephony();
            if (service != null) {
                return service.getAllowedCarriers(slotIndex);
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error calling ITelephony#getAllowedCarriers", e);
        }
        catch (NullPointerException e) {
            Log.e(TAG, "Error calling ITelephony#getAllowedCarriers", e);
        }
        return new ArrayList<CarrierIdentifier>(0);
    }

    public void carrierActionSetMeteredApnsEnabled(int subId, boolean enabled) {
        try {
            ITelephony service = this.getITelephony();
            if (service != null) {
                service.carrierActionSetMeteredApnsEnabled(subId, enabled);
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error calling ITelephony#carrierActionSetMeteredApnsEnabled", e);
        }
    }

    public void carrierActionSetRadioEnabled(int subId, boolean enabled) {
        try {
            ITelephony service = this.getITelephony();
            if (service != null) {
                service.carrierActionSetRadioEnabled(subId, enabled);
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error calling ITelephony#carrierActionSetRadioEnabled", e);
        }
    }

    public void carrierActionReportDefaultNetworkStatus(int subId, boolean report) {
        try {
            ITelephony service = this.getITelephony();
            if (service != null) {
                service.carrierActionReportDefaultNetworkStatus(subId, report);
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error calling ITelephony#carrierActionReportDefaultNetworkStatus", e);
        }
    }

    public NetworkStats getVtDataUsage(int how) {
        boolean perUidStats = how == 1;
        try {
            ITelephony service = this.getITelephony();
            if (service != null) {
                return service.getVtDataUsage(this.getSubId(), perUidStats);
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error calling ITelephony#getVtDataUsage", e);
        }
        return null;
    }

    public void setPolicyDataEnabled(boolean enabled, int subId) {
        try {
            ITelephony service = this.getITelephony();
            if (service != null) {
                service.setPolicyDataEnabled(enabled, subId);
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error calling ITelephony#setPolicyDataEnabled", e);
        }
    }

    public List<ClientRequestStats> getClientRequestStats(int subId) {
        try {
            ITelephony service = this.getITelephony();
            if (service != null) {
                return service.getClientRequestStats(this.getOpPackageName(), subId);
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error calling ITelephony#getClientRequestStats", e);
        }
        return null;
    }

    public boolean getEmergencyCallbackMode() {
        return this.getEmergencyCallbackMode(this.getSubId());
    }

    public boolean getEmergencyCallbackMode(int subId) {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony == null) {
                return false;
            }
            return telephony.getEmergencyCallbackMode(subId);
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error calling ITelephony#getEmergencyCallbackMode", e);
            return false;
        }
    }

    public SignalStrength getSignalStrength() {
        try {
            ITelephony service = this.getITelephony();
            if (service != null) {
                return service.getSignalStrength(this.getSubId());
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error calling ITelephony#getSignalStrength", e);
        }
        return null;
    }

    static {
        multiSimConfig = SystemProperties.get("persist.radio.multisim.config");
        sInstance = new TelephonyManager();
        EXTRA_STATE_IDLE = PhoneConstants.State.IDLE.toString();
        EXTRA_STATE_RINGING = PhoneConstants.State.RINGING.toString();
        EXTRA_STATE_OFFHOOK = PhoneConstants.State.OFFHOOK.toString();
        sKernelCmdLine = TelephonyManager.getProcCmdLine();
        sProductTypePattern = Pattern.compile("\\sproduct_type\\s*=\\s*(\\w+)");
        sLteOnCdmaProductType = SystemProperties.get("telephony.lteOnCdmaProductType", "");
    }

    public static abstract class UssdResponseCallback {
        public void onReceiveUssdResponse(TelephonyManager telephonyManager, String request, CharSequence response) {
        }

        public void onReceiveUssdResponseFailed(TelephonyManager telephonyManager, String request, int failureCode) {
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Feature {
    }

    public static enum MultiSimVariants {
        DSDS,
        DSDA,
        TSTS,
        UNKNOWN;

    }

    public static interface WifiCallingChoices {
        public static final int ALWAYS_USE = 0;
        public static final int ASK_EVERY_TIME = 1;
        public static final int NEVER_USE = 2;
    }
}

