/*
 * Decompiled with CFR 0.152.
 */
package android.text;

import android.graphics.Paint;
import android.text.AndroidBidi;
import android.text.Spanned;
import android.text.StaticLayout;
import android.text.TextDirectionHeuristic;
import android.text.TextDirectionHeuristics;
import android.text.TextPaint;
import android.text.TextUtils;
import android.text.style.MetricAffectingSpan;
import android.text.style.ReplacementSpan;
import com.android.internal.util.ArrayUtils;

class MeasuredText {
    private static final boolean localLOGV = false;
    CharSequence mText;
    int mTextStart;
    float[] mWidths;
    char[] mChars;
    byte[] mLevels;
    int mDir;
    boolean mEasy;
    int mLen;
    private int mPos;
    private TextPaint mWorkPaint = new TextPaint();
    private StaticLayout.Builder mBuilder;
    private static final Object[] sLock = new Object[0];
    private static final MeasuredText[] sCached = new MeasuredText[3];

    private MeasuredText() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static MeasuredText obtain() {
        Object[] objectArray = sLock;
        synchronized (sLock) {
            int i = sCached.length;
            while (--i >= 0) {
                if (sCached[i] == null) continue;
                MeasuredText mt = sCached[i];
                MeasuredText.sCached[i] = null;
                // ** MonitorExit[var1] (shouldn't be in output)
                return mt;
            }
            // ** MonitorExit[var1] (shouldn't be in output)
            MeasuredText mt = new MeasuredText();
            return mt;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static MeasuredText recycle(MeasuredText mt) {
        mt.finish();
        Object[] objectArray = sLock;
        synchronized (sLock) {
            for (int i = 0; i < sCached.length; ++i) {
                if (sCached[i] != null) continue;
                MeasuredText.sCached[i] = mt;
                mt.mText = null;
                break;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return null;
        }
    }

    void finish() {
        this.mText = null;
        this.mBuilder = null;
        if (this.mLen > 1000) {
            this.mWidths = null;
            this.mChars = null;
            this.mLevels = null;
        }
    }

    void setPos(int pos) {
        this.mPos = pos - this.mTextStart;
    }

    void setPara(CharSequence text, int start, int end, TextDirectionHeuristic textDir, StaticLayout.Builder builder) {
        int len;
        this.mBuilder = builder;
        this.mText = text;
        this.mTextStart = start;
        this.mLen = len = end - start;
        this.mPos = 0;
        if (this.mWidths == null || this.mWidths.length < len) {
            this.mWidths = ArrayUtils.newUnpaddedFloatArray(len);
        }
        if (this.mChars == null || this.mChars.length < len) {
            this.mChars = ArrayUtils.newUnpaddedCharArray(len);
        }
        TextUtils.getChars(text, start, end, this.mChars, 0);
        if (text instanceof Spanned) {
            Spanned spanned = (Spanned)text;
            ReplacementSpan[] spans = spanned.getSpans(start, end, ReplacementSpan.class);
            for (int i = 0; i < spans.length; ++i) {
                int startInPara = spanned.getSpanStart(spans[i]) - start;
                int endInPara = spanned.getSpanEnd(spans[i]) - start;
                if (startInPara < 0) {
                    startInPara = 0;
                }
                if (endInPara > len) {
                    endInPara = len;
                }
                for (int j = startInPara; j < endInPara; ++j) {
                    this.mChars[j] = 65532;
                }
            }
        }
        if ((textDir == TextDirectionHeuristics.LTR || textDir == TextDirectionHeuristics.FIRSTSTRONG_LTR || textDir == TextDirectionHeuristics.ANYRTL_LTR) && TextUtils.doesNotNeedBidi(this.mChars, 0, len)) {
            this.mDir = 1;
            this.mEasy = true;
        } else {
            boolean isRtl;
            if (this.mLevels == null || this.mLevels.length < len) {
                this.mLevels = ArrayUtils.newUnpaddedByteArray(len);
            }
            int bidiRequest = textDir == TextDirectionHeuristics.LTR ? 1 : (textDir == TextDirectionHeuristics.RTL ? -1 : (textDir == TextDirectionHeuristics.FIRSTSTRONG_LTR ? 2 : (textDir == TextDirectionHeuristics.FIRSTSTRONG_RTL ? -2 : ((isRtl = textDir.isRtl(this.mChars, 0, len)) ? -1 : 1))));
            this.mDir = AndroidBidi.bidi(bidiRequest, this.mChars, this.mLevels, len, false);
            this.mEasy = false;
        }
    }

    float addStyleRun(TextPaint paint, int len, Paint.FontMetricsInt fm) {
        if (fm != null) {
            paint.getFontMetricsInt(fm);
        }
        int p = this.mPos;
        this.mPos = p + len;
        float[] widths = null;
        if (this.mBuilder == null || paint.getClass() != TextPaint.class) {
            widths = this.mWidths;
        }
        if (this.mEasy) {
            boolean isRtl = this.mDir != 1;
            float width = 0.0f;
            if (widths != null) {
                width = paint.getTextRunAdvances(this.mChars, p, len, p, len, isRtl, widths, p);
                if (this.mBuilder != null) {
                    this.mBuilder.addMeasuredRun(p, p + len, widths);
                }
            } else {
                width = this.mBuilder.addStyleRun(paint, p, p + len, isRtl);
            }
            return width;
        }
        float totalAdvance = 0.0f;
        byte level = this.mLevels[p];
        int q = p;
        int i = p + 1;
        int e = p + len;
        while (true) {
            if (i == e || this.mLevels[i] != level) {
                boolean isRtl;
                boolean bl = isRtl = (level & 1) != 0;
                if (widths != null) {
                    totalAdvance += paint.getTextRunAdvances(this.mChars, q, i - q, q, i - q, isRtl, widths, q);
                    if (this.mBuilder != null) {
                        this.mBuilder.addMeasuredRun(q, i, widths);
                    }
                } else {
                    totalAdvance += this.mBuilder.addStyleRun(paint, q, i, isRtl);
                }
                if (i == e) break;
                q = i;
                level = this.mLevels[i];
            }
            ++i;
        }
        return totalAdvance;
    }

    float addStyleRun(TextPaint paint, MetricAffectingSpan[] spans, int len, Paint.FontMetricsInt fm) {
        float wid;
        TextPaint workPaint = this.mWorkPaint;
        workPaint.set(paint);
        workPaint.baselineShift = 0;
        ReplacementSpan replacement = null;
        for (int i = 0; i < spans.length; ++i) {
            MetricAffectingSpan span = spans[i];
            if (span instanceof ReplacementSpan) {
                replacement = (ReplacementSpan)span;
                continue;
            }
            span.updateMeasureState(workPaint);
        }
        if (replacement == null) {
            wid = this.addStyleRun(workPaint, len, fm);
        } else {
            wid = replacement.getSize(workPaint, this.mText, this.mTextStart + this.mPos, this.mTextStart + this.mPos + len, fm);
            if (this.mBuilder == null) {
                float[] w = this.mWidths;
                w[this.mPos] = wid;
                int e = this.mPos + len;
                for (int i = this.mPos + 1; i < e; ++i) {
                    w[i] = 0.0f;
                }
            } else {
                this.mBuilder.addReplacementRun(this.mPos, this.mPos + len, wid);
            }
            this.mPos += len;
        }
        if (fm != null) {
            if (workPaint.baselineShift < 0) {
                fm.ascent += workPaint.baselineShift;
                fm.top += workPaint.baselineShift;
            } else {
                fm.descent += workPaint.baselineShift;
                fm.bottom += workPaint.baselineShift;
            }
        }
        return wid;
    }

    int breakText(int limit, boolean forwards, float width) {
        int i;
        float[] w = this.mWidths;
        if (forwards) {
            int i2;
            for (i2 = 0; i2 < limit && !((width -= w[i2]) < 0.0f); ++i2) {
            }
            while (i2 > 0 && this.mChars[i2 - 1] == ' ') {
                --i2;
            }
            return i2;
        }
        for (i = limit - 1; i >= 0 && !((width -= w[i]) < 0.0f); --i) {
        }
        while (i < limit - 1 && (this.mChars[i + 1] == ' ' || w[i + 1] == 0.0f)) {
            ++i;
        }
        return limit - i - 1;
    }

    float measure(int start, int limit) {
        float width = 0.0f;
        float[] w = this.mWidths;
        for (int i = start; i < limit; ++i) {
            width += w[i];
        }
        return width;
    }
}

