/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.content.Intent;
import android.content.res.ColorStateList;
import android.graphics.PorterDuff;
import android.graphics.drawable.Drawable;
import android.view.ActionProvider;
import android.view.ContextMenu;
import android.view.SubMenu;
import android.view.View;

public interface MenuItem {
    public static final int SHOW_AS_ACTION_NEVER = 0;
    public static final int SHOW_AS_ACTION_IF_ROOM = 1;
    public static final int SHOW_AS_ACTION_ALWAYS = 2;
    public static final int SHOW_AS_ACTION_WITH_TEXT = 4;
    public static final int SHOW_AS_ACTION_COLLAPSE_ACTION_VIEW = 8;
    public static final int SHOW_AS_OVERFLOW_ALWAYS = Integer.MIN_VALUE;

    public int getItemId();

    public int getGroupId();

    public int getOrder();

    public MenuItem setTitle(CharSequence var1);

    public MenuItem setTitle(int var1);

    public CharSequence getTitle();

    public MenuItem setTitleCondensed(CharSequence var1);

    public CharSequence getTitleCondensed();

    public MenuItem setIcon(Drawable var1);

    public MenuItem setIcon(int var1);

    public Drawable getIcon();

    default public MenuItem setIconTintList(ColorStateList tint) {
        return this;
    }

    default public ColorStateList getIconTintList() {
        return null;
    }

    default public MenuItem setIconTintMode(PorterDuff.Mode tintMode) {
        return this;
    }

    default public PorterDuff.Mode getIconTintMode() {
        return null;
    }

    public MenuItem setIntent(Intent var1);

    public Intent getIntent();

    public MenuItem setShortcut(char var1, char var2);

    default public MenuItem setShortcut(char numericChar, char alphaChar, int numericModifiers, int alphaModifiers) {
        if ((alphaModifiers & 0x1100F) == 4096 && (numericModifiers & 0x1100F) == 4096) {
            return this.setShortcut(numericChar, alphaChar);
        }
        return this;
    }

    public MenuItem setNumericShortcut(char var1);

    default public MenuItem setNumericShortcut(char numericChar, int numericModifiers) {
        if ((numericModifiers & 0x1100F) == 4096) {
            return this.setNumericShortcut(numericChar);
        }
        return this;
    }

    public char getNumericShortcut();

    default public int getNumericModifiers() {
        return 4096;
    }

    public MenuItem setAlphabeticShortcut(char var1);

    default public MenuItem setAlphabeticShortcut(char alphaChar, int alphaModifiers) {
        if ((alphaModifiers & 0x1100F) == 4096) {
            return this.setAlphabeticShortcut(alphaChar);
        }
        return this;
    }

    public char getAlphabeticShortcut();

    default public int getAlphabeticModifiers() {
        return 4096;
    }

    public MenuItem setCheckable(boolean var1);

    public boolean isCheckable();

    public MenuItem setChecked(boolean var1);

    public boolean isChecked();

    public MenuItem setVisible(boolean var1);

    public boolean isVisible();

    public MenuItem setEnabled(boolean var1);

    public boolean isEnabled();

    public boolean hasSubMenu();

    public SubMenu getSubMenu();

    public MenuItem setOnMenuItemClickListener(OnMenuItemClickListener var1);

    public ContextMenu.ContextMenuInfo getMenuInfo();

    public void setShowAsAction(int var1);

    public MenuItem setShowAsActionFlags(int var1);

    public MenuItem setActionView(View var1);

    public MenuItem setActionView(int var1);

    public View getActionView();

    public MenuItem setActionProvider(ActionProvider var1);

    public ActionProvider getActionProvider();

    public boolean expandActionView();

    public boolean collapseActionView();

    public boolean isActionViewExpanded();

    public MenuItem setOnActionExpandListener(OnActionExpandListener var1);

    default public MenuItem setContentDescription(CharSequence contentDescription) {
        return this;
    }

    default public CharSequence getContentDescription() {
        return null;
    }

    default public MenuItem setTooltipText(CharSequence tooltipText) {
        return this;
    }

    default public CharSequence getTooltipText() {
        return null;
    }

    default public boolean requiresOverflow() {
        return false;
    }

    public static interface OnActionExpandListener {
        public boolean onMenuItemActionExpand(MenuItem var1);

        public boolean onMenuItemActionCollapse(MenuItem var1);
    }

    public static interface OnMenuItemClickListener {
        public boolean onMenuItemClick(MenuItem var1);
    }
}

