/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.graphics.Canvas;
import android.graphics.Canvas_Delegate;
import android.graphics.LinearGradient;
import android.graphics.Outline;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.RadialGradient;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Region;
import android.graphics.Shader;
import com.android.layoutlib.bridge.impl.GcSnapshot;
import com.android.layoutlib.bridge.impl.ResourceHelper;
import java.awt.Rectangle;

public class RectShadowPainter {
    private static final int START_COLOR = ResourceHelper.getColor("#37000000");
    private static final int END_COLOR = ResourceHelper.getColor("#03000000");
    private static final float PERPENDICULAR_ANGLE = 90.0f;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void paintShadow(Outline viewOutline, float elevation, Canvas canvas) {
        Rect outline = new Rect();
        if (!viewOutline.getRect(outline)) {
            assert (false) : "Outline is not a rect shadow";
            return;
        }
        float shadowSize = RectShadowPainter.elevationToShadow(elevation);
        int saved = RectShadowPainter.modifyCanvas(canvas, shadowSize);
        if (saved == -1) {
            return;
        }
        float radius = viewOutline.getRadius();
        if (radius <= 0.0f) {
            return;
        }
        try {
            Paint cornerPaint = new Paint(5);
            cornerPaint.setStyle(Paint.Style.FILL);
            Paint edgePaint = new Paint(cornerPaint);
            edgePaint.setAntiAlias(false);
            float outerArcRadius = radius + shadowSize;
            int[] colors = new int[]{START_COLOR, START_COLOR, END_COLOR};
            cornerPaint.setShader(new RadialGradient(0.0f, 0.0f, outerArcRadius, colors, new float[]{0.0f, radius / outerArcRadius, 1.0f}, Shader.TileMode.CLAMP));
            edgePaint.setShader(new LinearGradient(0.0f, 0.0f, -shadowSize, 0.0f, START_COLOR, END_COLOR, Shader.TileMode.CLAMP));
            Path path = new Path();
            path.setFillType(Path.FillType.EVEN_ODD);
            RectF shadowRect = new RectF(outline);
            shadowRect.inset(-shadowSize, -shadowSize);
            RectF inset = new RectF(outline);
            inset.inset(radius, radius);
            RectF edgeShadowRect = new RectF();
            edgeShadowRect.set(-shadowSize, 0.0f, 0.0f, inset.height());
            RectShadowPainter.sideShadow(canvas, edgePaint, edgeShadowRect, outline.left, inset.top, 0);
            RectShadowPainter.sideShadow(canvas, edgePaint, edgeShadowRect, outline.right, inset.bottom, 2);
            edgeShadowRect.set(-shadowSize, 0.0f, 0.0f, inset.width());
            RectShadowPainter.sideShadow(canvas, edgePaint, edgeShadowRect, inset.right, outline.top, 1);
            edgeShadowRect.set(-shadowSize, 0.0f, shadowSize / 2.0f, inset.width());
            edgePaint.setShader(new LinearGradient(edgeShadowRect.right, 0.0f, edgeShadowRect.left, 0.0f, colors, new float[]{0.0f, 0.33333334f, 1.0f}, Shader.TileMode.CLAMP));
            RectShadowPainter.sideShadow(canvas, edgePaint, edgeShadowRect, inset.left, outline.bottom, 3);
            RectShadowPainter.drawCorner(canvas, cornerPaint, path, inset.right, inset.bottom, outerArcRadius, 0);
            RectShadowPainter.drawCorner(canvas, cornerPaint, path, inset.left, inset.bottom, outerArcRadius, 1);
            RectShadowPainter.drawCorner(canvas, cornerPaint, path, inset.left, inset.top, outerArcRadius, 2);
            RectShadowPainter.drawCorner(canvas, cornerPaint, path, inset.right, inset.top, outerArcRadius, 3);
        }
        finally {
            canvas.restoreToCount(saved);
        }
    }

    private static float elevationToShadow(float elevation) {
        return elevation * 0.5f;
    }

    private static int modifyCanvas(Canvas canvas, float shadowSize) {
        Rect clipBounds = canvas.getClipBounds();
        if (clipBounds.isEmpty()) {
            return -1;
        }
        int saved = canvas.save();
        GcSnapshot snapshot = Canvas_Delegate.getDelegate(canvas).getSnapshot();
        Rectangle originalClip = snapshot.getOriginalClip();
        if (originalClip != null) {
            canvas.clipRect(originalClip.x, originalClip.y, originalClip.x + originalClip.width, originalClip.y + originalClip.height, Region.Op.REPLACE);
            canvas.clipRect(-canvas.getWidth(), -canvas.getHeight(), canvas.getWidth(), canvas.getHeight(), Region.Op.INTERSECT);
        }
        canvas.translate(0.0f, shadowSize / 2.0f);
        return saved;
    }

    private static void sideShadow(Canvas canvas, Paint edgePaint, RectF edgeShadowRect, float dx, float dy, int rotations) {
        if (RectShadowPainter.isRectEmpty(edgeShadowRect)) {
            return;
        }
        int saved = canvas.save();
        canvas.translate(dx, dy);
        canvas.rotate((float)rotations * 90.0f);
        canvas.drawRect(edgeShadowRect, edgePaint);
        canvas.restoreToCount(saved);
    }

    private static void drawCorner(Canvas canvas, Paint paint, Path path, float x, float y, float radius, int rotations) {
        int saved = canvas.save();
        canvas.translate(x, y);
        path.reset();
        path.arcTo(-radius, -radius, radius, radius, (float)rotations * 90.0f, 90.0f, false);
        path.lineTo(0.0f, 0.0f);
        path.close();
        canvas.drawPath(path, paint);
        canvas.restoreToCount(saved);
    }

    private static boolean isRectEmpty(RectF rect) {
        return (int)rect.left >= (int)rect.right || (int)rect.top >= (int)rect.bottom;
    }
}

