/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.graphics.Bitmap;
import android.graphics.GraphicBuffer;
import android.graphics.Rect;
import android.graphics.Region;
import android.os.Binder;
import android.os.IBinder;
import android.util.Log;
import android.view.Display;
import android.view.Surface;
import android.view.SurfaceSession;
import android.view.WindowAnimationFrameStats;
import android.view.WindowContentFrameStats;
import com.android.tools.layoutlib.create.OverrideMethod;
import dalvik.system.CloseGuard;

public class SurfaceControl {
    private static final String TAG = "SurfaceControl";
    private final CloseGuard mCloseGuard = CloseGuard.get();
    private final String mName;
    long mNativeObject;
    public static final int HIDDEN = 4;
    public static final int SECURE = 128;
    public static final int NON_PREMULTIPLIED = 256;
    public static final int OPAQUE = 1024;
    public static final int PROTECTED_APP = 2048;
    public static final int CURSOR_WINDOW = 8192;
    public static final int FX_SURFACE_NORMAL = 0;
    public static final int FX_SURFACE_DIM = 131072;
    public static final int FX_SURFACE_MASK = 983040;
    private static final int SURFACE_HIDDEN = 1;
    private static final int SURFACE_OPAQUE = 2;
    public static final int BUILT_IN_DISPLAY_ID_MAIN = 0;
    public static final int BUILT_IN_DISPLAY_ID_HDMI = 1;
    public static final int POWER_MODE_OFF = 0;
    public static final int POWER_MODE_DOZE = 1;
    public static final int POWER_MODE_NORMAL = 2;
    public static final int POWER_MODE_DOZE_SUSPEND = 3;
    public static final int WINDOW_TYPE_DONT_SCREENSHOT = 441731;

    private static long nativeCreate(SurfaceSession surfaceSession, String string2, int n, int n2, int n3, int n4, long l, int n5, int n6) throws Surface.OutOfResourcesException {
        return OverrideMethod.invokeL("android.view.SurfaceControl#nativeCreate(Landroid/view/SurfaceSession;Ljava/lang/String;IIIIJII)J", true, null);
    }

    private static void nativeRelease(long l) {
        OverrideMethod.invokeV("android.view.SurfaceControl#nativeRelease(J)V", true, null);
    }

    private static void nativeDestroy(long l) {
        OverrideMethod.invokeV("android.view.SurfaceControl#nativeDestroy(J)V", true, null);
    }

    private static void nativeDisconnect(long l) {
        OverrideMethod.invokeV("android.view.SurfaceControl#nativeDisconnect(J)V", true, null);
    }

    private static Bitmap nativeScreenshot(IBinder iBinder, Rect rect, int n, int n2, int n3, int n4, boolean bl, boolean bl2, int n5) {
        return (Bitmap)OverrideMethod.invokeA("android.view.SurfaceControl#nativeScreenshot(Landroid/os/IBinder;Landroid/graphics/Rect;IIIIZZI)Landroid/graphics/Bitmap;", true, null);
    }

    private static GraphicBuffer nativeScreenshotToBuffer(IBinder iBinder, Rect rect, int n, int n2, int n3, int n4, boolean bl, boolean bl2, int n5) {
        return (GraphicBuffer)OverrideMethod.invokeA("android.view.SurfaceControl#nativeScreenshotToBuffer(Landroid/os/IBinder;Landroid/graphics/Rect;IIIIZZI)Landroid/graphics/GraphicBuffer;", true, null);
    }

    private static void nativeScreenshot(IBinder iBinder, Surface surface, Rect rect, int n, int n2, int n3, int n4, boolean bl, boolean bl2) {
        OverrideMethod.invokeV("android.view.SurfaceControl#nativeScreenshot(Landroid/os/IBinder;Landroid/view/Surface;Landroid/graphics/Rect;IIIIZZ)V", true, null);
    }

    private static void nativeOpenTransaction() {
        OverrideMethod.invokeV("android.view.SurfaceControl#nativeOpenTransaction()V", true, null);
    }

    private static void nativeCloseTransaction(boolean bl) {
        OverrideMethod.invokeV("android.view.SurfaceControl#nativeCloseTransaction(Z)V", true, null);
    }

    private static void nativeSetAnimationTransaction() {
        OverrideMethod.invokeV("android.view.SurfaceControl#nativeSetAnimationTransaction()V", true, null);
    }

    private static void nativeSetLayer(long l, int n) {
        OverrideMethod.invokeV("android.view.SurfaceControl#nativeSetLayer(JI)V", true, null);
    }

    private static void nativeSetRelativeLayer(long l, IBinder iBinder, int n) {
        OverrideMethod.invokeV("android.view.SurfaceControl#nativeSetRelativeLayer(JLandroid/os/IBinder;I)V", true, null);
    }

    private static void nativeSetPosition(long l, float f, float f2) {
        OverrideMethod.invokeV("android.view.SurfaceControl#nativeSetPosition(JFF)V", true, null);
    }

    private static void nativeSetGeometryAppliesWithResize(long l) {
        OverrideMethod.invokeV("android.view.SurfaceControl#nativeSetGeometryAppliesWithResize(J)V", true, null);
    }

    private static void nativeSetSize(long l, int n, int n2) {
        OverrideMethod.invokeV("android.view.SurfaceControl#nativeSetSize(JII)V", true, null);
    }

    private static void nativeSetTransparentRegionHint(long l, Region region) {
        OverrideMethod.invokeV("android.view.SurfaceControl#nativeSetTransparentRegionHint(JLandroid/graphics/Region;)V", true, null);
    }

    private static void nativeSetAlpha(long l, float f) {
        OverrideMethod.invokeV("android.view.SurfaceControl#nativeSetAlpha(JF)V", true, null);
    }

    private static void nativeSetMatrix(long l, float f, float f2, float f3, float f4) {
        OverrideMethod.invokeV("android.view.SurfaceControl#nativeSetMatrix(JFFFF)V", true, null);
    }

    private static void nativeSetFlags(long l, int n, int n2) {
        OverrideMethod.invokeV("android.view.SurfaceControl#nativeSetFlags(JII)V", true, null);
    }

    private static void nativeSetWindowCrop(long l, int n, int n2, int n3, int n4) {
        OverrideMethod.invokeV("android.view.SurfaceControl#nativeSetWindowCrop(JIIII)V", true, null);
    }

    private static void nativeSetFinalCrop(long l, int n, int n2, int n3, int n4) {
        OverrideMethod.invokeV("android.view.SurfaceControl#nativeSetFinalCrop(JIIII)V", true, null);
    }

    private static void nativeSetLayerStack(long l, int n) {
        OverrideMethod.invokeV("android.view.SurfaceControl#nativeSetLayerStack(JI)V", true, null);
    }

    private static boolean nativeClearContentFrameStats(long l) {
        return OverrideMethod.invokeI("android.view.SurfaceControl#nativeClearContentFrameStats(J)Z", true, null) != 0;
    }

    private static boolean nativeGetContentFrameStats(long l, WindowContentFrameStats windowContentFrameStats) {
        return OverrideMethod.invokeI("android.view.SurfaceControl#nativeGetContentFrameStats(JLandroid/view/WindowContentFrameStats;)Z", true, null) != 0;
    }

    private static boolean nativeClearAnimationFrameStats() {
        return OverrideMethod.invokeI("android.view.SurfaceControl#nativeClearAnimationFrameStats()Z", true, null) != 0;
    }

    private static boolean nativeGetAnimationFrameStats(WindowAnimationFrameStats windowAnimationFrameStats) {
        return OverrideMethod.invokeI("android.view.SurfaceControl#nativeGetAnimationFrameStats(Landroid/view/WindowAnimationFrameStats;)Z", true, null) != 0;
    }

    private static IBinder nativeGetBuiltInDisplay(int n) {
        return (IBinder)OverrideMethod.invokeA("android.view.SurfaceControl#nativeGetBuiltInDisplay(I)Landroid/os/IBinder;", true, null);
    }

    private static IBinder nativeCreateDisplay(String string2, boolean bl) {
        return (IBinder)OverrideMethod.invokeA("android.view.SurfaceControl#nativeCreateDisplay(Ljava/lang/String;Z)Landroid/os/IBinder;", true, null);
    }

    private static void nativeDestroyDisplay(IBinder iBinder) {
        OverrideMethod.invokeV("android.view.SurfaceControl#nativeDestroyDisplay(Landroid/os/IBinder;)V", true, null);
    }

    private static void nativeSetDisplaySurface(IBinder iBinder, long l) {
        OverrideMethod.invokeV("android.view.SurfaceControl#nativeSetDisplaySurface(Landroid/os/IBinder;J)V", true, null);
    }

    private static void nativeSetDisplayLayerStack(IBinder iBinder, int n) {
        OverrideMethod.invokeV("android.view.SurfaceControl#nativeSetDisplayLayerStack(Landroid/os/IBinder;I)V", true, null);
    }

    private static void nativeSetDisplayProjection(IBinder iBinder, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
        OverrideMethod.invokeV("android.view.SurfaceControl#nativeSetDisplayProjection(Landroid/os/IBinder;IIIIIIIII)V", true, null);
    }

    private static void nativeSetDisplaySize(IBinder iBinder, int n, int n2) {
        OverrideMethod.invokeV("android.view.SurfaceControl#nativeSetDisplaySize(Landroid/os/IBinder;II)V", true, null);
    }

    private static PhysicalDisplayInfo[] nativeGetDisplayConfigs(IBinder iBinder) {
        return (PhysicalDisplayInfo[])OverrideMethod.invokeA("android.view.SurfaceControl#nativeGetDisplayConfigs(Landroid/os/IBinder;)[Landroid/view/SurfaceControl$PhysicalDisplayInfo;", true, null);
    }

    private static int nativeGetActiveConfig(IBinder iBinder) {
        return OverrideMethod.invokeI("android.view.SurfaceControl#nativeGetActiveConfig(Landroid/os/IBinder;)I", true, null);
    }

    private static boolean nativeSetActiveConfig(IBinder iBinder, int n) {
        return OverrideMethod.invokeI("android.view.SurfaceControl#nativeSetActiveConfig(Landroid/os/IBinder;I)Z", true, null) != 0;
    }

    private static int[] nativeGetDisplayColorModes(IBinder iBinder) {
        return (int[])OverrideMethod.invokeA("android.view.SurfaceControl#nativeGetDisplayColorModes(Landroid/os/IBinder;)[I", true, null);
    }

    private static int nativeGetActiveColorMode(IBinder iBinder) {
        return OverrideMethod.invokeI("android.view.SurfaceControl#nativeGetActiveColorMode(Landroid/os/IBinder;)I", true, null);
    }

    private static boolean nativeSetActiveColorMode(IBinder iBinder, int n) {
        return OverrideMethod.invokeI("android.view.SurfaceControl#nativeSetActiveColorMode(Landroid/os/IBinder;I)Z", true, null) != 0;
    }

    private static void nativeSetDisplayPowerMode(IBinder iBinder, int n) {
        OverrideMethod.invokeV("android.view.SurfaceControl#nativeSetDisplayPowerMode(Landroid/os/IBinder;I)V", true, null);
    }

    private static void nativeDeferTransactionUntil(long l, IBinder iBinder, long l2) {
        OverrideMethod.invokeV("android.view.SurfaceControl#nativeDeferTransactionUntil(JLandroid/os/IBinder;J)V", true, null);
    }

    private static void nativeDeferTransactionUntilSurface(long l, long l2, long l3) {
        OverrideMethod.invokeV("android.view.SurfaceControl#nativeDeferTransactionUntilSurface(JJJ)V", true, null);
    }

    private static void nativeReparentChildren(long l, IBinder iBinder) {
        OverrideMethod.invokeV("android.view.SurfaceControl#nativeReparentChildren(JLandroid/os/IBinder;)V", true, null);
    }

    private static void nativeReparentChild(long l, IBinder iBinder, IBinder iBinder2) {
        OverrideMethod.invokeV("android.view.SurfaceControl#nativeReparentChild(JLandroid/os/IBinder;Landroid/os/IBinder;)V", true, null);
    }

    private static void nativeSeverChildren(long l) {
        OverrideMethod.invokeV("android.view.SurfaceControl#nativeSeverChildren(J)V", true, null);
    }

    private static void nativeSetOverrideScalingMode(long l, int n) {
        OverrideMethod.invokeV("android.view.SurfaceControl#nativeSetOverrideScalingMode(JI)V", true, null);
    }

    private static IBinder nativeGetHandle(long l) {
        return (IBinder)OverrideMethod.invokeA("android.view.SurfaceControl#nativeGetHandle(J)Landroid/os/IBinder;", true, null);
    }

    private static boolean nativeGetTransformToDisplayInverse(long l) {
        return OverrideMethod.invokeI("android.view.SurfaceControl#nativeGetTransformToDisplayInverse(J)Z", true, null) != 0;
    }

    private static Display.HdrCapabilities nativeGetHdrCapabilities(IBinder iBinder) {
        return (Display.HdrCapabilities)OverrideMethod.invokeA("android.view.SurfaceControl#nativeGetHdrCapabilities(Landroid/os/IBinder;)Landroid/view/Display$HdrCapabilities;", true, null);
    }

    public SurfaceControl(SurfaceSession session, String name, int w, int h, int format, int flags, int windowType, int ownerUid) throws Surface.OutOfResourcesException {
        this(session, name, w, h, format, flags, null, windowType, ownerUid);
    }

    public SurfaceControl(SurfaceSession session, String name, int w, int h, int format, int flags) throws Surface.OutOfResourcesException {
        this(session, name, w, h, format, flags, null, -1, Binder.getCallingUid());
    }

    public SurfaceControl(SurfaceSession session, String name, int w, int h, int format, int flags, SurfaceControl parent, int windowType, int ownerUid) throws Surface.OutOfResourcesException {
        if (session == null) {
            throw new IllegalArgumentException("session must not be null");
        }
        if (name == null) {
            throw new IllegalArgumentException("name must not be null");
        }
        if ((flags & 4) == 0) {
            Log.w(TAG, "Surfaces should always be created with the HIDDEN flag set to ensure that they are not made visible prematurely before all of the surface's properties have been configured.  Set the other properties and make the surface visible within a transaction.  New surface name: " + name, new Throwable());
        }
        this.mName = name;
        this.mNativeObject = SurfaceControl.nativeCreate(session, name, w, h, format, flags, parent != null ? parent.mNativeObject : 0L, windowType, ownerUid);
        if (this.mNativeObject == 0L) {
            throw new Surface.OutOfResourcesException("Couldn't allocate SurfaceControl native object");
        }
        this.mCloseGuard.open("release");
    }

    public SurfaceControl(SurfaceControl other) {
        this.mName = other.mName;
        this.mNativeObject = other.mNativeObject;
        other.mCloseGuard.close();
        other.mNativeObject = 0L;
        this.mCloseGuard.open("release");
    }

    protected void finalize() throws Throwable {
        try {
            if (this.mCloseGuard != null) {
                this.mCloseGuard.warnIfOpen();
            }
            if (this.mNativeObject != 0L) {
                SurfaceControl.nativeRelease(this.mNativeObject);
            }
        }
        finally {
            super.finalize();
        }
    }

    public String toString() {
        return "Surface(name=" + this.mName + ")";
    }

    public void release() {
        if (this.mNativeObject != 0L) {
            SurfaceControl.nativeRelease(this.mNativeObject);
            this.mNativeObject = 0L;
        }
        this.mCloseGuard.close();
    }

    public void destroy() {
        if (this.mNativeObject != 0L) {
            SurfaceControl.nativeDestroy(this.mNativeObject);
            this.mNativeObject = 0L;
        }
        this.mCloseGuard.close();
    }

    public void disconnect() {
        if (this.mNativeObject != 0L) {
            SurfaceControl.nativeDisconnect(this.mNativeObject);
        }
    }

    private void checkNotReleased() {
        if (this.mNativeObject == 0L) {
            throw new NullPointerException("mNativeObject is null. Have you called release() already?");
        }
    }

    public static void openTransaction() {
        SurfaceControl.nativeOpenTransaction();
    }

    public static void closeTransaction() {
        SurfaceControl.nativeCloseTransaction(false);
    }

    public static void closeTransactionSync() {
        SurfaceControl.nativeCloseTransaction(true);
    }

    public void deferTransactionUntil(IBinder handle, long frame) {
        if (frame > 0L) {
            SurfaceControl.nativeDeferTransactionUntil(this.mNativeObject, handle, frame);
        }
    }

    public void deferTransactionUntil(Surface barrier, long frame) {
        if (frame > 0L) {
            SurfaceControl.nativeDeferTransactionUntilSurface(this.mNativeObject, barrier.mNativeObject, frame);
        }
    }

    public void reparentChildren(IBinder newParentHandle) {
        SurfaceControl.nativeReparentChildren(this.mNativeObject, newParentHandle);
    }

    public void reparentChild(IBinder newParentHandle, IBinder childHandle) {
        SurfaceControl.nativeReparentChild(this.mNativeObject, newParentHandle, childHandle);
    }

    public void detachChildren() {
        SurfaceControl.nativeSeverChildren(this.mNativeObject);
    }

    public void setOverrideScalingMode(int scalingMode) {
        this.checkNotReleased();
        SurfaceControl.nativeSetOverrideScalingMode(this.mNativeObject, scalingMode);
    }

    public IBinder getHandle() {
        return SurfaceControl.nativeGetHandle(this.mNativeObject);
    }

    public static void setAnimationTransaction() {
        SurfaceControl.nativeSetAnimationTransaction();
    }

    public void setLayer(int zorder) {
        this.checkNotReleased();
        SurfaceControl.nativeSetLayer(this.mNativeObject, zorder);
    }

    public void setRelativeLayer(IBinder relativeTo, int zorder) {
        this.checkNotReleased();
        SurfaceControl.nativeSetRelativeLayer(this.mNativeObject, relativeTo, zorder);
    }

    public void setPosition(float x, float y) {
        this.checkNotReleased();
        SurfaceControl.nativeSetPosition(this.mNativeObject, x, y);
    }

    public void setGeometryAppliesWithResize() {
        this.checkNotReleased();
        SurfaceControl.nativeSetGeometryAppliesWithResize(this.mNativeObject);
    }

    public void setSize(int w, int h) {
        this.checkNotReleased();
        SurfaceControl.nativeSetSize(this.mNativeObject, w, h);
    }

    public void hide() {
        this.checkNotReleased();
        SurfaceControl.nativeSetFlags(this.mNativeObject, 1, 1);
    }

    public void show() {
        this.checkNotReleased();
        SurfaceControl.nativeSetFlags(this.mNativeObject, 0, 1);
    }

    public void setTransparentRegionHint(Region region) {
        this.checkNotReleased();
        SurfaceControl.nativeSetTransparentRegionHint(this.mNativeObject, region);
    }

    public boolean clearContentFrameStats() {
        this.checkNotReleased();
        return SurfaceControl.nativeClearContentFrameStats(this.mNativeObject);
    }

    public boolean getContentFrameStats(WindowContentFrameStats outStats) {
        this.checkNotReleased();
        return SurfaceControl.nativeGetContentFrameStats(this.mNativeObject, outStats);
    }

    public static boolean clearAnimationFrameStats() {
        return SurfaceControl.nativeClearAnimationFrameStats();
    }

    public static boolean getAnimationFrameStats(WindowAnimationFrameStats outStats) {
        return SurfaceControl.nativeGetAnimationFrameStats(outStats);
    }

    public void setAlpha(float alpha) {
        this.checkNotReleased();
        SurfaceControl.nativeSetAlpha(this.mNativeObject, alpha);
    }

    public void setMatrix(float dsdx, float dtdx, float dtdy, float dsdy) {
        this.checkNotReleased();
        SurfaceControl.nativeSetMatrix(this.mNativeObject, dsdx, dtdx, dtdy, dsdy);
    }

    public void setWindowCrop(Rect crop) {
        this.checkNotReleased();
        if (crop != null) {
            SurfaceControl.nativeSetWindowCrop(this.mNativeObject, crop.left, crop.top, crop.right, crop.bottom);
        } else {
            SurfaceControl.nativeSetWindowCrop(this.mNativeObject, 0, 0, 0, 0);
        }
    }

    public void setFinalCrop(Rect crop) {
        this.checkNotReleased();
        if (crop != null) {
            SurfaceControl.nativeSetFinalCrop(this.mNativeObject, crop.left, crop.top, crop.right, crop.bottom);
        } else {
            SurfaceControl.nativeSetFinalCrop(this.mNativeObject, 0, 0, 0, 0);
        }
    }

    public void setLayerStack(int layerStack) {
        this.checkNotReleased();
        SurfaceControl.nativeSetLayerStack(this.mNativeObject, layerStack);
    }

    public void setOpaque(boolean isOpaque) {
        this.checkNotReleased();
        if (isOpaque) {
            SurfaceControl.nativeSetFlags(this.mNativeObject, 2, 2);
        } else {
            SurfaceControl.nativeSetFlags(this.mNativeObject, 0, 2);
        }
    }

    public void setSecure(boolean isSecure) {
        this.checkNotReleased();
        if (isSecure) {
            SurfaceControl.nativeSetFlags(this.mNativeObject, 128, 128);
        } else {
            SurfaceControl.nativeSetFlags(this.mNativeObject, 0, 128);
        }
    }

    public static void setDisplayPowerMode(IBinder displayToken, int mode) {
        if (displayToken == null) {
            throw new IllegalArgumentException("displayToken must not be null");
        }
        SurfaceControl.nativeSetDisplayPowerMode(displayToken, mode);
    }

    public static PhysicalDisplayInfo[] getDisplayConfigs(IBinder displayToken) {
        if (displayToken == null) {
            throw new IllegalArgumentException("displayToken must not be null");
        }
        return SurfaceControl.nativeGetDisplayConfigs(displayToken);
    }

    public static int getActiveConfig(IBinder displayToken) {
        if (displayToken == null) {
            throw new IllegalArgumentException("displayToken must not be null");
        }
        return SurfaceControl.nativeGetActiveConfig(displayToken);
    }

    public static boolean setActiveConfig(IBinder displayToken, int id2) {
        if (displayToken == null) {
            throw new IllegalArgumentException("displayToken must not be null");
        }
        return SurfaceControl.nativeSetActiveConfig(displayToken, id2);
    }

    public static int[] getDisplayColorModes(IBinder displayToken) {
        if (displayToken == null) {
            throw new IllegalArgumentException("displayToken must not be null");
        }
        return SurfaceControl.nativeGetDisplayColorModes(displayToken);
    }

    public static int getActiveColorMode(IBinder displayToken) {
        if (displayToken == null) {
            throw new IllegalArgumentException("displayToken must not be null");
        }
        return SurfaceControl.nativeGetActiveColorMode(displayToken);
    }

    public static boolean setActiveColorMode(IBinder displayToken, int colorMode) {
        if (displayToken == null) {
            throw new IllegalArgumentException("displayToken must not be null");
        }
        return SurfaceControl.nativeSetActiveColorMode(displayToken, colorMode);
    }

    public static void setDisplayProjection(IBinder displayToken, int orientation, Rect layerStackRect, Rect displayRect) {
        if (displayToken == null) {
            throw new IllegalArgumentException("displayToken must not be null");
        }
        if (layerStackRect == null) {
            throw new IllegalArgumentException("layerStackRect must not be null");
        }
        if (displayRect == null) {
            throw new IllegalArgumentException("displayRect must not be null");
        }
        SurfaceControl.nativeSetDisplayProjection(displayToken, orientation, layerStackRect.left, layerStackRect.top, layerStackRect.right, layerStackRect.bottom, displayRect.left, displayRect.top, displayRect.right, displayRect.bottom);
    }

    public static void setDisplayLayerStack(IBinder displayToken, int layerStack) {
        if (displayToken == null) {
            throw new IllegalArgumentException("displayToken must not be null");
        }
        SurfaceControl.nativeSetDisplayLayerStack(displayToken, layerStack);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setDisplaySurface(IBinder displayToken, Surface surface) {
        if (displayToken == null) {
            throw new IllegalArgumentException("displayToken must not be null");
        }
        if (surface != null) {
            Object object = surface.mLock;
            synchronized (object) {
                SurfaceControl.nativeSetDisplaySurface(displayToken, surface.mNativeObject);
            }
        } else {
            SurfaceControl.nativeSetDisplaySurface(displayToken, 0L);
        }
    }

    public static void setDisplaySize(IBinder displayToken, int width, int height) {
        if (displayToken == null) {
            throw new IllegalArgumentException("displayToken must not be null");
        }
        if (width <= 0 || height <= 0) {
            throw new IllegalArgumentException("width and height must be positive");
        }
        SurfaceControl.nativeSetDisplaySize(displayToken, width, height);
    }

    public static Display.HdrCapabilities getHdrCapabilities(IBinder displayToken) {
        if (displayToken == null) {
            throw new IllegalArgumentException("displayToken must not be null");
        }
        return SurfaceControl.nativeGetHdrCapabilities(displayToken);
    }

    public static IBinder createDisplay(String name, boolean secure) {
        if (name == null) {
            throw new IllegalArgumentException("name must not be null");
        }
        return SurfaceControl.nativeCreateDisplay(name, secure);
    }

    public static void destroyDisplay(IBinder displayToken) {
        if (displayToken == null) {
            throw new IllegalArgumentException("displayToken must not be null");
        }
        SurfaceControl.nativeDestroyDisplay(displayToken);
    }

    public static IBinder getBuiltInDisplay(int builtInDisplayId) {
        return SurfaceControl.nativeGetBuiltInDisplay(builtInDisplayId);
    }

    public static void screenshot(IBinder display, Surface consumer, int width, int height, int minLayer, int maxLayer, boolean useIdentityTransform) {
        SurfaceControl.screenshot(display, consumer, new Rect(), width, height, minLayer, maxLayer, false, useIdentityTransform);
    }

    public static void screenshot(IBinder display, Surface consumer, int width, int height) {
        SurfaceControl.screenshot(display, consumer, new Rect(), width, height, 0, 0, true, false);
    }

    public static void screenshot(IBinder display, Surface consumer) {
        SurfaceControl.screenshot(display, consumer, new Rect(), 0, 0, 0, 0, true, false);
    }

    public static Bitmap screenshot(Rect sourceCrop, int width, int height, int minLayer, int maxLayer, boolean useIdentityTransform, int rotation) {
        IBinder displayToken = SurfaceControl.getBuiltInDisplay(0);
        return SurfaceControl.nativeScreenshot(displayToken, sourceCrop, width, height, minLayer, maxLayer, false, useIdentityTransform, rotation);
    }

    public static GraphicBuffer screenshotToBuffer(Rect sourceCrop, int width, int height, int minLayer, int maxLayer, boolean useIdentityTransform, int rotation) {
        IBinder displayToken = SurfaceControl.getBuiltInDisplay(0);
        return SurfaceControl.nativeScreenshotToBuffer(displayToken, sourceCrop, width, height, minLayer, maxLayer, false, useIdentityTransform, rotation);
    }

    public static Bitmap screenshot(int width, int height) {
        IBinder displayToken = SurfaceControl.getBuiltInDisplay(0);
        return SurfaceControl.nativeScreenshot(displayToken, new Rect(), width, height, 0, 0, true, false, 0);
    }

    private static void screenshot(IBinder display, Surface consumer, Rect sourceCrop, int width, int height, int minLayer, int maxLayer, boolean allLayers, boolean useIdentityTransform) {
        if (display == null) {
            throw new IllegalArgumentException("displayToken must not be null");
        }
        if (consumer == null) {
            throw new IllegalArgumentException("consumer must not be null");
        }
        SurfaceControl.nativeScreenshot(display, consumer, sourceCrop, width, height, minLayer, maxLayer, allLayers, useIdentityTransform);
    }

    public static class PhysicalDisplayInfo {
        public int width;
        public int height;
        public float refreshRate;
        public float density;
        public float xDpi;
        public float yDpi;
        public boolean secure;
        public long appVsyncOffsetNanos;
        public long presentationDeadlineNanos;

        public PhysicalDisplayInfo() {
        }

        public PhysicalDisplayInfo(PhysicalDisplayInfo other) {
            this.copyFrom(other);
        }

        public boolean equals(Object o) {
            return o instanceof PhysicalDisplayInfo && this.equals((PhysicalDisplayInfo)o);
        }

        public boolean equals(PhysicalDisplayInfo other) {
            return other != null && this.width == other.width && this.height == other.height && this.refreshRate == other.refreshRate && this.density == other.density && this.xDpi == other.xDpi && this.yDpi == other.yDpi && this.secure == other.secure && this.appVsyncOffsetNanos == other.appVsyncOffsetNanos && this.presentationDeadlineNanos == other.presentationDeadlineNanos;
        }

        public int hashCode() {
            return 0;
        }

        public void copyFrom(PhysicalDisplayInfo other) {
            this.width = other.width;
            this.height = other.height;
            this.refreshRate = other.refreshRate;
            this.density = other.density;
            this.xDpi = other.xDpi;
            this.yDpi = other.yDpi;
            this.secure = other.secure;
            this.appVsyncOffsetNanos = other.appVsyncOffsetNanos;
            this.presentationDeadlineNanos = other.presentationDeadlineNanos;
        }

        public String toString() {
            return "PhysicalDisplayInfo{" + this.width + " x " + this.height + ", " + this.refreshRate + " fps, density " + this.density + ", " + this.xDpi + " x " + this.yDpi + " dpi, secure " + this.secure + ", appVsyncOffset " + this.appVsyncOffsetNanos + ", bufferDeadline " + this.presentationDeadlineNanos + "}";
        }
    }
}

