/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.content.Context;
import android.content.Intent;
import android.content.res.TypedArray;
import android.icu.text.MeasureFormat;
import android.icu.util.Measure;
import android.icu.util.MeasureUnit;
import android.net.Uri;
import android.os.SystemClock;
import android.text.format.DateUtils;
import android.util.AttributeSet;
import android.util.Log;
import android.view.RemotableViewMethod;
import android.view.View;
import android.widget.RemoteViews;
import android.widget.TextView;
import com.android.internal.R;
import com.android.layoutlib.bridge.android.AndroidLocale;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.IllegalFormatException;
import java.util.Locale;

@RemoteViews.RemoteView
public class Chronometer
extends TextView {
    private static final String TAG = "Chronometer";
    private long mBase;
    private long mNow;
    private boolean mVisible;
    private boolean mStarted;
    private boolean mRunning;
    private boolean mLogged;
    private String mFormat;
    private Formatter mFormatter;
    private Locale mFormatterLocale;
    private Object[] mFormatterArgs = new Object[1];
    private StringBuilder mFormatBuilder;
    private OnChronometerTickListener mOnChronometerTickListener;
    private StringBuilder mRecycle = new StringBuilder(8);
    private boolean mCountDown;
    private final Runnable mTickRunnable = new Runnable(){

        @Override
        public void run() {
            if (Chronometer.this.mRunning) {
                Chronometer.this.updateText(SystemClock.elapsedRealtime());
                Chronometer.this.dispatchChronometerTick();
                Chronometer.this.postDelayed(Chronometer.this.mTickRunnable, 1000L);
            }
        }
    };
    private static final int MIN_IN_SEC = 60;
    private static final int HOUR_IN_SEC = 3600;

    public Chronometer(Context context) {
        this(context, null, 0);
    }

    public Chronometer(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public Chronometer(Context context, AttributeSet attrs, int defStyleAttr) {
        this(context, attrs, defStyleAttr, 0);
    }

    public Chronometer(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.Chronometer, defStyleAttr, defStyleRes);
        this.setFormat(a.getString(0));
        this.setCountDown(a.getBoolean(1, false));
        a.recycle();
        this.init();
    }

    private void init() {
        this.mBase = SystemClock.elapsedRealtime();
        this.updateText(this.mBase);
    }

    @RemotableViewMethod
    public void setCountDown(boolean countDown) {
        this.mCountDown = countDown;
        this.updateText(SystemClock.elapsedRealtime());
    }

    public boolean isCountDown() {
        return this.mCountDown;
    }

    public boolean isTheFinalCountDown() {
        try {
            this.getContext().startActivity(new Intent("android.intent.action.VIEW", Uri.parse("https://youtu.be/9jK-NcRmVcw")).addCategory("android.intent.category.BROWSABLE").addFlags(528384));
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    @RemotableViewMethod
    public void setBase(long base) {
        this.mBase = base;
        this.dispatchChronometerTick();
        this.updateText(SystemClock.elapsedRealtime());
    }

    public long getBase() {
        return this.mBase;
    }

    @RemotableViewMethod
    public void setFormat(String format) {
        this.mFormat = format;
        if (format != null && this.mFormatBuilder == null) {
            this.mFormatBuilder = new StringBuilder(format.length() * 2);
        }
    }

    public String getFormat() {
        return this.mFormat;
    }

    public void setOnChronometerTickListener(OnChronometerTickListener listener) {
        this.mOnChronometerTickListener = listener;
    }

    public OnChronometerTickListener getOnChronometerTickListener() {
        return this.mOnChronometerTickListener;
    }

    public void start() {
        this.mStarted = true;
        this.updateRunning();
    }

    public void stop() {
        this.mStarted = false;
        this.updateRunning();
    }

    @RemotableViewMethod
    public void setStarted(boolean started) {
        this.mStarted = started;
        this.updateRunning();
    }

    @Override
    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.mVisible = false;
        this.updateRunning();
    }

    @Override
    protected void onWindowVisibilityChanged(int visibility) {
        super.onWindowVisibilityChanged(visibility);
        this.mVisible = visibility == 0;
        this.updateRunning();
    }

    @Override
    protected void onVisibilityChanged(View changedView, int visibility) {
        super.onVisibilityChanged(changedView, visibility);
        this.updateRunning();
    }

    private synchronized void updateText(long now) {
        String text;
        block6: {
            this.mNow = now;
            long seconds = this.mCountDown ? this.mBase - now : now - this.mBase;
            boolean negative = false;
            if ((seconds /= 1000L) < 0L) {
                seconds = -seconds;
                negative = true;
            }
            text = DateUtils.formatElapsedTime(this.mRecycle, seconds);
            if (negative) {
                text = this.getResources().getString(17040271, text);
            }
            if (this.mFormat != null) {
                Locale loc = AndroidLocale.getDefault();
                if (this.mFormatter == null || !loc.equals(this.mFormatterLocale)) {
                    this.mFormatterLocale = loc;
                    this.mFormatter = new Formatter(this.mFormatBuilder, loc);
                }
                this.mFormatBuilder.setLength(0);
                this.mFormatterArgs[0] = text;
                try {
                    this.mFormatter.format(this.mFormat, this.mFormatterArgs);
                    text = this.mFormatBuilder.toString();
                }
                catch (IllegalFormatException ex) {
                    if (this.mLogged) break block6;
                    Log.w(TAG, "Illegal format string: " + this.mFormat);
                    this.mLogged = true;
                }
            }
        }
        this.setText(text);
    }

    private void updateRunning() {
        boolean running;
        boolean bl = running = this.mVisible && this.mStarted && this.isShown();
        if (running != this.mRunning) {
            if (running) {
                this.updateText(SystemClock.elapsedRealtime());
                this.dispatchChronometerTick();
                this.postDelayed(this.mTickRunnable, 1000L);
            } else {
                this.removeCallbacks(this.mTickRunnable);
            }
            this.mRunning = running;
        }
    }

    void dispatchChronometerTick() {
        if (this.mOnChronometerTickListener != null) {
            this.mOnChronometerTickListener.onChronometerTick(this);
        }
    }

    private static String formatDuration(long ms) {
        int duration = (int)(ms / 1000L);
        if (duration < 0) {
            duration = -duration;
        }
        int h = 0;
        int m = 0;
        if (duration >= 3600) {
            h = duration / 3600;
            duration -= h * 3600;
        }
        if (duration >= 60) {
            m = duration / 60;
            duration -= m * 60;
        }
        int s = duration;
        ArrayList<Measure> measures = new ArrayList<Measure>();
        if (h > 0) {
            measures.add(new Measure(h, MeasureUnit.HOUR));
        }
        if (m > 0) {
            measures.add(new Measure(m, MeasureUnit.MINUTE));
        }
        measures.add(new Measure(s, MeasureUnit.SECOND));
        return MeasureFormat.getInstance(AndroidLocale.getDefault(), MeasureFormat.FormatWidth.WIDE).formatMeasures(measures.toArray(new Measure[measures.size()]));
    }

    @Override
    public CharSequence getContentDescription() {
        return Chronometer.formatDuration(this.mNow - this.mBase);
    }

    @Override
    public CharSequence getAccessibilityClassName() {
        return Chronometer.class.getName();
    }

    public static interface OnChronometerTickListener {
        public void onChronometerTick(Chronometer var1);
    }
}

