/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile.daemon;

import com.google.common.collect.Lists;
import java.io.File;
import java.util.Set;
import javax.inject.Inject;
import org.gradle.api.tasks.WorkResult;
import org.gradle.api.tasks.compile.BaseForkOptions;
import org.gradle.internal.UncheckedException;
import org.gradle.language.base.internal.compile.CompileSpec;
import org.gradle.language.base.internal.compile.Compiler;
import org.gradle.process.internal.util.MergeOptionsUtil;
import org.gradle.workers.internal.ActionExecutionSpec;
import org.gradle.workers.internal.DaemonForkOptions;
import org.gradle.workers.internal.DefaultWorkResult;
import org.gradle.workers.internal.SimpleActionExecutionSpec;
import org.gradle.workers.internal.WorkSpec;
import org.gradle.workers.internal.Worker;
import org.gradle.workers.internal.WorkerDaemonServer;
import org.gradle.workers.internal.WorkerFactory;
import org.gradle.workers.internal.WorkerProtocol;
import org.gradle.workers.internal.WorkerServer;

public abstract class AbstractDaemonCompiler<T extends CompileSpec>
implements Compiler<T> {
    private final Compiler<T> delegate;
    private final WorkerFactory workerFactory;

    public AbstractDaemonCompiler(Compiler<T> delegate, WorkerFactory workerFactory) {
        this.delegate = delegate;
        this.workerFactory = workerFactory;
    }

    public Compiler<T> getDelegate() {
        return this.delegate;
    }

    public WorkResult execute(T spec) {
        InvocationContext invocationContext = this.toInvocationContext(spec);
        DaemonForkOptions daemonForkOptions = invocationContext.getDaemonForkOptions();
        Worker worker = this.workerFactory.getWorker(this.getServerImplementation(), daemonForkOptions);
        DefaultWorkResult result = worker.execute((WorkSpec)new SimpleActionExecutionSpec(CompilerRunnable.class, "compiler daemon", invocationContext.getInvocationWorkingDir(), new Object[]{this.delegate, spec}));
        if (result.isSuccess()) {
            return result;
        }
        throw UncheckedException.throwAsUncheckedException((Throwable)result.getException());
    }

    protected abstract InvocationContext toInvocationContext(T var1);

    private Class<? extends WorkerProtocol<ActionExecutionSpec>> getServerImplementation() {
        switch (this.workerFactory.getIsolationMode()) {
            case NONE: 
            case CLASSLOADER: {
                return WorkerServer.class;
            }
            case PROCESS: {
                return WorkerDaemonServer.class;
            }
        }
        throw new IllegalArgumentException("Unknown isolation mode: " + this.workerFactory.getIsolationMode());
    }

    protected BaseForkOptions mergeForkOptions(BaseForkOptions left, BaseForkOptions right) {
        BaseForkOptions merged = new BaseForkOptions();
        merged.setMemoryInitialSize(MergeOptionsUtil.mergeHeapSize((String)left.getMemoryInitialSize(), (String)right.getMemoryInitialSize()));
        merged.setMemoryMaximumSize(MergeOptionsUtil.mergeHeapSize((String)left.getMemoryMaximumSize(), (String)right.getMemoryMaximumSize()));
        Set mergedJvmArgs = MergeOptionsUtil.normalized(left.getJvmArgs());
        mergedJvmArgs.addAll(MergeOptionsUtil.normalized(right.getJvmArgs()));
        merged.setJvmArgs(Lists.newArrayList((Iterable)mergedJvmArgs));
        return merged;
    }

    protected static class InvocationContext {
        private File invocationWorkingDir;
        private DaemonForkOptions daemonForkOptions;

        public InvocationContext(File invocationWorkingDir, DaemonForkOptions daemonForkOptions) {
            this.invocationWorkingDir = invocationWorkingDir;
            this.daemonForkOptions = daemonForkOptions;
        }

        File getInvocationWorkingDir() {
            return this.invocationWorkingDir;
        }

        DaemonForkOptions getDaemonForkOptions() {
            return this.daemonForkOptions;
        }

        public InvocationContext mergeWith(InvocationContext invocationContext) {
            if (!this.getInvocationWorkingDir().equals(invocationContext.getInvocationWorkingDir())) {
                throw new IllegalArgumentException("Cannot merge an InvocationContext with a different invocation working directory (this: " + this.getInvocationWorkingDir() + ", other: " + invocationContext.getInvocationWorkingDir() + ").");
            }
            DaemonForkOptions mergedForkOptions = this.getDaemonForkOptions().mergeWith(invocationContext.getDaemonForkOptions());
            return new InvocationContext(this.getInvocationWorkingDir(), mergedForkOptions);
        }
    }

    private static class CompilerRunnable<T extends CompileSpec>
    implements Runnable {
        private final Compiler<T> compiler;
        private final T compileSpec;

        @Inject
        public CompilerRunnable(Compiler<T> compiler, T compileSpec) {
            this.compiler = compiler;
            this.compileSpec = compileSpec;
        }

        @Override
        public void run() {
            this.compiler.execute(this.compileSpec);
        }
    }
}

