/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cvsSupport2.cvshandlers;

import com.intellij.CvsBundle;
import com.intellij.cvsSupport2.CvsUtil;
import com.intellij.cvsSupport2.actions.cvsContext.CvsLightweightFile;
import com.intellij.cvsSupport2.actions.update.UpdateSettings;
import com.intellij.cvsSupport2.application.CvsEntriesManager;
import com.intellij.cvsSupport2.config.CvsConfiguration;
import com.intellij.cvsSupport2.connections.CvsEnvironment;
import com.intellij.cvsSupport2.cvsExecution.ModalityContext;
import com.intellij.cvsSupport2.cvshandlers.CvsHandler;
import com.intellij.cvsSupport2.cvshandlers.FileSetToBeUpdated;
import com.intellij.cvsSupport2.cvshandlers.IOFilesBasedDirectoryPruner;
import com.intellij.cvsSupport2.cvshandlers.UpdateHandler;
import com.intellij.cvsSupport2.cvsoperations.common.CompositeOperation;
import com.intellij.cvsSupport2.cvsoperations.common.CvsExecutionEnvironment;
import com.intellij.cvsSupport2.cvsoperations.common.CvsOperation;
import com.intellij.cvsSupport2.cvsoperations.common.LoginPerformer;
import com.intellij.cvsSupport2.cvsoperations.common.PostCvsActivity;
import com.intellij.cvsSupport2.cvsoperations.cvsAdd.AddFilesOperation;
import com.intellij.cvsSupport2.cvsoperations.cvsAdd.AddedFileInfo;
import com.intellij.cvsSupport2.cvsoperations.cvsCheckOut.CheckoutFileOperation;
import com.intellij.cvsSupport2.cvsoperations.cvsCheckOut.CheckoutFilesOperation;
import com.intellij.cvsSupport2.cvsoperations.cvsCheckOut.CheckoutProjectOperation;
import com.intellij.cvsSupport2.cvsoperations.cvsCommit.CommitFilesOperation;
import com.intellij.cvsSupport2.cvsoperations.cvsEdit.EditOperation;
import com.intellij.cvsSupport2.cvsoperations.cvsEdit.UneditOperation;
import com.intellij.cvsSupport2.cvsoperations.cvsImport.ImportDetails;
import com.intellij.cvsSupport2.cvsoperations.cvsImport.ImportOperation;
import com.intellij.cvsSupport2.cvsoperations.cvsRemove.RemoveFilesOperation;
import com.intellij.cvsSupport2.cvsoperations.cvsTagOrBranch.BranchOperation;
import com.intellij.cvsSupport2.cvsoperations.cvsTagOrBranch.TagOperation;
import com.intellij.cvsSupport2.cvsoperations.cvsUpdate.UpdateOperation;
import com.intellij.cvsSupport2.cvsoperations.dateOrRevision.RevisionOrDateImpl;
import com.intellij.cvsSupport2.cvsoperations.dateOrRevision.SimpleRevision;
import com.intellij.cvsSupport2.errorHandling.CannotFindCvsRootException;
import com.intellij.cvsSupport2.errorHandling.CvsException;
import com.intellij.cvsSupport2.errorHandling.CvsProcessException;
import com.intellij.cvsSupport2.errorHandling.InvalidModuleDescriptionException;
import com.intellij.cvsSupport2.util.CvsVfsUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.update.UpdatedFiles;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.netbeans.lib.cvsclient.admin.Entry;
import org.netbeans.lib.cvsclient.admin.InvalidEntryFormatException;
import org.netbeans.lib.cvsclient.command.CommandAbortedException;

public class CommandCvsHandler
extends CvsHandler {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.cvsSupport2.cvshandlers.CommandCvsHandler");
    protected final CvsOperation myCvsOperation;
    private final List<CvsOperation> myPostActivities = new ArrayList<CvsOperation>();
    private final boolean myCanBeCanceled;
    protected boolean myIsCanceled = false;
    private PerformInBackgroundOption myBackgroundOption;

    public CommandCvsHandler(String title, CvsOperation cvsOperation, boolean canBeCanceled) {
        this(title, cvsOperation, FileSetToBeUpdated.EMPTY, canBeCanceled);
    }

    public CommandCvsHandler(String title, CvsOperation cvsOperation, FileSetToBeUpdated files, boolean canBeCanceled) {
        super(title, files);
        this.myCvsOperation = cvsOperation;
        this.myCanBeCanceled = canBeCanceled;
    }

    public CommandCvsHandler(String title, CvsOperation cvsOperation, FileSetToBeUpdated files) {
        this(title, cvsOperation, files, true);
    }

    public CommandCvsHandler(String title, CvsOperation cvsOperation) {
        this(title, cvsOperation, FileSetToBeUpdated.EMPTY);
    }

    public CommandCvsHandler(String title, CvsOperation operation, FileSetToBeUpdated files, PerformInBackgroundOption backgroundOption) {
        this(title, operation, files);
        this.myBackgroundOption = backgroundOption;
    }

    @Override
    public boolean login(Project project) {
        return this.loginAll(project);
    }

    @Override
    public boolean canBeCanceled() {
        return this.myCanBeCanceled;
    }

    @Override
    public PerformInBackgroundOption getBackgroundOption(Project project) {
        return this.myBackgroundOption;
    }

    @Override
    protected boolean runInReadThread() {
        return this.myCvsOperation.runInReadThread();
    }

    public static CvsHandler createCheckoutFileHandler(FilePath[] files, CvsConfiguration configuration, @Nullable PerformInBackgroundOption option) {
        return new CommandCvsHandler(CvsBundle.message((String)"operation.name.check.out.files", (Object[])new Object[0]), (CvsOperation)new CheckoutFilesOperation(files, configuration), FileSetToBeUpdated.selectedFiles(files), option == null ? PerformInBackgroundOption.DEAF : option);
    }

    public static CvsHandler createCheckoutHandler(CvsEnvironment environment, String[] checkoutPath, File target, boolean useAltCheckoutDir, boolean makeNewFilesReadOnly, PerformInBackgroundOption option) {
        CheckoutProjectOperation checkoutOperation = CheckoutProjectOperation.create(environment, checkoutPath, target, useAltCheckoutDir, makeNewFilesReadOnly);
        return new CommandCvsHandler(CvsBundle.message((String)"operation.name.check.out.project", (Object[])new Object[0]), (CvsOperation)checkoutOperation, FileSetToBeUpdated.allFiles(), option == null ? PerformInBackgroundOption.DEAF : option){

            @Override
            public void finish() {
                CvsEntriesManager.getInstance().clearAll();
            }
        };
    }

    public static CvsHandler createImportHandler(ImportDetails details) {
        return new CommandCvsHandler(CvsBundle.message((String)"operation.name.import", (Object[])new Object[0]), (CvsOperation)new ImportOperation(details), FileSetToBeUpdated.EMPTY);
    }

    public static UpdateHandler createUpdateHandler(FilePath[] files, UpdateSettings updateSettings, Project project, @NotNull UpdatedFiles updatedFiles) {
        return new UpdateHandler(files, updateSettings, project, updatedFiles);
    }

    public static CvsHandler createTagHandler(FilePath[] selectedFiles, String tagName, boolean switchToThisTag, boolean overrideExisting, boolean makeNewFilesReadOnly, Project project) {
        CompositeOperation operation = new CompositeOperation();
        operation.addOperation(new TagOperation(selectedFiles, tagName, false, overrideExisting));
        if (switchToThisTag) {
            operation.addOperation(new UpdateOperation(selectedFiles, tagName, makeNewFilesReadOnly, project));
        }
        return new CommandCvsHandler(CvsBundle.message((String)"operation.name.create.tag", (Object[])new Object[0]), (CvsOperation)operation, FileSetToBeUpdated.selectedFiles(selectedFiles));
    }

    public static CvsHandler createBranchHandler(FilePath[] selectedFiles, String branchName, boolean switchToThisBranch, boolean overrideExisting, boolean makeNewFilesReadOnly, Project project) {
        CompositeOperation operation = new CompositeOperation();
        operation.addOperation(new BranchOperation(selectedFiles, branchName, overrideExisting));
        if (switchToThisBranch) {
            operation.addOperation(new UpdateOperation(selectedFiles, branchName, makeNewFilesReadOnly, project));
        }
        return new CommandCvsHandler(CvsBundle.message((String)"operation.name.create.branch", (Object[])new Object[0]), (CvsOperation)operation, FileSetToBeUpdated.selectedFiles(selectedFiles));
    }

    public static CvsHandler createCommitHandler(FilePath[] selectedFiles, String commitMessage, String title, boolean makeNewFilesReadOnly, Project project, boolean tagFilesAfterCommit, String tagName, @NotNull List<File> dirsToPrune) {
        CommitFilesOperation operation = new CommitFilesOperation(commitMessage, makeNewFilesReadOnly);
        if (selectedFiles != null) {
            for (FilePath selectedFile : selectedFiles) {
                operation.addFile(selectedFile.getIOFile());
            }
        }
        if (!dirsToPrune.isEmpty()) {
            operation.addFinishAction(() -> {
                IOFilesBasedDirectoryPruner pruner = new IOFilesBasedDirectoryPruner(null);
                for (File dir : dirsToPrune) {
                    pruner.addFile(dir);
                }
                pruner.execute();
            });
        }
        CommandCvsHandler result = new CommandCvsHandler(title, (CvsOperation)operation, FileSetToBeUpdated.selectedFiles(selectedFiles));
        if (tagFilesAfterCommit) {
            result.addOperation(new TagOperation(selectedFiles, tagName, false, CvsConfiguration.getInstance((Project)project).OVERRIDE_EXISTING_TAG_FOR_PROJECT));
        }
        return result;
    }

    public static CvsHandler createAddFilesHandler(Project project, Collection<AddedFileInfo> addedRoots) {
        AddFilesOperation operation = new AddFilesOperation();
        ArrayList<AddedFileInfo> addedFileInfo = new ArrayList<AddedFileInfo>();
        for (AddedFileInfo info : addedRoots) {
            info.clearAllCvsAdminDirectoriesInIncludedDirectories();
            addedFileInfo.addAll(info.collectAllIncludedFiles());
        }
        ArrayList<VirtualFile> addedFiles = new ArrayList<VirtualFile>();
        for (AddedFileInfo info : addedFileInfo) {
            addedFiles.add(info.getFile());
            operation.addFile(info.getFile(), info.getKeywordSubstitution());
        }
        return new CommandCvsHandler(CvsBundle.message((String)"action.name.add", (Object[])new Object[0]), (CvsOperation)operation, FileSetToBeUpdated.selectedFiles(VfsUtilCore.toVirtualFileArray(addedFiles)), VcsConfiguration.getInstance((Project)project).getAddRemoveOption());
    }

    public static CvsHandler createRemoveFilesHandler(Project project, Collection<File> files) {
        RemoveFilesOperation operation = new RemoveFilesOperation();
        for (File file : files) {
            operation.addFile(file.getPath());
        }
        return new CommandCvsHandler(CvsBundle.message((String)"action.name.remove", (Object[])new Object[0]), (CvsOperation)operation, FileSetToBeUpdated.selectedFiles(CommandCvsHandler.getAdminDirectoriesFor(files)), VcsConfiguration.getInstance((Project)project).getAddRemoveOption());
    }

    private static VirtualFile[] getAdminDirectoriesFor(Collection<File> files) {
        HashSet<VirtualFile> result = new HashSet<VirtualFile>();
        for (File file : files) {
            File parentFile = file.getParentFile();
            VirtualFile cvsAdminDirectory = CvsVfsUtil.findFileByIoFile(new File(parentFile, "CVS"));
            if (cvsAdminDirectory == null) continue;
            result.add(cvsAdminDirectory);
        }
        return VfsUtilCore.toVirtualFileArray(result);
    }

    public static CvsHandler createRestoreFileHandler(VirtualFile parent, String name, boolean makeNewFilesReadOnly) {
        File ioFile = new File(VfsUtilCore.virtualToIoFile((VirtualFile)parent), name);
        Entry entry = CvsEntriesManager.getInstance().getEntryFor(parent, name);
        String revision = CommandCvsHandler.getRevision(entry);
        CheckoutFileOperation operation = new CheckoutFileOperation(parent, new SimpleRevision(revision), name, makeNewFilesReadOnly);
        CommandCvsHandler cvsHandler = new CommandCvsHandler(CvsBundle.message((String)"operation.name.restore", (Object[])new Object[0]), (CvsOperation)operation, FileSetToBeUpdated.EMPTY);
        operation.addFinishAction(() -> {
            List<VcsException> errors = cvsHandler.getErrors();
            if (errors != null && !errors.isEmpty()) {
                return;
            }
            if (entry != null) {
                entry.setRevision(revision);
                entry.setConflict(CvsUtil.formatDate(new Date(ioFile.lastModified())));
                try {
                    CvsUtil.saveEntryForFile(ioFile, entry);
                }
                catch (IOException e) {
                    LOG.error((Throwable)e);
                }
                CvsEntriesManager.getInstance().clearCachedEntriesFor(parent);
            }
        });
        return cvsHandler;
    }

    public static CvsHandler createEditHandler(VirtualFile[] selectedFiles, boolean isReservedEdit) {
        EditOperation operation = new EditOperation(isReservedEdit);
        operation.addFiles(selectedFiles);
        return new CommandCvsHandler(CvsBundle.message((String)"action.name.edit", (Object[])new Object[0]), (CvsOperation)operation, FileSetToBeUpdated.selectedFiles(selectedFiles));
    }

    public static CvsHandler createUneditHandler(VirtualFile[] selectedFiles, boolean makeNewFilesReadOnly) {
        UneditOperation operation = new UneditOperation(makeNewFilesReadOnly);
        operation.addFiles(selectedFiles);
        return new CommandCvsHandler(CvsBundle.message((String)"operation.name.unedit", (Object[])new Object[0]), (CvsOperation)operation, FileSetToBeUpdated.selectedFiles(selectedFiles));
    }

    public static CvsHandler createRemoveTagAction(FilePath[] selectedFiles, String tagName) {
        return new CommandCvsHandler(CvsBundle.message((String)"action.name.delete.tag", (Object[])new Object[0]), (CvsOperation)new TagOperation(selectedFiles, tagName, true, false), FileSetToBeUpdated.EMPTY);
    }

    @Nullable
    private static String getRevision(Entry entry) {
        if (entry == null) {
            return null;
        }
        String result = entry.getRevision();
        if (result == null) {
            return null;
        }
        if (StringUtil.startsWithChar((CharSequence)result, (char)'-')) {
            return result.substring(1);
        }
        return result;
    }

    @Override
    public boolean isCanceled() {
        return this.myIsCanceled;
    }

    private boolean loginAll(Project project) {
        HashSet<CvsEnvironment> allRoots = new HashSet<CvsEnvironment>();
        try {
            this.myCvsOperation.appendSelfCvsRootProvider(allRoots);
            for (CvsOperation postActivity : this.myPostActivities) {
                postActivity.appendSelfCvsRootProvider(allRoots);
            }
        }
        catch (CannotFindCvsRootException e2) {
            this.myErrors.add(new VcsException((Throwable)e2));
            return false;
        }
        LoginPerformer performer = new LoginPerformer(project, allRoots, (Consumer<VcsException>)((Consumer)e -> this.myErrorMessageProcessor.addError((VcsException)((Object)e))));
        performer.setForceCheck(true);
        return performer.loginAll();
    }

    @Override
    public void internalRun(Project project, ModalityContext executor, boolean runInReadAction) {
        if (!this.login(project)) {
            return;
        }
        CvsExecutionEnvironment executionEnvironment = new CvsExecutionEnvironment(this.myCompositeListener, this.getProgressListener(), this.myErrorMessageProcessor, this.getPostActivityHandler(), project);
        if (!this.runOperation(executionEnvironment, runInReadAction, this.myCvsOperation)) {
            return;
        }
        this.onOperationFinished(executor);
        while (!this.myPostActivities.isEmpty()) {
            CvsOperation cvsOperation = this.myPostActivities.get(0);
            if (!this.runOperation(executionEnvironment, runInReadAction, cvsOperation)) {
                return;
            }
            this.myPostActivities.remove(cvsOperation);
        }
    }

    private boolean runOperation(CvsExecutionEnvironment executionEnvironment, boolean runInReadAction, CvsOperation cvsOperation) {
        try {
            cvsOperation.execute(executionEnvironment, runInReadAction);
            return true;
        }
        catch (VcsException e) {
            this.myErrors.add(e);
        }
        catch (InvalidModuleDescriptionException ex) {
            this.myErrors.add(new CvsException(ex, ex.getCvsRoot()));
        }
        catch (InvalidEntryFormatException e) {
            this.myErrors.add(new VcsException(CvsBundle.message((String)"exception.text.entries.file.is.corrupted", (Object[])new Object[]{e.getEntriesFile()})));
        }
        catch (CvsProcessException ex) {
            this.myErrors.add(new CvsException(ex, cvsOperation.getLastProcessedCvsRoot()));
        }
        catch (CommandAbortedException ex) {
            LOG.error((Throwable)ex);
            this.myErrors.add(new CvsException(ex, cvsOperation.getLastProcessedCvsRoot()));
        }
        catch (ProcessCanceledException ex) {
            this.myIsCanceled = true;
        }
        catch (Exception ex) {
            LOG.error((Throwable)ex);
            this.myErrors.add(new CvsException(ex, this.myCvsOperation.getLastProcessedCvsRoot()));
        }
        return false;
    }

    protected void onOperationFinished(ModalityContext modalityContext) {
    }

    protected void addFileToCheckout(VirtualFile file) {
        this.addOperation(new CheckoutFileOperation(file.getParent(), RevisionOrDateImpl.createOn(file), file.getName(), false));
    }

    protected void addOperation(CvsOperation operation) {
        this.myPostActivities.add(operation);
    }

    protected PostCvsActivity getPostActivityHandler() {
        return PostCvsActivity.DEAF;
    }

    @Override
    protected int getFilesToProcessCount() {
        return this.myCvsOperation.getFilesToProcessCount();
    }

    public static CvsHandler createGetFileFromRepositoryHandler(CvsLightweightFile[] cvsLightweightFiles, boolean makeNewFilesReadOnly) {
        CompositeOperation compositeOperation = new CompositeOperation();
        CvsEntriesManager entriesManager = CvsEntriesManager.getInstance();
        for (CvsLightweightFile cvsLightweightFile : cvsLightweightFiles) {
            File root = cvsLightweightFile.getRoot();
            File workingDirectory = root;
            if (workingDirectory == null) continue;
            if (cvsLightweightFile.getLocalFile().getParentFile().equals(workingDirectory)) {
                workingDirectory = workingDirectory.getParentFile();
            }
            String alternativeCheckoutPath = CommandCvsHandler.getAlternativeCheckoutPath(cvsLightweightFile, workingDirectory);
            CheckoutProjectOperation checkoutFileOperation = new CheckoutProjectOperation(new String[]{cvsLightweightFile.getModuleName()}, entriesManager.getCvsConnectionSettingsFor(root), makeNewFilesReadOnly, workingDirectory, alternativeCheckoutPath, true, null);
            compositeOperation.addOperation(checkoutFileOperation);
        }
        return new CommandCvsHandler(CvsBundle.message((String)"action.name.get.file.from.repository", (Object[])new Object[0]), (CvsOperation)compositeOperation, FileSetToBeUpdated.allFiles(), true);
    }

    private static String getAlternativeCheckoutPath(CvsLightweightFile cvsLightweightFile, File workingDirectory) {
        File parent = cvsLightweightFile.getLocalFile().getParentFile();
        return parent.getAbsolutePath().substring(workingDirectory.getAbsolutePath().length());
    }
}

