/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cvsSupport2.cvsoperations.common;

import com.intellij.cvsSupport2.CvsUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ObjectsConvertor;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import java.util.LinkedList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class FindAllRootsHelper {
    private FindAllRootsHelper() {
    }

    public static List<VirtualFile> findVersionedUnder(List<VirtualFile> coll) {
        List pathList = ObjectsConvertor.vf2fp(coll);
        MyVisitor visitor = new MyVisitor();
        for (FilePath root : pathList) {
            VirtualFile vf = root.getVirtualFile();
            if (vf == null) continue;
            VfsUtilCore.visitChildrenRecursively((VirtualFile)vf, (VirtualFileVisitor)visitor);
        }
        return visitor.found;
    }

    private static class MyVisitor
    extends VirtualFileVisitor {
        private final List<VirtualFile> found = new LinkedList<VirtualFile>();

        private MyVisitor() {
            super(new VirtualFileVisitor.Option[0]);
        }

        @NotNull
        public VirtualFileVisitor.Result visitFileEx(@NotNull VirtualFile file) {
            if (CvsUtil.fileIsUnderCvsMaybeWithVfs(file)) {
                this.found.add(file);
            }
            return file.isDirectory() && this.found.contains(file) ? SKIP_CHILDREN : CONTINUE;
        }
    }
}

