/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.launcher.cli.converter;

import java.util.Map;
import org.gradle.api.logging.LogLevel;
import org.gradle.api.logging.configuration.LoggingConfiguration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertiesToLogLevelConfigurationConverter {
    public LoggingConfiguration convert(Map<String, String> properties, LoggingConfiguration loggingConfiguration) {
        String logLevel = properties.get("org.gradle.logging.level");
        if (logLevel != null) {
            LogLevel level = this.parseLogLevel(logLevel);
            loggingConfiguration.setLogLevel(level);
        }
        return loggingConfiguration;
    }

    private LogLevel parseLogLevel(String value) {
        try {
            LogLevel logLevel = LogLevel.valueOf((String)value.toUpperCase());
            if (logLevel == LogLevel.ERROR) {
                throw new IllegalArgumentException("Log level cannot be set to 'ERROR'.");
            }
            return logLevel;
        }
        catch (IllegalArgumentException e) {
            String message = String.format("Value '%s' given for %s system property is invalid.  (must be one of quiet, warn, lifecycle, info, or debug)", value, "org.gradle.logging.level");
            throw new IllegalArgumentException(message, e);
        }
    }
}

