/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.client.api;

import com.android.tools.lint.detector.api.ClassContext;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationOwner;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeVisitor;
import com.intellij.psi.PsiWildcardType;

public abstract class JavaEvaluator {
    public abstract boolean extendsClass(PsiClass var1, String var2, boolean var3);

    public abstract boolean implementsInterface(PsiClass var1, String var2, boolean var3);

    public boolean isMemberInSubClassOf(PsiMember method, String className, boolean strict) {
        PsiClass containingClass = method.getContainingClass();
        return containingClass != null && this.extendsClass(containingClass, className, strict);
    }

    public boolean isMemberInClass(PsiMember method, String className) {
        if (method == null) {
            return false;
        }
        PsiClass containingClass = method.getContainingClass();
        return containingClass != null && className.equals(containingClass.getQualifiedName());
    }

    public int getParameterCount(PsiMethod method) {
        return method.getParameterList().getParametersCount();
    }

    public boolean inheritsFrom(PsiClass cls, String className, boolean strict) {
        return this.extendsClass(cls, className, strict) || this.implementsInterface(cls, className, strict);
    }

    public boolean methodMatches(PsiMethod method, String className, boolean allowInherit, String ... argumentTypes) {
        if (className != null && allowInherit && !this.isMemberInSubClassOf((PsiMember)method, className, false)) {
            return false;
        }
        return this.parametersMatch(method, argumentTypes);
    }

    public boolean parametersMatch(PsiMethod method, String ... argumentTypes) {
        PsiParameterList parameterList = method.getParameterList();
        if (parameterList.getParametersCount() != argumentTypes.length) {
            return false;
        }
        PsiParameter[] parameters = parameterList.getParameters();
        for (int i = 0; i < parameters.length; ++i) {
            PsiType type = parameters[i].getType();
            if (type.getCanonicalText().equals(argumentTypes[i])) continue;
            return false;
        }
        return true;
    }

    public boolean parameterHasType(PsiMethod method, int parameterIndex, String typeName) {
        if (method == null) {
            return false;
        }
        PsiParameterList parameterList = method.getParameterList();
        return parameterList.getParametersCount() > parameterIndex && this.typeMatches(parameterList.getParameters()[parameterIndex].getType(), typeName);
    }

    public boolean typeMatches(PsiType type, String typeName) {
        return type != null && type.getCanonicalText().equals(typeName);
    }

    public PsiElement resolve(PsiElement element) {
        PsiMethod resolved;
        if (element instanceof PsiReference) {
            return ((PsiReference)element).resolve();
        }
        if (element instanceof PsiMethodCallExpression && (resolved = ((PsiMethodCallExpression)element).resolveMethod()) != null) {
            return resolved;
        }
        return null;
    }

    public boolean isPublic(PsiModifierListOwner owner) {
        if (owner != null) {
            PsiModifierList modifierList = owner.getModifierList();
            return modifierList != null && modifierList.hasModifierProperty("public");
        }
        return false;
    }

    public boolean isStatic(PsiModifierListOwner owner) {
        if (owner != null) {
            PsiModifierList modifierList = owner.getModifierList();
            return modifierList != null && modifierList.hasModifierProperty("static");
        }
        return false;
    }

    public boolean isPrivate(PsiModifierListOwner owner) {
        if (owner != null) {
            PsiModifierList modifierList = owner.getModifierList();
            return modifierList != null && modifierList.hasModifierProperty("private");
        }
        return false;
    }

    public boolean isAbstract(PsiModifierListOwner owner) {
        if (owner != null) {
            PsiModifierList modifierList = owner.getModifierList();
            return modifierList != null && modifierList.hasModifierProperty("abstract");
        }
        return false;
    }

    public boolean isFinal(PsiModifierListOwner owner) {
        if (owner != null) {
            PsiModifierList modifierList = owner.getModifierList();
            return modifierList != null && modifierList.hasModifierProperty("final");
        }
        return false;
    }

    public PsiMethod getSuperMethod(PsiMethod method) {
        if (method == null) {
            return null;
        }
        PsiMethod[] superMethods = method.findSuperMethods();
        if (superMethods.length > 0) {
            return superMethods[0];
        }
        return null;
    }

    public String getInternalName(PsiClass psiClass) {
        String qualifiedName = psiClass.getQualifiedName();
        if (qualifiedName == null && (qualifiedName = psiClass.getName()) == null) {
            assert (psiClass instanceof PsiAnonymousClass);
            return this.getInternalName(psiClass.getContainingClass());
        }
        return ClassContext.getInternalName(qualifiedName);
    }

    public String getInternalName(PsiClassType psiClassType) {
        return ClassContext.getInternalName(psiClassType.getCanonicalText());
    }

    public String getInternalDescription(PsiMethod method, boolean includeName, boolean includeReturn) {
        assert (!includeName);
        assert (!includeReturn);
        StringBuilder signature = new StringBuilder();
        if (includeName) {
            if (method.isConstructor()) {
                PsiClass outerClass;
                PsiClass declaringClass = method.getContainingClass();
                if (declaringClass != null && (outerClass = declaringClass.getContainingClass()) != null && !declaringClass.hasModifierProperty("static") && !this.appendJvmTypeName(signature, outerClass)) {
                    return null;
                }
                signature.append("<init>");
            } else {
                signature.append(method.getName());
            }
        }
        signature.append('(');
        for (PsiParameter psiParameter : method.getParameterList().getParameters()) {
            if (this.appendJvmSignature(signature, psiParameter.getType())) continue;
            return null;
        }
        signature.append(')');
        if (includeReturn) {
            if (!method.isConstructor()) {
                if (!this.appendJvmSignature(signature, method.getReturnType())) {
                    return null;
                }
            } else {
                signature.append('V');
            }
        }
        return signature.toString();
    }

    private boolean appendJvmTypeName(StringBuilder signature, PsiClass outerClass) {
        String className = this.getInternalName(outerClass);
        if (className == null) {
            return false;
        }
        signature.append('L').append(className.replace('.', '/')).append(';');
        return true;
    }

    private boolean appendJvmSignature(StringBuilder buffer, PsiType type) {
        if (type == null) {
            return false;
        }
        PsiType psiType = JavaEvaluator.erasure(type);
        if (psiType instanceof PsiArrayType) {
            buffer.append('[');
            this.appendJvmSignature(buffer, ((PsiArrayType)psiType).getComponentType());
        } else if (psiType instanceof PsiClassType) {
            PsiClass resolved = ((PsiClassType)psiType).resolve();
            if (resolved == null) {
                return false;
            }
            if (!this.appendJvmTypeName(buffer, resolved)) {
                return false;
            }
        } else if (psiType instanceof PsiPrimitiveType) {
            buffer.append(JavaEvaluator.getPrimitiveSignature(psiType.getCanonicalText()));
        } else {
            return false;
        }
        return true;
    }

    public boolean areSignaturesEqual(PsiMethod method1, PsiMethod method2) {
        PsiParameterList parameterList1 = method1.getParameterList();
        PsiParameterList parameterList2 = method2.getParameterList();
        if (parameterList1.getParametersCount() != parameterList2.getParametersCount()) {
            return false;
        }
        PsiParameter[] parameters1 = parameterList1.getParameters();
        PsiParameter[] parameters2 = parameterList2.getParameters();
        int n = parameters1.length;
        for (int i = 0; i < n; ++i) {
            PsiType type2;
            PsiParameter parameter1 = parameters1[i];
            PsiParameter parameter2 = parameters2[i];
            PsiType type1 = parameter1.getType();
            if (type1.equals(type2 = parameter2.getType()) || (type1 = JavaEvaluator.erasure(parameter1.getType())).equals(type2 = JavaEvaluator.erasure(parameter2.getType()))) continue;
            return false;
        }
        return true;
    }

    public static PsiType erasure(PsiType type) {
        if (type == null) {
            return null;
        }
        return (PsiType)type.accept((PsiTypeVisitor)new PsiTypeVisitor<PsiType>(){

            public PsiType visitType(PsiType type) {
                return type;
            }

            public PsiType visitClassType(PsiClassType classType) {
                return classType.rawType();
            }

            public PsiType visitWildcardType(PsiWildcardType wildcardType) {
                return wildcardType;
            }

            public PsiType visitPrimitiveType(PsiPrimitiveType primitiveType) {
                return primitiveType;
            }

            public PsiType visitEllipsisType(PsiEllipsisType ellipsisType) {
                PsiType componentType = ellipsisType.getComponentType();
                PsiType newComponentType = (PsiType)componentType.accept((PsiTypeVisitor)this);
                if (newComponentType == componentType) {
                    return ellipsisType;
                }
                return newComponentType != null ? newComponentType.createArrayType() : null;
            }

            public PsiType visitArrayType(PsiArrayType arrayType) {
                PsiType componentType = arrayType.getComponentType();
                PsiType newComponentType = (PsiType)componentType.accept((PsiTypeVisitor)this);
                if (newComponentType == componentType) {
                    return arrayType;
                }
                return newComponentType != null ? newComponentType.createArrayType() : null;
            }
        });
    }

    public static String getPrimitiveSignature(String typeName) {
        switch (typeName) {
            case "boolean": {
                return "Z";
            }
            case "byte": {
                return "B";
            }
            case "char": {
                return "C";
            }
            case "short": {
                return "S";
            }
            case "int": {
                return "I";
            }
            case "long": {
                return "J";
            }
            case "float": {
                return "F";
            }
            case "double": {
                return "D";
            }
            case "void": {
                return "V";
            }
        }
        return null;
    }

    public abstract PsiClass findClass(String var1);

    public abstract PsiClassType getClassType(PsiClass var1);

    public abstract PsiAnnotation[] getAllAnnotations(PsiModifierListOwner var1, boolean var2);

    public abstract PsiAnnotation findAnnotationInHierarchy(PsiModifierListOwner var1, String ... var2);

    public abstract PsiAnnotation findAnnotation(PsiModifierListOwner var1, String ... var2);

    public abstract String findJarPath(PsiElement var1);

    public boolean isInherited(PsiAnnotation annotation, PsiModifierListOwner owner) {
        PsiAnnotationOwner annotationOwner = annotation.getOwner();
        return annotationOwner == null || !annotationOwner.equals(owner.getModifierList());
    }

    public abstract PsiPackage getPackage(PsiElement var1);
}

