/*
 * Decompiled with CFR 0.152.
 */
package git4idea.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import com.intellij.vcsUtil.VcsUtil;
import git4idea.GitUtil;
import git4idea.GitVcs;
import git4idea.commands.Git;
import git4idea.commands.GitCommandResult;
import git4idea.commands.GitLineHandlerListener;
import git4idea.i18n.GitBundle;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class GitInit
extends DumbAwareAction {
    public void actionPerformed(AnActionEvent e) {
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        if (project == null) {
            project = ProjectManager.getInstance().getDefaultProject();
        }
        FileChooserDescriptor fcd = FileChooserDescriptorFactory.createSingleFolderDescriptor();
        fcd.setShowFileSystemRoots(true);
        fcd.setTitle(GitBundle.getString("init.destination.directory.title"));
        fcd.setDescription(GitBundle.getString("init.destination.directory.description"));
        fcd.setHideIgnored(false);
        VirtualFile baseDir = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE);
        if (baseDir == null) {
            baseDir = project.getBaseDir();
        }
        GitInit.doInit(project, fcd, baseDir, baseDir);
    }

    private static void doInit(final Project project, FileChooserDescriptor fcd, VirtualFile baseDir, final VirtualFile finalBaseDir) {
        FileChooser.chooseFile((FileChooserDescriptor)fcd, (Project)project, (VirtualFile)baseDir, (Consumer)new Consumer<VirtualFile>(){

            public void consume(final VirtualFile root) {
                if (GitUtil.isUnderGit(root) && Messages.showYesNoDialog((Project)project, (String)GitBundle.message("init.warning.already.under.git", StringUtil.escapeXml((String)root.getPresentableUrl())), (String)GitBundle.getString("init.warning.title"), (Icon)Messages.getWarningIcon()) != 0) {
                    return;
                }
                GitCommandResult result = Git.getInstance().init(project, root, new GitLineHandlerListener[0]);
                if (!result.success()) {
                    GitVcs vcs = GitVcs.getInstance(project);
                    if (vcs != null && vcs.getExecutableValidator().checkExecutableAndNotifyIfNeeded()) {
                        VcsNotifier.getInstance((Project)project).notifyError("Git init failed", result.getErrorOutputAsHtmlString());
                    }
                    return;
                }
                if (project.isDefault()) {
                    return;
                }
                final String path = root.equals(finalBaseDir) ? "" : root.getPath();
                GitVcs.runInBackground(new Task.Backgroundable(project, GitBundle.getString("common.refreshing")){

                    public void run(@NotNull ProgressIndicator indicator) {
                        GitInit.refreshAndConfigureVcsMappings(project, root, path);
                    }
                });
            }
        });
    }

    public static void refreshAndConfigureVcsMappings(Project project, VirtualFile root, String path) {
        VfsUtil.markDirtyAndRefresh((boolean)false, (boolean)true, (boolean)false, (VirtualFile[])new VirtualFile[]{root});
        ProjectLevelVcsManager manager = ProjectLevelVcsManager.getInstance((Project)project);
        manager.setDirectoryMappings(VcsUtil.addMapping((List)manager.getDirectoryMappings(), (String)path, (String)"Git"));
        manager.updateActiveVcss();
        VcsDirtyScopeManager.getInstance((Project)project).dirDirtyRecursively(root);
    }
}

