/*
 * Decompiled with CFR 0.152.
 */
package git4idea.actions;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VirtualFile;
import git4idea.GitVcs;
import git4idea.actions.GitMergeAction;
import git4idea.commands.GitLineHandler;
import git4idea.i18n.GitBundle;
import git4idea.merge.GitMergeDialog;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitMerge
extends GitMergeAction {
    @Override
    @NotNull
    protected String getActionName() {
        return GitBundle.getString("merge.action.name");
    }

    @Override
    @Nullable
    protected GitMergeAction.DialogState displayDialog(@NotNull Project project, @NotNull List<VirtualFile> gitRoots, @NotNull VirtualFile defaultRoot) {
        GitVcs vcs = GitVcs.getInstance(project);
        if (vcs == null) {
            return null;
        }
        final GitMergeDialog dialog = new GitMergeDialog(project, gitRoots, defaultRoot);
        try {
            dialog.updateBranches();
        }
        catch (VcsException e) {
            if (vcs.getExecutableValidator().checkExecutableAndShowMessageIfNeeded(null)) {
                vcs.showErrors(Collections.singletonList(e), GitBundle.getString("merge.retrieving.branches"));
            }
            return null;
        }
        if (!dialog.showAndGet()) {
            return null;
        }
        return new GitMergeAction.DialogState(dialog.getSelectedRoot(), GitBundle.message("merging.title", dialog.getSelectedRoot().getPath()), new Computable<GitLineHandler>(){

            public GitLineHandler compute() {
                return dialog.handler();
            }
        });
    }
}

